/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.visitors;

import com.python.pydev.analysis.IAnalysisPreferences;
import com.python.pydev.analysis.messages.IMessage;
import com.python.pydev.analysis.scopeanalysis.AbstractScopeAnalyzerVisitor;
import com.python.pydev.analysis.visitors.DuplicationChecker;
import com.python.pydev.analysis.visitors.Found;
import com.python.pydev.analysis.visitors.MessagesManager;
import com.python.pydev.analysis.visitors.NoSelfChecker;
import com.python.pydev.analysis.visitors.ScopeItems;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.python.pydev.core.IModule;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.Tuple;
import org.python.pydev.editor.codecompletion.revisited.modules.SourceToken;
import org.python.pydev.editor.codecompletion.revisited.visitors.AbstractVisitor;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Assert;
import org.python.pydev.parser.jython.ast.Assign;
import org.python.pydev.parser.jython.ast.AugAssign;
import org.python.pydev.parser.jython.ast.Call;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.Compare;
import org.python.pydev.parser.jython.ast.Comprehension;
import org.python.pydev.parser.jython.ast.Expr;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.If;
import org.python.pydev.parser.jython.ast.Lambda;
import org.python.pydev.parser.jython.ast.ListComp;
import org.python.pydev.parser.jython.ast.Print;
import org.python.pydev.parser.jython.ast.Raise;
import org.python.pydev.parser.jython.ast.Return;
import org.python.pydev.parser.jython.ast.Str;
import org.python.pydev.parser.jython.ast.VisitorIF;
import org.python.pydev.parser.jython.ast.While;
import org.python.pydev.parser.jython.ast.Yield;
import org.python.pydev.parser.jython.ast.decoratorsType;
import org.python.pydev.parser.jython.ast.stmtType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OccurrencesVisitor
extends AbstractScopeAnalyzerVisitor {
    protected MessagesManager messagesManager;
    protected DuplicationChecker duplicationChecker;
    protected NoSelfChecker noSelfChecker;
    private int isInTestScope = 0;

    public OccurrencesVisitor(IPythonNature nature, String moduleName, IModule current, IAnalysisPreferences prefs, IDocument document, IProgressMonitor monitor) {
        super(nature, moduleName, current, document, monitor);
        this.messagesManager = new MessagesManager(prefs, moduleName, document);
        this.duplicationChecker = new DuplicationChecker(this);
        this.noSelfChecker = new NoSelfChecker(this, moduleName);
    }

    public Object visitCompare(Compare node) throws Exception {
        Object ret = super.visitCompare(node);
        if (this.isInTestScope == 0) {
            SourceToken token = AbstractVisitor.makeToken((SimpleNode)node, (String)this.moduleName);
            this.messagesManager.addMessage(11, (IToken)token);
        }
        return ret;
    }

    public void traverse(If node) throws Exception {
        this.checkStop();
        if (node.test != null) {
            ++this.isInTestScope;
            node.test.accept((VisitorIF)this);
            --this.isInTestScope;
        }
        if (node.body != null) {
            int i = 0;
            while (i < node.body.length) {
                if (node.body[i] != null) {
                    node.body[i].accept((VisitorIF)this);
                }
                ++i;
            }
        }
        if (node.orelse != null) {
            node.orelse.accept((VisitorIF)this);
        }
    }

    public Object visitTuple(org.python.pydev.parser.jython.ast.Tuple node) throws Exception {
        ++this.isInTestScope;
        Object ret = super.visitTuple(node);
        --this.isInTestScope;
        return ret;
    }

    public void traverse(While node) throws Exception {
        this.checkStop();
        OccurrencesVisitor visitor = this;
        if (node.test != null) {
            ++this.isInTestScope;
            node.test.accept((VisitorIF)visitor);
            --this.isInTestScope;
        }
        if (node.body != null) {
            int i = 0;
            while (i < node.body.length) {
                if (node.body[i] != null) {
                    node.body[i].accept((VisitorIF)visitor);
                }
                ++i;
            }
        }
        if (node.orelse != null) {
            node.orelse.accept((VisitorIF)visitor);
        }
    }

    public Object visitRaise(Raise node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitRaise(node);
        --this.isInTestScope;
        return r;
    }

    public Object visitComprehension(Comprehension node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitComprehension(node);
        --this.isInTestScope;
        return r;
    }

    public Object visitAssert(Assert node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitAssert(node);
        --this.isInTestScope;
        return r;
    }

    public Object visitPrint(Print node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitPrint(node);
        --this.isInTestScope;
        return r;
    }

    @Override
    public Object visitAssign(Assign node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitAssign(node);
        --this.isInTestScope;
        return r;
    }

    public Object visitYield(Yield node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitYield(node);
        --this.isInTestScope;
        return r;
    }

    @Override
    public Object visitAugAssign(AugAssign node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitAugAssign(node);
        --this.isInTestScope;
        return r;
    }

    public Object visitCall(Call node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitCall(node);
        --this.isInTestScope;
        return r;
    }

    public Object visitReturn(Return node) throws Exception {
        ++this.isInTestScope;
        Object r = super.visitReturn(node);
        --this.isInTestScope;
        return r;
    }

    @Override
    protected void handleDecorator(decoratorsType dec) throws Exception {
        ++this.isInTestScope;
        dec.accept((VisitorIF)this);
        --this.isInTestScope;
    }

    @Override
    public Object visitLambda(Lambda node) throws Exception {
        ++this.isInTestScope;
        Object ret = super.visitLambda(node);
        --this.isInTestScope;
        return ret;
    }

    @Override
    public void traverse(SimpleNode node) throws Exception {
        if (node instanceof If) {
            this.traverse((If)node);
        } else if (node instanceof While) {
            this.traverse((While)node);
        } else if (node instanceof ListComp) {
            this.visitListComp((ListComp)node);
        } else {
            super.traverse(node);
        }
    }

    public List<IMessage> getMessages() {
        this.endScope(null);
        return this.messagesManager.getMessages();
    }

    @Override
    protected void onAddUndefinedVarInImportMessage(IToken foundTok, Found foundAs) {
        this.messagesManager.addUndefinedVarInImportMessage(foundTok, foundTok.getRepresentation());
    }

    @Override
    protected void onAddAssignmentToBuiltinMessage(IToken foundTok, String representation) {
        this.messagesManager.onAddAssignmentToBuiltinMessage(foundTok, representation);
    }

    @Override
    protected void onAddUndefinedMessage(IToken token, Found foundAs) {
        if ("...".equals(token.getRepresentation())) {
            return;
        }
        this.messagesManager.addUndefinedMessage(token);
    }

    @Override
    protected void onLastScope(ScopeItems m) {
        for (Found n : this.probablyNotDefined) {
            Map<String, Tuple<IToken, Found>> lastInStack;
            String rep = n.getSingle().tok.getRepresentation();
            if (this.scope.findInNamesToIgnore(rep, lastInStack = m.namesToIgnore) != null) continue;
            this.onAddUndefinedMessage(n.getSingle().tok, n);
        }
        this.messagesManager.setLastScope(m);
    }

    @Override
    protected void onAfterEndScope(SimpleNode node, ScopeItems m) {
        boolean reportUnused = true;
        if (node != null && node instanceof FunctionDef) {
            boolean bl = reportUnused = !this.isVirtual((FunctionDef)node);
        }
        if (reportUnused) {
            int scopeType = m.getScopeType();
            for (List<Found> list : m.getAll()) {
                int len = list.size();
                int i = 0;
                while (i < len) {
                    Found f = list.get(i);
                    if (!f.isUsed() && ((scopeType & 0x12) != 0 || f.isImport())) {
                        this.messagesManager.addUnusedMessage(node, f);
                    }
                    ++i;
                }
            }
        }
    }

    protected boolean isVirtual(FunctionDef node) {
        if (node.body != null) {
            int len = node.body.length;
            int i = 0;
            while (i < len) {
                stmtType n = node.body[i];
                if (!(n instanceof Raise || n instanceof Expr && ((Expr)n).value instanceof Str)) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    protected void onAfterStartScope(int newScopeType, SimpleNode node) {
        if (newScopeType == 4) {
            this.duplicationChecker.beforeClassDef((ClassDef)node);
            this.noSelfChecker.beforeClassDef((ClassDef)node);
        } else if ((newScopeType & 2) != 0) {
            this.duplicationChecker.beforeFunctionDef((FunctionDef)node);
            this.noSelfChecker.beforeFunctionDef((FunctionDef)node);
        }
    }

    @Override
    protected void onBeforeEndScope(SimpleNode node) {
        if (node instanceof ClassDef) {
            this.noSelfChecker.afterClassDef((ClassDef)node);
            this.duplicationChecker.afterClassDef((ClassDef)node);
        } else if (node instanceof FunctionDef) {
            this.duplicationChecker.afterFunctionDef((FunctionDef)node);
            this.noSelfChecker.afterFunctionDef((FunctionDef)node);
        }
    }

    @Override
    public void onAddUnusedMessage(SimpleNode node, Found found) {
        this.messagesManager.addUnusedMessage(node, found);
    }

    @Override
    public void onAddReimportMessage(Found newFound) {
        this.messagesManager.addReimportMessage(newFound);
    }

    @Override
    public void onAddUnresolvedImport(IToken token) {
        this.messagesManager.addMessage(6, token);
    }

    @Override
    public void onAddDuplicatedSignature(SourceToken token, String name) {
        this.messagesManager.addMessage(4, (IToken)token, name);
    }

    @Override
    public void onAddNoSelf(SourceToken token, Object[] objects) {
        this.messagesManager.addMessage(7, (IToken)token, objects);
    }

    @Override
    protected void onAfterVisitAssign(Assign node) {
        this.noSelfChecker.visitAssign(node);
    }
}

