/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.analysis.additionalinfo;

import com.python.pydev.analysis.AnalysisPlugin;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalDependencyInfo;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalInfoWithBuild;
import com.python.pydev.analysis.additionalinfo.AbstractAdditionalTokensInfo;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;

public class AdditionalSystemInterpreterInfo
extends AbstractAdditionalInfoWithBuild {
    private IInterpreterManager manager;
    private final String additionalInfoInterpreter;
    private static Map<Tuple<String, String>, AbstractAdditionalTokensInfo> additionalSystemInfo = new HashMap<Tuple<String, String>, AbstractAdditionalTokensInfo>();
    private volatile File persistingFolderCache = null;
    private File persistingLocation;

    public AdditionalSystemInterpreterInfo(IInterpreterManager manager, String interpreter) throws MisconfigurationException {
        super(false);
        this.manager = manager;
        this.additionalInfoInterpreter = interpreter;
        this.init();
    }

    public IInterpreterManager getManager() {
        return this.manager;
    }

    public String getAdditionalInfoInterpreter() {
        return this.additionalInfoInterpreter;
    }

    protected File getPersistingFolder() {
        File base;
        if (this.persistingFolderCache != null) {
            return this.persistingFolderCache;
        }
        try {
            IPath stateLocation = AnalysisPlugin.getDefault().getStateLocation();
            base = stateLocation.toFile();
        }
        catch (NullPointerException e) {
            Log.logInfo((String)"Error getting persisting folder", (Throwable)e);
            base = new File(".");
        }
        File file = new File(base, String.valueOf(this.manager.getManagerRelatedName()) + "_" + StringUtils.getExeAsFileSystemValidPath((String)this.additionalInfoInterpreter));
        if (!file.exists()) {
            file.mkdirs();
        }
        this.persistingFolderCache = file;
        return file;
    }

    protected File getPersistingLocation() throws MisconfigurationException {
        if (this.persistingLocation == null) {
            this.persistingLocation = new File(this.getPersistingFolder(), String.valueOf(this.manager.getManagerRelatedName()) + ".pydevsysteminfo");
        }
        return this.persistingLocation;
    }

    protected void setAsDefaultInfo() {
        AdditionalSystemInterpreterInfo.setAdditionalSystemInfo(this.manager, this.additionalInfoInterpreter, this);
    }

    public static boolean loadAdditionalSystemInfo(IInterpreterManager manager, String interpreter) throws MisconfigurationException {
        AdditionalSystemInterpreterInfo info = new AdditionalSystemInterpreterInfo(manager, interpreter);
        return info.load();
    }

    public static AbstractAdditionalDependencyInfo getAdditionalSystemInfo(IInterpreterManager manager, String interpreter) throws MisconfigurationException {
        return AdditionalSystemInterpreterInfo.getAdditionalSystemInfo(manager, interpreter, false);
    }

    public static AbstractAdditionalDependencyInfo getAdditionalSystemInfo(IInterpreterManager manager, String interpreter, boolean errorIfNotAvailable) throws MisconfigurationException {
        Tuple key = new Tuple((Object)manager.getManagerRelatedName(), (Object)interpreter);
        AbstractAdditionalDependencyInfo info = (AbstractAdditionalDependencyInfo)additionalSystemInfo.get(key);
        if (info == null) {
            return new AdditionalSystemInterpreterInfo(manager, interpreter);
        }
        return info;
    }

    public static void setAdditionalSystemInfo(IInterpreterManager manager, String interpreter, AbstractAdditionalTokensInfo additionalSystemInfoToSet) {
        additionalSystemInfo.put((Tuple<String, String>)new Tuple((Object)manager.getManagerRelatedName(), (Object)interpreter), additionalSystemInfoToSet);
    }

    public int hashCode() {
        return this.additionalInfoInterpreter.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AdditionalSystemInterpreterInfo)) {
            return false;
        }
        AdditionalSystemInterpreterInfo additionalSystemInterpreterInfo = (AdditionalSystemInterpreterInfo)obj;
        return this.additionalInfoInterpreter.equals(additionalSystemInterpreterInfo.additionalInfoInterpreter);
    }
}

