/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.log;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.MessageConsole;
import org.python.pydev.core.CorePlugin;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.Tuple;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Log {
    private static final int DEBUG_LEVEL = 2;
    private static MessageConsole fConsole;
    private static IOConsoleOutputStream fOutputStream;
    private static Map<Tuple<Integer, String>, Long> lastLoggedTime;
    private static final Object lock;
    private static final StringBuffer logIndent;

    static {
        lastLoggedTime = new HashMap<Tuple<Integer, String>, Long>();
        lock = new Object();
        logIndent = new StringBuffer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CoreException log(int errorLevel, String message, Throwable e) {
        CorePlugin plugin = CorePlugin.getDefault();
        String id = plugin == null ? "CorePlugin" : plugin.getBundle().getSymbolicName();
        Status s = new Status(errorLevel, id, errorLevel, message, e);
        CoreException coreException = new CoreException((IStatus)s);
        Tuple<Integer, String> key = new Tuple<Integer, String>(errorLevel, message);
        Map<Tuple<Integer, String>, Long> map = lastLoggedTime;
        synchronized (map) {
            Long lastLoggedMillis = lastLoggedTime.get(key);
            long currentTimeMillis = System.currentTimeMillis();
            if (lastLoggedMillis != null && currentTimeMillis < lastLoggedMillis + 20000L) {
                return coreException;
            }
            lastLoggedTime.put(key, currentTimeMillis);
        }
        try {
            if (plugin != null) {
                plugin.getLog().log((IStatus)s);
            } else if (2 <= errorLevel) {
                System.err.println(message);
                if (e != null) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception exception) {}
        return coreException;
    }

    public static CoreException log(Throwable e) {
        return Log.log(4, e.getMessage() != null ? e.getMessage() : "No message gotten (null message).", e);
    }

    public static CoreException log(String msg) {
        return Log.log(4, msg, new RuntimeException(msg));
    }

    public static CoreException log(String msg, Throwable e) {
        return Log.log(4, msg, e);
    }

    public static CoreException logInfo(Throwable e) {
        return Log.log(1, e.getMessage(), e);
    }

    public static CoreException logInfo(String msg) {
        return Log.log(1, msg, new RuntimeException(msg));
    }

    public static CoreException logInfo(String msg, Throwable e) {
        return Log.log(1, msg, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void toLogFile(Object obj, String string) {
        Object object = lock;
        synchronized (object) {
            if (obj == null) {
                obj = new Object();
            }
            Class<?> class1 = obj.getClass();
            Log.toLogFile(string, class1);
        }
    }

    public static void toLogFile(String string, Class<? extends Object> class1) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(logIndent);
        buffer.append(FullRepIterable.getLastPart(class1.getName()));
        buffer.append(": ");
        buffer.append(string);
        Log.toLogFile(buffer.toString());
    }

    private static void toLogFile(final String buffer) {
        Runnable r = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = lock;
                synchronized (object) {
                    try {
                        CorePlugin default1 = CorePlugin.getDefault();
                        if (default1 == null) {
                            System.out.println(buffer);
                            return;
                        }
                        System.out.println(buffer);
                        IOConsoleOutputStream c = Log.getConsoleOutputStream();
                        c.write(buffer.toString());
                        c.write("\r\n");
                    }
                    catch (Throwable e) {
                        Log.log(e);
                    }
                }
            }
        };
        Display current = Display.getCurrent();
        if (current != null && current.getThread() == Thread.currentThread()) {
            r.run();
        } else if (current == null) {
            current = Display.getDefault();
            current.asyncExec(r);
        }
    }

    private static IOConsoleOutputStream getConsoleOutputStream() {
        if (fConsole == null) {
            fConsole = new MessageConsole("PyDev Logging", CorePlugin.getImageCache().getDescriptor("icons/python_logging.png"));
            fOutputStream = fConsole.newOutputStream();
            HashMap<IOConsoleOutputStream, String> themeConsoleStreamToColor = new HashMap<IOConsoleOutputStream, String>();
            themeConsoleStreamToColor.put(fOutputStream, "console.output");
            fConsole.setAttribute("themeConsoleStreamToColor", themeConsoleStreamToColor);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{fConsole});
        }
        return fOutputStream;
    }

    public static void toLogFile(Exception e) {
        String msg = Log.getExceptionStr(e);
        Log.toLogFile(msg);
    }

    public static String getExceptionStr(Exception e) {
        ByteArrayOutputStream str = new ByteArrayOutputStream();
        PrintStream prnt = new PrintStream(str);
        e.printStackTrace(prnt);
        prnt.flush();
        String msg = new String(str.toByteArray());
        return msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addLogLevel() {
        Object object = lock;
        synchronized (object) {
            logIndent.append("    ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remLogLevel() {
        Object object = lock;
        synchronized (object) {
            if (logIndent.length() > 3) {
                logIndent.delete(0, 4);
            }
        }
    }

    @Deprecated
    public static void log(IStatus status) {
        CorePlugin.getDefault().getLog().log(status);
    }
}

