/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.core.callbacks;

import org.python.pydev.core.OrderedSet;
import org.python.pydev.core.callbacks.ICallbackListener;
import org.python.pydev.core.callbacks.ICallbackWithListeners;
import org.python.pydev.core.log.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallbackWithListeners<X>
implements ICallbackWithListeners<X> {
    private final OrderedSet<ICallbackListener<X>> listeners = new OrderedSet();

    @Override
    public Object call(X obj) {
        Object result = null;
        for (ICallbackListener iCallbackListener : this.listeners) {
            try {
                Object callResult = iCallbackListener.call(obj);
                if (callResult == null) continue;
                result = callResult;
            }
            catch (Throwable e) {
                Log.log(e);
            }
        }
        return result;
    }

    @Override
    public void registerListener(ICallbackListener<X> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void unregisterListener(ICallbackListener<X> listener) {
        this.listeners.remove(listener);
    }
}

