/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model.remote;

import java.io.IOException;
import java.net.Socket;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.model.IProcess;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.remote.AbstractRemoteDebugger;
import org.python.pydev.debug.model.remote.ListenConnector;
import org.python.pydev.debug.ui.launching.PythonRunnerConfig;

public class RemoteDebugger
extends AbstractRemoteDebugger {
    private ListenConnector connector;
    private Thread connectThread;
    private PythonRunnerConfig config;

    public RemoteDebugger(PythonRunnerConfig config) {
        this.config = config;
    }

    public void startConnect(IProgressMonitor monitor) throws IOException, CoreException {
        monitor.subTask("Finding free socket...");
        this.connector = this.config.getDebuggerListenConnector();
        this.connectThread = new Thread((Runnable)this.connector, "pydevd.connect");
        this.connectThread.start();
    }

    public Socket waitForConnect(IProgressMonitor monitor, Process p, IProcess ip) throws Exception {
        while (this.connectThread.isAlive()) {
            if (monitor.isCanceled()) {
                this.connector.stopListening();
                p.destroy();
                return null;
            }
            try {
                p.exitValue();
                this.connector.stopListening();
                String errorMessage = ip.getStreamsProxy().getErrorStreamMonitor().getContents();
                if (errorMessage.length() != 0) {
                    throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Something got printed in the error stream", null));
                }
            }
            catch (IllegalThreadStateException illegalThreadStateException) {}
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        Exception connectorException = this.connector.getException();
        if (connectorException != null) {
            throw connectorException;
        }
        return this.connector.getSocket();
    }

    public void disconnect() {
        this.dispose();
    }

    public void dispose() {
        if (this.connector != null) {
            this.connector.stopListening();
            this.connector = null;
        }
        for (AbstractDebugTarget target : this.targets) {
            target.terminate();
        }
    }
}

