/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.debug.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.model.IStackFrame;
import org.python.pydev.core.REF;
import org.python.pydev.debug.core.PydevDebugPlugin;
import org.python.pydev.debug.model.AbstractDebugTarget;
import org.python.pydev.debug.model.IVariableLocator;
import org.python.pydev.debug.model.PyStackFrame;
import org.python.pydev.debug.model.PyThread;
import org.python.pydev.debug.model.PyVariable;
import org.python.pydev.debug.model.PyVariableCollection;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLUtils {
    static SAXParserFactory parserFactory = SAXParserFactory.newInstance();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static SAXParser getSAXParser() throws CoreException {
        SAXParser parser = null;
        try {
            SAXParserFactory sAXParserFactory = parserFactory;
            synchronized (sAXParserFactory) {
                parser = parserFactory.newSAXParser();
            }
        }
        catch (ParserConfigurationException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected XML SAX error", e));
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected XML SAX error", e));
        }
        return parser;
    }

    private static String decode(String value) {
        if (value != null) {
            try {
                return URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static PyThread[] ThreadsFromXML(AbstractDebugTarget target, String payload) throws CoreException {
        try {
            SAXParser parser = XMLUtils.getSAXParser();
            XMLToThreadInfo info = new XMLToThreadInfo(target);
            parser.parse((InputStream)new ByteArrayInputStream(payload.getBytes()), (DefaultHandler)info);
            return info.threads.toArray(new PyThread[0]);
        }
        catch (CoreException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected XML error", e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected XML error", e));
        }
    }

    static PyVariable createVariable(AbstractDebugTarget target, IVariableLocator locator, Attributes attributes) {
        String name = attributes.getValue("name");
        String type = attributes.getValue("type");
        String value = attributes.getValue("value");
        try {
            if (value != null) {
                value = URLDecoder.decode(value, "UTF-8");
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        String isContainer = attributes.getValue("isContainer");
        PyVariable var = "True".equals(isContainer) ? new PyVariableCollection(target, name, type, value, locator) : new PyVariable(target, name, type, value, locator);
        return var;
    }

    public static Object[] XMLToStack(AbstractDebugTarget target, String payload) throws CoreException {
        Object[] retVal = new Object[3];
        try {
            SAXParser parser = XMLUtils.getSAXParser();
            XMLToStackInfo info = new XMLToStackInfo(target);
            parser.parse((InputStream)new ByteArrayInputStream(payload.getBytes()), (DefaultHandler)info);
            IStackFrame[] stack = info.stack.toArray(new IStackFrame[0]);
            retVal[0] = info.thread;
            retVal[1] = info.stop_reason;
            retVal[2] = stack;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected XML error reading:" + payload, e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected IO error reading xml:" + payload, e));
        }
        return retVal;
    }

    public static PyVariable[] XMLToVariables(AbstractDebugTarget target, IVariableLocator locator, String payload) throws CoreException {
        try {
            SAXParser parser = XMLUtils.getSAXParser();
            XMLToVariableInfo info = new XMLToVariableInfo(target, locator);
            parser.parse((InputStream)new ByteArrayInputStream(payload.getBytes()), (DefaultHandler)info);
            PyVariable[] vars = new PyVariable[info.vars.size()];
            int i = 0;
            while (i < info.vars.size()) {
                vars[i] = info.vars.get(i);
                ++i;
            }
            return vars;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected XML error", e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected XML error", e));
        }
    }

    public static List<Object[]> XMLToCompletions(String payload) throws CoreException {
        try {
            SAXParser parser = XMLUtils.getSAXParser();
            XMLToCompletionsInfo info = new XMLToCompletionsInfo();
            parser.parse((InputStream)new ByteArrayInputStream(payload.getBytes()), (DefaultHandler)info);
            return info.completions;
        }
        catch (CoreException e) {
            throw e;
        }
        catch (SAXException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected XML error", e));
        }
        catch (IOException e) {
            throw new CoreException((IStatus)PydevDebugPlugin.makeStatus(4, "Unexpected XML error", e));
        }
    }

    static class XMLToCompletionsInfo
    extends DefaultHandler {
        public List<Object[]> completions = new ArrayList<Object[]>();

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("comp")) {
                Object[] comp = new Object[]{XMLUtils.decode(attributes.getValue("p0")), XMLUtils.decode(attributes.getValue("p1")), XMLUtils.decode(attributes.getValue("p2")), XMLUtils.decode(attributes.getValue("p3"))};
                this.completions.add(comp);
            }
        }
    }

    static class XMLToStackInfo
    extends DefaultHandler {
        public PyThread thread;
        public String stop_reason;
        public List<IStackFrame> stack = new ArrayList<IStackFrame>();
        public List<PyVariable> locals;
        public AbstractDebugTarget target;
        PyStackFrame currentFrame;

        public XMLToStackInfo(AbstractDebugTarget target) {
            this.target = target;
        }

        private void startThread(Attributes attributes) throws SAXException {
            String target_id = attributes.getValue("id");
            this.thread = this.target.findThreadByID(target_id);
            if (this.thread == null) {
                throw new SAXException("Thread not found (" + target_id + ")");
            }
            this.stop_reason = attributes.getValue("stop_reason");
        }

        private void startFrame(Attributes attributes) {
            String name = attributes.getValue("name");
            String id = attributes.getValue("id");
            String file = attributes.getValue("file");
            try {
                File tempFile;
                if (file != null && (tempFile = new File(file = URLDecoder.decode(file, "UTF-8"))).exists()) {
                    file = REF.getFileAbsolutePath((File)tempFile);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String line = attributes.getValue("line");
            Path filePath = new Path(file);
            this.currentFrame = this.thread.findStackFrameByID(id);
            if (this.currentFrame == null) {
                this.currentFrame = new PyStackFrame(this.thread, id, name, (IPath)filePath, Integer.parseInt(line), this.target);
            } else {
                this.currentFrame.setName(name);
                this.currentFrame.setPath((IPath)filePath);
                this.currentFrame.setLine(Integer.parseInt(line));
            }
            this.stack.add(this.currentFrame);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("thread")) {
                this.startThread(attributes);
            } else if (qName.equals("frame")) {
                this.startFrame(attributes);
            }
        }

        public void endElement(String uri, String localName, String qName) throws SAXException {
        }
    }

    static class XMLToThreadInfo
    extends DefaultHandler {
        public AbstractDebugTarget target;
        public List<PyThread> threads = new ArrayList<PyThread>();

        public XMLToThreadInfo(AbstractDebugTarget target) {
            this.target = target;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("thread")) {
                String name = attributes.getValue("name");
                String id = attributes.getValue("id");
                name = XMLUtils.decode(name);
                this.threads.add(new PyThread(this.target, name, id));
            }
        }
    }

    static class XMLToVariableInfo
    extends DefaultHandler {
        private AbstractDebugTarget target;
        private IVariableLocator locator;
        public List<PyVariable> vars;

        public XMLToVariableInfo(AbstractDebugTarget target, IVariableLocator locator) {
            this.target = target;
            this.locator = locator;
            this.vars = new ArrayList<PyVariable>();
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals("var")) {
                this.vars.add(XMLUtils.createVariable(this.target, this.locator, attributes));
            }
        }
    }
}

