/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.parser;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.python.pydev.core.IPyEdit;
import org.python.pydev.core.parser.IParserObserver;
import org.python.pydev.core.parser.IPyParser;
import org.python.pydev.parser.PyParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyParserManager {
    private static final boolean DEBUG = false;
    private Object lock = new Object();
    private static final String KEY_IN_PYEDIT_CACHE = "PyParserManager_PyParser";
    public static final String USE_PYDEV_ANALYSIS_ONLY_ON_DOC_SAVE = "USE_PYDEV_ONLY_ON_DOC_SAVE";
    public static final String PYDEV_ELAPSE_BEFORE_ANALYSIS = "PYDEV_ELAPSE_BEFORE_ANALYSIS";
    private IPreferenceStore prefs;
    private int millisBeforeAnalysis;
    private boolean useOnlyOnSave;
    private static PyParserManager pyParserManager;
    private volatile Map<IPyParser, List<IPyEdit>> parsers = new HashMap<IPyParser, List<IPyEdit>>();

    public int getElapseMillisBeforeAnalysis() {
        return this.millisBeforeAnalysis;
    }

    public boolean useAnalysisOnlyOnDocSave() {
        return this.useOnlyOnSave;
    }

    public static synchronized PyParserManager getPyParserManager(IPreferenceStore prefs) {
        if (pyParserManager == null) {
            pyParserManager = new PyParserManager(prefs);
        }
        return pyParserManager;
    }

    public static synchronized void setPyParserManager(PyParserManager pyParserManager) {
        PyParserManager.pyParserManager = pyParserManager;
    }

    private PyParserManager(IPreferenceStore prefs) {
        Assert.isNotNull((Object)prefs);
        this.prefs = prefs;
        this.millisBeforeAnalysis = prefs.getInt(PYDEV_ELAPSE_BEFORE_ANALYSIS);
        this.useOnlyOnSave = prefs.getBoolean(USE_PYDEV_ANALYSIS_ONLY_ON_DOC_SAVE);
        IPropertyChangeListener prefListener = new IPropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent event) {
                String property = event.getProperty();
                if (property.equals(PyParserManager.USE_PYDEV_ANALYSIS_ONLY_ON_DOC_SAVE) || property.equals(PyParserManager.PYDEV_ELAPSE_BEFORE_ANALYSIS)) {
                    PyParserManager.this.millisBeforeAnalysis = PyParserManager.this.prefs.getInt(PyParserManager.PYDEV_ELAPSE_BEFORE_ANALYSIS);
                    PyParserManager.this.useOnlyOnSave = PyParserManager.this.prefs.getBoolean(PyParserManager.USE_PYDEV_ANALYSIS_ONLY_ON_DOC_SAVE);
                    boolean useAnalysisOnlyOnDocSave = PyParserManager.this.useAnalysisOnlyOnDocSave();
                    Object object = PyParserManager.this.lock;
                    synchronized (object) {
                        for (IPyParser parser : PyParserManager.this.parsers.keySet()) {
                            parser.resetTimeoutPreferences(useAnalysisOnlyOnDocSave);
                        }
                    }
                }
            }
        };
        this.prefs.addPropertyChangeListener(prefListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<IPyParser> getParsers() {
        Object object = this.lock;
        synchronized (object) {
            ArrayList<IPyParser> ret = new ArrayList<IPyParser>(this.parsers.keySet());
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void attachParserTo(IPyEdit edit) {
        Object object = this.lock;
        synchronized (object) {
            IPyParser existingParser = this.getParser(edit);
            if (existingParser != null) {
                this.notifyEditorDisposed(edit);
            }
            for (Map.Entry<IPyParser, List<IPyEdit>> entry : this.parsers.entrySet()) {
                for (IPyEdit curr : entry.getValue()) {
                    if (!curr.hasSameInput(edit)) continue;
                    IPyParser p = this.getParser(curr);
                    this.makeParserAssociations(edit, p);
                    p.forceReparse(new Object[0]);
                    return;
                }
            }
            PyParser pyParser = new PyParser(edit);
            boolean useAnalysisOnlyOnDocSave = this.useAnalysisOnlyOnDocSave();
            pyParser.resetTimeoutPreferences(useAnalysisOnlyOnDocSave);
            this.makeParserAssociations(edit, pyParser);
            IDocument doc = edit.getDocument();
            pyParser.setDocument(doc, edit.getEditorInput());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void makeParserAssociations(IPyEdit edit, IPyParser pyParser) {
        Object object = this.lock;
        synchronized (object) {
            List<IPyEdit> lst = this.parsers.get(pyParser);
            if (lst == null) {
                lst = new ArrayList<IPyEdit>();
                this.parsers.put(pyParser, lst);
            }
            lst.add(edit);
            pyParser.addParseListener((IParserObserver)edit);
            edit.getCache().put(KEY_IN_PYEDIT_CACHE, pyParser);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notifySaved(IPyEdit edit) {
        Object object = this.lock;
        synchronized (object) {
            this.getParser(edit).notifySaved();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void notifyEditorDisposed(IPyEdit edit) {
        Object object = this.lock;
        synchronized (object) {
            IPyParser parser = this.getParser(edit);
            if (parser != null) {
                boolean dispose;
                parser.removeParseListener((IParserObserver)edit);
                List<IPyEdit> lst = this.parsers.get(parser);
                lst.remove(edit);
                edit.getCache().remove(KEY_IN_PYEDIT_CACHE);
                boolean bl = dispose = lst.size() == 0;
                if (dispose) {
                    parser.dispose();
                    this.parsers.remove(parser);
                } else {
                    IPyEdit pyEdit = lst.get(0);
                    IDocument doc = pyEdit.getDocument();
                    parser.setDocument(doc, pyEdit.getEditorInput());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized IPyParser getParser(IPyEdit edit) {
        Object object = this.lock;
        synchronized (object) {
            return (IPyParser)edit.getCache().get(KEY_IN_PYEDIT_CACHE);
        }
    }
}

