/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.django_templates.common;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;

public abstract class DjContentDescriber
implements ITextContentDescriber {
    private static final QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK};

    public int describe(Reader contents, IContentDescription description) throws IOException {
        BufferedReader reader = new BufferedReader(contents);
        String line = reader.readLine();
        if (line == null) {
            return 1;
        }
        if (!line.startsWith(this.getPrefix())) {
            return 1;
        }
        return 2;
    }

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        byte[] xmlPrefixBytes;
        byte[] prefix;
        byte[] bom = this.getByteOrderMark(contents);
        contents.reset();
        String xmlDeclEncoding = "UTF-8";
        if (bom != null) {
            if (bom == IContentDescription.BOM_UTF_16BE) {
                xmlDeclEncoding = "UTF-16BE";
            } else if (bom == IContentDescription.BOM_UTF_16LE) {
                xmlDeclEncoding = "UTF-16LE";
            }
            contents.skip(bom.length);
        }
        if (contents.read(prefix = new byte[(xmlPrefixBytes = this.getPrefix().getBytes(xmlDeclEncoding)).length]) < prefix.length) {
            return 1;
        }
        int i = 0;
        while (i < prefix.length) {
            if (prefix[i] != xmlPrefixBytes[i]) {
                return 1;
            }
            ++i;
        }
        return 2;
    }

    public QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    protected abstract String getPrefix();

    private byte[] getByteOrderMark(InputStream input) throws IOException {
        int first = input.read();
        if (first == 239) {
            int second = input.read();
            int third = input.read();
            if (second == 187 && third == 191) {
                return IContentDescription.BOM_UTF_8;
            }
        } else if (first == 254) {
            if (input.read() == 255) {
                return IContentDescription.BOM_UTF_16BE;
            }
        } else if (first == 255 && input.read() == 254) {
            return IContentDescription.BOM_UTF_16LE;
        }
        return null;
    }
}

