/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.codecompletion.participant;

import com.python.pydev.analysis.CtxInsensitiveImportComplProposal;
import com.python.pydev.analysis.ui.AutoImportsPreferencesPage;
import com.python.pydev.codecompletion.ctxinsensitive.PyConsoleCompletion;
import com.python.pydev.codecompletion.ui.CodeCompletionPreferencesPage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;
import org.python.pydev.core.FullRepIterable;
import org.python.pydev.core.ICodeCompletionASTManager;
import org.python.pydev.core.ICompletionState;
import org.python.pydev.core.ILocalScope;
import org.python.pydev.core.IModulesManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IToken;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.PythonNatureWithoutProjectException;
import org.python.pydev.core.docutils.PySelection;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.dltk.console.ui.IScriptConsoleViewer;
import org.python.pydev.editor.codecompletion.CompletionRequest;
import org.python.pydev.editor.codecompletion.IPyDevCompletionParticipant;
import org.python.pydev.editor.codecompletion.IPyDevCompletionParticipant2;
import org.python.pydev.editor.codecompletion.PyCodeCompletionImages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportsCompletionParticipant
implements IPyDevCompletionParticipant,
IPyDevCompletionParticipant2 {
    public Collection<ICompletionProposal> computeConsoleCompletions(PySelection.ActivationTokenAndQual tokenAndQual, List<IPythonNature> naturesUsed, IScriptConsoleViewer viewer, int requestOffset) {
        ArrayList<ICompletionProposal> completions = new ArrayList<ICompletionProposal>();
        if (tokenAndQual.activationToken != null && tokenAndQual.activationToken.length() > 0) {
            return completions;
        }
        String qual = tokenAndQual.qualifier;
        if (qual.length() >= CodeCompletionPreferencesPage.getCharsForContextInsensitiveModulesCompletion() && naturesUsed != null && naturesUsed.size() > 0) {
            int qlen = qual.length();
            boolean addAutoImport = AutoImportsPreferencesPage.doAutoImport();
            for (IPythonNature nature : naturesUsed) {
                this.fillCompletions(requestOffset, completions, qual, nature, qlen, addAutoImport, viewer, false);
            }
            this.fillCompletions(requestOffset, completions, qual, naturesUsed.get(0), qlen, addAutoImport, viewer, true);
        }
        return completions;
    }

    private void fillCompletions(int requestOffset, ArrayList<ICompletionProposal> completions, String qual, IPythonNature nature, int qlen, boolean addAutoImport, IScriptConsoleViewer viewer, boolean getSystem) {
        ICodeCompletionASTManager astManager = nature.getAstManager();
        if (astManager == null) {
            return;
        }
        Image img = PyCodeCompletionImages.getImageForType((int)6);
        IModulesManager modulesManager = astManager.getModulesManager();
        try {
            if (modulesManager == null) {
                nature.getProjectInterpreter();
            }
            if (getSystem && (modulesManager = modulesManager.getSystemModulesManager()) == null) {
                nature.getProjectInterpreter();
            }
        }
        catch (PythonNatureWithoutProjectException e) {
            throw new RuntimeException(e);
        }
        catch (MisconfigurationException e) {
            throw new RuntimeException(e);
        }
        String lowerQual = qual.toLowerCase();
        Set allModuleNames = modulesManager.getAllModuleNames(false, lowerQual);
        FastStringBuffer realImportRep = new FastStringBuffer();
        FastStringBuffer displayString = new FastStringBuffer();
        HashSet<String> alreadyFound = new HashSet<String>();
        for (String name : allModuleNames) {
            FullRepIterable iterable = new FullRepIterable(name);
            for (String string : iterable) {
                String found;
                realImportRep.clear();
                String[] strings = FullRepIterable.headAndTail((String)string);
                String importRep = strings[1];
                String lowerImportRep = importRep.toLowerCase();
                if (!lowerImportRep.startsWith(lowerQual)) continue;
                displayString.clear();
                displayString.append(importRep);
                String packageName = strings[0];
                if (packageName.length() > 0) {
                    if (addAutoImport) {
                        realImportRep.append("from ");
                        realImportRep.append(packageName);
                        realImportRep.append(" ");
                    }
                    displayString.append(" - ");
                    displayString.append(packageName);
                }
                if (addAutoImport) {
                    realImportRep.append("import ");
                    realImportRep.append(strings[1]);
                }
                if (alreadyFound.contains(found = displayString.toString())) continue;
                alreadyFound.add(found);
                PyConsoleCompletion proposal = new PyConsoleCompletion(importRep, requestOffset - qlen, qlen, realImportRep.length(), img, found, null, "", lowerImportRep.equals(lowerQual) ? 1 : 100, realImportRep.toString(), viewer);
                completions.add((ICompletionProposal)proposal);
            }
        }
    }

    private Collection<CtxInsensitiveImportComplProposal> getThem(CompletionRequest request, ICompletionState state, boolean addAutoImport) throws MisconfigurationException {
        ArrayList<CtxInsensitiveImportComplProposal> list = new ArrayList<CtxInsensitiveImportComplProposal>();
        if (request.isInCalltip) {
            return list;
        }
        if (request.qualifier.length() >= CodeCompletionPreferencesPage.getCharsForContextInsensitiveModulesCompletion()) {
            ICodeCompletionASTManager astManager = request.nature.getAstManager();
            if (astManager == null) {
                return list;
            }
            String initialModule = request.resolveModule();
            Image img = PyCodeCompletionImages.getImageForType((int)6);
            IModulesManager projectModulesManager = astManager.getModulesManager();
            String lowerQual = request.qualifier.toLowerCase();
            Set allModuleNames = projectModulesManager.getAllModuleNames(true, lowerQual);
            FastStringBuffer realImportRep = new FastStringBuffer();
            FastStringBuffer displayString = new FastStringBuffer();
            HashSet<String> importedNames = this.getImportedNames(state);
            for (String name : allModuleNames) {
                if (name.equals(initialModule)) continue;
                FullRepIterable iterable = new FullRepIterable(name);
                for (String string : iterable) {
                    realImportRep.clear();
                    String[] strings = FullRepIterable.headAndTail((String)string);
                    String importRep = strings[1];
                    String lowerImportRep = importRep.toLowerCase();
                    if (!lowerImportRep.startsWith(lowerQual) || importedNames.contains(importRep)) continue;
                    displayString.clear();
                    displayString.append(importRep);
                    String packageName = strings[0];
                    if (packageName.length() > 0) {
                        if (addAutoImport) {
                            realImportRep.append("from ");
                            realImportRep.append(packageName);
                            realImportRep.append(" ");
                        }
                        displayString.append(" - ");
                        displayString.append(packageName);
                    }
                    if (addAutoImport) {
                        realImportRep.append("import ");
                        realImportRep.append(strings[1]);
                    }
                    CtxInsensitiveImportComplProposal proposal = new CtxInsensitiveImportComplProposal(importRep, request.documentOffset - request.qlen, request.qlen, realImportRep.length(), img, displayString.toString(), null, "", lowerImportRep.equals(lowerQual) ? 1 : 100, realImportRep.toString());
                    list.add(proposal);
                }
            }
        }
        return list;
    }

    private HashSet<String> getImportedNames(ICompletionState state) {
        List tokenImportedModules = state.getTokenImportedModules();
        HashSet<String> importedNames = new HashSet<String>();
        if (tokenImportedModules != null) {
            for (IToken token : tokenImportedModules) {
                importedNames.add(token.getRepresentation());
            }
        }
        return importedNames;
    }

    public Collection getGlobalCompletions(CompletionRequest request, ICompletionState state) throws MisconfigurationException {
        return this.getThem(request, state, AutoImportsPreferencesPage.doAutoImport());
    }

    public Collection getCompletionsForMethodParameter(ICompletionState state, ILocalScope localScope, Collection<IToken> interfaceForLocal) {
        return Collections.emptyList();
    }

    public Collection getStringGlobalCompletions(CompletionRequest request, ICompletionState state) throws MisconfigurationException {
        return this.getThem(request, state, false);
    }

    public Collection<Object> getArgsCompletion(ICompletionState state, ILocalScope localScope, Collection<IToken> interfaceForLocal) {
        throw new RuntimeException("Deprecated");
    }

    public Collection<IToken> getCompletionsForTokenWithUndefinedType(ICompletionState state, ILocalScope localScope, Collection<IToken> interfaceForLocal) {
        return Collections.emptyList();
    }
}

