/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.ui.pythonpathconf;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.dialogs.SelectionDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyListSelectionDialog
extends SelectionDialog {
    private List<String> inputElement;
    private ILabelProvider labelProvider;
    private IStructuredContentProvider contentProvider;
    CheckboxTableViewer listViewer;
    private boolean addSelectAllNotInWorkspace;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 250;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 300;

    public PyListSelectionDialog(Shell parentShell, List<String> input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String message, boolean addSelectAllNotInWorkspace) {
        super(parentShell);
        this.addSelectAllNotInWorkspace = addSelectAllNotInWorkspace;
        this.setTitle("Selection needed");
        this.inputElement = input;
        this.contentProvider = contentProvider;
        this.labelProvider = labelProvider;
        if (message != null) {
            this.setMessage(message);
        } else {
            this.setMessage("Select items");
        }
    }

    private void addSelectionButtons(Composite composite) {
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        buttonComposite.setLayout((Layout)layout);
        buttonComposite.setLayoutData((Object)new GridData(0x1000008, 128, true, false));
        if (this.addSelectAllNotInWorkspace) {
            Button selectNotInWorkspaceButton = this.createButton(buttonComposite, 18, "Select All not in Workspace", false);
            SelectionAdapter listenerNotInWorkspace = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IProject[] projects;
                    IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
                    IPath rootLocation = root.getLocation().makeAbsolute();
                    HashSet<IPath> rootPaths = new HashSet<IPath>();
                    rootPaths.add(rootLocation);
                    IProject[] iProjectArray = projects = root.getProjects();
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject iProject = iProjectArray[n2];
                        IPath location = iProject.getLocation();
                        IPath abs = location.makeAbsolute();
                        if (!rootLocation.isPrefixOf(abs)) {
                            rootPaths.add(abs);
                        }
                        ++n2;
                    }
                    TableItem[] children = PyListSelectionDialog.this.listViewer.getTable().getItems();
                    int i = 0;
                    while (i < children.length) {
                        TableItem item = children[i];
                        String data = (String)item.getData();
                        IPath path = Path.fromOSString((String)data);
                        boolean found = false;
                        for (IPath p : rootPaths) {
                            if (!p.isPrefixOf(path)) continue;
                            found = true;
                            break;
                        }
                        item.setChecked(!found);
                        ++i;
                    }
                }
            };
            selectNotInWorkspaceButton.addSelectionListener((SelectionListener)listenerNotInWorkspace);
        }
        Button selectButton = this.createButton(buttonComposite, 18, "Select All", false);
        SelectionAdapter listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PyListSelectionDialog.this.listViewer.setAllChecked(true);
            }
        };
        selectButton.addSelectionListener((SelectionListener)listener);
        Button deselectButton = this.createButton(buttonComposite, 19, "Deselect All", false);
        listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PyListSelectionDialog.this.listViewer.setAllChecked(false);
            }
        };
        deselectButton.addSelectionListener((SelectionListener)listener);
    }

    private void checkInitialSelections() {
        Iterator itemsToCheck = this.getInitialElementSelections().iterator();
        while (itemsToCheck.hasNext()) {
            this.listViewer.setChecked(itemsToCheck.next(), true);
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.initializeDialogUnits((Control)composite);
        this.createMessageArea(composite);
        this.listViewer = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        GridData data = new GridData(1808);
        data.heightHint = 250;
        data.widthHint = 300;
        this.listViewer.getTable().setLayoutData((Object)data);
        this.listViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.listViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.addSelectionButtons(composite);
        this.initializeViewer();
        if (!this.getInitialElementSelections().isEmpty()) {
            this.checkInitialSelections();
        }
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected CheckboxTableViewer getViewer() {
        return this.listViewer;
    }

    private void initializeViewer() {
        this.listViewer.setInput(this.inputElement);
    }

    protected void okPressed() {
        Object[] children = this.contentProvider.getElements(this.inputElement);
        if (children != null) {
            ArrayList<Object> list = new ArrayList<Object>();
            int i = 0;
            while (i < children.length) {
                Object element = children[i];
                if (this.listViewer.getChecked(element)) {
                    list.add(element);
                }
                ++i;
            }
            this.setResult(list);
        }
        super.okPressed();
    }
}

