/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.runners;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchManager;
import org.python.pydev.core.IInterpreterInfo;
import org.python.pydev.core.IInterpreterManager;
import org.python.pydev.core.IPythonNature;
import org.python.pydev.core.IPythonPathNature;
import org.python.pydev.core.MisconfigurationException;
import org.python.pydev.core.REF;
import org.python.pydev.core.Tuple;
import org.python.pydev.core.docutils.StringSubstitution;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;
import org.python.pydev.core.structure.FastStringBuffer;
import org.python.pydev.plugin.PydevPlugin;
import org.python.pydev.runners.ThreadStreamReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleRunner {
    public static Process createProcess(String[] cmdarray, String[] envp, File workingDir) throws IOException {
        return Runtime.getRuntime().exec(SimpleRunner.getWithoutEmptyParams(cmdarray), SimpleRunner.getWithoutEmptyParams(envp), workingDir);
    }

    private static String[] getWithoutEmptyParams(String[] cmdarray) {
        if (cmdarray == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        String[] stringArray = cmdarray;
        int n = cmdarray.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (string != null && string.length() > 0) {
                list.add(string);
            }
            ++n2;
        }
        return list.toArray(new String[list.size()]);
    }

    public static String[] getEnvironment(IPythonNature pythonNature, IInterpreterInfo interpreter, IInterpreterManager manager, boolean removePythonpathFromDefaultEnv) throws CoreException {
        String[] env;
        if (pythonNature == null) {
            env = SimpleRunner.getDefaultSystemEnvAsArray(null, removePythonpathFromDefaultEnv);
        } else {
            String pythonPathEnvStr = "";
            try {
                if (interpreter != null) {
                    pythonPathEnvStr = SimpleRunner.makePythonPathEnvString(pythonNature, interpreter, manager);
                }
                env = SimpleRunner.createEnvWithPythonpath(pythonPathEnvStr, pythonNature, manager);
            }
            catch (Exception e) {
                Log.log((Throwable)e);
                env = SimpleRunner.getDefaultSystemEnvAsArray(pythonNature, removePythonpathFromDefaultEnv);
            }
        }
        if (interpreter != null) {
            env = interpreter.updateEnv(env);
        }
        return env;
    }

    public static String[] createEnvWithPythonpath(String pythonPathEnvStr, String interpreter, IInterpreterManager manager, IPythonNature nature) throws CoreException, MisconfigurationException {
        String[] env = SimpleRunner.createEnvWithPythonpath(pythonPathEnvStr, nature, manager);
        IInterpreterInfo info = manager.getInterpreterInfo(interpreter, (IProgressMonitor)new NullProgressMonitor());
        env = info.updateEnv(env);
        return env;
    }

    private static String[] createEnvWithPythonpath(String pythonPathEnvStr, IPythonNature nature, IInterpreterManager manager) throws CoreException {
        DebugPlugin defaultPlugin = DebugPlugin.getDefault();
        if (defaultPlugin != null) {
            Map<String, String> env = SimpleRunner.getDefaultSystemEnv(defaultPlugin, nature, false);
            env.put("PYTHONPATH", pythonPathEnvStr);
            switch (manager.getInterpreterType()) {
                case 1: {
                    env.put("CLASSPATH", pythonPathEnvStr);
                    env.put("JYTHONPATH", pythonPathEnvStr);
                    break;
                }
                case 2: {
                    env.put("IRONPYTHONPATH", pythonPathEnvStr);
                }
            }
            return SimpleRunner.getMapEnvAsArray(env);
        }
        return null;
    }

    public static String[] getDefaultSystemEnvAsArray(IPythonNature nature, boolean removePythonpathFromDefaultEnv) throws CoreException {
        Map<String, String> defaultSystemEnv = SimpleRunner.getDefaultSystemEnv(nature, removePythonpathFromDefaultEnv);
        if (defaultSystemEnv != null) {
            return SimpleRunner.getMapEnvAsArray(defaultSystemEnv);
        }
        return null;
    }

    public static Map<String, String> getDefaultSystemEnv(IPythonNature nature, boolean removePythonpathFromDefaultEnv) throws CoreException {
        DebugPlugin defaultPlugin = DebugPlugin.getDefault();
        return SimpleRunner.getDefaultSystemEnv(defaultPlugin, nature, removePythonpathFromDefaultEnv);
    }

    private static Map<String, String> getDefaultSystemEnv(DebugPlugin defaultPlugin, IPythonNature nature, boolean removePythonpathFromDefaultEnv) throws CoreException {
        if (defaultPlugin != null) {
            ILaunchManager launchManager = defaultPlugin.getLaunchManager();
            HashMap<String, String> env = new HashMap<String, String>();
            env.putAll(launchManager.getNativeEnvironment());
            boolean win32 = REF.isWindowsPlatform();
            for (Map.Entry entry : env.entrySet()) {
                String value;
                String key = (String)entry.getKey();
                if (win32) {
                    key = key.toUpperCase();
                }
                String translated = value = (String)entry.getValue();
                try {
                    StringSubstitution stringSubstitution = new StringSubstitution(nature);
                    translated = stringSubstitution.performStringSubstitution(value, false);
                }
                catch (Exception e) {
                    Log.log((Throwable)e);
                }
                env.put(key, translated);
            }
            env.remove("PYTHONHOME");
            if (removePythonpathFromDefaultEnv) {
                env.remove("PYTHONPATH");
            }
            return env;
        }
        return null;
    }

    public static String getArgumentsAsStr(String[] commandLine, String ... args) {
        if (args != null && args.length > 0) {
            String[] newCommandLine = new String[commandLine.length + args.length];
            System.arraycopy(commandLine, 0, newCommandLine, 0, commandLine.length);
            System.arraycopy(args, 0, newCommandLine, commandLine.length, args.length);
            commandLine = newCommandLine;
        }
        if (commandLine.length < 1) {
            return "";
        }
        FastStringBuffer buf = new FastStringBuffer();
        FastStringBuffer command = new FastStringBuffer();
        int i = 0;
        while (i < commandLine.length) {
            if (commandLine[i] != null) {
                buf.append(' ');
                char[] characters = commandLine[i].toCharArray();
                command.clear();
                boolean containsSpace = false;
                int j = 0;
                while (j < characters.length) {
                    char character = characters[j];
                    if (character == '\"') {
                        command.append('\\');
                    } else if (character == ' ') {
                        containsSpace = true;
                    }
                    command.append(character);
                    ++j;
                }
                if (containsSpace) {
                    buf.append('\"');
                    buf.append(command.toString());
                    buf.append('\"');
                } else {
                    buf.append(command.toString());
                }
            }
            ++i;
        }
        return buf.toString();
    }

    public static String makePythonPathEnvString(IPythonNature pythonNature, IInterpreterInfo interpreter, IInterpreterManager manager) {
        if (pythonNature == null) {
            return SimpleRunner.makePythonPathEnvFromPaths(new ArrayList<String>());
        }
        IPythonPathNature pythonPathNature = pythonNature.getPythonPathNature();
        if (pythonPathNature == null) {
            IProject project = pythonNature.getProject();
            String projectName = project == null ? "null?" : project.getName();
            throw new RuntimeException("The project " + projectName + " does not have the pythonpath configured, \n" + "please configure it correcly (please check the pydev getting started guide at \n" + "http://pydev.org/manual_101_root.html for better information on how to do it).");
        }
        List paths = pythonPathNature.getCompleteProjectPythonPath(interpreter, manager);
        return SimpleRunner.makePythonPathEnvFromPaths(paths);
    }

    public static String makePythonPathEnvFromPaths(Collection<String> inPaths) {
        ArrayList<String> paths = new ArrayList<String>(inPaths);
        try {
            paths.add(0, REF.getFileAbsolutePath((File)PydevPlugin.getScriptWithinPySrc("pydev_sitecustomize")));
        }
        catch (CoreException e) {
            Log.log((Throwable)e);
        }
        String separator = SimpleRunner.getPythonPathSeparator();
        StringBuffer pythonpath = new StringBuffer();
        boolean first = true;
        for (String path : paths) {
            if (first) {
                first = false;
            } else {
                pythonpath.append(separator);
            }
            pythonpath.append(path);
        }
        return pythonpath.toString();
    }

    public static String getPythonPathSeparator() {
        return System.getProperty("path.separator");
    }

    private static String[] getMapEnvAsArray(Map<String, String> env) {
        ArrayList<String> strings = new ArrayList<String>(env.size());
        for (Map.Entry<String, String> entry : env.entrySet()) {
            StringBuffer buffer = new StringBuffer(entry.getKey());
            buffer.append('=').append(entry.getValue());
            strings.add(buffer.toString());
        }
        return strings.toArray(new String[strings.size()]);
    }

    public Tuple<Process, String> run(String[] cmdarray, File workingDir, IPythonNature nature, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        String executionString = SimpleRunner.getArgumentsAsStr(cmdarray, new String[0]);
        monitor.setTaskName("Executing: " + executionString);
        monitor.worked(5);
        Process process = null;
        try {
            monitor.setTaskName("Making pythonpath environment..." + executionString);
            String[] envp = null;
            if (nature != null) {
                envp = SimpleRunner.getEnvironment(nature, nature.getProjectInterpreter(), nature.getRelatedInterpreterManager(), false);
            }
            monitor.setTaskName("Making exec..." + executionString);
            if (workingDir != null && !workingDir.isDirectory()) {
                throw new RuntimeException(StringUtils.format((String)"Working dir must be an existing directory (received: %s)", (Object[])new Object[]{workingDir}));
            }
            process = SimpleRunner.createProcess(cmdarray, envp, workingDir);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return new Tuple((Object)process, (Object)executionString);
    }

    public Tuple<String, String> runAndGetOutput(String[] cmdarray, File workingDir, IPythonNature nature, IProgressMonitor monitor) {
        Tuple<Process, String> r = this.run(cmdarray, workingDir, nature, monitor);
        return SimpleRunner.getProcessOutput((Process)r.o1, (String)r.o2, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Tuple<String, String> getProcessOutput(Process process, String executionString, IProgressMonitor monitor) {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (process != null) {
            try {
                process.getOutputStream().close();
            }
            catch (IOException iOException) {}
            monitor.setTaskName("Reading output...");
            monitor.worked(5);
            ThreadStreamReader std = new ThreadStreamReader(process.getInputStream(), false);
            ThreadStreamReader err = new ThreadStreamReader(process.getErrorStream(), false);
            std.start();
            err.start();
            boolean interrupted = true;
            while (interrupted) {
                interrupted = false;
                try {
                    monitor.setTaskName("Waiting for process to finish.");
                    monitor.worked(5);
                    process.waitFor();
                }
                catch (InterruptedException interruptedException) {
                    interrupted = true;
                }
            }
            try {
                Object sync;
                Object object = sync = new Object();
                synchronized (object) {
                    sync.wait(50L);
                }
            }
            catch (Exception exception) {}
            return new Tuple((Object)std.getContents(), (Object)err.getContents());
        }
        try {
            throw new CoreException((IStatus)PydevPlugin.makeStatus(4, "Error creating process - got null process(" + executionString + ")", new Exception("Error creating process - got null process.")));
        }
        catch (CoreException e) {
            Log.log((int)4, (String)e.getMessage(), (Throwable)e);
            return new Tuple((Object)"", (Object)("Error creating process - got null process(" + executionString + ")"));
        }
    }

    public static List<String> splitPythonpath(String pythonpath) {
        ArrayList<String> splitted = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(pythonpath, SimpleRunner.getPythonPathSeparator());
        while (tokenizer.hasMoreTokens()) {
            splitted.add(tokenizer.nextToken());
        }
        return splitted;
    }
}

