/*
 * Decompiled with CFR 0.152.
 */
package org.python.pydev.outline;

import java.util.ArrayList;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.python.pydev.core.log.Log;
import org.python.pydev.editor.PyEdit;
import org.python.pydev.editor.model.IModelListener;
import org.python.pydev.outline.IOutlineModel;
import org.python.pydev.outline.ParsedItem;
import org.python.pydev.outline.PyOutlinePage;
import org.python.pydev.parser.ErrorDescription;
import org.python.pydev.parser.jython.SimpleNode;
import org.python.pydev.parser.jython.ast.Attribute;
import org.python.pydev.parser.jython.ast.ClassDef;
import org.python.pydev.parser.jython.ast.FunctionDef;
import org.python.pydev.parser.jython.ast.Import;
import org.python.pydev.parser.jython.ast.ImportFrom;
import org.python.pydev.parser.jython.ast.NameTokType;
import org.python.pydev.parser.jython.ast.aliasType;
import org.python.pydev.parser.visitors.scope.ASTEntryWithChildren;
import org.python.pydev.parser.visitors.scope.OutlineCreatorVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParsedModel
implements IOutlineModel {
    PyEdit editor;
    PyOutlinePage outline;
    IModelListener modelListener;
    ParsedItem root = null;

    public ParsedModel(PyOutlinePage outline, PyEdit editor) {
        this.editor = editor;
        this.outline = outline;
        this.modelListener = new IModelListener(){

            public void modelChanged(final SimpleNode ast) {
                Display.getDefault().asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        1 var1_1 = this;
                        synchronized (var1_1) {
                            OutlineCreatorVisitor visitor = OutlineCreatorVisitor.create((SimpleNode)ast);
                            ParsedModel.this.setRoot(new ParsedItem(visitor.getAll().toArray(new ASTEntryWithChildren[0]), (this).ParsedModel.this.editor.getErrorDescription()));
                        }
                    }
                });
            }

            public void errorChanged(final ErrorDescription errorDesc) {
                Display.getDefault().asyncExec(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        2 var1_1 = this;
                        synchronized (var1_1) {
                            ParsedItem currRoot = ParsedModel.this.getRoot();
                            ParsedItem newRoot = currRoot != null ? new ParsedItem(currRoot.getAstChildrenEntries(), errorDesc) : new ParsedItem(new ASTEntryWithChildren[0], errorDesc);
                            ParsedModel.this.setRoot(newRoot);
                        }
                    }
                });
            }
        };
        OutlineCreatorVisitor visitor = OutlineCreatorVisitor.create((SimpleNode)editor.getAST());
        this.root = new ParsedItem(visitor.getAll().toArray(new ASTEntryWithChildren[0]), editor.getErrorDescription());
        editor.addModelListener(this.modelListener);
    }

    @Override
    public void dispose() {
        this.editor.removeModelListener(this.modelListener);
    }

    @Override
    public ParsedItem getRoot() {
        return this.root;
    }

    private void patchRootHelper(ParsedItem oldItem, ParsedItem newItem, ArrayList<ParsedItem> itemsToRefresh, ArrayList<ParsedItem> itemsToUpdate) {
        ParsedItem[] oldChildren;
        ParsedItem[] newChildren = newItem.getChildren();
        if (newChildren.length != (oldChildren = oldItem.getChildren()).length) {
            oldItem.updateTo(newItem);
            itemsToRefresh.add(oldItem);
        } else {
            String newTitle;
            int i = 0;
            while (i < oldChildren.length) {
                this.patchRootHelper(oldChildren[i], newChildren[i], itemsToRefresh, itemsToUpdate);
                ++i;
            }
            String oldTitle = oldItem.toString();
            if (!oldTitle.equals(newTitle = newItem.toString())) {
                itemsToUpdate.add(oldItem);
            } else {
                ASTEntryWithChildren astThisOld = oldItem.getAstThis();
                ASTEntryWithChildren astThisNew = newItem.getAstThis();
                if (astThisOld != null && astThisNew != null && astThisOld.node != null && astThisNew.node != null && astThisOld.node.getClass() != astThisNew.node.getClass()) {
                    itemsToUpdate.add(oldItem);
                }
            }
            oldItem.setAstThis(newItem.getAstThis());
            oldItem.setErrorDesc(newItem.getErrorDesc());
        }
    }

    public void setRoot(ParsedItem newRoot) {
        try {
            if (this.root != null) {
                ArrayList<ParsedItem> itemsToRefresh = new ArrayList<ParsedItem>();
                ArrayList<ParsedItem> itemsToUpdate = new ArrayList<ParsedItem>();
                this.patchRootHelper(this.root, newRoot, itemsToRefresh, itemsToUpdate);
                if (this.outline != null) {
                    int itemsToRefreshSize;
                    if (this.outline.isDisposed()) {
                        return;
                    }
                    int itemsToUpdateSize = itemsToUpdate.size();
                    if (itemsToUpdateSize > 0) {
                        this.outline.updateItems(itemsToUpdate.toArray(new ParsedItem[itemsToUpdateSize]));
                    }
                    if ((itemsToRefreshSize = itemsToRefresh.size()) > 0) {
                        this.outline.refreshItems(itemsToRefresh.toArray(new ParsedItem[itemsToRefreshSize]));
                    }
                }
            } else {
                Log.log((String)"No old model root?");
            }
        }
        catch (Throwable e) {
            Log.log((Throwable)e);
        }
    }

    @Override
    public SimpleNode[] getSelectionPosition(StructuredSelection sel) {
        if (sel.size() == 1) {
            Object firstElement = sel.getFirstElement();
            ASTEntryWithChildren p = ((ParsedItem)firstElement).getAstThis();
            if (p == null) {
                return null;
            }
            SimpleNode node = p.node;
            if (node instanceof ClassDef) {
                ClassDef def = (ClassDef)node;
                node = def.name;
            } else if (node instanceof Attribute) {
                Attribute attribute = (Attribute)node;
                node = attribute.attr;
            } else if (node instanceof FunctionDef) {
                FunctionDef def = (FunctionDef)node;
                node = def.name;
            } else {
                if (node instanceof Import) {
                    ArrayList<NameTokType> ret = new ArrayList<NameTokType>();
                    Import importToken = (Import)node;
                    int i = 0;
                    while (i < importToken.names.length) {
                        aliasType aliasType2 = importToken.names[i];
                        if (aliasType2.asname != null) {
                            ret.add(aliasType2.asname);
                        }
                        ret.add(aliasType2.name);
                        ++i;
                    }
                    return ret.toArray(new SimpleNode[0]);
                }
                if (node instanceof ImportFrom) {
                    ArrayList<NameTokType> ret = new ArrayList<NameTokType>();
                    ImportFrom importToken = (ImportFrom)node;
                    boolean found = false;
                    int i = 0;
                    while (i < importToken.names.length) {
                        found = true;
                        aliasType aliasType3 = importToken.names[i];
                        if (aliasType3.asname != null) {
                            ret.add(aliasType3.asname);
                        }
                        ret.add(aliasType3.name);
                        ++i;
                    }
                    if (!found) {
                        ret.add(importToken.module);
                    }
                    return ret.toArray(new SimpleNode[0]);
                }
            }
            return new SimpleNode[]{node};
        }
        return null;
    }
}

