<?php
/**
 * Dutch Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2009  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @author Eduard Wustenveld
 * @author Erik Bent
 * @author Boudewijn Sjouke
 * @version $Id: configure_help.nl.php 4863 2009-01-21 22:03:52Z canajun2eh $
 */

if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}

//-- CONFIGURE FILE MESSAGES
$pgv_lang["configure"]				= "Instellen PhpGedView";
$pgv_lang["standard_conf"]			= "Standaard configuratieopties";
$pgv_lang["advanced_conf"]			= "Extra configuratieopties";
$pgv_lang["gedcom_conf"]			= "Basisinstellingen";
$pgv_lang["media_conf"]				= "Multimedia";
$pgv_lang["accpriv_conf"]			= "Toegang en privacy";
$pgv_lang["displ_conf"]				= "Tonen en opmaak";
$pgv_lang["displ_names_conf"]		= "Namen";
$pgv_lang["displ_comsurn_conf"]		= "Meest voorkomende achternamen";
$pgv_lang["displ_layout_conf"]		= "Opmaak";
$pgv_lang["displ_hide_conf"]		= "Tonen & verbergen";
$pgv_lang["editopt_conf"]		= "Opties voor wijzigen";
$pgv_lang["editopt_conf"]		= "Opties voor wijzigen";
$pgv_lang["useropt_conf"]			= "Opties voor gebruikers";
$pgv_lang["contact_conf"]			= "Contactinformatie";
$pgv_lang["meta_conf"]				= "Website en META-tags";
$pgv_lang["configure_head"]			= "PhpGedView instellingen";
$pgv_lang["gedconf_head"]			= "GEDCOM-instellingen";
$pgv_lang["default_user"]			= "Aanmaken van de beheerder.";
$pgv_lang["about_user"]				= "U moet eerst de beheerder aanmaken. De beheerder heeft de rechten om de instellingen te wijzigen, privé-gegevens te bekijken en andere gebruikers aan te maken.";
$pgv_lang["can_admin"]				= "Mag beheren";
$pgv_lang["can_edit"]				= "Mag wijzigen";
$pgv_lang["access"]					= "Toegang";
$pgv_lang["user_relationship_priv"]	= "Toegang beperken tot verwante personen";
$pgv_lang["sync_gedcom"]		= "Gebruikersgegevens met genealogiegegevens synchroniseren";
$pgv_lang["add_user"]				= "Toevoegen van een nieuwe gebruiker";
$pgv_lang["current_users"]			= "Lijst gebruikers";
$pgv_lang["back_useradmin"]			= "Terug naar Beheer gebruikers";
$pgv_lang["del_proceed"]			= "Doorgaan";
$pgv_lang["del_unveru"]				= "Gebruiker heeft zijn gegevens niet binnen 7 dagen geverifieerd.";
$pgv_lang["del_unvera"]				= "Gebruiker niet geverifieerd door de beheerder.";
$pgv_lang["del_gedrights"]			= "GEDCOM niet langer actief, verwijder verwijzingen van gebruikers.";
$pgv_lang["usr_idle"]				= "Aantal maanden voordat de gebruiker beschouwd wordt als te lang niet aangemeld: ";
$pgv_lang["usr_idle_toolong"]		= "Deze gebruiker is te lang inactief geweest: ";
$pgv_lang["usr_unset_rights"]		= "GEDCOM-rechten verwijderd voor ";
$pgv_lang["usr_unset_rootid"]		= "Start-ID verwijderd voor ";
$pgv_lang["usr_unset_gedcomid"]		= "GEDCOM-ID verwijderd voor ";
$pgv_lang["usr_deleted"]			= "Gebruiker verwijderd: ";
$pgv_lang["configured_languages"]	= "Gebruikte talen";
$pgv_lang["message_to_all"]			= "Bericht aan alle gebruikers sturen";
$pgv_lang["ip_address"]				= "IP adres";
$pgv_lang["date_time"]				= "Datum en tijd";
$pgv_lang["searchtype"]				= "Zoektype";
$pgv_lang["query"]					= "Zoekvraag";
$pgv_lang["leave_blank"]			= "Laat het wachtwoord leeg als u het huidige wachtwoord wilt behouden.";
$pgv_lang["other_theme"]			= "Ander, typ in";
$pgv_lang["performing_update"]		= "Update uitvoeren.";
$pgv_lang["config_file_read"]		= "Lezen instellingenbestand.";
$pgv_lang["does_not_exist"]			= "bestaat niet";
$pgv_lang["media_drive_letter"]		= "In het pad naar de multimediamap kan geen driveletter worden opgenomen. Een foutief multimediapad leidt ertoe, dat multimedia-items niet worden weergegeven.";
$pgv_lang["pgv_config_write_error"] = "Fout! Kan niet schrijven naar het PhpGedView-configuratiebestand. Controleer de toegangsrechten voor het bestand en de map en probeer opnieuw.";
$pgv_lang["db_setup_bad"]			= "De huidige databaseconfiguratie is corrupt. Controleer de database-verbindingsparameters en configureer opnieuw.";
$pgv_lang["bad_host_user_pass"]		= "PhpGedView kan geen verbinding maken met uw SQL databaseserver. Controleer de naam van de SQL database machine, de SQL database gebruikersnaam en het SQL database wachtwoord. ";
$pgv_lang["bad_database_name"]		= "PhpGedView kan verbinding maken met de SQL database machine, maar krijgt geen toegang tot de opgegeven database. Controleer de databasenaam, de gebruikersnaam en de toegekende rechten.";
$pgv_lang["click_here_to_continue"]	= "Klik hier om door te gaan.";
$pgv_lang["config_help"]			= "Configuratie-informatie";
$pgv_lang["index"]					= "Indexbestanden";
$pgv_lang["mysql"]					= "MySQL";
$pgv_lang["db"]						= "Database";
$pgv_lang["dbase"]					= "dBase";
$pgv_lang["fbsql"]					= "FrontBase";
$pgv_lang["ibase"]					= "InterBase";
$pgv_lang["ifx"]					= "Informix";
$pgv_lang["msql"]					= "Mini SQL";
$pgv_lang["mssql"]					= "Microsoft SQL Server";
$pgv_lang["mysqli"]					= "MySQL 4.1+ met PHP5";
$pgv_lang["oci8"]					= "Oracle 7+";
$pgv_lang["pgsql"]					= "PostgreSQL";
$pgv_lang["sqlite"]					= "SQLite";
$pgv_lang["sybase"]					= "Sybase";
$pgv_lang["admin_gedcoms"]			= "Klik hier om de GEDCOM-bestanden te beheren.";
$pgv_lang["current_gedcoms"]		= "Huidige GEDCOM-bestanden";
$pgv_lang["gedcom_adm_head"]		= "GEDCOM-beheer";
$pgv_lang["ged_download"]			= "Download";
$pgv_lang["ged_gedcom"]				= "GEDCOM-bestand";
$pgv_lang["ged_title"]				= "GEDCOM-titel";
$pgv_lang["gedcom_title"]			= "Geef een omschrijving van het GEDCOM-bestand";
$pgv_lang["ged_config"]				= "Instellingenbestand";
$pgv_lang["ged_search"]				= "Logbestand Zoeken";
$pgv_lang["ged_privacy"]			= "Privacybestand";
$pgv_lang["show_phpinfo"]			= "Toon PHPInfo";
$pgv_lang["confirm_gedcom_delete"]	= "Weet u zeker dat u dit GEDCOM-bestand wilt verwijderen?";
$pgv_lang["date_format"]			= "Datumformaat:";
$pgv_lang["disabled"]				= "Uitgeschakeld";
$pgv_lang["mouseover"]				= "Door muisaanwijzer erover";
$pgv_lang["mousedown"]				= "Door muisknop ingedrukt";
$pgv_lang["click"]					= "Door muisklik";
$pgv_lang["mailto"]	 				= "Mailen naar";
$pgv_lang["messaging"]				= "PhpGedView interne berichten";
$pgv_lang["messaging2"]				= "Interne berichten en e-mails";
$pgv_lang["messaging3"]				= "PhpGedView verzendt e-mails zonder opslaan";
$pgv_lang["no_messaging"]			= "Geheel geen contact";
$pgv_lang["no_logs"]				= "Log-bestand uitschakelen";
$pgv_lang["daily"]					= "Dagelijks";
$pgv_lang["weekly"]					= "Wekelijks";
$pgv_lang["monthly"]				= "Maandelijks";
$pgv_lang["yearly"]					= "Jaarlijks";
$pgv_lang["config_still_writable"]	= "<br />Uw config.php bestand heeft schrijftoegang.<br />Als u klaar bent met het configureren van uw site, dient u de rechten om beveiligingsredenen te wijzigen in \"alleen lezen\".";
$pgv_lang["admin_verification_waiting"] = "Er wachten gebruikers op verificatie door de beheerder";
$pgv_lang["admin_user_warnings"]		= "Een of meer gebruikers hebben een waarschuwing";
$pgv_lang["enter_db_pass"]			= "Om beveiligingsredenen moet u de database gebruikersnaam en het database wachtwoord opnieuw invoeren bij het wijzigen van de configuratie.";
$pgv_lang["PGV_DATABASE"] 			= "PhpGedView gegevensopslag";
$pgv_lang["PGV_DATABASE_help"] 		= "~PHPGEDVIEW GEGEVENSOPSLAG~<br /><br />Hiermee stelt u in, welk type gegevensopslag u wilt gebruiken voor de GEDCOM-bestanden, die u importeert. Selecteer \"Indexbestanden\" voor opslag in de Index-map, selecteer \"Database\" om een SQL-database zoals MySQL te gebruiken.<br />Als u PHP5 gebruikt, wordt aangeraden om in plaats van Index SQLite te gebruiken, vanwege de veel hogere prestaties.";
$pgv_lang["DBTYPE"]					= "Type database";
$pgv_lang["DBTYPE_help"]			= "~TYPE DATABASE~<br /><br />Het type PEAR ondersteunende database om verbinding mee te maken. De mogelijkheden zijn: MySQL, PostgreSQL en SQLite. De eerste twee hebben extra bibliotheken van PHP nodig. SQLite wordt standaard met PHP5 meegeleverd.<br />Als u SQLite gebruikt, hoeven database machine, database gebruikersnaam en database wachtwoord niet ingevuld te worden. In plaats daarvan vult u in het vak \"Databasenaam\" het pad en de naam van de database in.";
$pgv_lang["DBHOST"] 				= "Database-machine";
$pgv_lang["DBHOST_help"] 			= "~DATABASE-MACHINE~<br /><br />De DNS-naam of het IP-adres van the computer waar de database staat.<br />Als zowel PHP als de database op dezelfde machine staan, volstaat localhost.  Deze instelling wordt niet gebruikt als u een SQLite database heeft ingesteld.";
$pgv_lang["DBUSER"] 				= "Database-gebruikersnaam";
$pgv_lang["DBUSER_help"] 			= "~DATABASE-GEBRUIKERSNAAM~<br /><br />De database gebruikersnaam die nodig is om in te loggen op de database. Deze instelling wordt niet gebruikt als u een SQLite database heeft ingesteld.";
$pgv_lang["DBPASS"] 				= "Database-wachtwoord";
$pgv_lang["DBPASS_help"] 			= "~DATABASE-WACHTWOORD~<br /><br />Het database wachtwoord van de gebruiker. Deze instelling wordt niet gebruikt als u een SQLite database heeft ingesteld.";
$pgv_lang["DBNAME"] 				= "Databasenaam";
$pgv_lang["DBNAME_help"] 			= "~DATABASENAAM~<br /><br />De database in de machine die PhpGedView moet gebruiken. De gebruikersnaam in het gebruikersveld moet create, insert, update, delete, en select privilege op deze database hebben.<br />Voor SQLite dient u een bestandsnaam aan te geven in een map die schrijfbaar is voor PhpGedView. Voorbeeld: index/phpgedview.db.";
$pgv_lang["TBLPREFIX"]				= "Voorvoegsel databasetabellen";
$pgv_lang["TBLPREFIX_help"]			= "~VOORVOEGSEL DATABASETABELLEN~<br /><br />Een voorvoegsel voor de SQL tabellen die gemaakt zijn door PhpGedView. Door het veranderen van deze waarde kunt u meerdere PhpGedView sites gebruik laten maken van dezelfde database maar met verschillende tabellen.";
$pgv_lang["DEFAULT_GEDCOM"]			= "Standaard GEDCOM";
$pgv_lang["privileges"]				= "Rechten";
$pgv_lang["date_registered"]		= "Geregistreerd";
$pgv_lang["last_login"]				= "Laatst aangemeld";
$pgv_lang["server_url_note"]		= "Dit behoort de URL naar uw PhpGedView-map te zijn. Wijzig deze waarde alleen als u de consequenties overziet. PhpGedView heeft de SERVER_URL samengesteld als #GUESS_URL#.";
$pgv_lang["ALLOW_CHANGE_GEDCOM"]	= "Sta wisselen van GEDCOM-bestand toe";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]	= "~STA WISSELEN VAN GEDCOM-BESTAND TOE~<br /><br />Als u deze optie op \"Ja\" zet, kunnen gebruikers wisselen van GEDCOM-bestand. Dit is alleen mogelijk als op uw site meerdere GEDCOM-bestanden aanwezig zijn.";
$pgv_lang["gedcom_path"]			= "Map en naam GEDCOM-bestand";
$pgv_lang["gedcom_path_help"]		= "~MAP EN NAAM GEDCOM-BESTAND~<br /><br />Upload eerst uw GEDCOM-bestand naar een locatie op de server die door PHP bereikt kan worden. Voer dan het pad naar dat bestand en de bestandsnaam hier in.<br /><br />Voorbeeld: ./index/myged.ged<br /><br />Zie het <a href=\"readme.txt\">readme.txt</a> bestand voor meer uitleg.";
$pgv_lang["CHARACTER_SET"]			= "Karakterset codering";
$pgv_lang["CHARACTER_SET_help"]		= "~KARAKTERSET CODERING~<br /><br />Dit is de karakterset van uw GEDCOM-bestand. UTF-8 is de standaard en moet voor bijna alle sites werken. Als het GEDCOM-bestand de IBM-Windowscodering gebruikt dan moet u hier WINDOWS neerzetten.<br /><br />N.B.: PHP ondersteunt geen UNICODE (UTF-16); zet dat er dus niet en om vervolgens te gaan klagen bij de PHP ondersteuners :-)";
$pgv_lang["LANGUAGE"]				= "Taal";
$pgv_lang["LANGUAGE_help"]			= "~TAAL~<br /><br />Stelt de standaardtaal in voor de website. Gebruikers hebben de mogelijkheid om deze instelling aan te passen via de browserinstellingen of via het keuzeveld op het scherm, indien ENABLE_MULTI_LANGUAGE = true.<br /><br />";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]	= "Laat de gebruiker de taal wijzigen";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"] = "~LAAT DE GEBRUIKER DE TAAL WIJZIGEN~<br /><br />Zet dit op \"Ja\" om de gebruikers de mogelijkheid te geven een andere taal te kiezen via het keuzevak op het scherm. De standaard is de taalinstelling van de browser.<br /><br />";
$pgv_lang["LANGUAGE_DEFAULT"]		= "U heeft de talen niet ingesteld, die op uw website worden ondersteund.<br />PhpGedView gebruikt de standaardinstellingen.";
$pgv_lang["CALENDAR_FORMAT"]		= "Kalenderformaat";
$pgv_lang["CALENDAR_FORMAT_help"]	= "~KALENDERFORMAAT~<br /><br />Hiermee specificeert u het type kalender, dat u wilt gebruiken met dit GEDCOM-bestand.<br />Hebreeuws is hetzelfde als de Joodse kalender, maar dan met Hebreeuwse karakters. Let op: de Joods/Hebreeuwse datums worden berekend met behulp van Gregoriaanse/Juliaanse datums. Omdat de Joodse kalender bij zonsondergang start, wordt bij gebeurtenissen die plaatsvinden tussen zonsondergang en middernacht een datum weergegeven die een dag eerder ligt dan de juiste Joodse datum. Verder kan weergave van Hebreeuws een probleem zijn voor oude Internet Verkenners. Ze tonen het Hebreeuws achterstevoren of geheel niet.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]		= "Geef Hebreeuwse duizendtallen weer";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]	= "~GEEF HEBREEUWSE DUIZENDTALLEN WEER~<br /><br />Toon Alafim in Hebreeuwse kalenders. \"JA\" geeft het jaar 1969 weer als <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; , \"NEE\" als <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;. Dit beïnvloedt de waarde van het Joodse jaar niet, deze blijft ongewijzigd 5729 ongeacht deze instelling.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]		= "Toon Hebreeuws Gershayim";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]	= "~TOON HEBREEUWS GERSHAYIM~<br /><br />Toon dubbele en enkele aanhalingstekens bij het weergeven van Hebreeuwse datums. Deze waarde op JA toont de datum van 8 februari 1969 als <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; deze waarde op NEE toont het als <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;. Dit heeft geen invloed op het Joodse jaartal, omdat aanhalingstekens in Joodse datums worden weergegeven met de Latin karakterset.<br />Let op: Deze waarde is gelijk aan de PHP 5.0 kalender constanten CAL_JEWISH_ADD_ALAFIM_GERESH en CAL_JEWISH_ADD_GERESHAYIM. Deze waarde beïnvloedt beide.";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]		= "Joods Ashkenazi woordgebruik";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"] = "~JOODS ASHKENAZI WOORDGEBRUIK~<br /><br />Kies Joods Ashkenazi woordgebruik.<br /> Bij \"JA\" worden de maanden Cheshvan en Teves gespeld met Ashkenazi woordgebruik. Bij \"NEE\" blijven deze ongewijzigd.<br />Dit heeft alleen effect op de Joodse instelling. Indien ingesteld op Hebreeuws, wordt het Hebreeuwse alfabet gebruikt.";
$pgv_lang["USE_RTL_FUNCTIONS"]		= "RTL gegevensverwerking";
$pgv_lang["USE_RTL_FUNCTIONS_help"]	= "~RTL GEGEVENSVERWERKING~<br /><br />Met deze optie stelt u in, dat de gegevens in het bestand het opvragen worden bewerkt om ze juist weer te geven in rechts naar links talen. Deze optie kan invloed hebben op de snelheid van de website.";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]		= "Generaties kwartierstaat";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]	= "~GENERATIES KWARTIERSTAAT~<br /><br />Stelt het aantal generaties dat standaard afgebeeld moet worden in de kwartierstaat.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]		= "Max. aantal generaties kwartierstaat";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]	= "~MAX. AANTAL GENERATIES KWARTIERSTAAT~<br /><br />Stelt het maximum aantal generaties in, dat in de kwartierstaat wordt getoond.";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]		= "Max. aantal generaties nakomelingen";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "~MAX. AANTAL GENERATIES NAKOMELINGEN~<br /><br />Stelt het maximum aantal generaties in, dat in de grafiek nakomelingen wordt getoond.";
$pgv_lang["USE_RIN"]				= "Gebruik RIN in plaats van GEDCOM-ID";
$pgv_lang["USE_RIN_help"]			= "~GEBRUIK RIN IN PLAATS VAN GEDCOM-ID~<br /><br />Kies \"Ja\" om RIN-nrs. te gebruiken in plaats van GEDCOM-ID's. Deze worden gebruikt in configuratiebestanden, gebruikersinstellingen en overzichten. Dit is nuttig voor genealogieprogramma's, die geen bijbehorende ID's exporteren maar altijd dezelfde RIN gebruiken.";
$pgv_lang["PEDIGREE_ROOT_ID"]		= "Beginpersoon kwartierstaat en nakomelingen";
$pgv_lang["PEDIGREE_ROOT_ID_help"]	= "~BEGINPERSOON KWARTIERSTAAT EN NAKOMELINGEN~<br /><br />Stelt het ID van de beginpersoon in voor kwartierstaat en nakomelingenoverzicht.";
$pgv_lang["GEDCOM_ID_PREFIX"]		= "Voorvoegsel GEDCOM-ID";
$pgv_lang["GEDCOM_ID_PREFIX_help"]	= "~VOORVOEGSEL GEDCOM-ID~<br /><br />Bij weergave van de kwartierstaat, nakomelingen, verwantschap en andere weergaven wordt gebruikers gevraagd een ID in te voeren. Als hierbij geen voorvoegsel wordt ingevoerd, wordt deze toegevoegd.";
$pgv_lang["SOURCE_ID_PREFIX"]		= "Voorvoegsel bron-ID";
$pgv_lang["SOURCE_ID_PREFIX_help"]	= "~VOORVOEGSEL BRON-ID~<br /><br />Als met behulp van PhpGedView een nieuwe bron wordt aangemaakt, wordt hiervoor automatisch een ID aangemaakt. Het bron-ID heeft het hier opgegeven voorvoegsel, gevolgd door een volgnummer.";
$pgv_lang["REPO_ID_PREFIX"]			= "Voorvoegsel bewaarplaats-ID";
$pgv_lang["REPO_ID_PREFIX_help"]	= "~VOORVOEGSEL BEWAARPLAATS-ID~<br /><br />Als met behulp van PhpGedView een nieuwe bewaarplaats wordt aangemaakt, wordt hiervoor automatisch een ID aangemaakt. Het bewaarplaats-ID heeft het hier opgegeven voorvoegsel, gevolgd door een volgnummer.";
$pgv_lang["PEDIGREE_FULL_DETAILS"]		= "Laat geboorte- en overlijdensgegevens zien in kwartierstaat en nakomelingenoverzicht";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"] = "~LAAT GEBOORTE- EN OVERLIJDENSGEGEVENS ZIEN IN KWARTIERSTAAT EN NAKOMELINGENOVERZICHT~<br /><br />Geeft aan of de geboorte- en overlijdensgegevens van een persoon zichtbaar worden.";
$pgv_lang["PEDIGREE_LAYOUT"] 		= "Standaard opmaak kwartierstaat";
$pgv_lang["PEDIGREE_LAYOUT_help"] 	= "~STANDAARD OPMAAK KWARTIERSTAAT~<br /><br />Geeft aan of de kwartierstaat staand of liggend moet worden weergegeven.";
$pgv_lang["SHOW_EMPTY_BOXES"]		= "Toon lege vakken in de kwartierstaat";
$pgv_lang["SHOW_EMPTY_BOXES_help"]	= "~TOON LEGE VAKKEN IN DE KWARTIERSTAAT~<br /><br />Kies hier, of lege vakken worden getoond in de kwartierstaat.";
$pgv_lang["ZOOM_BOXES"]				= "Inzoomen op vakken in de weergave";
$pgv_lang["ZOOM_BOXES_help"]		= "~INZOOMEN OP VAKKEN IN DE WEERGAVE~<br /><br />Geeft een gebruiker de mogelijkheid om in te zoomen op de vakken en zodoende meer informatie te tonen. \"Uitschakelen\" zet deze functie uit, \"Door muisaanwijzer erover\" activeert de functie wanneer de muisaanwijzer op het scherm op het icoon komt, \"Door muisknop ingedrukt\" activeert de zoomfunctie, zolang de knop blijft ingedrukt, \"Door muisklik\" wordt de functie afwisselend aan en uit geschakeld.";
$pgv_lang["LINK_ICONS"]				= "Popup met koppelingen in weergaven";
$pgv_lang["LINK_ICONS_help"]		= "~POPUP MET KOPPELINGEN IN WEERGAVEN~<br /><br />Geeft een gebruiker de mogelijkheid om door te springen naar andere weergaven en verwanten van de persoon. \"Uitschakelen\" zet deze functie uit, \"Door muisaanwijzer erover\" activeert de functie wanneer het pijltje op het scherm op het icoon komt, \"Door muisknop ingedrukt\" activeert de functie, zolang de knop blijft ingedrukt, \"Door muisklik\" wordt de functie afwisselend aan en uit geschakeld.";
$pgv_lang["ABBREVIATE_CHART_LABELS"]		= "Afgekorte veldtitels";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]	= "~AFGEKORTE VELDTITELS~<br /><br />Geeft aan of titels bij gegevens worden afgekort: \"G\" in plaats van \"Geboren\".";
$pgv_lang["SHOW_PARENTS_AGE"]		= "Toon leeftijd ouders bij geboortedatum kind";
$pgv_lang["SHOW_PARENTS_AGE_help"]	= "~TOON LEEFTIJD OUDERS BIJ GEBOORTEDATUM KIND~<br /><br />Hiermee wordt het tonen van de leeftijd van de ouders bij de geboorte van het kind al dan niet ingeschakeld.<br /><br />";
$pgv_lang["AUTHENTICATION_MODULE"]		= "Autorisatiemodule";
$pgv_lang["AUTHENTICATION_MODULE_help"] = "~AUTORISATIEMODULE~<br /><br />Bestand met de autorisatiefuncties. Door de implementatie van de functies in dit bestand kunnen gebruikers PhpGedView aanpassen met een andere autorisatiemethode en/of gebruikers in een andere database zetten. Hopelijk zullen gebruikers hun aangepaste autorisatiemodule delen met andere PhpGedView gebruikers.";
$pgv_lang["HIDE_LIVE_PEOPLE"]		= "Gebruik privacyinstellingen";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]	= "~GEBRUIK PRIVACYINSTELLINGEN~<br /><br />Met deze optie kunt u de privacymodule inschakelen en de details van levende personen verbergen. Levende personen hebben geen gebeurtenis die meer dan het aantal jaren, zoals gedefinieerd in de variabele \$MAX_ALIVE_AGE geleden gebeurd zijn en geen kinderen geboren zijn.<br />In de privacymodule kunt u de privacyinstellingen verder bewerken.";
$pgv_lang["REQUIRE_AUTHENTICATION"]			= "Vereis bezoekersauthenticatie";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]	= "~VEREIS BEZOEKERSAUTHENTICATIE~<br /><br />Door deze optie in te schakelen worden alle bezoekers in te loggen, voordat ze gegevens op de site kunnen bekijken.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]			= "Welkomsttekst op de aanmeldpagina bij aanmelden vereist";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]	= "~WELKOMSTTEKST OP DE AANMELDPAGINA BIJ AANMELDEN VEREIST~<br /><br />Kies hier de tekst, die op het aanmeldscherm verschijnt in geval bezoekers zich moeten aanmelden bij deze site (authenticatie vereist).<br />U kunt uitproberen welke standaard tekst op uw situatie van toepassing is.<br />U kunt er ook voor kiezen, om zelf een tekst in te voeren in het onderstaande vak.<br /><br />Let op: deze tekst wordt niet vertaald in de taal van uw gebruikers.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]	= "Voorgedefinieerde tekst: Alle bezoekers kunnen een gebruikersnaam aanvragen";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]	= "Voorgedefinieerde tekst: De sitebeheerder is selectief toekennen van toegangsrechten";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]	= "Voorgedefinieerde tekst: Alleen familieleden kunnen een gebruikersnaam aanvragen";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]	= "Kies zelf gedefinieerde tekst hieronder";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "Zelf gedefinieerde tekst voor authenticatie vereist";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]	= "~ZELF GEDEFINIEERDE TEKST VOOR AUTHENTICATIE VEREIST~<br /><br />Als u heeft gekozen om een zelf gedefinieerde tekst te tonen op het aanmeldscherm, dan kunt u hier de desbetreffende tekst intypen.<br />Let op: de tekst wordt weergegeven zoals u die intypt en wordt dus NIET vertaald in de taal van de bezoekers.<br />Als u wilt, kunt u in de tekst HTML-tekens gebruiken voor opmaak.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"] = "Standaard koptekst voor zelf gedefinieerde welkomsttekst";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"] = "~STANDAARD KOPTEKST VOOR ZELF GEDEFINIEERDE WELKOMSTTEKST~<br /><br />Kies deze optie om, aan uw eigen welkomsttekst bij \"aanmelden vereist\", een standaard koptekst vanuit PhpGedView toe te voegen.<br />Deze koptekst is beschikbaar in alle talen van PhpGedView.";
$pgv_lang["CHECK_CHILD_DATES"]		= "Controleer datums van de kinderen";
$pgv_lang["CHECK_CHILD_DATES_help"]	= "~CONTROLEER DATUMS VAN DE KINDEREN~<br /><br />Controleer de datums van de kinderen om te bepalen of een persoon overleden is. Op oudere systemen en bij grote GEDCOM-bestanden verlaagt dit de response tijd van uw website.";
$pgv_lang["MAX_ALIVE_AGE"]			= "Leeftijd waarboven iemand geacht wordt overleden te zijn";
$pgv_lang["MAX_ALIVE_AGE_help"]		= "~LEEFTIJD WAARBOVEN IEMAND GEACHT WORDT OVERLEDEN TE ZIJN~<br /><br />De maximum leeftijd die een persoon kan hebben of de maximum leeftijd van hun kinderen om te bepalen waarneer iemand overleden is of niet.";
$pgv_lang["SHOW_GEDCOM_RECORD"]			= "Sta toe dat gebruikers de GEDCOM-regels zien";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]	= "~STA TOE DAT GEBRUIKERS DE GEDCOM-REGELS ZIEN~<br /><br />Door deze optie op 'ja' te zetten worden er, bij personen, gezinnen en bronnen, koppelingen geplaatst die gebruikers een nieuw venster geven met de gegevens uit het GEDCOM-bestand.";
$pgv_lang["ALLOW_EDIT_GEDCOM"]		= "Sta wijzigen toe";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]	= "~STA WIJZIGEN TOE~<br /><br />Stelt functionaliteit ter beschikking om in de toepassing gegevens te wijzigen. De desbetreffende gebruikers moeten hier dan nog expliciet voor worden geautoriseerd.";
$pgv_lang["POSTAL_CODE"]  = "Positie postcode";
$pgv_lang["INDEX_DIRECTORY"]		= "Map voor indexbestanden";
$pgv_lang["INDEX_DIRECTORY_help"]	= "~MAP VOOR INDEXBESTANDEN~<br /><br />Het pad naar een lees- en schrijfbare map waar PhpGedView de indexbestanden moet opslaan (inclusief de \"/\" aan het eind).";
$pgv_lang["ALPHA_INDEX_LISTS"]		= "Splits lange lijsten volgens de eerste letter";
$pgv_lang["ALPHA_INDEX_LISTS_help"]	= "~SPLITS LANGE LIJSTEN VOLGENS DE EERSTE LETTER~<br /><br />Zet dit op 'Ja' voor erg lange persoons- en gezinslijsten. De lijst wordt dan gesplitst in meerdere pagina's volgens de eerste letter van de achternaam.";
$pgv_lang["NAME_FROM_GEDCOM"]		= "Haal weergegeven naam uit GEDCOM";
$pgv_lang["NAME_FROM_GEDCOM_help"]	= "~HAAL WEERGEGEVEN NAAM UIT GEDCOM~<br /><br />Standaard toont PhpGedView van een persoon de naam, die in de indexbestanden is opgeslagen. Bij sommige GEDCOM-formaten en -talen, wordt de in de index opgeslagen naam niet correct weergegeven. Spaanse namen zijn hier een voorbeeld van. Deze kunnen het formaat aannemen van \"Voornaam Vaders achternaam Moeders achternaam\". De (niet correcte) weergave uit de indexbestanden zou dan zijn: \"Voornaam Moeders achternaam Vaders achternaam). Uit het GEDCOM-bestand wordt dan de correcte naam opgehaald. Let op: dit vertraagt de werking van het programma.";
$pgv_lang["SHOW_ID_NUMBERS_help"]	= "~TOON ID-NUMMERS BIJ NAMEN~<br /><br />Toon ID-nummers tussen haakjes achter de persoonsnaam in de vakken.";
$pgv_lang["SHOW_FAM_ID_NUMBERS"]		= "Toon ID's bij gezinnen";
$pgv_lang["SHOW_FAM_ID_NUMBERS_help"]	= "~TOON ID'S BIJ GEZINNEN~<br /><br />Toon de ID's van de gezinnen bij de gezinsnamen en in de lijsten op de persoonspagina.<br /><br />";
$pgv_lang["SHOW_PEDIGREE_PLACES"]		= "Toon plaatsen in persoonsvakken";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]	= "~TOON PLAATSEN IN PERSOONSVAKKEN~<br /><br />Stelt in, hoeveel niveaus van plaatsinformatie worden weergegeven bij geboorte- en overlijdensdata in de kwartierstaat- en nakomelingengrafieken. De waarde 9 laat alle niveaus zien, de waarde 0 geen enkele. De waarde 1 toont alleen het eerste niveau, 2 ook het tweede, etc.";
$pgv_lang["MULTI_MEDIA"]			= "Multimedia mogelijkheden aanzetten";
$pgv_lang["MULTI_MEDIA_help"]		= "~MULTIMEDIA MOGELIJKHEDEN AANZETTEN~<br /><br />GEDCOM 5.5 bevat de mogelijkheid om afbeeldingen, video's en andere multimedia-objecten op te nemen in het GEDCOM-bestand. Als u geen multimedia-objecten in uw GEDCOM-bestand heeft dan kunt u deze optie op 'Nee' zetten om de multimediamogelijkheden uit te zetten.<br />Zie de multimediaparagraaf het <a href=\"readme.txt\">readme.txt</a> bestand voor meer informatie over het opnemen van media in uw website.";
$pgv_lang["MULTI_MEDIA_DB"]			= "Multimediabeheer door PhpGedView";
$pgv_lang["MULTI_MEDIA_DB_help"]	= "~MULTIMEDIABEHEER DOOR PHPGEDVIEW~<br /><br />Als uw GEDCOM-bestand geen multimedia-koppelingen bevat, kunt u deze met behulp van PhpGedView onderhouden. Bij het importeren van een nieuw GEDCOM-bestand worden de bestaande koppelingen behouden en zijn dus weer beschikbaar in het nieuwe bestand.<br /><br />";
$pgv_lang["MEDIA_EXTERNAL"]			= "Behoudt koppelingen";
$pgv_lang["MEDIA_EXTERNAL_help"]	= "~BEHOUDT KOPPELINGEN~<br /><br />Als een multimedia-item wordt gevonden waarvan de naam start met bijvoorbeeld http://, ftp:// of mms://, wordt de naam ongewijzigd gelaten als deze optie aan staat. Bijvoorbeeld: http://www.mijnfamilie.nl/foto/vader.jpg blijft http://www.mijnfamilie.nl/foto/vader.jpg. Als de optie uit staat, wordt de naam behandeld als standaardverwijzing en wordt het aantal niveaus van de multimediamappen toegepast. Bijvoorbeeld: http://www.mijnfamilie.nl/foto/vader.jpg wordt ./media/vader.jpg.";
$pgv_lang["MEDIA_DIRECTORY"]		= "Multimediamappen";
$pgv_lang["MEDIA_DIRECTORY_help"]	= "~MULTIMEDIAMAPPEN~<br /><br />Het pad naar de map waar PhpGedView de lokale mediagegevens ophaalt (met de laatste \"/\" achter de padnaam).<br />Het pad moet een relatief pad zijn binnen de PGV website, bijvoorbeeld: ./media/<br />Ook een URL naar een website kan als pad NIET worden gebruikt, aangezien dit niet in alle gevallen werkt.";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]			= "Aantal niveaus van de Multimediamappen";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]	= "~AANTAL NIVEAUS VAN DE MULTIMEDIAMAPPEN~<br /><br />Een waarde van 0 zal alle mappen overslaan in het pad van het media object. Een waarde van 1 zal ook de eerste map van het object gebruiken. Door het verhogen van het getal wordt het aantal niveaus van mappen verhoogd dat gebruikt wordt.<br />Bijvoorbeeld: als er een koppeling naar het object staat met het pad C:\\Documents and Settings\\User\\My Documents\\My Pictures\\Genealogy\\Surname Line\\grandpa.jpg dan zal een waarde van 0 vertaald worden in het pad ./media/grandpa.jpg. Een waarde van 1 zal vertaald worden naar ./media/Surname Line/grandpa.jpg, enz. De meeste mensen zullen met een 0 kunnen volstaan. Let op: het is mogelijk dat sommige media objecten met dezelfde naam elkaar overschrijven. Dit maakt het mogelijk om enige structuur aan te brengen in de media map en voorkomt het voorkomen van dubbele namen.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"] = "~LAAT EERSTE AFBEELDING IN PERSOONSVAK ZIEN~<br /><br />Als de multimedia mogelijkheden op uw site zijn ingeschakeld, dan kunt u PhpGedView een mini-afbeelding, in overzichten en vakjes, laten tonen naast de naam van de persoon.  Op dit moment gebruikt PhpGedView het eerste multimedia-object, genoemd in de GEDCOM-gegevens van de persoon, als de voorkeursafbeelding.  Voor personen met meerdere afbeeldingen zou u de multimedia objecten zodanig moeten indelen, dat de afbeelding die u wilt tonen, vooraan in de lijst staat.<br />Bekijk ook de multimediasectie in het <a href=\"readme.txt\">readme.txt</a> bestand voor meer informatie over het gebruik van media op uw site.";
$pgv_lang["USE_THUMBS_MAIN"]		= "Gebruik miniweergaven voor hoofdafbeelding bij detailgegevens persoon";
$pgv_lang["USE_THUMBS_MAIN_help"]	= "~GEBRUIK MINIWEERGAVEN VOOR HOOFDAFBEELDING BIJ DETAILGEGEVENS PERSOON~<br /><br />Afhankelijk van de omvang van de afbeeldingen kan het beter zijn om in plaats van de afbeeldingen de miniatuurweergaven te gebruiken naast de naam van de persoon. Als de afbeeldingen erg groot zijn, kan de tijd die nodig is voor het opbouwen van de pagina erg lang worden. Let er wel op dat uw miniatuurweergaven van voldoende kwaliteit zijn.<br /><br />Zet deze waarde op \"Ja\" om miniatuurweergaven te gebruiken en \"Nee\" om de oorspronkelijke afbeeldingen te gebruiken.";
$pgv_lang["ENABLE_CLIPPINGS_CART"]		= "Knipselbak aanzetten";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"] = "~KNIPSELBAK AANZETTEN~<br /><br />De knipselbak maakt het voor bezoekers mogelijk om informatie toe te voegen aan een GEDCOM-knipselbestand.<br />De bezoeker kan dit bestand downloaden als een GEDCOM-bestand en in zijn of haar genealogiesoftware inlezen.";
$pgv_lang["HIDE_GEDCOM_ERRORS"]			= "Verberg GEDCOM-fouten";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]	= "~VERBERG GEDCOM-FOUTEN~<br /><br />Door deze optie op 'Ja' te zetten worden fouten niet getoond als PhpGedView een GEDCOM-code tegenkomt die het niet herkent. PhpGedView voldoet aan de GEDCOM 5.5 standaard, maar veel genealogieprogramma's bevatten aangepaste of eigen codes. Zie het <a href=\"readme.txt\">readme.txt</a> bestand voor meer informatie.";
$pgv_lang["WORD_WRAPPED_NOTES"]			= "Toevoegen spaties als notities zijn afgebroken";
$pgv_lang["WORD_WRAPPED_NOTES_help"]	= "~TOEVOEGEN SPATIES ALS NOTITIES ZIJN AFGEBROKEN~<br /><br />Sommige genealogie programma's breken opmerkingen af op woorden terwijl andere de opmerkingen op een willekeurige plek afbreken. Hierdoor is het mogelijk dat PhpGedView woorden aan elkaar plakt. Door dit op 'Ja' te zetten wordt er een spatie tussen woorden gezet.";
$pgv_lang["SHOW_CONTEXT_HELP_help"]	= "~TOON \"?\" HELPKOPPELINGEN OP DE PAGINA'S~<br /><br />Door middel van deze optie kunt op de pagina's vraagtekens weergeven naast de verschillende koppelingen en velden. Bezoekers kunnen hierop klikken en krijgen dan informatie over het desbetreffende item.";
$pgv_lang["COMMON_NAMES_THRESHOLD"]			= "Minimum aantal voor \"Meest voorkomende achternamen\"";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]	= "~MINIMUM AANTAL VOOR \"MEEST VOORKOMENDE ACHTERNAMEN\"~<br /><br />Dit is het aantal malen dat een achternaam moet voorkomen in de genealogie, voordat hij verschijnt in de \"Meest voorkomende achternamen\" op de Welkomstpagina.";
$pgv_lang["COMMON_NAMES_ADD"]		= "Namen om toe te voegen aan \"Meest voorkomende achternamen\"";
$pgv_lang["COMMON_NAMES_ADD_help"]	= "~NAMEN OM TOE TE VOEGEN AAN \"MEEST VOORKOMENDE ACHTERNAMEN\"~<br /><br />Als het aantal malen dat een achternaam in de genealogie voorkomt lager is dan de drempelwaarde, zal de naam niet in de lijst met Meest voorkomende achternamen verschijnen. De achternaam kan dan hier handmatig worden toegevoegd. Als er meer namen worden opgegeven, moeten ze met een komma worden gescheiden.<br />Let op: de opgegeven namen zijn hoofdlettergevoelig!";
$pgv_lang["COMMON_NAMES_REMOVE"]		= "Namen om te verwijderen uit Meest voorkomende achternamen (komma gescheiden)";
$pgv_lang["COMMON_NAMES_REMOVE_help"]	= "~NAMEN OM TE VERWIJDEREN UIT \"MEEST VOORKOMENDE ACHTERNAMEN\"~<br /><br />Als u een achternaam wilt verwijderen uit de Meest voorkomende achternamen, zonder de drempelwaarde daarvoor te verhogen, kunt u de naam hier invoeren. Als er meer namen worden opgegeven, moeten ze met een komma worden gescheiden.<br />Let op: de opgegeven namen zijn hoofdlettergevoelig!";
$pgv_lang["SHOW_CONTEXT_HELP"]		= "Toon \"?\" helpkoppelingen op de pagina's";
$pgv_lang["HOME_SITE_URL"]			= "Website-URL";
$pgv_lang["HOME_SITE_URL_help"]		= "~WEBSITE-URL~<br /><br />Het adres dat in de standaard themabestanden zorgt voor een koppeling naar uw website.";
$pgv_lang["HOME_SITE_TEXT"]			= "Website-tekst";
$pgv_lang["HOME_SITE_TEXT_help"]	= "~WEBSITE-TEKST~<br /><br />De tekst die gebruikt wordt voor de koppeling naar uw website.";
$pgv_lang["CONTACT_EMAIL"]			= "E-mail genealogische vragen";
$pgv_lang["CONTACT_EMAIL_help"]		= "~E-MAIL GENEALOGISCHE VRAGEN~<br /><br />Het e-mailadres dat gebruikt moet worden als er vragen zijn over de genealogische gegevens op deze website.";
$pgv_lang["CONTACT_METHOD"] 		= "Verzendwijze genealogische vragen";
$pgv_lang["CONTACT_METHOD_help"] 	= "~VERZENDWIJZE GENEALOGISCHE VRAGEN~<br /><br />De methode die bezoekers zullen gebruiken om contact op te nemen met de contactpersoon voor genealogische vragen.<br />De 'mailto' optie zal een 'mailto' koppeling toevoegen, waarop de bezoekers kunnen klikken om u een e-mail te sturen, d.m.v. hun eigen mailprogramma.<br />De 'berichten' optie zal het ingebouwde PhpGedView berichtensysteem gebruiken en er worden geen e-mails verzonden.<br />De 'berichten met e-mails' optie is de standaardoptie en zal het PhpGedView berichtensysteem gebruiken, maar zal eveneens een kopie van de berichten per e-mail verzenden.<br />De optie 'E-mails zonder opslag' zorgt ervoor, dat berichten weliswaar per e-mail worden verzonden, maar dat ze niet in PhpGedView worden opgeslagen.<br />Als u de optie voor 'geen berichten' kiest, zal er geen mogelijkheid zijn voor de bezoekers om contact met u op te nemen.";
$pgv_lang["WEBMASTER_EMAIL"]		= "E-mail Sitebeheerder";
$pgv_lang["WEBMASTER_EMAIL_help"]	= "~E-MAIL SITEBEHEERDER~<br /><br />Het e-mail adres dat gebruikt moet worden als er vragen zijn over de techniek of als er fouten worden gevonden op de website.";
$pgv_lang["SUPPORT_METHOD"] 		= "Verzendwijze ondersteuningsvragen";
$pgv_lang["SUPPORT_METHOD_help"] 	= "~VERZENDWIJZE ONDERSTEUNINGSVRAGEN~<br /><br />De methode die bezoekers zullen gebruiken om contact op te nemen met de Sitebeheerder.   <br />De 'mailto' optie zal een 'mailto' koppeling toevoegen, waarop de bezoekers kunnen klikken om u een e-mail te sturen, d.m.v. hun eigen mailprogramma.  <br />De 'berichten' optie zal het ingebouwde PhpGedView berichtensysteem gebruiken en er worden geen e-mails verzonden.  <br />De 'berichten met e-mails' optie is de standaardoptie en zal het PhpGedView berichtensysteem gebruiken, maar zal eveneens een kopie van de berichten per e-mail verzenden.  <br />De optie 'E-mails zonder opslag' zorgt ervoor, dat berichten weliswaar per e-mail worden verzonden, maar dat ze niet in PhpGedView worden opgeslagen.<br />Als u de optie voor 'geen berichten' kiest, zal er geen mogelijkheid zijn voor de bezoekers om contact met u op te nemen.";
$pgv_lang["FAVICON"]				= "Favorieten icoon";
$pgv_lang["FAVICON_help"]			= "~FAVORIETEN ICOON~<br /><br />Wijzig dit in het icoon dat getoond moet worden in de favorieten als mensen de website markeren.";
$pgv_lang["THEME_DIR"]				= "Themamap";
$pgv_lang["THEME_DIR_help"]			= "~THEMAMAP~<br /><br />De map waar de PhpGedView thema bestanden staan. U kunt elk standaard thema aanpassen die met PhpGedView worden meegeleverd om uw website op een unieke manier te tonen.<br /> Zie de paragraaf over thema-aanpassing in het <a href=\"readme.txt\">readme.txt</a> bestand voor meer informatie.";
$pgv_lang["TIME_LIMIT"]				= "PHP tijdslimiet";
$pgv_lang["TIME_LIMIT_help"]		= "~PHP TIJDSLIMIET~<br /><br />De maximale tijd in seconden dat PhpGedView mag draaien. De standaard tijd is één minuut. Afhankelijk van de omvang van het GEDCOM-bestand is het mogelijk dat deze waarde verhoogt moet worden tijdens het opbouwen van de indexen. Met de waarde 0 mag PHP altijd blijven draaien.<br />OPGELET: door deze waarde op 0 te zetten of een andere hoge waarde is het mogelijk dat de website blijft hangen op bepaalde bewerkingen zolang het script draait. Door de waarde op 0 te zetten is het mogelijk dat het script nooit gestopt wordt behalve als het door de server beheerder wordt gestopt of de machine herstart. Een grote genealogietabel kan zeer lang draaien; door deze waarde zo laag mogelijk te houden wordt voorkomen dat iemand de webserver kan laten stoppen door een 1000 generatie lijst op te vragen.";
$pgv_lang["PGV_SESSION_SAVE_PATH"]		= "Map voor sessiebestanden";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"] = "~MAP VOOR SESSIEBESTANDEN~<br /><br />De map, waarin de PhpGedView sessiebestanden worden opgeslagen. Op sommige computers is PHP niet goed ingesteld en worden sessiegegevens niet bewaard tijdens schermwisselingen. Door deze instelling is het mogelijk om zelf te bepalen in welke map deze bestanden worden opgeslagen. De ./INDEX/ map is een goede keuze als aanpassing nodig is. Als deze waarde leeg wordt gelaten, wordt de map gebruikt die in het php.ini bestand is aangegeven.";
$pgv_lang["SERVER_URL"] 			= "PhpGedView-URL";
$pgv_lang["SERVER_URL_help"] 		= "~PhpGedView-URL~<br /><br />Type hier de URL van uw server, als u https of een andere dan de standaardpoort gebruikt.";
$pgv_lang["LOGIN_URL"]				= "URL voor aanmelden";
$pgv_lang["LOGIN_URL_help"]			= "~URL VOOR AANMELDEN~<br /><br />De URL voor aanmelden vult u alleen in, als u een andere site of locatie wilt opgeven waar uw gebruikers zich moeten aanmelden. Dit is bijvoorbeeld nuttig voor het geval u om wilt schakelen naar https voor aanmelden. De volledige URL naar het login.php-bestand dient hier ingevoerd te worden, bijv. https://www.mijnserver.nl/phpgedview/login.php.";
$pgv_lang["PGV_SESSION_TIME"]		= "Sessie verlopen";
$pgv_lang["PGV_SESSION_TIME_help"]	= "~SESSIE VERLOPEN~<br /><br />De tijd in seconden, dat een PhpGedView sessie actief blijft, voordat opnieuw aanmelden noodzakelijk is. Standaard is 120 minuten.";
$pgv_lang["SHOW_STATS"]				= "Toon verwerkingsgegevens";
$pgv_lang["SHOW_STATS_help"]		= "~TOON VERWERKINGSGEGEVENS~<br /><br />Toont verwerkingsgegevens en database bevragingen onder aan ieder scherm.";
$pgv_lang["SHOW_COUNTER"]			= "Toon bezoekteller";
$pgv_lang["SHOW_COUNTER_help"]		= "~TOON BEZOEKTELLER~<br /><br />Toont de bezoekteller op de MyGedView-pagina, de Genealogie-infopagina en op de personen-pagina.";
$pgv_lang["USE_REGISTRATION_MODULE"]		= "Gebruikers toestaan om gebruikersnamen te registreren";
$pgv_lang["USE_REGISTRATION_MODULE_help"]	= "~GEBRUIKERS TOESTAAN OM GEBRUIKERSNAMEN TE REGISTREREN~<br /><br />Geeft gebruikers de mogelijkheid zich op de site te registreren.<br />De gebruiker ontvangt daarna een e-mail met verificatiegegevens.<br />Beheerders moeten de registratie na verificatie goedkeuren opdat die actief wordt.";
$pgv_lang["ALLOW_USER_THEMES"] 		= "Gebruikers toestaan om hun eigen site-opmaak te kiezen";
$pgv_lang["ALLOW_USER_THEMES_help"] = "~GEBRUIKERS TOESTAAN OM HUN EIGEN SITE-OPMAAK TE KIEZEN~<br /><br />Geeft gebruikers de mogelijkheid hun eigen opmaakthema te kiezen.";
$pgv_lang["PGV_SIMPLE_MAIL"]		= "Gebruik alleen e-mailadres voor externe berichten";
$pgv_lang["PGV_SIMPLE_MAIL_help"]	= "~GEBRUIK ALLEEN E-MAILADRES VOOR EXTERNE BERICHTEN~<br /><br />Normaliter worden in externe mailberichten zowel het e-mailadres als de naam van de geadresseerde en de afzender gebruikt. Sommige mailsystemen accepteren dit niet. Bij de waarde \"Ja\" wordt alleen het e-mailadres gebruikt.";
$pgv_lang["CREATE_GENDEX"] 			= "Gendexbestanden maken";
$pgv_lang["CREATE_GENDEX_help"] 	= "~GENDEXBESTANDEN MAKEN~<br /><br />Laat PhpGedView GENDEX bestanden aanmaken zodra een GEDCOM-bestand wordt geïmporteerd. Deze worden opgeslagen in de index-map.";
$pgv_lang["gedcom_title_help"] 		= "~GEDCOM-TITEL~<br /><br />Voer een titel in, welke de inhoud van dit GEDCOM-bestand beschrijft.";
$pgv_lang["LOGFILE_CREATE"] 		= "Archiveer Logbestanden";
$pgv_lang["PGV_STORE_MESSAGES"]		= "Sta toe dat berichten worden opgeslagen";
$pgv_lang["PGV_STORE_MESSAGES_help"]	= "~STA TOE DAT BERICHTEN WORDEN OPGESLAGEN~<br /><br />Hiermee wordt aangegeven, of berichten, die door PhpGedView worden verzonden, opgeslagen worden. Bij de waarde \"Ja\" kunnen gebruikers, bij aanmelden, hun ontvangen berichten lezen. Bij de waarde \"Nee\" worden de berichten alleen via externe e-mail verzonden.";
$pgv_lang["ALLOW_THEME_DROPDOWN"]		= "Toon keuzelijst voor wijziging thema";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]	= "~TOON KEUZELIJST VOOR WIJZIGING THEMA~<br /><br />Deze optie geeft gebruikers de mogelijkheid om hun eigen site-opmaak te kiezen uit een keuzelijst.<br />de optie \"#ALLOW_USER_THEMES#\" moet eveneens ingeschakeld staan.";
$pgv_lang["META_AUTHOR"]			= "META-tag auteur";
$pgv_lang["META_AUTHOR_help"]		= "~META-TAG AUTEUR~<br /><br />Deze waarde wordt geplaatst in de META-tag voor de auteur in de kop van de HTML-pagina. Als deze leeg wordt gelaten, wordt de volledige naam van de contactpersoon opgenomen.";
$pgv_lang["META_AUTHOR_descr"]		= "Laat dit veld leeg om de volledige naam van de contactpersoon voor de desbetreffende genealogie te gebruiken.";
$pgv_lang["META_PUBLISHER"]			= "META-tag uitgever";
$pgv_lang["META_PUBLISHER_help"]	= "~META-TAG UITGEVER~<br /><br />Deze waarde wordt geplaatst in de META-tag voor de uitgever in de kop van de HTML-pagina. Als deze leeg wordt gelaten, wordt de volledige naam van de contactpersoon voor de desbetreffende genealogie opgenomen.";
$pgv_lang["META_PUBLISHER_descr"]	= "Laat dit veld leeg om de volledige naam van de contactpersoon voor de desbetreffende genealogie te gebruiken.";
$pgv_lang["META_COPYRIGHT"]			= "META-tag copyright";
$pgv_lang["META_COPYRIGHT_help"]	= "~META-TAG COPYRIGHT~<br /><br />Deze waarde wordt geplaatst in de META-tag voor copyright in de kop van de HTML-pagina. Als deze leeg wordt gelaten, wordt de volledige naam van de contactpersoon voor de desbetreffende genealogie opgenomen.";
$pgv_lang["META_COPYRIGHT_descr"]	= "Laat dit veld leeg om de volledige naam van de contactpersoon voor de desbetreffende genealogie te gebruiken.";
$pgv_lang["META_DESCRIPTION"]		= "META-tag omschrijving";
$pgv_lang["META_DESCRIPTION_help"]	= "~META-TAG OMSCHRIJVING~<br /><br />Deze waarde wordt geplaatst in de META-tag voor de omschrijving van de pagina, in de kop van de HTML-pagina. Als deze leeg wordt gelaten, wordt de naam van de actieve genealogie opgenomen.";
$pgv_lang["META_DESCRIPTION_descr"]	= "Laat dit veld leeg om voor deze waarde de naam van de actieve genealogie te gebruiken.";
$pgv_lang["META_PAGE_TOPIC"]		= "META-tag paginaonderwerp";
$pgv_lang["META_PAGE_TOPIC_help"]	= "~META-TAG PAGINAONDERWERP~<br /><br />Deze waarde wordt geplaatst in de META-tag voor het onderwerp van de pagina, in de kop van de HTML-pagina. Als deze leeg wordt gelaten, wordt de naam van de actieve genealogie opgenomen.";
$pgv_lang["META_PAGE_TOPIC_descr"]	= "Laat dit veld leeg om voor deze waarde de naam van de actieve genealogie te gebruiken.";
$pgv_lang["META_AUDIENCE"]			= "META-tag doelgroep";
$pgv_lang["META_AUDIENCE_help"]		= "~META-TAG DOELGROEP~<br /><br />Deze waarde wordt geplaatst in de META-tag voor de doelgroep van de pagina, in de kop van de HTML-pagina.";
$pgv_lang["META_PAGE_TYPE"]			= "META-tag paginatype";
$pgv_lang["META_PAGE_TYPE_help"]	= "~META-TAG PAGINATYPE~<br /><br />Deze waarde wordt geplaatst in de META-tag voor paginatype, in de kop van de HTML-pagina.";
$pgv_lang["META_ROBOTS"]			= "META-tag robots";
$pgv_lang["META_ROBOTS_help"]		= "~META-TAG ROBOTS~<br /><br />Deze waarde wordt geplaatst in de META-tag voor robots, in de kop van de HTML-pagina. Let op: veel zoek-robots negeren deze waarde.<";
$pgv_lang["META_REVISIT"]			= "META-tag herbezoek";
$pgv_lang["META_REVISIT_help"]		= "~META-TAG HERBEZOEK~<br /><br />Deze waarde wordt geplaatst in de META-tag voor herbezoek door zoekrobots, in de kop van de HTML-pagina.";
$pgv_lang["META_KEYWORDS"]			= "META-tag sleutelwoorden";
$pgv_lang["RSS_FORMAT"]				= "RSS-indeling";
$pgv_lang["META_KEYWORDS_help"]		= "~META-TAG SLEUTELWOORDEN~<br /><br />Deze waarde wordt geplaatst in de META-tag voor sleutelwoorden, in de kop van de HTML-pagina. Veel zoekmachines gebruiken de sleutelwoorden om de pagina te ontsluiten. Aan wat hier wordt opgegeven, worden automatisch de lijst met veel voorkomende achternamen en de statistieken voor de genealogie toegevoegd.";
$pgv_lang["META_TITLE"]				= "META-tag toevoegen aan titel";
$pgv_lang["META_TITLE_help"]		=	"~META-TAG TOEVOEGEN AAN TITEL~<br /><br />Alles wat hier wordt opgegeven, wordt toegevoegd aan de titel-metatag, achter de paginatitel en voor de PhpGedView informatie.";
$pgv_lang["PGV_MEMORY_LIMIT"]		= "Geheugenlimiet";
$pgv_lang["PGV_MEMORY_LIMIT_help"]	= "~GEHEUGENLIMIET~<br /><br />Het maximum geheugen dat PHP-scripts kunnen gebruiken. De standaardwaarde is 16 Mb. Op veel machines is de optie om deze waarde voor PHP in te stellen uitgeschakeld. Het instellen van deze waarde heeft daarom niet altijd invloed op de werkelijke maximumwaarde.";
$pgv_lang["LOGFILE_CREATE_help"] 	= "~ARCHIVEER LOGBESTANDEN~<br /><br />Geef aan hoe vaak het programma de log bestanden moet archiveren.";
$pgv_lang["welcome_new"] 			= "Welkom bij uw nieuwe PhpGedView website. U ziet deze pagina omdat u PhpGedView met succes op uw webserver heeft geïnstalleerd en kunt nu beginnen met het instellen volgens uw wensen.<br />";
$pgv_lang["welcome_new_help"]		= "~WELKOM~<br /><br />Dit Help-venster zal u behulpzaam zijn bij het configuratieproces.  Omdat u diverse velden moet invullen, kan dit venster u van aanvullende informatie voorzien, over het veld waarin u bent. U kunt dit venster sluiten, om het weer te openen klik op een van de \"?\" vraagtekens naast het label van het veld.";
$pgv_lang["review_readme"] 			= "Leest u eerst het <a href=\"readme.txt\" target=\"_blank\">readme.txt</a> bestand voordat u verder gaat met het instellen van PhpGedView.<br /><br />";
$pgv_lang["return_editconfig"]		= "U kunt ten allen tijde terugkeren naar deze pagina, door te klikken op de koppeling <b>Instellingen</b> op de Pagina <b>Beheer</b>, of met uw internet verkenner het bestand editconfig.php op te roepen.<br />";
$pgv_lang["return_editconfig_gedcom"]	= "U kunt ten allen tijde terugkeren naar deze pagina, door te klikken op de koppeling <b>Wijzig</b> in de tabel <b>Huidige GEDCOM-bestanden</b> op de Pagina <b>Beheer GEDCOM-bestanden en privacy instellingen</b>, of met uw internet verkenner het bestand editconfig_gedcom.php op te roepen.<br />";
$pgv_lang["save_config"] 			= "Instellingen opslaan";
$pgv_lang["download_here"]			= "Klik hier om het bestand te downloaden.";
$pgv_lang["download_gedconf"]		= "Download de GEDCOM-configuratie.";
$pgv_lang["not_writable"]			= "Er is geconstateerd dat PHP geen schrijftoegang heeft tot uw configuratie bestand. Klik op de download-knop om het bestand elders te plaatsen. Later kan dit handmatig op de juiste locatie geplaatst worden.";
$pgv_lang["upload_to_index"]		= "Upload het bestand naar de index-map.";
$pgv_lang["import_sql"]				= "Er zijn SQL bestanden gevonden in uw index-map. Omdat deze afkomstig kunnen zijn van \"Migreren gebruikersinformatie\", heeft u hier de mogelijkheid om de informatie te importeren in uw database. Wilt u nu proberen deze bestanden te importeren? Alle bestaande gebruikersinformatie(gebruiker, nieuws, boodschappen, vak-indelingen en favorieten) gaat verloren.<br /><br />Als u doorgaat, zal PhpGedView trachten om de gegevens te importeren. Als dit niet succesvol verloopt, zal u worden gevraagd om een Administrator account aan te maken.<br /><br />";

//-- edit privacy messages
$pgv_lang["edit_privacy"]			= "Wijzig privacy";
$pgv_lang["edit_privacy_title"]		= "Wijzig GEDCOM privacy-instellingen";
$pgv_lang["PRIV_PUBLIC"]			= "Zichtbaar voor ALLE bezoekers";
$pgv_lang["PRIV_USER"]				= "Alleen zichtbaar voor geautoriseerde gebruikers";
$pgv_lang["PRIV_NONE"]				= "Alleen zichtbaar voor beheerders";
$pgv_lang["PRIV_HIDE"]				= "Verberg, zelfs voor beheerders";
$pgv_lang["save_changed_settings"]	= "Wijzigingen opslaan";
$pgv_lang["add_new_pp_setting"]		= "Nieuwe privacy instelling voor persoon toevoegen";
$pgv_lang["add_new_up_setting"]		= "Nieuwe privacy instelling voor gebruiker toevoegen";
$pgv_lang["add_new_gf_setting"]		= "Nieuwe algemene instelling voor gegevens toevoegen";
$pgv_lang["add_new_pf_setting"]		= "Nieuwe specifieke instelling voor gegevens toevoegen";
$pgv_lang["add_new_pf_setting_source"]		= "Voeg nieuwe instelling toe voor gegevens van een bron";
$pgv_lang["privacy_source"]			= "Bron";
$pgv_lang["privacy_indi"]			= "Persoon";
$pgv_lang["privacy_indi_source"]	= "Persoon / Bron";
$pgv_lang["privacy_source_id"]		= "Bron - ID";
$pgv_lang["privacy_indi_id"]		= "Persoons - ID";
$pgv_lang["add_new_pf_setting_indi"]		= "Voeg nieuwe instelling toe voor gegevens van een persoon";
$pgv_lang["file_read_error"]		= "F O U T !!! Kan het Privacybestand niet lezen!";
$pgv_lang["general_privacy"]		= "Algemene privacy-instellingen";
$pgv_lang["person_privacy"]			= "Privacy instellingen voor een persoon";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Wijzig bestaande privacy instellingen voor persoon";
$pgv_lang["user_privacy"]			= "Privacy instellingen voor een gebruiker";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Wijzig bestaande privacy instellingen voor een gebruiker";
$pgv_lang["global_facts"]			= "Algemene instellingen voor gegevens";
$pgv_lang["edit_exist_global_facts_settings"]	= "Wijzig bestaande algemene instellingen voor gegevens";
$pgv_lang["person_facts"]			= "Specifieke instellingen voor gegevens";
$pgv_lang["edit_exist_person_facts_settings"]	= "Wijzig bestaande specifieke instellingen voor gegevens van een persoon";
$pgv_lang["general_privacy_help"]	= "De <b>#pgv_lang[general_privacy]#.</b><br />Hier maakt u de basisinstellingen voor deze genealogie. Let erop, dat u de instellingen van de juiste genealogie aanpast, want als u meer genealogieën in PhpGedView beschikbaar heeft, gelden voor iedere genealogie eigen privacy-instellingen.<br />Afwijkingen van de basisinstellingen zijn mogelijk, door de andere instellingen op deze pagina te gebruiken.<br />#pgv_lang[more_config_help]#";
$pgv_lang["accessible_by"]			= "Zichtbaar voor?";
$pgv_lang["hide"]					= "Verbergen";
$pgv_lang["show_question"]			= "Zichtbaar?";
$pgv_lang["user_name"]				= "Gebruikersnaam";
$pgv_lang["name_of_fact"]			= "Omschrijving gegevens";
$pgv_lang["choice"]					= "Keuze";
$pgv_lang["fact_show"]				= "Gegeven zichtbaar";
$pgv_lang["fact_details"]			= "Details gegeven zichtbaar";
$pgv_lang["privacy_header"]			= "Wijzig interne privacy instellingen";
$pgv_lang["unable_to_find_privacy_indi"]	= "Kan geen persoon met dit ID vinden";
$pgv_lang["save_and_import"]		= "Nadat u deze GEDCOM-configuratie heeft opgeslagen, moet u opnieuw het GEDCOM-bestand importeren door op de knop <b>Importeer GEDCOM</b> te klikken of te gaan naar <b>Beheren->Beheer GEDCOMs->Importeren GEDCOM-bestand</b>";
$pgv_lang["SHOW_LIVING_NAMES"]		= "Namen levende personen zichtbaar";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]		= "Gebruik relatie privacy";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]		= "Controleer relaties door huwelijk";
$pgv_lang["SHOW_DEAD_PEOPLE"]		= "Overleden personen zichtbaar";
$pgv_lang["help_info"]				= "U kunt hulp krijgen, voor elk onderwerp, door te klikken op het rode \"?\" naast het label van elk veld.";
$pgv_lang["SHOW_LIVING_NAMES_help"]	= "~NAMEN LEVENDE PERSONEN ZICHTBAAR~<br /><br />Hiermee wordt ingesteld, voor welke groep gebruikers de namen van nog levende personen zichtbaar zijn.";
$pgv_lang["SHOW_RESEARCH_LOG"]			= "Toon onderzoekslogboek";
$pgv_lang["SHOW_RESEARCH_LOG_help"]		= "~TOON ONDERZOEKSLOGBOEK~<br /><br />Dit geeft aan welke gebruikers het onderzoekslogboek kunnen bekijken, als dit is geinstalleerd.";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "~GEBRUIK RELATIE PRIVACY~<br /><br />Een 'Nee' waarde betekent dat geautoriseerde gebruikers de details van alle levende personen kunnen zien.<br />Een 'Ja' waarde betekent dat gebruikers alleen de privé-informatie kunnen zien van levende personen, aan wie ze verwant zijn.";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]		= "Max. lengte relatie-pad";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "~MAX. LENGTE RELATIE-PAD~<br /><br />Indien voor relatieprivacy is gekozen, stelt u hiermee in, welke andere personen een gebruiker kan zien. Als de waarde 3 wordt gekozen, kan hij dit maximaal 3 personen ver zien. Bijvoorbeeld zijn vaders broers vrouw (zijn tante) of de zoon van zijn moeders zuster (neef).";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "~CONTROLEER RELATIES DOOR HUWELIJK~<br /><br />Controleer de verwantschap door huwelijksrelaties, als voor relatieprivacy is gekozen. Staat dit op \"Ja\", dan kan de gebruiker, bij een relatiepad van 3, de vrouw van zijn vaders broer zien. Staat het op \"Nee\", dan kan dit niet. Echter, wanneer het relatiepad dan op 4 wordt gezet, dan is het pad weer mogelijk door vader - broer van vader - kind - moeder van kind.";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]	= "~OVERLEDEN PERSONEN ZICHTBAAR~<br /><br />Stelt het privacy-toegangsniveau in voor alle overleden personen.";
$pgv_lang["person_privacy_help"]	= "De <b>#pgv_lang[person_privacy]#.</b><br /><br />Deze instellingen geven beheerders de mogelijkheid om de standaard privacy-instellingen voor een bepaalde persoon, in het GEDCOM-bestand, te niet te doen. Veronderstel bijv. dat er een kind is, dat jong overleed. Normaal gesproken, zouden de details zichtbaar zijn voor alle gebruikers, aangezien het kind is overleden. Maar de rest van de familie is nog steeds privé. U wilt niet de gegevens van het overlijden van het kind verwijderen, maar u wilt de details verbergen en privé maken. Veronderstel dat het kind het ID I100 had, dan zou u de volgende privacy instellingen moeten invoeren: <br /><br />ID: I100<br />Zichtbaar voor: \"Alleen zichtbaar voor geautoriseerde gebruikers\"<br /><br />Omgekeerd werkt dit eveneens. Als u de details openbaar wilt maken van iemand (ID 101), waarvan u weet dat hij overleden is, maar waarvan u geen overlijdensdatum heeft, kunt u het volgende toevoegen:<br /><br />ID: I101<br />Zichtbaar voor: \"Zichtbaar voor ALLE bezoekers\"";
$pgv_lang["user_privacy_help"]		= "De <b>#pgv_lang[user_privacy]#.</b><br /><br />Deze instellingen geven beheerders de mogelijkheid om de standaard privacy-instellingen te niet te doen, voor personen in het GEDCOM-bestand, gebaseerd op de gebruikersnaam van de gebruiker.<br /><br />Dus, als u niet wilt dat de gebruikersnaam \"John\" uw details kan zien, en u heeft het ID 100 in het GEDCOM-bestand, kunt u het als volgt instellen:<br /><br />Gebruikersnaam: John<br />ID: I100<br />Zichtbaar?: \"Verbergen\"<br /><br />en uw details zullen alleen verborgen zijn voor de Gebruikernaam \"John\".<br /><br />Om de details van I101 (welke normaal gesproken verborgen zijn, omdat I101 nog in leven is) zichtbaar te maken voor de gebruikernaam \"John\" stelt u het als volgt in:<br /><br />Gebruikersnaam: John<br />ID: I101<br />Zichtbaar?: \"Toon\"";
$pgv_lang["global_facts_help"]		= "De <b>#pgv_lang[global_facts]#.</b><br /><br />Met deze instellingen regelt u, op algemeen niveau, welke gegevens van alle personen in het GEDCOM-bestand verborgen moeten blijven.<br /><br />Het [\"Omschrijving gegevens\"] element bepaalt welk gegeven verborgen moet blijven. Het element [\"Keuze\"] kiest het gegeven, of de daaraan gerelateerde details. Het element [\"Zichtbaar voor\"] bepaalt bij welk toegangsniveau het gegeven zichtbaar is.<br /><br />De algemene instellingen voor gegevens zijn bedoeld om bepaalde gegevens van alle personen te verbergen, zowel van levende als overleden personen, zoals opgeslagen per GEDCOM-tag. Standaard is al de SSN (sofi-nummer) tag verborgen voor publieke bezoekers. Dit is om te voorkomen dat dit soort gegevens kan worden gestolen en dat misbruik wordt gemaakt van bijv. Sofi-nummers van overleden verwanten. Dit is waarschijnlijk het meest relevant voor de V.S. <br />Indien u alle huwelijken voor publieke bezoekers zou willen verbergen, kunt u het volgende instellen:<br /><br />Omschrijving gegevens: (MARR) - Huwelijk<br />Keuze: \"Gegeven zichtbaar\"<br />Zichtbaar voor?: \"Alleen zichtbaar voor geautoriseerde gebruikers\"<br /><br />Omschrijving gegevens: (MARR) - Huwelijk<br />Keuze: \"Details gegevens zichtbaar\"<br />Zichtbaar voor?: \"Alleen zichtbaar voor geautoriseerde gebruikers\"<br /><br />Met deze instellingen zijn alle huwelijken (en gerelateerde details) verborgen, behalve voor beheerders en gebruikers, die zich hebben aangemeld.";
$pgv_lang["person_facts_help"]		= "De <b>#pgv_lang[person_facts]#.</b><br /><br />Met deze instellingen regelt u, per bepaald persoon in het GEDCOM-bestand, welke gegevens en op welk niveau verborgen zijn.<br /><br />Het eerste element is het ID van de persoon, het tweede element is het gegeven.<br />Het element [\"Keuze\"] kiest het gegeven, of de daaraan gerelateerde details. Het element [\"Zichtbaar voor\"] bepaalt bij welk toegangsniveau het gegeven zichtbaar is.<br /><br />Deze instellingen werken op dezelfde wijze als de algemene instellingen, behalve dat u hier ook het GEDCOM-ID van de persoon, waarvan u gegevens wilt verbergen, instelt. Dus kunt u bijvoorbeeld de gegevens van het huwelijk van een bepaald persoon verbergen.";
$pgv_lang["select_privacyfile_button"]		= "Geselecteerd privacybestand";
$pgv_lang["PRIVACY_BY_YEAR"]		= "Beperk privacy door de ouderdom van de gebeurtenis.";
$pgv_lang["PRIVACY_BY_YEAR_help"]	= "De optie \"Beperk privacy door de ouderdom van de gebeurtenis\" verbergt de details van personen, gebaseerd op hoe oud ze waren ten tijde van een gebeurtenis en onafhankelijk van of ze zijn overleden of niet. Gebruik deze optie in combinatie met de optie \"Leeftijd waarboven iemand geacht wordt overleden te zijn\".<br /><br />Bijvoorbeeld: als u deze optie aanzet en de waarde op 100 jaar instelt, worden alle personen die minder dan 100 jaar geleden zijn geboren, verborgen. Personen die minder dan 85 jaar geleden zijn gehuwd en personen die minder dan 75 jaar geleden overleden zijn worden eveneens verborgen.<br /><br />Let op: deze optie verlaagt de prestaties van PhpGedView enigszins.";
$pgv_lang["enable_disable_lang"]	= "In- en uitschakelen talen";
$pgv_lang["translator_tools"]		= "Beheer taalbestanden";

//-- language edit utility
$pgv_lang["edit_langdiff"]			= "Bewerk en configureer de taalbestanden";
$pgv_lang["bom_check"]				= "BOM-controle taalbestanden";
$pgv_lang["bom_check_help"]		= "~#pgv_lang[bom_check]#~<br /><br />#pgv_lang[bom_check_desc]#<br /><br />";
$pgv_lang["bom_check_desc"]			= "Middels deze controle worden BOM's (Byte Order Mark) in de taalbestanden opgespoord en verwijderd.<br /><br />";
$pgv_lang["lang_debug"]				= "Helptekst foutzoeken";
$pgv_lang["lang_debug_help"]	= "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#<br /><br />";
$pgv_lang["lang_debug_desc"]		= "Als u deze optie aanzet, worden de namen van de taalvariabelen die in de helptekst worden gebruikt, in het popup-venster getoond. Dit helpt vertalers om de naam van de variabele te bepalen, als de tekst moet worden aangepast.<br /><br />Deze optie blijft alleen gedurende uw huidige PhpGedView-sessie aanstaan.";
$pgv_lang["lang_debug_use"]			= "Gebruik optie foutzoeken in helptekst ";
$pgv_lang["bom_not_found"]			= "Geen BOM gevonden in de taalbestanden.";
$pgv_lang["bom_found"]				= "BOM gevonden in ";
$pgv_lang["edit_lang_utility"]		= "Bewerkingsprogramma taalbestand";
$pgv_lang["edit_lang_utility_help"]	= "U kunt dit programma gebruiken om een taalbestand te wijzigen aan de hand van het Engelstalige bestand.<br />Het programma geeft een lijst weer van teksten in het Engelse taalbestand en de bijbehorende teksten in het door u gekozen taalbestand.<br />U kunt een tekst in het gekozen taalbestand wijzigen door erop te klikken en de tekst vervolgens aan te passen. Daarna kunt u de wijzigingen opslaan.<br />De teksten kunnen elk 6144 karakters groot zijn.<br /><br />";
$pgv_lang["edit_lang_utility_warning"]	= "LET OP!<br /><br />Het gebruik van de knop #close_window_without_refresh# kan leiden tot verminking van het taalbestand!<br /><br />Als u deze knop heeft gebruikt, wordt de tekst in het venster van het vertaalprogramma niet ververst. De aangebrachte wijzigingen zijn dan niet zichtbaar.<br />Bovendien leidt opnieuw wijzigen van de desbetreffende tekst tot fouten in het taalbestand.<br />Als u een tekst toch opnieuw wilt wijzigen, herlaadt deze dan eerst door op de knop \"Wijzig\" te klikken boven aan het scherm.";
$pgv_lang["language_to_edit"]		= "Taal om te wijzigen";
$pgv_lang["file_to_edit"]			= "Taalbestandstype om te wijzigen";
$pgv_lang["check"]					= "Controleer";
$pgv_lang["lang_save"]				= "Opslaan";
$pgv_lang["contents"]				= "Inhoud";
$pgv_lang["listing"]				= "Lijst";
$pgv_lang["no_content"]				= "Geen inhoud";
$pgv_lang["editlang"]				= "Wijzigen";
$pgv_lang["editlang_help"]			= "Wijzig bericht in taalbestand";
$pgv_lang["savelang"]				= "Opslaan";
$pgv_lang["savelang_help"]			= "Sla aangepast bericht op";
$pgv_lang["original_message"]		= "Origineel bericht";
$pgv_lang["message_to_edit"]		= "Te wijzigen bericht";
$pgv_lang["changed_message"]		= "Gewijzigde inhoud";
$pgv_lang["message_empty_warning"] 	= "WAARSCHUWING! De tekst van deze boodschap ontbreekt in [#LANGUAGE_FILE#]";
$pgv_lang["language_to_export"]		= "Kies taal voor export";
$pgv_lang["export_lang_utility"]	= "Hulpprogramma export taalbestand";
$pgv_lang["export"]					= "Export";
$pgv_lang["export_lang_utility_desc"]	= "Kies een taal om de helpinformatie uit het gekozen configuration_help taalbestand te exporteren naar een documentatiebestand.<br /><br />";
$pgv_lang["export_ok"]				= "Helpinformatie is geëxporteerd.";
$pgv_lang["compare_lang_utility"]	= "Hulpprogramma vergelijking taalbestanden";
$pgv_lang["compare_lang_utility_desc"]	= "Deze module vergelijkt twee taalbestanden en maakt een lijst van verschillen. Aangegeven wordt, welke variabelen ten opzichte van het eerste bestand niet meer voorkomen of er juist zijn bijgekomen.<br /><br />In het bestand [<a href=\"languages/LANG_CHANGELOG.txt\" target=\"_blank\">LANG_CHANGELOG.txt</a>] in de languages-map staan nog andere wijzigingen vermeld. Hierin kunt u vinden welke variabelen qua inhoud zijn gewijzigd.<br /><br />";
$pgv_lang["new_language"]			= "Eerste taal";
$pgv_lang["old_language"]			= "Tweede taal";
$pgv_lang["compare"]				= "Vergelijk";
$pgv_lang["comparing"]				= "Vergeleken taalbestanden";
$pgv_lang["additions"]				= "Toevoegingen";
$pgv_lang["no_additions"]			= "Geen toevoegingen";
$pgv_lang["subtractions"]			= "Verwijderingen";
$pgv_lang["no_subtractions"]		= "Geen verwijderingen";
$pgv_lang["config_lang_utility"]	= "Configuratie ondersteunde talen";
$pgv_lang["config_lang_utility_help"]	= "Met behulp van deze module kunt u eenvoudig de ondersteunde talen in PhpGedView in- of uitschakelen.<br />Tevens kunt u een aantal land- en taalspecifieke instellingen aanpassen.<br /><br />Let op: Als u de originele instellingen wijzigt, wordt een nieuw instellingenbestand aangemaakt in uw #INDEX_DIRECTORY#-map. Vanaf dat moment gebruikt PhpGedView dit nieuwe bestand. Ook latere wijzigingen op de ondersteunde talen worden steeds hierin opgeslagen.<br /><br />Als u problemen heeft met taalinstellingen en u rapporteert dit, vermeldt er dan bij dat u gebruik maakt van aangepaste taalinstellingen.<br /><br />";
$pgv_lang["active"]					= "Actief";
$pgv_lang["active_help"]			= "~ACTIEF~<br /><br />Sta de gebruikers toe deze taal te kiezen, indien het is toegestaan om een andere taal te selecteren.";
$pgv_lang["edit_settings"]			= "Wijzig instellingen";
$pgv_lang["lang_edit"]				= "Wijzig";
$pgv_lang["lang_language"]			= "Taal";
$pgv_lang["export_filename"]		= "Naam van het bestand met de geëxporteerde gegevens:";
$pgv_lang["lang_back"]				= "Terug naar het Hoofdmenu om taalbestanden te wijzigen en te configureren";
$pgv_lang["lang_back_admin"]		= "Terug naar menu Beheer";
$pgv_lang["lang_back_manage_gedcoms"]	= "Terug naar menu Beheer GEDCOM-bestanden";
$pgv_lang["lang_name_czech"]		= "Tsjechisch";
$pgv_lang["lang_name_danish"]		= "Deens";
$pgv_lang["lang_name_german"]		= "Duits";
$pgv_lang["lang_name_english"]		= "Engels";
$pgv_lang["lang_name_finnish"]		= "Fins";
$pgv_lang["lang_name_spanish"]		= "Spaans";
$pgv_lang["lang_name_spanish-ar"]	= "Spaans (Latijns-Amerikaans)";
$pgv_lang["lang_name_portuguese-br"]	= "Portugees (Brazilië)";
$pgv_lang["lang_name_portuguese"]	= "Portugees";
$pgv_lang["lang_name_french"]		= "Frans";
$pgv_lang["lang_name_italian"]		= "Italiaans";
$pgv_lang["lang_name_dutch"]		= "Nederlands";
$pgv_lang["lang_name_norwegian"]	= "Noors";
$pgv_lang["lang_name_polish"]		= "Pools";
$pgv_lang["lang_name_swedish"]		= "Zweeds";
$pgv_lang["lang_name_turkish"]		= "Turks";
$pgv_lang["lang_new_language"]		= "Nieuwe taal";
$pgv_lang["lang_name_hungarian"]	= "Hongaars";
$pgv_lang["lang_name_chinese"]		= "Chinees";
$pgv_lang["lang_name_hebrew"]		= "Hebreeuws";
$pgv_lang["lang_name_russian"]		= "Russisch";
$pgv_lang["lang_name_greek"]		= "Grieks";
$pgv_lang["lang_name_vietnamese"]	= "Vietnamees";
$pgv_lang["lang_name_arabic"]		= "Arabisch";
$pgv_lang["lang_name_lithuanian"]	= "Litouws";
$pgv_lang["original_lang_name"]			= "Originele naam van de taal in het #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]	= "~ORIGINELE NAAM VAN DE TAAL~<br /><br />Hiermee geeft u aan, hoe deze taal in die taal zelf wordt genoemd.<br />Voorbeelden: Engels: English, Duits: Deutsch, Nederlands: Nederlands.";
$pgv_lang["lang_shortcut"]			= "Afkorting van de taal";
$pgv_lang["lang_shortcut_help"]		= "~AFKORTING VAN DE TAAL~<br /><br />Met deze optie stelt u in, hoe de taal in twee letters wordt afgekort.<br />Meestal is dit de eerste code, die in de taaldetectiecodes is opgenomen.<br />De afkorting wordt gebruikt voor de naamgeving van de taalbestanden. ";
$pgv_lang["lang_langcode_help"]		= "~TAALDETECTIECODES~<br /><br />Met behulp van deze codes kan PhpGedView detecteren welke taalinstelling de Internetverkenner van de gebruiker gebruikt voor het bekijken van de PhpGedView pagina's. De codes moeten worden gescheiden door een puntkomma \";\". ";
$pgv_lang["lang_langcode"]			= "Taaldetectiecodes";
$pgv_lang["lang_filenames"]			= "Taalbestand";
$pgv_lang["lang_filenames_help"]		= "_TAALBESTAND~<br /><br />PhpGedView ondersteunt een groot aantal talen. Hiertoe worden alle teksten in het programma per taal opgeslagen in aparte bestanden, gescheiden van het programma zelf. Per taal zijn de teksten ondergebracht in vijf bestanden. In welk bestand een bepaalde tekst is opgeslagen, hangt af van de functie van de tekst. Als een bepaalde tekst niet is vertaald in een gekozen taal, wordt de Engelse tekst getoond.<br /><br />De bestanden voor elke taal zijn:<br /><ul><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;Dit bestand bevat de teksten, uitdrukkingen en helpinformatie die bij het instellen van PhpGedView worden gebruikt. De helpinformatie wordt niet aan gewone gebruikers getoond.<br /></li><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;Dit is een lijst met landcodes en -namen, afkomstig van de website van de Statistics Division, United Nations Department of Economic and Social Affairs. Dit is de link naar de Engelstalige lijst: <a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=\"_blank\"><b>link</b></a>. De lijst is beschikbaar in het Engels en in het Frans.<br /></li><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;Dit bestand bevat de teksten die horen bij de GEDCOM-feitcodes uit de GEDCOM 5.5.1 Standaard. Het bevat eveneens niet-standaard codes die door verschillende genealogie-programma's worden gebruikt.<br /><br />U kunt de Engelstalige versie van de <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=\"_blank\"><b>GEDCOM 5.5.1 Standaard</b></a> downloaden in PDF (Portable Document Format).<br /></li><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;In dit bestand zijn alle helpteksten voor gewonde gebruikers opgeslagen. Sommige teksten, die specifiek voor beheerders zijn bedoeld, worden niet aan gebruikers zonder beheerdersrechten getoond.<br /></li><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Dit bestand bevat alle teksten die bij het gebruik van PhpGedview op de pagina's te zien zijn.</li></ul>";
$pgv_lang["flagsfile"]				= "Vlagbestand:";
$pgv_lang["flagsfile_help"]			= "~VLAGBESTAND~<br /><br />Naam en pad van het afbeeldingbestand van de nationale vlag van de geselecteerde taal.";
$pgv_lang["text_direction"]			= "Richting van de tekst:";
$pgv_lang["text_direction_help"]	= "~RICHTING VAN DE TEKST~<br /><br />Hiermee stelt u in, op welke wijze teksten worden weergegeven. In de meeste talen is dit van links naar rechts, maar met name in veel Semitische talen zoals het Arabisch, Aramees en Hebreeuws is dit van rechts naar links.";
$pgv_lang["time_format"]			= "Tijdformaat";
$pgv_lang["time_format_help"]		= "~TIJDFORMAAT~<br /><br />Verschillende landen hebben verschillende manieren om de tijd weer te geven. Met deze variabele stelt u in, hoe de tijd in de desbetreffende taal wordt weergegeven.<br /><br />In Nederland wordt vaak de 24-uurs klok gebruikt, terwijl in Engelstalige landen de 12-uurs klok gangbaar is, met de toevoeging AM of PM.<br />Hiermee stelt u in, hoe PhpGedView de tijd in de gekozen taal weergeeft.<br /><br />Variabelen die u kunt gebruiken zijn:<br />a - Aanduiding voor am/pm in kleine letters.<br />A - Aanduiding voor AM/PM in hoofdletters.<br />B - Swatch internettijd, 000 - 999.<br />c - ISO 8601 datum (toegevoegd in PHP 5) 2004-02-12T15:19:21+00:00.<br />d - Dag van de maand in cijfers met voorloopnullen (00 - 31).<br />D - Dag van de week in drie letters in het Engels (Mon - Sun).<br />F - Naam van de maand in letters, Engelstalig (January - December).<br />g - Uren in cijfers, 12-urige klok, zonder voorloopnullen (0 - 12).<br />G - Uren in cijfers, 24-urige klok, zonder voorloopnullen (0 - 23).<br />h - Uren in cijfers, 12-urige klok, met voorloopnullen (00 - 12).<br />H - Uren in cijfers, 24-urige klok, met voorloopnullen (00 - 23).<br />i - Minuten in cijfers, met voorloopnullen (00-59).<br />I - (Hoofdletter i) Geeft aan of de tijd in zomertijd is weergegeven. 1 is wel, 0 is niet.<br />j - Dag van de maand in cijfers, zonder voorloopnullen (1 - 31).<br />l - (kleine letter L) Dag van de week in letters, in het Engels (Sunday - Saturday).<br />L Schrikkeljaar, 1 is wel, 0 is niet.<br />m - Maand in cijfers, met voorloopnullen (01 - 12).<br />M - Maand in drie letters tekst, in het Engels (Jan - Dec).<br />n - Maand in cijfers, zonder voorloopnullen (1 - 12).<br />O - Verschil met Greenwich Mean Time (GMT) in aantal uren, bijvoorbeeld +0200.<br />r - Datum in het formaat van RFC2822, bijvoorbeeld: Thu, 21 Dec 2000 16:01:07 +0200.<br />s - Seconden in cijfers met voorloopnullen (00 - 59).<br />S - Engelse toevoeging op het dagnummer, bijvoorbeeld 1st, 2nd, 3rd, 4th. Kan gebruikt worden in combinatie met \"j\".<br />t - Aantal dagen in de desbetreffende maand (28 - 31).<br />T - Instelling van de tijdzone voor deze machine, bijvoorbeeld CEST, EST, MDT, etc.<br />U - Aantal seconden vanaf de start van de UNIX-tijd (1 januari 1970, 00:00:00 GMT).<br />w - Dag van de week in cijfers ( 0 - 6, voor Zondag - Maandag).<br />W - Weeknummer volgens ISO-8601 (01 - 53). De week start op maandag.<br />Y - Jaartal in 4 cijfers, bijvoorbeeld 1995, 2004.<br />y - Jaartal in twee cijfers, bijvoorbeeld 95, 04.<br />z - Dagnummer binnen het jaar (0 - 365).<br />Z - Verschil van de tijdzone met UTC in seconden. Ten westen van UTC zijn de waarden altijd negatief, ten oosten positief ( -43200 - 43200)<br /><br />U kunt zowel de volgorde van de variabelen zelf bepalen, als de tussenliggende tekens, zoals \"-\" of \":\".<br /><br />Voorbeelden:<br />G:i:s  = Uren (24-uursklok):minuten:seconden<br />g:i:sa = Uren (12-uursklok):minuten:seconden am/pm";
$pgv_lang["date_format_help"]		= "~DATUMFORMAAT~<br /><br />Verschillende landen hebben verschillende manieren om de datum te tonen. In het Nederlands is dit standaard \"Dag Maand Jaar\", terwijl in het Engels vaak \"Maand Dag Jaar\" wordt gehanteerd. Hiermee stelt u in, hoe PhpGedView de datum in de gekozen taal toont. Dit betreft zowel datumweergave vanuit PhpGedView als de weergave van datums die in de gegevens voorkomen.<br /><br />Voorbeelden:<br />D M Y  = 13 oktober 2004 (o.a. Nederland)<br />D. M Y = 13. oktober 2004 (o.a. Duitsland)<br />D-M-Y  = 13-oktober-2004<br />M D Y  = oktober 13 2004 (o.a. Verenigde Staten)<br />D. M#ta# Y = 13. octoberta 2004 (Finland)";
$pgv_lang["week_start"]				= "Week begint op:";
$pgv_lang["week_start_help"]		= "~WEEK BEGINT OP~<br /><br />De dag van de week, waarop in deze taal een week begint. In de meeste landen start de week op zondag, maar sommigen starten op maandag of een andere dag.";
$pgv_lang["name_reverse"]			= "Achternaam eerst:";
$pgv_lang["name_reverse_help"]		= "~ACHTERNAAM EERST~<br /><br />In sommige talen wordt de achternaam eerst genoemd, voor de voornaam, in plaats van andersom, wat standaard is. Met deze optie stelt u in dat de achternaam eerst wordt weergegeven.";
$pgv_lang["ltr"]					= "v.l.n.r.:";
$pgv_lang["rtl"]					= "v.r.n.l.:";
$pgv_lang["file_does_not_exist"]	= "FOUT! Het bestand bestaat niet!...";
$pgv_lang["alphabet_upper"]			= "Alfabet hoofdletters";
$pgv_lang["alphabet_upper_help"]	= "~ALFABET HOOFDLETTERS~<br /><br />Alfabet van hoofdletters in deze taal. Dit alfabet wordt gebruikt voor het sorteren van namen in hoofdletters in de namenlijsten van PhpGedView.";
$pgv_lang["alphabet_lower"]			= "Alfabet kleine letters";
$pgv_lang["alphabet_lower_help"]	= "~ALFABET KLEINE LETTERS~<br /><br />Alfabet van kleine letters in deze taal. Dit alfabet wordt gebruikt voor het sorteren van namen in kleine letters in de namenlijsten van PhpGedView.";
$pgv_lang["lang_config_write_error"]	= "Fout bij het wegschrijven van de taalinstellingen in het bestand  [language_settings.php]. Controleer de schrijfrechten en probeer het opnieuw.";
$pgv_lang["translation_forum_desc"]	= "Deze koppeling opent een nieuw venster in uw Internet Verkenner, naar het vertalerforum van PhpGedView (http://sourceforge.net/forum/forum.php?forum_id=294245). Hier kunt u vragen stellen over vertalingen, problemen voorleggen en (als u wilt) u aanmelden voor het leveren van een bijdrage aan de vertalingen.<br />Als u moeite heeft met de Engelse taal, dan kunt u uw bericht in het Nederlands stellen.<br /><br />";
$pgv_lang["lang_set_file_read_error"]	= "F O U T !!! Kan het bestand [language_settings.php] niet lezen!";
$pgv_lang["add_new_language"]		= "Bestanden en instellingen voor nieuwe taal toevoegen";
$pgv_lang["add_new_language_help"]	= "~#pgv_lang[add_new_language]#~<br /><br />#pgv_lang[add_new_language_desc]#";
$pgv_lang["add_new_language_desc"]	= "Met behulp van deze optie kunt u nieuwe, nog niet ondersteunde talen aan PhpGedView toevoegen. In het volgende scherm kunt u hiervoor de instellingen aanbrengen.<br />Nadat de nieuwe taal is toegevoegd, kunt u met het bewerkingsprogramma taalbestand alle teksten en berichten in die taal aanmaken.";
$pgv_lang["add_new_lang_button"]	= "Nieuwe taal toevoegen";
$pgv_lang["hide_translated"]		= "Verberg vertalingen";
$pgv_lang["lang_file_write_error"]	= "F O U T !!!<br /><br />De wijzigingen kunnen niet in het geselecteerde taalbestand worden weggeschreven!<br />Controleer de schrijfrechten op (#lang_filename#)|";
$pgv_lang["no_open"]				= "F O U T !!!<br /><br />Kan bestand niet openen: #lang_filename#";
$pgv_lang["never"]					= "Nooit";
$pgv_lang["users_total"]			= "Totaal aantal gebruikers";
$pgv_lang["users_admin"]			= "Website beheerders";
$pgv_lang["users_unver"]			= "Niet geverifieerd door gebruiker";
$pgv_lang["users_unver_admin"]		= "Niet geverifieerd door beheerder";
$pgv_lang["users_langs"]			= "Gebruikers per taal";
$pgv_lang["warn_users"]				= "Gebruikers met waarschuwing";
$pgv_lang["users_gedadmin"]			= "GEDCOM-beheerders";
$pgv_lang["cleanup_users"]			= "Opschonen gebruikers";
$pgv_lang["um_header"]				= "Migreren gebruikersinformatie";
$pgv_lang["um_proceed"]				= "Doorgaan met importeren/exporteren van gebruikersinformatie?<br /><br />";
$pgv_lang["um_creating"]			= "Aanmaken";
$pgv_lang["um_sql_index"]			= "Dit programma maakt het bestand \"authenticate.php\" en diverse <b>.dat</b> bestanden aan in uw indexmap.<br />Nadat de bestanden succesvol zijn aangemaakt, kunt u overschakelen naar index-modus met beoud van alle gebruikersinstellingen, berichten, favorieten, nieuwsberichten en opmaak van de genealogie-startpagina en MGedView-pagina's.<br /><br />Let op: Na het overschakelen naar index-modus moet u uw GEDCOM-bestand(en) opnieuw importeren.<br /><br />";
$pgv_lang["um_file_create_fail1"]	= "Aanmaken van nieuw bestand is mislukt, een bestand met deze naam bestaat al:";
$pgv_lang["um_file_create_fail2"]	= "Aanmaken niet mogelijk van";
$pgv_lang["um_file_create_fail3"]	= "Controleer uw toegangsrechten tot deze map.";
$pgv_lang["um_file_create_succ1"]	= "Bestand succesvol aangemaakt:";
$pgv_lang["um_file_not_created"]	= "Bestand is niet aangemaakt.";
$pgv_lang["um_nomsg"]				= "Er zijn geen berichten aanwezig in het systeem.";
$pgv_lang["um_nofav"]				= "Er zijn geen favorieten aanwezig in het systeem.";
$pgv_lang["um_nonews"]				= "Er zijn geen nieuwsberichten aanwezig in het systeem.";
$pgv_lang["um_noblocks"]			= "Er zijn geen indelingsdefinities aanwezig in het systeem.";
$pgv_lang["um_index_sql"]			= "Dit programma importeert de gegevens uit het \"authenticate.php\" bestand en uit de .dat bestanden in uw indexmap, in uw database.<br />";
$pgv_lang["um_mixedmode"]			= "U gebruikt PhpGedView in SQL-modus, maar u gebruikt de autenticatiemodule van de index-modus.<br /><br />Alle gebruikersgegevens, favorieten, vakdefinities voor de Welkomst- en MyGedView-pagina's, berichten en nieuwsberichten worden al opgeslagen in een formaat dat in de index-modus kan worden gebruikt.<br />U kunt nu naar index-modus overschakelen, het migreren van gebruikersinformatie is niet noodzakelijk.<br />";
$pgv_lang["um_noaction"]			= "Er zijn nu geen handelingen nodig om de gebruikersinformatie naar SQL-modus over te zetten.<br />Zodra u bent overgeschakeld naar SQL-modus, kunt u dit programma opnieuw starten om alle gebruikersgegevens in uw SQL-database te importeren.<br />U dient het bestand \"authenticate.php\" en de .dat bestanden <b>niet</b> uit uw indexmap te verwijderen bij het overschakelen.<br />";
$pgv_lang["um_import"]				= "Import";
$pgv_lang["um_export"]				= "Export";
$pgv_lang["um_explain"]				= "Dit programma heeft twee functies: het exporteert gebruikersgegevens van SQL- naar index-modus, of het importeert gebruikersgegevens van index- naar sql-modus.<br /><br />Gebruikersgegevens, favorieten, vakdefinities op de Welkomst- en MyGedView-pagina's, berichten en nieuwsberichten zijn na migratie weer beschikbaar.<br /><br /><b>LET OP!</b><br />U kunt dit programma niet gebruiken om gegevens te migreren tussen verschillende versies van PhpGedView. Overtuig u ervan, dat de gegevens afkomstig zijn en geïmporteerd worden in dezelfde versie van PhpGedView.<br /><br /><b>IMPORT</b><br />Als u ervoor kiest om gegevens vanuit index-modus te importeren, dan worden de bestaande gebruikersgegevens in de SQL-database <b>overschreven</b>. Dit programma voegt de gegevens <b>niet</b> samen. Zodra u de import heeft uitgevoerd, kunt op op geen enkele wijze via PhpGedView de oude gegevens terugkrijgen.<br /><br /><b>EXPORT</b><br />Als u voor exporteren kiest, zal dit programma de gebruikersinformatie uit de SQL-database opslaan in een formaat dat voor de index-modus bruikbaar is. Het bestand <i>authenticate.php</i> en een aantal <i>.dat</i> bestanden worden in uw index-map aangemaakt. Indien al bestanden met dezelfde naam bestaan, wordt u gevraagd of deze moeten worden overschreven. Na het overschakelen naar index-modus zijn alle gegevens direct beschikbaar.<br /><br /><b>LET OP:</b><br />Na het overschakelen naar index-modus dient u uw GEDCOM-bestand(en) opnieuw te importeren.<br /><br />";
$pgv_lang["um_sql_index_help"] = "~Migreren gebruikers van SQL- naar Index modus~<br /><br />#pgv_lang[um_sql_index]#|";
$pgv_lang["um_index_sql_help"] = "~Migreren gebruikersgegevens van Index naar SQL-modus~<br /><br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"]			= "Importeren gebruikers";
$pgv_lang["um_imp_blocks"]			= "Importeren vakindelingen";
$pgv_lang["um_imp_favorites"]		= "Importeren favorieten";
$pgv_lang["um_imp_messages"]		= "Importeren berichten";
$pgv_lang["um_imp_news"]			= "Importeren nieuwsberichten";
$pgv_lang["um_results"]		= "Resultaten";
$pgv_lang["type_audio"] = "Geluidsfragment";
$pgv_lang["type_book"] = "Boek";
$pgv_lang["type_card"] = "Kaart";
$pgv_lang["type_electronic"] = "Elektronische afbeelding";
$pgv_lang["type_fiche"] = "Microfiche";
$pgv_lang["type_film"] = "Film";
$pgv_lang["type_magazine"] = "Tijdschrift";
$pgv_lang["type_map"] = "Landkaart";
$pgv_lang["type_manuscript"] = "Manuscript";
$pgv_lang["type_newspaper"] = "Krant";
$pgv_lang["type_photo"] = "Foto";
$pgv_lang["type_tombstone"] = "Grafsteen";
$pgv_lang["type_video"] = "Video";
$pgv_lang["um_nousers"]				= "Bestand \"authenticate.php\" niet gevonden in uw indexmap. Migratie is afgebroken.";
$pgv_lang["um_imp_succ"]			= "Import gereed";
$pgv_lang["um_imp_fail"]			= "Importfout";
$pgv_lang["um_files_exist"]			= "Een of meer bestanden bestaat al. Wilt u deze overschrijven?";
$pgv_lang["um_backup"]				= "Backup";
$pgv_lang["um_zip_succ"]			= "ZIP-bestand succesvol aangemaakt.";
$pgv_lang["um_zip_dl"]				= "Download ZIP-bestand met backup";
$pgv_lang["um_bu_explain"]			= "Dit programma maakt een backup van verschillende soorten gegevens in PhpGedView.<br /><br />De gegevens die u hieronder voor de backup selecteert worden verzameld en in een ZIP-bestand opgeslagen.<br />Dit kunt u downloaden met de koppeling die dan onderaan de pagina verschijnt.<br />Het ZIP-bestand blijft aanwezig in uw index-map totdat u dit handmatig verwijdert.";
$pgv_lang["um_bu_help"] = "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"]			= "PhpGedView instellingenbestand";
$pgv_lang["um_bu_gedcoms"]			= "GEDCOM bestanden";
$pgv_lang["um_bu_gedsets"]			= "GEDCOM bestands- en privacy-instellingen";
$pgv_lang["um_bu_logs"]				= "GEDCOM tellers, zoek-logbestanden en PhpGedView-logbestanden";
$pgv_lang["um_bu_usinfo"]			= "Gebruikersinstellingen, vakinstellingen. favorieten, berichten en nieuwsberichten.";
$pgv_lang["um_mk_bu"]				= "Maak backup";
$pgv_lang["um_nofiles"]				= "Geen bestanden gevonden voor de backup.";
$pgv_lang["system_time"]			= "Huidige systeemdatum/tijd: ";
$pgv_lang["gedcom_not_imported"]	= "Dit GEDCOM-bestand is nog niet geïmporteerd.";
$pgv_lang["translation_forum"]		= "Koppeling naar het vertalerforum op de PhpGedView site van SourceForge";
$pgv_lang["lang_save_success"]		= "Wijzigingen in #PGV_LANG# succesvol weggeschreven";
$pgv_lang["SHOW_LDS_AT_GLANCE"]		= "Toon codes LDS-gebeurtenissen in overzichtsvakken";
$pgv_lang["SHOW_LDS_AT_GLANCE_help"]	= "~TOON CODES LDS-GEBEURTENISSEN IN OVERZICHTSVAKKEN~<br /><br />Als deze optie is ingeschakeld, worden de codes voor LDS-gebeurtenissen getoond in de overzichtsvakken van personen.<ul><li><b>B</b> - LDS Doop</li><li><b>E</b> - LDS Gave</li><li><b>S</b> - LDS ega verzegeling</li><li><b>P</b> - LDS kind verzegeling</li></ul>Een persoon waarbij al deze gebeurtenissen hebben plaatsgevonden, heeft \"<b>BESP</b>\" afgedrukt achter de naam. Als een van de gebeurtenissen ontbreekt, wordt de code getoond als bijvoorbeeld \"<b>BE__</b>\" met _ voor de ontbrekende gebeurtenis.";
$pgv_lang["GEDCOM_DEFAULT_TAB"]			= "Standaard tabblad op persoonspagina";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"]	= "~STANDAARD TABBLAD OP PERSOONSPAGINA~<br /><br />Met deze optie kunt u instellen welk tabblad standaard wordt getoond op de persoonspagina.";
$pgv_lang["SHOW_MARRIED_NAMES"]			= "Toon huwelijkse namen in personenlijst";
$pgv_lang["SHOW_MARRIED_NAMES_help"]	= "~TOON HUWELIJKSE NAMEN IN PERSONENLIJST~<br /><br />Met deze optie worden de huwelijkse namen van vrouwen getoond in de personenlijst. Uiteraard moeten deze bij het importeren van het GEDCOM-bestand wel zijn vervaardigd.";
$pgv_lang["META_SURNAME_KEYWORDS"]		= "Voeg veel voorkomende achternamen toe aan META-tag sleutelwoorden";
$pgv_lang["META_SURNAME_KEYWORDS_help"]	= "~VOEG VEEL VOORKOMENDE ACHTERNAMEN TOE AAN META-TAG SLEUTELWOORDEN~<br /><br />Als u deze optie aanzet, wordt de lijst met veel voorkomende achternamen toegevoegd aan de META-tag sleutelwoorden. Dit helpt zoekmachines om uw site te vinden aan de hand van deze namen.";
$pgv_lang["SHOW_QUICK_RESN"]		= "Toon vak Beperking in Snel toevoegen/wijzigen";
$pgv_lang["SHOW_QUICK_RESN_help"]	= "~TOON VAK BEPERKINGEN IN SNEL TOEVOEGEN/WIJZIGEN~<br /><br />Hiermee kunt u aangeven, of in het formulier \"Snel toevoegen/wijzigen\" voor feiten een instelling voor beperking van toegang wordt getoond. De gebruiker kan hierdoor de toegang tot de door hem ingebrachte gegevens zelf instellen als extra bovenop bestaande algemene privacy instellingen.";
$pgv_lang["USE_QUICK_UPDATE"]		= "Gebruik \"Snel toevoegen/wijzigen\"";
$pgv_lang["USE_QUICK_UPDATE_help"]	= "~GEBRUIK \"SNEL TOEVOEGEN/WIJZIGEN\"~<br /><br />Deze optie stelt aangemelde gebruikers in staat om wijzigingen aan te brengen middels het formulier \"Snel toevoegen/wijzigen\".";
$pgv_lang["SEARCHLOG_CREATE"]		= "Archiveer logbestand zoekopdrachten";
$pgv_lang["SEARCHLOG_CREATE_help"]	= "~ARCHIVEER LOGBESTAND ZOEKEN~<br /><br />Hiermee stelt u in, hoe vaak het logbestand voor zoekacties wordt gearchiveerd.";
$pgv_lang["CHANGELOG_CREATE"]		= "Archiveer logbestand wijzigingen";
$pgv_lang["CHART_BOX_TAGS"]			= "Andere feiten in overzichten";
$pgv_lang["CHART_BOX_TAGS_help"]	= "~ANDERE FEITEN IN OVERZICHTEN~<br /><br />Voer hier de GEDCOM-tags in van feiten die u in overzichten (zoals de kwartierstaat) extra in de vakken wilt laten zien. Als u bijvoorbeeld het beroep wilt toevoegen, kunt u hier \"OCCU\" invullen.";
$pgv_lang["PRIVACY_BY_RESN"]		= "Gebruik GEDCOM (RESN) toegangsbeperking";
$pgv_lang["PRIVACY_BY_RESN_help"]	= "~GEBRUIK GEDCOM (RESN) TOEGANGSBEPERKING~<br /><br />In de GEDCOM 5.5 standaard is opgenomen, dat de toegang tot informatie kan worden beperkt door RESN (restriction) tags. Als deze optie wordt aangezet, kijkt PhpGedView naar 1 RESN tags. Als deze aanwezig is, betekent het dat de toegang tot een niveau 0 object (persoon, gezin) is beperkt.<br /><br />RESN tags op niveau 2 en hoger (feiten, gebeurtenissen) worden automatisch verwerkt door PhpGedView en worden dus niet benvloed door deze optie.<br /><br />Let op: aanzetten van deze optie kan tot vertraging leiden van sommige functies van PhpGedView, zoals de personenlijst.";
$pgv_lang["ALLOW_REMEMBER_ME"]		= "Toon \"Onthoudt mij\" op inlogpagina";
$pgv_lang["ALLOW_REMEMBER_ME_help"]	= "~TOON \"ONTHOUDT MIJ\"  OP INLOGPAGINA~<br /><br />Op veel websites hebben gebruikers de mogelijkheid om herkend te worden als ze vanaf dezelfde computer nogmaals de website bezoeken. Ze hoeven zich dan niet nogmaals aan te melden. Door inschakelen van deze optie verschijnt een \"Onthoudt mij\"-vinkvakje op de aanmeldpagina. Het aanvinken zorgt ervoor dat een cookie wordt opgeslagen in de windows verkenner waardoor de gebruiker bij een volgend bezoek wordt herkend.";
$pgv_lang["UNDERLINE_NAME_QUOTES"]		= "Namen tussen aanhalingstekens onderstrepen";
$pgv_lang["UNDERLINE_NAME_QUOTES_help"]	= "~NAMEN TUSSEN AANHALINGSTEKENS ONDERSTREPEN~<br /><br />Veel genealogieprogramma's geven de voorkeurs-voornaam in het bestand aan door deze tussen dubbele aanhalingstekens te plaatsen. Hierdoor wordt deze onderstreept weergegeven. Het inschakelen van deze optie zorgt ervoor, dat alle namen waar omheen dubbele aanhalingstekens staan worden omgezet naar \"span\" met een CSS class \"starredname\".<br /><br />Als bijvoorbeeld in het bestand een regel voorkomt als 1 NAME Jan \"Nicolaas\" Pieter/de Groot/, dan wordt dit omgezet naar Jan <span class=\"starredname\">Nicolaas</span> Pieter de Groot.";
$pgv_lang["SPLIT_PLACES"]		= "Locaties splitsen bij wijzigen";
$pgv_lang["SPLIT_PLACES_help"]	= "~LOCATIES SPLITSEN BIJ WIJZIGEN~<br /><br />Deze optie zorgt ervoor dat locaties worden opgesplitst in delen (plaats, gemeente, provincie/staat, land), om het wijzigen ervan makkelijker te maken.<br />Voorbeeld<br /><ol><li>Standaard:<br /><u>Locatie</u>: Sloten, Amsterdam, Noord Holland, Nederland<br /></li><li>Gesplitst:<br /><u>Land</u>: Nederland<br /><u>Provincie</u>: Noord Holland<br /><u>Gemeente</u>: Amsterdam<br /><u>Plaats</u>: Sloten</li></ol><br /><br />";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION"]		= "Beheerder moet nieuwe aanmeldingen goedkeuren";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION_help"]	= "~BEHEERDER MOET NIEUWE AANMELDINGEN GOEDKEUREN~<br /><br />Als de optie \"#pgv_lang[USE_REGISTRATION_MODULE]#\" is aangezet, moeten nieuwe aanmeldingen voor een gebruikersnaam door een beheerder worden goedgekeurd. De gebruiker moet hier, na de eigen verificatie van de gegevens, op wachten.<br />Als deze optie wordt uitgezet, wordt de aanmelding na verificatie door de gebruiker automatisch goedgekeurd, en kunnen de gebruikers direct toegang krijgen met hun gebruikersnaam en wachtwoord.";
$pgv_lang["SHOW_SOURCES"]			= "Toon bronnen";
$pgv_lang["SHOW_SOURCES_help"]		= "~TOON BRONNEN~<br /><br />Dit stelt privacybeperking in op alle bronnen. Als de gebruiker geen toegang heeft tot bronnen, wordt de bronnen-tab op de personen-pagina verwijderd en wordt de optie \"Bronnen\" in het menu \"Detailgegevens\" verborgen.<br /><br />";
$pgv_lang["THUMBNAIL_WIDTH"]			= "Breedte van gegenereerde miniweergaves";
$pgv_lang["THUMBNAIL_WIDTH_help"]		= "~BREEDTE VAN GEGENEREERDE MINIWEERGAVES~<br /><br />Dit is de breedte (in pixels) die PhpGedView gebruikt voor automatisch gegenereerde miniweergaves. De standaard waarde is 100 pixels.<br /><br />";
$pgv_lang["LANG_SELECTION"] 			= "Ondersteunde talen";
$pgv_lang["MEDIA_ID_PREFIX"]		= "Voorvoegsel media-ID";
$pgv_lang["FAM_ID_PREFIX"]		= "Voorvoegsel gezins-ID";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"]			= "Altijd deze feiten voor gezinnen tonen in \"Snel wijzigen\"";
$pgv_lang["QUICK_ADD_FAMFACTS"]			= "Deze feiten voor gezinnen tonen in \"Snel wijzigen\"";
$pgv_lang["AUTO_GENERATE_THUMBS"]			= "Miniweergaves automatisch maken";
$pgv_lang["QUICK_ADD_FACTS"]			= "Deze feiten tonen in \"Snel wijzigen\"";
$pgv_lang["QUICK_REQUIRED_FACTS"]			= "Deze feiten altijd tonen in \"Snel Wijzigen\"";
$pgv_lang["INDI_FACTS_ADD"] 			= "Feiten voor personen";
$pgv_lang["INDI_FACTS_UNIQUE"] 			= "Unieke feiten voor personen";
$pgv_lang["FAM_FACTS_ADD"] 			= "Feiten voor gezinnen";
$pgv_lang["FAM_FACTS_UNIQUE"] 			= "Unieke feiten voor gezinnen";
$pgv_lang["SOUR_FACTS_ADD"] 			= "Feiten voor bronnen";
$pgv_lang["SOUR_FACTS_UNIQUE"] 			= "Unieke feiten voor bronnen";
$pgv_lang["REPO_FACTS_ADD"] 			= "Feiten voor bewaarplaatsen";
$pgv_lang["REPO_FACTS_UNIQUE"] 			= "Unieke feiten voor bewaarplaatsen";
?>
