<?php
/**
 * French Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2009  PGV Development Team.  All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @subpackage Languages
 * @version $Id: configure_help.fr.php 4863 2009-01-21 22:03:52Z canajun2eh $
 */
if (!defined('PGV_PHPGEDVIEW')) {
	header('HTTP/1.0 403 Forbidden');
	exit;
}
$pgv_lang["SHOW_LIST_PLACES"]           = "Afficher les niveaux de lieux sur des listes";
$pgv_lang["SHOW_LIST_PLACES_help"]      = "~#pgv_lang[SHOW_LIST_PLACES]#~<br /><br />Cette option détermine la granularité de l'information qui est affichée dans les listes des champs de lieux .<br /><br />Si vous paramétrez la valeur à <b>9</b> tous les détails de l'information du lieu seront affichés. Si vous paramétrez la valeur à <b>0</b> (zéro) cela masquera complètement les lieux. Si vous paramétrez la valeur à <b>1</b> cela n'affichera que le niveau supérieur de l'information de lieu, qui est en règle générale le pays. Si vous paramétrez la valeur à <b>2</b> cela affichera les deux niveaux supérieurs d'information de lieu. Le deuxième niveau supérieur, en dessous du pays, est en règle générale, la région ou l'Etat (pour les USA par exemple). Etc.<br />";
$pgv_lang["new_gedcom_title"]           = "Généalogie de [#GEDCOMFILE#]";
$pgv_lang["USE_MEDIA_VIEWER"]           = "Utiliser le diaporama";
$pgv_lang["USE_MEDIA_FIREWALL"]         = "Utiliser le pare-feu MultiMedia";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR"]     = "Répertoire racine du pare-feu MultiMedia";
$pgv_lang["MEDIA_FIREWALL_ROOTDIR_note"]= "Lorsque ce champ est vide, le répertoire <b> # GLOBALS [INDEX_DIRECTORY] # </ b> sera utilisé.";
$pgv_lang["MEDIA_FIREWALL_THUMBS"]      = "Protéger les vignettes des images protégées";
$pgv_lang["SHOW_SPIDER_TAGLINE"]        = "Montrer un indicateur du moteur de recherche";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS"] = "Afficher les relations privées";
$pgv_lang["SYNC_GEDCOM_FILE"]           = "Synchroniser le fichier GEDCOM avec les modifications dans la base de données";
$pgv_lang["SHOW_MULTISITE_SEARCH"]      = "Montrer la recherche dans des sites multiples";
$pgv_lang["SHOW_NO_WATERMARK"]          = "Qui peut voir les images sans filigrane ?";
$pgv_lang["WATERMARK_THUMB"]            = "Ajouter des filigranes aux vignettes ?";
$pgv_lang["SAVE_WATERMARK_THUMB"]       = "Stocker les vignettes filigranées sur le serveur ?";
$pgv_lang["SAVE_WATERMARK_IMAGE"]       = "Stocker les images filigranées sur le serveur ?";
$pgv_lang["DBPERSIST"]                  = "Utiliser des connexions à la base de données permanentes";
$pgv_lang["INDI_FACTS_ADD"]             = "Événements ajoutables pour un individu";
$pgv_lang["INDI_FACTS_ADD_help"]        = "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />Liste des codes GEDCOM pour les événements qu'il sera possible d'ajouter à une fiche individu.  Vous pouvez librement ajouter ou supprimer des codes à cette liste, à l'exception de ceux figurant dans la liste <i>#pgv_lang[INDI_FACTS_UNIQUE]#</i>.<br />";
$pgv_lang["INDI_FACTS_UNIQUE"]          = "Événements uniques pour un individu";
$pgv_lang["INDI_FACTS_QUICK"]           = "Événements «1-clic» pour un individu";
$pgv_lang["FAM_FACTS_ADD"]              = "Événements ajoutables pour une famille";
$pgv_lang["FAM_FACTS_UNIQUE"]           = "Événements uniques pour une famille";
$pgv_lang["FAM_FACTS_QUICK"]            = "Événements «1-clic» pour une famille";
$pgv_lang["SOUR_FACTS_ADD"]             = "Événements ajoutables pour une source";
$pgv_lang["SOUR_FACTS_UNIQUE"]          = "Événements uniques pour une source";
$pgv_lang["SOUR_FACTS_QUICK"]           = "Événements «1-clic» pour une source";
$pgv_lang["REPO_FACTS_ADD"]             = "Événements ajoutables pour un dépôt d'archives";
$pgv_lang["REPO_FACTS_UNIQUE"]          = "Événements uniques pour un dépôt d'archives";
$pgv_lang["REPO_FACTS_QUICK"]           = "Événements «1-clic» pour un dépôt d'archives";
$pgv_lang["MEDIA_ID_PREFIX"]            = "Préfixe MultiMédia";
$pgv_lang["FAM_ID_PREFIX"]              = "Préfixe Famille";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"]    = "Événements Famille à toujours afficher en mode <i>Mise à jour rapide</i>";
$pgv_lang["QUICK_ADD_FAMFACTS"]         = "Événements Famille à ajouter en mode <i>Mise à jour rapide</i>";
$pgv_lang["QUICK_REQUIRED_FACTS"]       = "Événements à toujours afficher en mode <i>Mise à jour rapide</i>";
$pgv_lang["QUICK_ADD_FACTS"]            = "Événements à ajouter en mode <i>Mise à jour rapide</i>";
$pgv_lang["AUTO_GENERATE_THUMBS"]       = "Créer automatiquement les vignettes";
$pgv_lang["more_help_advice"]         = "<br /> <b> Plus d'aide </ b> <br /> Plus d'aide est disponible en cliquant sur le <b>? </ b> qui se trouve à côté des éléments de la page. <br />";
$pgv_lang["THUMBNAIL_WIDTH"]            = "Largeur des vignettes";
$pgv_lang["THUMBNAIL_WIDTH_help"]       = "~ # pgv_lang [THUMBNAIL_WIDTH] # ~ <br /> <br /> C'est la largeur (en pixels) que le programme utilisera lors de la génération automatique de vignettes. Le réglage par défaut est 100. <br />";
$pgv_lang["SHOW_SOURCES"]               = "Montrer les sources ?";
$pgv_lang["SHOW_SOURCES_help"]          = "Option pour masquer les liens vers les sources sur toutes les pages si l'utilisateur n'a pas les droits suffisants.";
$pgv_lang["SPLIT_PLACES"]               = "Découper les lieux";
$pgv_lang["SPLIT_PLACES_help"]          = "Option pour découper chaque lieu en mode saisie/modification, offrant ainsi une meilleure lisibilité. Exemple :<br /><ol><li>Mode par défaut<br /><u>Lieu</u> : Caen, Calvados (14), Basse-Normandie, FRA<br /><li>Mode découpe<br /><u>Pays</u> : FRA<br /><u>Région</u> : Basse-Normandie<br/><u>Département</u> : Calvados (14)<br/><u>Ville</u> : Caen</ol>";
$pgv_lang["UNDERLINE_NAME_QUOTES"]      = "Souligner les noms entre guillemets (\")";
$pgv_lang["UNDERLINE_NAME_QUOTES_help"] = "~#pgv_lang[UNDERLINE_NAME_QUOTES]#~<br /><br />Beaucoup de logiciels généalogiques mettent le prénom préféré entre guillemets (\") dans le GEDCOM.  Un façon d'indiquer ces prénoms préférés est de les souligner.  Cette option sélectionnée à Oui convertit tous les noms entre guillements à &lt;span class=\"starredname\"&gt;.<br /><br />Par exemple, supposons que le nom dans la base de données soit 1&nbsp;NAME&nbsp;Gustave&nbsp;\"Jean&nbsp;Paul\"&nbsp;Charles&nbsp;/Wilson/ : cette option transforme les noms entre guillemets en &lt;span&nbsp;class=\"starredname\"&gt;Jean&nbsp;Paul&lt;/span&gt; .  Ensuite le navigateur peut afficher le nom comme <b>Gustave&nbsp;<span class=\"starredname\">Jean&nbsp;Paul</span>&nbsp;Charles&nbsp;Wilson</b> ou <b>Wilson,&nbsp;Gustave&nbsp;<span class=\"starredname\">Jean&nbsp;Paul</span> Charles</b> selon des autres options.<br />";
$pgv_lang["PRIVACY_BY_RESN"]            = "Utiliser le mode Restriction d'accès (RESN) de GEDCOM";
$pgv_lang["PRIVACY_BY_RESN_help"]       = "GEDCOM 5.5 permet de gérer les restrictions d'accès au moyen du marqueur RESN. En activant cette fonction, un contrôle sera effectué au niveau 1 pour chaque enregistrement de votre fichier GEDCOM. Le contrôle aux niveaux 2 et + est systématiquement réalisé et n'est pas affecté par cette valeur. Ce choix risque de ralentir certaines fonctions de PhpGedView comme la liste des individus.<br />";
$pgv_lang["SHOW_LDS_AT_GLANCE"]         = "Montrer les codes SDJ sur les diagrammes";
$pgv_lang["GEDCOM_DEFAULT_TAB"]         = "Onglet par défaut sur la fiche individuelle";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"]    = "Option permettant de pré-sélectionner un onglet à l'affichage de la page Individu.<br />";
$pgv_lang["SHOW_MARRIED_NAMES"]         = "Montrer le nom des femmes mariées dans les listes";
$pgv_lang["SHOW_QUICK_RESN"]            = "Restrictions d'accès en mode <i>Mise à jour rapide</i>";
$pgv_lang["SHOW_QUICK_RESN_help"]       = "Option pour ajouter les champs de restrictions d'accès dans le formulaire <i>Mise à jour rapide</i>.<br />";
$pgv_lang["USE_QUICK_UPDATE"]           = "Autoriser le mode <i>Mise à jour rapide</i>";
$pgv_lang["USE_QUICK_UPDATE_help"]      = "Option pour autoriser les utilisateurs connectés à soumettre des modifications à l'aide du formulaire de <i>Mise à jour rapide</i>.<br />";
$pgv_lang["SEARCHLOG_CREATE"]           = "Archivage journal des recherches";
$pgv_lang["SEARCHLOG_CREATE_help"]      = "Fréquence d'archivage des journaux.<br />p";
$pgv_lang["CHANGELOG_CREATE"]           = "Archivage journal des modifications";
$pgv_lang["CHANGELOG_CREATE_help"]      = "~ # pgv_lang [CHANGELOG_CREATE] # ~ <br /> <br /> À quelle fréquence le programme doit archiver les fichiers de modifications des logs (Changelog). <br />";
$pgv_lang["CHART_BOX_TAGS"]             = "Autres événements à afficher dans les tableaux";
$pgv_lang["CHART_BOX_TAGS_help"]        = "Liste de codes GEDCOM, séparés par une virgule ou un espace, pour forcer l'affichage de certains événements dans les tableaux (ascendance, descendance...).<br />Exemple : pour afficher systématiquement la profession, ajouter le code «OCCU» dans cette zone.<br />";
$pgv_lang["FULL_SOURCES"]               = "Enregistrer tous les détails des sources";
$pgv_lang["PREFER_LEVEL2_SOURCES"]      = "Enregistrer les sources au niveau des évènements";
$pgv_lang["PREFER_LEVEL2_SOURCES_help"] = "~#pgv_lang[PREFER_LEVEL2_SOURCES]#~<br /><br />Lors de la saisie, les sources peuvent être enregistrées au niveau de l'enregistrement complet (INDI, FAM) ou au niveau de l'évènement (BIRT, MARR, DEAT). Cette option permet de choisir le mode par défaut.<br />";
//-- CONFIGURE FILE MESSAGES
$pgv_lang["gedcom_conf"]                = "GEDCOM";
$pgv_lang["media_conf"]                 = "Objets MultiMédia";
$pgv_lang["media_general_conf"]         = "Général";
$pgv_lang["media_firewall_conf"]        = "Pare-feu MultiMédia";
$pgv_lang["accpriv_conf"]               = "Restrictions d'accès";
$pgv_lang["displ_conf"]                 = "Affichage";
$pgv_lang["displ_names_conf"]           = "Noms";
$pgv_lang["displ_comsurn_conf"]         = "Noms fréquents";
$pgv_lang["displ_layout_conf"]          = "Affichage";
$pgv_lang["displ_hide_conf"]            = "Cacher/Montrer";
$pgv_lang["editopt_conf"]               = "Édition";
$pgv_lang["useropt_conf"]               = "Utilisateurs";
$pgv_lang["contact_conf"]               = "Contact";
$pgv_lang["meta_conf"]                  = "Balises META";
$pgv_lang["gedconf_head"]               = "GEDCOM";
$pgv_lang["other_theme"]                = "ou entrer une autre valeur";
$pgv_lang["performing_update"]          = "Mise à jour en cours.";
$pgv_lang["config_file_read"]           = "Fichier de configuration lu.";
$pgv_lang["does_not_exist"]             = "n'existe pas";
$pgv_lang["media_drive_letter"]         = "NE PAS indiquer de lettre de lecteur (C:) dans le chemin Média. Les objets ne pourront pas être affichés.";
$pgv_lang["db_setup_bad"]               = "Mauvais fichier de configuration.  Veuillez vérifier vos paramètres de connexion à la base de données et recommencer la configuration.";
$pgv_lang["bad_host_user_pass"]         = "Echec de connexion à la base de données. Vérifier le nom du serveur, du compte utilisateur et le mot de passe.";
$pgv_lang["bad_database_name"]          = "La base de données a été trouvée, mais impossible d'y accéder. Vérifier les droits de l'utilisateur.";
$pgv_lang["db"]                         = "Database";
$pgv_lang["dbase"]                      = "dBase";
$pgv_lang["current_gedcoms"]            = "Liste des fichiers GEDCOM chargés";
$pgv_lang["ged_gedcom"]                 = "Fichier GEDCOM";
$pgv_lang["ged_title"]                  = "Titre du fichier GEDCOM";
$pgv_lang["ged_config"]                 = "Fichier de configuration";
$pgv_lang["ged_search"]                 = "Journal des recherches";
$pgv_lang["ged_change"]                 = "Journal des modifications";
$pgv_lang["ged_privacy"]                = "Fichier des restrictions d'accès";
$pgv_lang["disabled"]                   = "Désactivé";
$pgv_lang["mouseover"]                  = "Passage de souris";
$pgv_lang["mousedown"]                  = "Souris maintenue appuyée";
$pgv_lang["click"]                      = "Clic de souris";
$pgv_lang["enter_db_pass"]              = "Par sécurité, vous devez saisir votre <b>identificateur</b> et votre <b>mot de passe</b> avant toute modification.";
$pgv_lang["server_url_note"]            = "Chemin du répertoire PhpGedView. Ne modifier qu'avec précaution. Valeur par défaut pour votre installation : <tt>#GUESS_URL#</tt>";
$pgv_lang["DBTYPE"]                     = "Type de la base de données";
$pgv_lang["DBTYPE_help"]                = "Type PEAR (PHP Extension and Application Repository) pour connexion à la base de données. À choisir parmi : MySQL, PostgreSQL, Oracle, SQLite... <br />";
$pgv_lang["DBHOST"]                     = "Serveur de la base de données";
$pgv_lang["DBHOST_help"]                = "Adresse DNS ou IP du système qui héberge le serveur de votre base de données.<br />";
$pgv_lang["DBPORT"]                     = "Port de la base de données";
$pgv_lang["DBUSER"]                     = "Identificateur de connexion à la base de données";
$pgv_lang["DBUSER_help"]                = "Identificateur défini pour la connexion à la base de données.<br />";
$pgv_lang["DBPASS"]                     = "Mot de passe de la base de données";
$pgv_lang["DBPASS_help"]                = "Mot de passe d'accès à la base de données pour l'identificateur défini.<br />";
$pgv_lang["DBNAME"]                     = "Nom de la base de données";
$pgv_lang["DBNAME_help"]                = "Base de données du serveur qui sera utilisée par PhpGedView.  L'identificateur de connexion utilisé doit avoir les droits de création, d'insertion, de mise à jour, de suppression et de sélection sur cette base de données.<br />";
$pgv_lang["TBLPREFIX_help"]             = "Préfixe ajouté au nom des tables créées par PhpGedView.  En changeant cette valeur vous pouvez gérer plusieurs sites PhpGedView qui utilisent la même base de données mais avec des tables différentes.<br />";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]   = "Permet aux visiteurs et aux utilisateurs de changer de fichier GEDCOM quand il en existent plusieurs sur le serveur.<br />";
$pgv_lang["upload_path"]                = "Chemin du fichier";
$pgv_lang["gedcom_path"]                = "Chemin et nom du fichier GEDCOM";
$pgv_lang["gedcom_path_help"]           = "Téléchargez d'abord votre fichier GEDCOM dans un répertoire accessible par PHP sur le serveur. Entrez ensuite ici le chemin d'accès et le nom complet du fichier.<br />Exemple : ./index/name.ged.<br /><br />Voir le fichier <a href=readme.txt>Readme.txt</a> pour d'autres détails.";
$pgv_lang["CHARACTER_SET"]              = "Code du jeu de caractères";
$pgv_lang["CHARACTER_SET_help"]         = "Jeu de caractères utilisé dans votre fichier GEDCOM.  Le jeu de caractères UTF-8 est le jeu par défaut qui devrait fonctionner pratiquement pour tous les sites.  Si vous exportez vos données GEDCOM en utilisant le code IBM de Windows, codez ici la valeur WINDOWS.<br /><br />NOTE : PHP n'accepte pas le code UNICODE (UTF-16).";
$pgv_lang["LANGUAGE"]                   = "Langue";
$pgv_lang["LANGUAGE_help"]              = "Langue par défaut pour le site. Les utilisateurs peuvent modifier cette valeur en changeant les préférences de leur navigateur ou en utilisant le formulaire proposé sur la page si vous avez autorisé le changement de langue.";
$pgv_lang["ENABLE_MULTI_LANGUAGE"]      = "Autoriser le changement de langue";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"] = "Permet aux utilisateurs de sélectionner une autre langue et de choisir par défaut la langue qu'ils ont définie dans les options de leur navigateur.";
$pgv_lang["CALENDAR_FORMAT"]            = "Format du calendrier";
$pgv_lang["CALENDAR_FORMAT_help"]       = "Permet d'indiquer le <b>type de calendrier</b> que vous souhaitez utiliser avec ce fichier GEDCOM.  Le calendrier hébreu est le même que le calendrier israélite mais avec des caractères hébraïques.  Note : les dates du calendrier israélite/hébreu sont calculées à partir des dates du calendrier grégorien ou julien. Comme le jour israélite commence le soir, chaque événement qui a eu lieu entre le crépuscule et minuit sera noté avec un jour d'avance sur la date correcte. L'affichage des caractères hébraïques peut poser problème avec les anciens navigateurs. Certains navigateurs afficheront les caractères dans le mauvais sens ou ne les afficheront pas du tout.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]   = "Affichage des milliers des années hébraïques";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"]= "Affichage Alafim dans le calendrier hébreu. En codant «oui» l'année 1969 sera affichée : <span lang='he-IL' dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;\"&#1496;</span>&lrm; alors qu'en codant «non» elle sera affichée : <span lang='he-IL' dir='rtl'>&#1514;&#1513;&#1499;\"&#1496;</span>&lrm;. Cette valeur n'a pas d'impact sur le calcul de l'année. L'année sera 5729 quelle que soit la valeur de cette variable.<br />";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]  = "Affichage Gershayim";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"]= "Afficher les simple et double quotes pour les dates hébraïques. En codant «oui» le 8 février 1969 sera affiché  <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;\"&#1496;</span>&lrm; alors qu'en codant «non» il sera affiché <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;. Sans impact sur la valeur de l'année juive car les quotes ne sont pas utilisées dans les dates avec les caractères Latin.<br />Note : ce paramétre est similaire aux constantes PHP 5.0 CAL_JEWISH_ADD_ALAFIM_GERESH et CAL_JEWISH_ADD_GERESHAYIM. Il affecte les deux valeurs.<br />";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"]= "Prononciation Ashkénaze";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"]= "Utiliser la prononciation Ashkénaze.<br />En codant «oui» les mois de Cheshvan et de Teves seront codés selon la prononciation Ashkénaze. En codant «non» ils seront codés Hesvan et Tevet.<br />Ceci n'affecte que le calendrier israélite. Avec le calendrier hébreu c'est l'alphabet hébreu qui sera utilisé.<br />";
$pgv_lang["USE_RTL_FUNCTIONS"]          = "Utiliser l'affichage RTL (de droite à gauche)";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"]= "Nombre de générations de l'arbre d'<b>ascendance</b>";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"]= "Indique le nombre de générations à afficher par défaut sur les arbres d'<b>ascendance</b>.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]   = "Nombre maximum de générations de l'arbre d'<b>ascendance</b>";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"]= "Fixe le nombre maximum de générations à afficher pour les arbres d'<b>ascendance</b>.";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"]= "Nombre maximum de générations de l'arbre de <b>descendance</b>";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]= "Fixe le nombre maximun de générations à afficher pour les arbres de <b>descendance</b>.";
$pgv_lang["USE_RIN"]                    = "Utiliser le numéro RIN au lieu de la clé GEDCOM";
$pgv_lang["USE_RIN_help"]               = "Option pour utiliser le numéro RIN au lieu de l'identifiant GEDCOM comme code des individus dans les fichiers de configuration, dans les fichiers de préférences et les arbres. Ceci est utile avec les programmes de généalogie qui exportent les données GEDCOM en utilisant le RIN.";
$pgv_lang["GENERATE_GUID"]              = "Création automatique d'un identifiant unique";
$pgv_lang["PEDIGREE_ROOT_ID"]           = "Individu par défaut pour les arbres d'ascendance et de descendance";
$pgv_lang["PEDIGREE_ROOT_ID_help"]      = "Indique l'identificateur de la personne à afficher par défaut pour les arbres d'ascendance et de descendance.";
$pgv_lang["GEDCOM_ID_PREFIX"]           = "Préfixe Individu";
$pgv_lang["GEDCOM_ID_PREFIX_help"]      = "Préfixe ajouté par défaut à l'identifiant GEDCOM d'un individu (INDI) quand l'utilisateur ne l'indique pas.";
$pgv_lang["SOURCE_ID_PREFIX"]           = "Préfixe Source";
$pgv_lang["SOURCE_ID_PREFIX_help"]      = "Préfixe ajouté par défaut à l'identifiant GEDCOM d'une source (SOUR) quand l'utilisateur ne l'indique pas.";
$pgv_lang["REPO_ID_PREFIX"]             = "Préfixe Dépôt d'archives";
$pgv_lang["REPO_ID_PREFIX_help"]        = "Préfixe ajouté par défaut à l'identifiant GEDCOM d'un dépôt d'archives (REPO) quand l'utilisateur ne l'indique pas.";
$pgv_lang["PEDIGREE_FULL_DETAILS"]      = "Afficher les détails de la naissance et du décès sur les arbres";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"] = "Option pour afficher par défaut les détails de la naissance et du décès d'un individu sur les arbres d'ascendance et de descendance.";
$pgv_lang["PEDIGREE_SHOW_GENDER"]       = "Afficher le symbole masculin/féminin sur les diagrammes";
$pgv_lang["PEDIGREE_LAYOUT"]            = "Orientation par défaut des arbres";
$pgv_lang["PEDIGREE_LAYOUT_help"]       = "Indique le sens d'orientation des arbres sur la page :<br /><ul><li>Portrait = <img src=\"images/darrow.gif\" align=\"middle\" /> vertical<li>Paysage = <img src=\"images/rarrow.gif\" align=\"middle\" /> horizontal</ul>";
$pgv_lang["SHOW_EMPTY_BOXES"]           = "Afficher les cases vides sur les arbres d'ascendance";
$pgv_lang["SHOW_EMPTY_BOXES_help"]      = "Indique si les cases sans informations doivent être affichées ou non sur les arbres d'ascendance.";
$pgv_lang["ZOOM_BOXES"]                 = "Zoom sur les cases des tableaux";
$pgv_lang["ZOOM_BOXES_help"]            = "Méthode de zoom sur les cases d'un tableau pour obtenir davantage d'informations.";
$pgv_lang["LINK_ICONS"]                 = "Liens entre tableaux";
$pgv_lang["LINK_ICONS_help"]            = "Méthode d'activation des liens entre les tableaux.";
$pgv_lang["ABBREVIATE_CHART_LABELS"]    = "Abréger les intitulés dans les tableaux";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]= "Option pour abréger ou non les intitulés comme «Naissance» par la première lettre «N».";
$pgv_lang["SHOW_AGE_DIFF"]              = "Voir les écarts d'âge";
$pgv_lang["SHOW_AGE_DIFF_help"]         = "~#pgv_lang[SHOW_AGE_DIFF]#~<br /><br />Option pour afficher les différences d'âge entre les époux, entre les enfants, ou après la date de mariage pour le premier enfant.";
$pgv_lang["SHOW_PARENTS_AGE"]           = "Afficher l'âge des parents à la naissance de l'enfant";
$pgv_lang["SHOW_PARENTS_AGE_help"]      = "~#pgv_lang[SHOW_PARENTS_AGE]#~<br /><br />Option pour afficher l'âge du père et de la mère dans les tableaux à côté de la date de naissance de l'enfant.";
$pgv_lang["SHOW_RELATIVES_EVENTS"]      = "Afficher naissance, mariage et décès des proches sur la fiche individuelle";
$pgv_lang["SHOW_RELATIVES_EVENTS_help"] = "~#pgv_lang[SHOW_RELATIVES_EVENTS]#~<br /><br />La naissance, le mariage ou le décès d'un proche sont des événements importants dans la vie de chacun. Cette option permet de les ajouter sur l'onglet «Faits et détails personnels» de la fiche individuelle.";
$pgv_lang["EXPAND_RELATIVES_EVENTS"]    = "Ouvrir automatiquement la liste d'événements";
$pgv_lang["EXPAND_RELATIVES_EVENTS_help"]= "~#pgv_lang[EXPAND_RELATIVES_EVENTS]#~<br /><br />Option pour ouvrir par défaut la liste <i>#pgv_lang[SHOW_RELATIVES_EVENTS]#</i>.<br />";
$pgv_lang["EXPAND_SOURCES"]             = "Ouvrir automatiquement les sources";
$pgv_lang["EXPAND_SOURCES_help"]        = "~#pgv_lang[EXPAND_SOURCES]#~<br /><br />Option pour afficher par défaut le contenu des <i>Sources</i> sur la page individuelle.<br />";
$pgv_lang["EXPAND_NOTES"]               = "Ouvrir automatiquement les notes";
$pgv_lang["EXPAND_NOTES_help"]          = "~#pgv_lang[EXPAND_NOTES]#~<br /><br />Option pour afficher par défaut le contenu des <i>Notes</i> sur la page individuelle.<br />";
$pgv_lang["SHOW_LEVEL2_NOTES"]          = "Montrer tous les Notes et Sources dans les onglets «Notes» et «Sources»";
$pgv_lang["HIDE_LIVE_PEOPLE"]           = "Masquer les personnes vivantes";
$pgv_lang["HIDE_LIVE_PEOPLE_help"]      = "Cette option indique à PhpGedView qu'il faut cacher les détails qui concernent les personnes qui sont encore en vie.  Les personnes vivantes sont celles dont l'âge n'a pas dépassé la valeur \$MAX_ALIVE_AGE, et qui n'ont pas d'enfant dont l'âge est inférieur à \$MAX_ALIVE_AGE.";
$pgv_lang["REQUIRE_AUTHENTICATION"]     = "Authentification obligatoire";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]= "Oblige les visiteurs à se connecter avant toute opération.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]     = "Texte de bienvenue sur la page de connexion";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]= "Choix du texte qui s'affichera sur l'écran de connexion, si le mode Authentification est actif. Choisir SVP le texte le plus approprié. Vous pouvez également saisir votre propre texte de bienvenue, mais il ne s'affichera pas dans la langue du visiteur.<br /><br />Liste des textes prédéfinis :<br /><br /><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]# :</b><br /><br />#pgv_lang[welcome_text_auth_mode_1]#<br /><br /><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]# :</b><br /><br />#pgv_lang[welcome_text_auth_mode_2]#<br /><br /><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]# :</b><br /><br />#pgv_lang[welcome_text_auth_mode_3]#";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT0"]= "Aucun texte par défaut";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]= "Texte indiquant que tous les visiteurs peuvent demander un compte";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]= "Texte indiquant que l'administrateur décidera si besoin d'un compte";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]= "Texte indiquant que seuls les membres de la famille peuvent demander un compte";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]= "Choisir un texte de bienvenue";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]= "Texte de bienvenue personnalisé";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]= "Si vous avez fait le choix d'un texte de bienvenue personnalisé, vous pouvez le saisir ici.<br />Ce texte ne sera PAS traduit dans la langue des visiteurs, il s'affichera exactement comme vous l'aurez tapé.<br /><br />Les marqueurs HTML sont autorisés.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"]= "En-tête standard pour le texte de bienvenue personnalisé";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"]= "Affichage d'un en-tête standard multi-langues pour votre texte de bienvenue personnalisé.<br /><br />Il se présentera comme ceci :<br /><br />#pgv_lang[welcome_text_cust_head]#";
$pgv_lang["CHECK_CHILD_DATES"]          = "Contrôler les dates des enfants";
$pgv_lang["CHECK_CHILD_DATES_help"]     = "Vérification des dates des enfants pour déterminer si une personne est décédée.  Sur des systèmes anciens et avec de gros fichiers GEDCOM cette option peut dégrader les temps de réponse.";
$pgv_lang["MAX_ALIVE_AGE"]              = "Âge maxi d'une personne";
$pgv_lang["MAX_ALIVE_AGE_help"]         = "L'âge maximal auquel on peut trouver un événement enregistré pour une personne ou l'âge maximal de ses enfants pour déterminer si elle est vivante ou non.";
$pgv_lang["SHOW_GEDCOM_RECORD"]         = "Autoriser la <b>consultation</b> des enregistrements GEDCOM";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]    = "Option permettant de placer des liens sur les individus, les sources et les familles pour autoriser les utilisateurs à ouvrir une fenêtre qui contiendra le code GEDCOM extrait du fichier.";
$pgv_lang["ALLOW_EDIT_GEDCOM"]          = "Autoriser la <b>modification</b> des données GEDCOM du serveur";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"]     = "Autorise les fonctions d'édition des donnéees GEDCOM pour que les utilisateurs autorisés puissent mettre à jour ce fichier directement.";
$pgv_lang["EDIT_AUTOCLOSE"]             = "Fermer automatiquement la fenêtre d'édition";
$pgv_lang["EDIT_AUTOCLOSE_help"]        = "~#pgv_lang[EDIT_AUTOCLOSE]#~<br /><br />Option pour fermer automatiquement la fenêtre d'édition après une mise à jour réussie, sans avoir besoin de cliquer sur le bouton «Fermer».<br />";
$pgv_lang["INDEX_DIRECTORY_help"]       = "Le chemin vers un répertoire accessible en lecture et en écriture où PhpGedView doit stocker les fichiers d'index (avec le «/» final)<br />";
$pgv_lang["POSTAL_CODE"]                = "Position du code postal";
$pgv_lang["POSTAL_CODE_help"]           = "~#pgv_lang[POSTAL_CODE]#~<br /><br />Option pour afficher le code postal devant ou derrière le nom de la ville, selon le pays.<br />";
$pgv_lang["SUBLIST_TRIGGER_I"]          = "Nombre maximal de noms de famille";
$pgv_lang["SUBLIST_TRIGGER_F"]          = "Nombre maximal de noms de famille";
$pgv_lang["SURNAME_LIST_STYLE"]         = "Style de présentation des listes";
$pgv_lang["SHOW_ID_NUMBERS_help"]       = "Option pour afficher l'identifiant des individus entre parenthèses sur les arbres et les listes.";
$pgv_lang["SHOW_LAST_CHANGE"]           = "Afficher la date de dernière modification de l'enregistrement GEDCOM dans les listes";
$pgv_lang["SHOW_EST_LIST_DATES"]        = "Afficher les dates estimées pour la naissance et le décès";
$pgv_lang["SHOW_PEDIGREE_PLACES"]       = "Niveau de détail pour l'affichage des lieux";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]  = "Indique le nombre de niveaux à afficher pour les lieux sur les arbres d'ascendance et de descendance. Valeur entre 0 (=ne rien afficher) et 9 (=afficher tout).";
$pgv_lang["MULTI_MEDIA"]                = "Autoriser les fonctions MultiMédia";
$pgv_lang["MULTI_MEDIA_help"]           = "GEDCOM 5.5 permet d'associer des images, des vidéos et autres objets MultiMédia. Si vous n'avez pas inclus d'objets MultiMédia dans votre fichier GEDCOM vous pouvez désactiver cette option.<br /><br />Voir le chapitre MultiMédia du fichier <a href=readme.txt>readme.txt</a> pour plus d'informations sur l'insertion de fichiers MultiMédia sur votre site.";
$pgv_lang["MEDIA_EXTERNAL"]             = "Conserver les liens";
$pgv_lang["MEDIA_EXTERNAL_help"]        = "Option pour les liens MultiMédia au format <tt>http://</tt>, <tt>ftp://</tt>, <tt>mms://</tt><br />Choix <i>Oui</i> : les liens ne sont pas modifiés. Par exemple : <u>http://www.myfamily.com/photo/dad.jpg</u> restera <u>http://www.myfamily.com/photo/dad.jpg</u>.<br />Choix <i>Non</i> : ces liens suivent la règle des objets MultiMédia. Par example : <u>http://www.myfamily.com/photo/dad.jpg</u> deviendra <u>./media/dad.jpg</u>";
$pgv_lang["MEDIA_DIRECTORY"]            = "Répertoire MultiMédia";
$pgv_lang["MEDIA_DIRECTORY_help"]       = "Chemin d'accès à un répertoire accessible en lecture où PhpGedView doit trouver les fichiers MultiMédia (coder le «/» final).";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"]     = "Niveaux de sous-répertoires MultiMédia";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"]= "Une valeur de 0 permettra d'ignorer tous les sous-répertoires du chemin d'accès aux objets MultiMédia.<br />Une valeur de 1 permettra d'accèder au sous-répertoire qui contient l'objet.<br />En augmentant cette valeur on augmentera le nombre des sous-répertoires parents à inclure dans ce chemin d'accès.<br />Par exemple : si le lien vers une image de votre fichier GEDCOM est libellé ainsi C:\\Documents&nbsp;and&nbsp;Settings\\User\\My&nbsp;Documents\\My&nbsp;Pictures\\Genealogy\\Surname&nbsp;Line\\grandpa.jpg, alors une valeur de 0 traduira ce chemin en ./media/grandpa.jpg. Une valeur de 1 le traduira en ./media/Surname&nbsp;Line/grandpa.jpg, etc. Vous n'aurez le plus souvent qu'à utiliser la valeur de 0. Mais il est possible que certains objets MultiMédia aient des noms identiques et se substituent de ce fait l'un à l'autre. Ce paramètre vous permet de conserver l'organisation de vos sous-répertoires en évitant les conflits de noms.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"] = "Si vous avez activé les fonctions MultiMédia sur votre site, vous pouvez faire afficher une image miniature à côté du nom de la personne dans les cases des arbres. PhpGedView utilise comme image le premier objet MultiMédia cité dans l'enregistrement GEDCOM. Pour les personnes qui ont plusieurs images, vous devrez organiser vos données GEDCOM de manière à mettre en première position l'image souhaitée.<br />Voir le chapitre multimedia du fichier <a href=readme.txt>readme.txt</a> pour des informations complémentaires.";
$pgv_lang["USE_THUMBS_MAIN"]            = "Afficher les vignettes à la place des images";
$pgv_lang["USE_THUMBS_MAIN_help"]       = "À l'écran, il est souvent préférable d'afficher uniquement les vignettes (thumbnails), plus rapides à charger que les images d'origine. Cela dépend surtout de votre façon d'organiser les images, de leur poids, et de la qualité des vignettes.";
$pgv_lang["SHOW_MEDIA_FILENAME"]        = "Montrer le nom du fichier dans le diaporama";
$pgv_lang["SHOW_MEDIA_DOWNLOAD"]        = "Montrer le lien de téléchargement dans le diaporama";
$pgv_lang["ENABLE_CLIPPINGS_CART"]      = "Autoriser la copie de données";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"] = "La copie de données (<i>clipping</i>) permet aux visiteurs de votre site d'extraire des informations dans un fichier qu'ils pourront télécharger au format GEDCOM et importer dans leur logiciel de généalogie.";
$pgv_lang["HIDE_GEDCOM_ERRORS"]         = "Masquer les erreurs GEDCOM";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"]    = "Option pour masquer les messages d'erreur produits par PhpGedView lorsqu'il ne reconnaît pas une balise GEDCOM de votre fichier. PhpGedView s'efforce de respecter le standard GEDCOM 5.5, mais beaucoup de logiciels de généalogie utilisent leurs propres balises.<br />Voir le fichier <a href=readme.txt>readme.txt</a> pour plus d'informations.";
$pgv_lang["WORD_WRAPPED_NOTES"]         = "Ajouter des espaces en fin de ligne dans les notes";
$pgv_lang["WORD_WRAPPED_NOTES_help"]    = "Certains programmes génèrent des fins de ligne dans les notes sans couper les mots alors que d'autres programmes les génèrent à n'importe quel endroit.  Ceci peut provoquer l'accolade de deux mots sans espace de séparation par PhpGedView. En codant «oui» pour cette option, un espace sera inséré entre les mots quand ils ont été coupés dans le fichier GEDCOM.";
$pgv_lang["SHOW_CONTEXT_HELP"]          = "Afficher le lien d'aide contextuelle";
$pgv_lang["SHOW_CONTEXT_HELP_help"]     = "Option d'affichage du lien d'aide contextuelle derrière les champs.";
$pgv_lang["DAYS_TO_SHOW_LIMIT"]         = "Limite des prochains événements (jours)";
$pgv_lang["COMMON_NAMES_THRESHOLD"]     = "Fréquence mini pour figurer dans la liste des principaux noms de familles";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]= "Nombre à partir duquel un nom de famille sera affiché dans la liste des principaux noms de familles sur la page d'accueil.";
$pgv_lang["COMMON_NAMES_ADD"]           = "Noms à <b>ajouter</b> dans la liste des principaux noms de familles";
$pgv_lang["COMMON_NAMES_ADD_help"]      = "Si un nom de famille n'atteint pas le seuil pour être affiché dans la liste, il peut être ajouté manuellement ici. Pour ajouter plusieurs noms, les séparer par une virgule. Le système distingue majuscules et minuscules.";
$pgv_lang["COMMON_NAMES_REMOVE"]        = "Noms à <b>retirer</b> de la liste des principaux noms de familles";
$pgv_lang["COMMON_NAMES_REMOVE_help"]   = "Pour ne pas afficher un nom dans la liste des principaux noms de famille sans modifier le seuil, il suffit de l'ajouter à ici manuellement ici. Pour ajouter plusieurs noms, les séparer par une virgule. Le système distingue majuscules et minuscules.";
$pgv_lang["HOME_SITE_URL"]              = "URL du site web";
$pgv_lang["HOME_SITE_URL_help"]         = "URL qui est utilisée dans le «<i>header</i>» des thèmes fournis pour générer un lien vers votre site web.";
$pgv_lang["HOME_SITE_TEXT"]             = "Description du site web";
$pgv_lang["HOME_SITE_TEXT_help"]        = "Texte utilisé pour la génération du lien vers votre site web.";
$pgv_lang["CONTACT_EMAIL"]              = "Adresse courriel du contact Généalogie";
$pgv_lang["CONTACT_EMAIL_help"]         = "L'adresse que les visiteurs doivent utiliser pour contacter la personne responsable des données généalogiques de ce site.";
$pgv_lang["CONTACT_METHOD"]             = "Préférence du contact Généalogie";
$pgv_lang["CONTACT_METHOD_help"]        = "Méthode à utiliser sur le lien contact Généalogie.";
$pgv_lang["PHPGEDVIEW_EMAIL"]           = "Adresse courriel de réponse";
$pgv_lang["WEBMASTER_EMAIL"]            = "Adresse courriel de l'administrateur";
$pgv_lang["WEBMASTER_EMAIL_help"]       = "L'adresse que les visiteurs doivent utiliser pour les questions techniques ou les erreurs qu'ils peuvent rencontrer sur votre site.";
$pgv_lang["SUPPORT_METHOD"]             = "Préférence de l'administrateur";
$pgv_lang["SUPPORT_METHOD_help"]        = "Méthode à utiliser sur le lien contact Administrateur.";
$pgv_lang["SHOW_FACT_ICONS"]            = "Montrer les icônes des événements";
$pgv_lang["FAVICON"]                    = "Icône des favoris";
$pgv_lang["FAVICON_help"]               = "Changez cette valeur pour pointer vers l'icône que vous souhaitez afficher dans le menu des favoris quand on enregistre un pointeur vers votre site.";
$pgv_lang["THEME_DIR"]                  = "Répertoire des thèmes";
$pgv_lang["THEME_DIR_help"]             = "Le répertoire dans lequel les fichiers des thèmes PhpGedView sont conservés. Vous pouvez personnaliser les thèmes qui sont livrés avec PhpGedView afin d'obtenir une présentation originale et unique de votre site.  Voir le chapitre personnalisation des thèmes du fichier <a href=readme.txt>readme.txt</a> pour plus d'informations.";
$pgv_lang["TIME_LIMIT"]                 = "Durée max.";
$pgv_lang["TIME_LIMIT_help"]            = "Temps maximal en secondes que PhpGedView est autorisé à consommer. La valeur par défaut est d'une minute.  Selon la taille de votre fichier GEDCOM, il peut être nécessaire d'augmenter cette valeur.  En codant une valeur de 0, vous supprimez la limite de temps d'exécution de PHP.<br />ATTENTION : En codant 0 ou en codant une valeur trop élevée vous pourrez causer le blocage de votre site sur certains systèmes d'exploitation jusqu'à la fin de l'exécution du script.  La valeur de 0 signifie qu'il pourrait ne jamais se terminer jusqu'à ce qu'un administrateur du serveur arrête le processus ou redémarre le serveur. La construction d'un grand arbre généalogique peut prendre un très long temps, et en laissant cette valeur aussi basse que possible vous serez certain que personne ne pourra bloquer le serveur de votre site en demandant la construction d'un arbre de 1000 générations.";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"] = "Indique le chemin à utiliser pour stocker les fichiers des sessions PhpGedView. Certains serveurs n'ont pas une configuration correcte de PHP et les sessions ne sont pas maintenues en passant d'une page à une autre. Cette option permet aux administrateurs de régler le problème en sauvegardant les fichiers dans un répertoire local. Le répertoire ./index/ est un bon choix si vous devez choisir un répertoire. Par défaut ce champ est laissé vide, ce qui permet d'utiliser le chemin configuré dans le fichier php.ini.<br />";
$pgv_lang["SERVER_URL_help"]            = "Si vous utilisez le protocole <tt>https</tt>, ou un port autre que celui par défaut, entrez ici le chemin d'accès au serveur.<br />";
$pgv_lang["LOGIN_URL"]                  = "URL de connexion (login)";
$pgv_lang["LOGIN_URL_help"]             = "À utiliser uniquement dans le cas où vous souhaitez rediriger la connexion vers un autre site, ou pour basculer du mode <tt>http</tt> au mode <tt>https</tt>.<br /><br />Entrer ici l'URL complète du fichier login.php, par exemple :<br /><tt>https://www.yourserver.com/phpgedview/login.php</tt>.";
$pgv_lang["PGV_SESSION_TIME_help"]      = "Durée, en secondes, pendant laquelle une session PhpGedView reste active avant de nécessiter une nouvelle connexion.  La valeur par défaut est de 30 minutes.<br />";
$pgv_lang["SHOW_STATS"]                 = "Afficher les statistiques";
$pgv_lang["SHOW_STATS_help"]            = "Affichage des statistiques d'exécution du programme et des requêtes faites sur la base de données au bas de chaque page.";
$pgv_lang["SHOW_COUNTER"]               = "Afficher le compteur de visites";
$pgv_lang["SHOW_COUNTER_help"]          = "Compteur du nombre d'accès aux pages du site.";
$pgv_lang["USE_REGISTRATION_MODULE_help"]= "Autoriser les utilisateurs à demander l'ouverture d'un compte sur ce site. Les administrateurs devront approuver l'inscription pour que le compte devienne actif.<br />";
$pgv_lang["ALLOW_USER_THEMES_help"]     = "Autoriser les utilisateurs à choisir leur propre thème.<br />";
$pgv_lang["PGV_SIMPLE_MAIL_help"]       = "L'en-tête normal de courriel comporte l'adresse courriel et le nom du destinataire. Certains systèmes de messagerie ne l'acceptent pas. En choisissant cette option, seule l'adresse courriel sera utilisée.<br />";
$pgv_lang["gedcom_title"]               = "Titre descriptif des données de ce fichier GEDCOM";
$pgv_lang["gedcom_title_help"]          = "Entrer une courte description de ce fichier GEDCOM pour le présenter aux visiteurs.";
$pgv_lang["LOGFILE_CREATE"]             = "Archivage des journaux";
$pgv_lang["LOGFILE_CREATE_help"]        = "Fréquence d'archivage des journaux.<br />";
$pgv_lang["PGV_MEMORY_LIMIT_help"]      = "Quantité de mémoire allouée au programme. Défaut : 32 Mo. La plupart des serveurs interdisent cette modification.<br />";
$pgv_lang["PGV_STORE_MESSAGES_help"]    = "Option de stockage des messages sur le serveur. «Oui» permettra aux utilisateurs de retrouver leurs messages quand ils se reconnectent. «Non» enverra les messages par courriel.<br />";
$pgv_lang["ALLOW_THEME_DROPDOWN"]       = "Affichage d'une liste de choix pour changer le thème";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]  = "Permet aux utilisateurs de choisir leur propre thème à partir d'une liste (si la configuration l'autorise).<br />";
$pgv_lang["MAX_VIEW_RATE"]              = "Taux max de visite des pages";
$pgv_lang["META_AUTHOR"]                = "META Author";
$pgv_lang["META_AUTHOR_help"]           = "Contenu du champ «Author» (Auteur du site) de la balise META à insérer dans l'entête de chaque page HTML.<br />";
$pgv_lang["META_AUTHOR_descr"]          = "Si vide, le nom complet de l'administrateur GEDCOM sera utilisé.";
$pgv_lang["META_PUBLISHER"]             = "META Publisher";
$pgv_lang["META_PUBLISHER_help"]        = "Contenu du champ «Publisher» (Editeur du site) de la balise META à insérer dans l'entête de chaque page HTML.<br />";
$pgv_lang["META_PUBLISHER_descr"]       = "Si vide, le nom complet de l'administrateur GEDCOM sera utilisé.";
$pgv_lang["META_COPYRIGHT"]             = "META Copyright";
$pgv_lang["META_COPYRIGHT_help"]        = "Contenu du champ «Copyright» de la balise META à insérer dans l'entête de chaque page HTML.<br />";
$pgv_lang["META_COPYRIGHT_descr"]       = "Si vide, le nom complet de l'administrateur GEDCOM sera utilisé.";
$pgv_lang["META_DESCRIPTION"]           = "META Description";
$pgv_lang["META_DESCRIPTION_help"]      = "Contenu du champ «Description» de la balise META à insérer dans l'entête de chaque page HTML.<br />";
$pgv_lang["META_DESCRIPTION_descr"]     = "Si vide, le titre de la base GEDCOM sera utilisé.";
$pgv_lang["META_PAGE_TOPIC"]            = "META Page-Topic";
$pgv_lang["META_PAGE_TOPIC_help"]       = "Contenu du champ «Page-Topic» (sujet du site) de la balise META à insérer dans l'entête de chaque page HTML.<br />";
$pgv_lang["META_PAGE_TOPIC_descr"]      = "Si vide, le titre de la base GEDCOM sera utilisé.";
$pgv_lang["META_AUDIENCE"]              = "META Audience";
$pgv_lang["META_AUDIENCE_help"]         = "Contenu du champ «Audience» (public visé par le site) de la balise META à insérer dans l'entête de chaque page HTML.<br />";
$pgv_lang["META_PAGE_TYPE"]             = "META Page-Type";
$pgv_lang["META_PAGE_TYPE_help"]        = "Contenu du champ «Page-Type» (type de page) de la balise META à insérer dans l'entête de chaque page HTML.<br />";
$pgv_lang["META_ROBOTS"]                = "META Robots";
$pgv_lang["META_ROBOTS_help"]           = "Contenu du champ «Robots» (instructions pour les robots) de la balise META à insérer dans l'entête de chaque page HTML.<br />Certains robots ne tiennent pas compte de cette balise.<br />";
$pgv_lang["META_REVISIT"]               = "META Revisit";
$pgv_lang["META_REVISIT_help"]          = "Contenu du champ «Revisit» (fréquence de revisite de la page) de la balise META à insérer dans l'entête de chaque page HTML.<br />Certains navigateurs ne tiennent pas compte de cette balise.<br />";
$pgv_lang["META_KEYWORDS"]              = "META Keywords";
$pgv_lang["META_KEYWORDS_help"]         = "Contenu du champ «Keywords» (liste de mots clés) de la balise META à insérer dans l'entête de chaque page HTML.<br />La plupart des moteurs de recherche utilisent ces valeurs pour classer les pages.<br />.";
$pgv_lang["META_SURNAME_KEYWORDS"]      = "Principaux noms de familles en mots-clés";
$pgv_lang["META_SURNAME_KEYWORDS_help"] = "Option pour ajouter les principaux noms de familles dans la balise HTML des mots-clés (META Keywords) pour une meilleure indexation par les moteurs de recherche.<br />";
$pgv_lang["META_TITLE"]                 = "Complément balise TITLE";
$pgv_lang["META_TITLE_help"]            = "Texte à ajouter au titre de chaque page HTML.<br />";
$pgv_lang["ENABLE_RSS"]                 = "Activer RSS";
$pgv_lang["RSS_FORMAT"]                 = "Format RSS";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"]= "Vérifiez si les fichiers GEDCOM sont téléchargeables";
$pgv_lang["gedcom_download_secure"]     = "#GEDCOM# ne peut être transféré du serveur.";
$pgv_lang["welcome_new_help"]           = "Cette fenêtre d'aide vous guidera pendant la configuration. Une aide vous sera fournie pour chaque champ. Vous pouvez fermer cette fenêtre, et la réouvrir à tout moment en cliquant sur le bouton d'aide près du chaque champ.";
$pgv_lang["return_editconfig"]          = "Vous pourrez revenir à cette configuration à tout moment en faisant pointer votre navigateur sur editconfig.php, ou par le lien <b>Configuration</b> du menu <b>Administration</b>.<br />";
$pgv_lang["return_editconfig_gedcom"]   = "Vous pourrez revenir à cette configuration à tout moment en faisant pointer votre navigateur sur editconfig_gedcom.php, ou par le lien <b>GEDCOM</b> du menu <b>Administration</b>.<br />";
$pgv_lang["save_config"]                = "Sauvegarder la configuration";
$pgv_lang["download_gedconf"]           = "Télécharger le fichier de configuration GEDCOM sur votre poste (<i>Download</i>).";
$pgv_lang["not_writable"]               = "Votre fichier de configuration est protégé contre l'écriture. Vous pouvez utiliser le bouton de téléchargement pour sauvegarder vos données dans un fichier que vous transfèrerez manuellement.";
$pgv_lang["upload_to_index"]            = "Télécharger le fichier sur le serveur (<i>Upload</i>) dans le répertoire : ";
//-- edit privacy messages
$pgv_lang["edit_privacy"]               = "Règles de confidentialité";
$pgv_lang["edit_privacy_title"]         = "Modifier les règles de confidentialité";
$pgv_lang["save_changed_settings"]      = "Enregistrer les modifications";
$pgv_lang["add_new_pp_setting"]         = "Ajouter une nouvelle règle";
$pgv_lang["add_new_up_setting"]         = "Ajouter une nouvelle règle";
$pgv_lang["add_new_gf_setting"]         = "Ajouter une nouvelle règle";
$pgv_lang["add_new_pf_setting"]         = "Ajouter une nouvelle règle";
$pgv_lang["file_read_error"]            = "Impossible de lire le fichier de confidentialité!";
$pgv_lang["edit_exist_person_privacy_settings"]= "Modifier les paramètres";
$pgv_lang["edit_exist_user_privacy_settings"]= "Modifier les paramètres";
$pgv_lang["edit_exist_global_facts_settings"]= "Modifier les règles sur les événements";
$pgv_lang["edit_exist_person_facts_settings"]= "Modifier les paramètres";
$pgv_lang["general_privacy"]            = "Restrictions d'accès";
$pgv_lang["general_privacy_help"]       = "<b>#pgv_lang[general_settings]#.</b><br />Paramètre par défaut pour ce fichier GEDCOM.<br /><br />Si vous avez chargé plusieurs fichiers GEDCOM sur votre site, chacun peut avoir ses propres paramètres.<br /><br />Certains paramètres sont modifiables sur la page #pgv_lang[edit_privacy_title]#.<br />#pgv_lang[more_config_help]#";
$pgv_lang["person_privacy"]             = "selon l'enregistrement";
$pgv_lang["person_privacy_help"]        = "<b>#pgv_lang[person_privacy_settings]#.</b><br />Permet à l'administrateur de forcer une règle de confidentialité pour un <b>individu</b> particulier. Pour un enfant mort par exemple. Par défaut, les détails le concernant sont visibles par tous, puisqu'il s'agit d'une personne décédée. Pour masquer ces informations sans supprimer l'enregistrement du décès, il suffit d'ajouter une règle.<br />";
$pgv_lang["user_privacy"]               = "selon l'utilisateur";
$pgv_lang["user_privacy_help"]          = "<b>#pgv_lang[user_privacy_settings]#.</b><br />Permet à l'administrateur de forcer une règle de confidentialité pour un <b>utilisateur</b> particulier.<br />";
$pgv_lang["global_facts"]               = "selon l'événement";
$pgv_lang["global_facts_help"]          = "<b>#pgv_lang[global_facts_settings]#.</b><br />Permet à l'administrateur de forcer une règle de confidentialité pour un <b>événement</b> particulier.<br />";
$pgv_lang["person_facts"]               = "selon l'événement et l'enregistrement";
$pgv_lang["person_facts_help"]          = "<b>#pgv_lang[person_facts_settings]#.</b><br />Permet à l'administrateur de forcer une règle de confidentialité pour un <b>événement et un individu</b> particulier.<br />";
$pgv_lang["accessible_by"]              = "Montrer à qui ?";
$pgv_lang["hide"]                       = "Cacher";
$pgv_lang["show_question"]              = "Montrer ?";
$pgv_lang["user_name"]                  = "Nom de l'utilisateur";
$pgv_lang["name_of_fact"]               = "Code de l'événement";
$pgv_lang["choice"]                     = "Montrer quoi ?";
$pgv_lang["fact_show"]                  = "Montrer l'événement";
$pgv_lang["fact_details"]               = "Montrer les détails de l'événement";
$pgv_lang["privacy_header"]             = "Modifier les paramètres";
$pgv_lang["unable_to_find_privacy_indi"]= "Aucun résultat pour l'ID";
$pgv_lang["save_and_import"]            = "Après la sauvegarde de cette configuration, il vous reste à faire l'<b>import</b> du fichier GEDCOM.";
$pgv_lang["help_info"]                  = "Pour obtenir de l'aide sur un champ, cliquer sur le «?» près du champ.";
$pgv_lang["SHOW_LIVING_NAMES"]          = "Montrer les noms des personnes en vie";
$pgv_lang["SHOW_LIVING_NAMES_help"]     = "#pgv_lang[SHOW_LIVING_NAMES]#<br />";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]    = "Montrer l'assistant de recherche";
$pgv_lang["SHOW_RESEARCH_ASSISTANT_help"]= "~ # pgv_lang [SHOW_RESEARCH_ASSISTANT] # ~ <br /> <br /> Quel type d'utilisateur peut afficher le module d'assistant de recherche s'il est installé? <br />";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]   = "Autoriser l'accès aux détails privés des proches";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]= "#pgv_lang[USE_RELATIONSHIP_PRIVACY]#<br /><br />Option désactivée : les utilisateurs authentifiés peuvent voir les détails de toutes les personnes vivantes.<br />Option activée : accès aux détails privés des proches uniquement.<br />";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]   = "Degré de parenté pour l'accès aux détails privés";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]= "#pgv_lang[MAX_RELATION_PATH_LENGTH]#<br /><br />Si l'option #pgv_lang[USE_RELATIONSHIP_PRIVACY]# est activée, les utilisateurs authentifiés auront accès aux détails des individus dans la limite de ce degré de parenté.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]   = "Vérifier les liens par mariage";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]= "Accès aux détails privés des proches par alliance.<br />";
$pgv_lang["SHOW_DEAD_PEOPLE"]           = "Montrer les personnes décédées";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]      = "Niveau de confidentialité pour toutes les personnes décédées";
$pgv_lang["select_privacyfile_button"]  = "Choix d'un fichier de Confidentialité";
$pgv_lang["PRIVACY_BY_YEAR"]            = "Restriction par ancienneté d'événement";
$pgv_lang["PRIVACY_BY_YEAR_help"]       = "L'option #pgv_lang[PRIVACY_BY_YEAR]# permet de masquer les détails pour les individus selon l'âge qu'ils avaient à un événement donné, qu'ils soient décédés depuis ou pas.<br /><br />Si l'âge maximum est défini à 100 ans, on peut ainsi masquer toutes les personnes, vivantes ou non, nées depuis moins de 100 ans, mariées depuis moins de 85 ans, ou décédées depuis moins de 75 ans.<br /><br />Avertissement : cette option peut ralentir fortement les temps de réponse.<br />";
// Google Translate
$pgv_lang["google_translate"]           = "Traduction Google ";
$pgv_lang["commit"]                     = "Accepter";
$pgv_lang["commit_google"]              = "Accepter les traductions proposées par Google";
$pgv_lang["commit_google_help"]         = "~ # pgv_lang [commit_google] # ~ <br /> <br /> En cliquant sur ce lien, vous sauvegardez toutes les traductions proposées par Google. L'indicateur de progression de l'écriture des traductions est affiché ci-dessous. <br /> <br />";
##$pgv_lang["google_translate_help"]    = "~#pgv_lang[google_translate]#~<br /><br />This tool uses Google Translate to provide a hint to the translator.  It is <b>not</b> intended to replace translations done by a person who fully understands the source and the target languages.<br /><br />Use this tool as follows:  First select the entries you want to edit, then click the <b>#pgv_lang[google_translate]#</b> link, and then click <b>#pgv_lang[commit]#</b> to allow each individual row to be committed or click the <b>#pgv_lang[commit_google]#</b> to commit all Google translations at once.  After the page is reloaded, you should correct the mistranslated entries by hand. <b>There is no guarantee that the Google translation will be correct.</b><br /><br />You need to remove special characters such as #, <, >, / and HTML entities as well as references to other language or global variables from your text before attempting to have Google translate it.  Please be aware also that the Google translate tool is not always able to perform a translation.<br /><br />";
//-- language edit utility
$pgv_lang["edit_langdiff"]              = "Éditer le contenu des fichiers de traduction";
$pgv_lang["bom_check"]                  = "Utilitaire de suppression du BOM";
$pgv_lang["bom_check_help"]             = "Cet outil effectue la suppression du BOM* dans les fichiers de langues.<br />*BOM = Byte Order Mark : 3 octets ajoutés au tout début d'un fichier par certains éditeurs de texte. Ce marqueur sert à mémoriser le format du fichier (ANSI, UTF-8...). La présence du BOM provoque une erreur d'affichage PhpGedView, il est donc nécessaire de le supprimer.";
$pgv_lang["lang_debug_help"]            = "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#<br />";
$pgv_lang["bom_not_found"]              = "Aucun BOM trouvé.";
$pgv_lang["bom_found"]                  = "BOM supprimé du fichier ";
$pgv_lang["edit_lang_utility"]          = "Utilitaire d'édition des fichiers de traduction";
$pgv_lang["edit_lang_utility_help"]     = "Utilitaire pour modifier le contenu d'un fichier de traduction en vous appuyant sur le contenu de la version anglaise.<br /><br />Le programme vous listera le contenu du fichier de la version anglaise originale et celui de la version à traduire. Après avoir cliqué sur le message que vous voulez traduire une nouvelle fenêtre qui s'ouvrira vous permettra de modifier et de sauvegarder votre traduction du message dans la langue choisie.";
$pgv_lang["edit_lang_utility_warning"]  = "ATTENTION!<br />Le bouton <i>#pgv_lang[close_window_without_refresh]#</i> oblige à recharger la page pour afficher les modifications.<br /><br />N'utilisez ce bouton qu'avec précaution.";
$pgv_lang["language_to_edit"]           = "Traduction en";
$pgv_lang["language_to_edit_help"]      = "~ # pgv_lang [language_to_edit] # ~ <br /> <br /> Dans cette liste, vous sélectionnez la langue avec laquelle vous souhaitez modifier les messages. <br />";
$pgv_lang["file_to_edit"]               = "Type de fichier à traduire";
$pgv_lang["file_to_edit_help"]          = "~#pgv_lang[file_to_edit]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["check"]                      = "Vérifier";
$pgv_lang["lang_save"]                  = "Sauvegarder";
$pgv_lang["contents"]                   = "Contenu";
$pgv_lang["listing"]                    = "Liste";
$pgv_lang["no_content"]                 = "Vide";
$pgv_lang["editlang"]                   = "Modifier";
$pgv_lang["editlang_help"]              = "Éditer un message du fichier";
$pgv_lang["savelang"]                   = "Enregistrer";
$pgv_lang["savelang_help"]              = "Sauvegarder le message";
$pgv_lang["original_message"]           = "Message original";
$pgv_lang["message_to_edit"]            = "Message à éditer";
$pgv_lang["changed_message"]            = "Valeur modifiée";
$pgv_lang["message_empty_warning"]      = "-> Avertissement!!! Message vide dans le fichier [#LANGUAGE_FILE#] <-";
$pgv_lang["language_to_export"]         = "Langage à exporter";
$pgv_lang["export_lang_utility"]        = "Utilitaire d'export du fichier langue";
$pgv_lang["export"]                     = "Exporter";
$pgv_lang["export_lang_utility_help"]   = "Ce module permet de choisir une langue et d'exporter le contenu du fichier d'aide pour obtenir une documentation.";
$pgv_lang["export_ok"]                  = "Les messages d'aide ont été exportés";
$pgv_lang["compare_lang_utility"]       = "Utilitaire de comparaison de fichiers de langues";
$pgv_lang["compare_lang_utility_help"]  = "Ce module affiche les écarts entre deux fichiers de langues.<br /><br />Voir également le fichier [<a href=\"languages/LANG_CHANGELOG.txt\" target=\"_blank\">LANG_CHANGELOG.txt</a>].";
$pgv_lang["new_language"]               = "Langue 1";
$pgv_lang["old_language"]               = "Langue 2";
$pgv_lang["compare"]                    = "Comparaison";
$pgv_lang["comparing"]                  = "Fichiers comparés ";
$pgv_lang["additions"]                  = "Ajouts";
$pgv_lang["no_additions"]               = "Aucun ajout";
$pgv_lang["subtractions"]               = "Suppressions";
$pgv_lang["no_subtractions"]            = "Aucune suppression";
$pgv_lang["config_lang_utility"]        = "Configuration des langues supportées";
$pgv_lang["config_lang_utility_help"]   = "Ce module vous aide à configurer les langues utilisables avec PhpGedView.<br /><br />Attention : au premier changement, PhpGedView va créer un nouveau fichier <tt>lang_settings.php</tt> dans le répertoire <tt>#INDEX_DIRECTORY#</tt>.<br /><br />Ensuite PhpGedView utilisera uniquement ce fichier. Par conséquent, pour tout problème relatif à une langue, merci de préciser que vous utilisez un fichier modifié de votre répertoire <tt>#INDEX_DIRECTORY#</tt>.";
$pgv_lang["active"]                     = "Actif";
$pgv_lang["active_help"]                = "Permet de choisir une autre langue, si l'administrateur l'autorise.";
$pgv_lang["edit_settings"]              = "Éditer les préférences";
$pgv_lang["lang_edit"]                  = "Éditer";
$pgv_lang["lang_language"]              = "Langue";
$pgv_lang["export_filename"]            = "Nom du fichier d'export";
$pgv_lang["lang_back"]                  = "Retour au menu des langues";
$pgv_lang["lang_back_admin"]            = "Retour au menu Administrateur";
$pgv_lang["lang_back_manage_gedcoms"]   = "Retour au menu administration GEDCOM";
$pgv_lang["lang_name_arabic"]           = "Arabe";
$pgv_lang["lang_name_czech"]            = "Tchèque";
$pgv_lang["lang_name_chinese"]          = "Chinois";
$pgv_lang["lang_name_danish"]           = "Danois";
$pgv_lang["lang_name_dutch"]            = "Hollandais";
$pgv_lang["lang_name_english"]          = "Anglais";
$pgv_lang["lang_name_estonian"]         = "Estonien";
$pgv_lang["lang_name_finnish"]          = "Finnois";
$pgv_lang["lang_name_french"]           = "Français";
$pgv_lang["lang_name_german"]           = "Allemand";
$pgv_lang["lang_name_greek"]            = "Grec";
$pgv_lang["lang_name_hebrew"]           = "Hébreu";
$pgv_lang["lang_name_hungarian"]        = "Hongrois";
$pgv_lang["lang_name_italian"]          = "Italien";
$pgv_lang["lang_name_lithuanian"]       = "Lituanien";
$pgv_lang["lang_name_norwegian"]        = "Norvégien";
$pgv_lang["lang_name_polish"]           = "Polonais";
$pgv_lang["lang_name_portuguese"]       = "Portugais";
$pgv_lang["lang_name_russian"]          = "Russe";
$pgv_lang["lang_name_slovak"]           = "Slovaque";
$pgv_lang["lang_name_spanish"]          = "Espagnol";
$pgv_lang["lang_name_spanish-ar"]       = "Espagnol Sud Américain";
$pgv_lang["lang_name_swedish"]          = "Suédois";
$pgv_lang["lang_name_turkish"]          = "Turc";
$pgv_lang["lang_name_vietnamese"]       = "Vietnamien";
$pgv_lang["lang_new_language"]          = "Nouvelle Langue";
$pgv_lang["original_lang_name"]         = "Nom d'origine de la langue en #D_LANGNAME#";
$pgv_lang["original_lang_name_help"]    = "Comment se nomme cette langue dans cette langue ?<br /><br />En anglais, l'anglais se nomme : English<br />En allemand, l'allemand se nomme : Deutsch<br />etc.";
$pgv_lang["lang_shortcut"]              = "Raccourci pour les fichiers de langues";
$pgv_lang["lang_shortcut_help"]         = "Raccourci du code langue dans PhpGedView.<br />Habituellement il s'agit du premier code dans le fichier des «Codes de Langues» à définir dans le champ suivant.";
$pgv_lang["lang_langcode"]              = "Codes de langue";
$pgv_lang["lang_langcode_help"]         = "Ces codes permettent à PhpGedView de détecter la langue par défaut du navigateur. Séparateur : «;'";
$pgv_lang["lang_filenames"]             = "Fichiers de langues";
$pgv_lang["lang_filenames_help"]        = "~#pgv_lang[lang_filenames]#~<br /><br />#pgv_lang[lang_file_descriptions]#";
$pgv_lang["flagsfile"]                  = "Fichier image du drapeau";
$pgv_lang["flagsfile_help"]             = "Nom et chemin d'accès au fichier image du drapeau pour cette langue.";
$pgv_lang["text_direction"]             = "Sens du texte";
$pgv_lang["text_direction_help"]        = "Sens de l'écriture dans la langue choisie.<br /><br />Habituellement les langues occidentales s'écrivent de gauche à droite (LTR).<br />D'autres langues, comme l'hébreu, s'écrivent de droite à gauche (RTL).";
$pgv_lang["date_format"]                = "Format de date";
$pgv_lang["time_format"]                = "Format de l'heure";
$pgv_lang["week_start"]                 = "Premier jour de la semaine";
$pgv_lang["week_start_help"]            = "Jour de la semaine qui commence une nouvelle semaine dans cette langue. La plupart commencent par le Dimanche, certaines par le Lundi ou un autre jour.";
$pgv_lang["name_reverse"]               = "Nom de famille en tête";
$pgv_lang["name_reverse_help"]          = "Option pour afficher le prénom en arrière, suivant le nom de famille, comme cela se fait dans certaines langues comme l'hongrois, le chinois, et le japonais. Valeur par défaut : afficher le prénom en premier.";
$pgv_lang["ltr"]                        = "De gauche à droite (LTR)";
$pgv_lang["rtl"]                        = "De droite à gauche (RTL)";
$pgv_lang["file_does_not_exist"]        = "Le fichier n'existe pas...";
$pgv_lang["optional_file_not_exist"]    = "Le fichier optionnel n'existe pas...";
$pgv_lang["alphabet_upper"]             = "Alphabet des majuscules";
$pgv_lang["alphabet_upper_help"]        = "Alphabet des majuscules dans cette langue. Utilisé pour le tri des noms en majuscules.";
$pgv_lang["alphabet_lower"]             = "Alphabet des minuscules";
$pgv_lang["alphabet_lower_help"]        = "Alphabet des minuscules dans cette langue. Utilisé pour le tri des noms en minuscules.";
$pgv_lang["multi_letter_alphabet"]      = "Alphabet multi-lettres";
$pgv_lang["dictionary_sort"]            = "Tri dans l'ordre du dictionnaire";
$pgv_lang["lang_config_write_error"]    = "Erreur d'écriture du fichier [language_settings.php]. Vérifier les droits d'accès et réessayer.";
$pgv_lang["translation_forum"]          = "Forum traduction";
$pgv_lang["translation_forum_help"]     = "Lien direct au forum des traductions de PhpGedView sur le serveur SourceForge où vous pourrez parler des problèmes spécifiques de traduction <tt>http://sourceforge.net/forum/forum.php?forum_id=294245</tt>";
$pgv_lang["lang_set_file_read_error"]   = "Erreur de lecture du fichier [language_settings.php]!";
$pgv_lang["add_new_language_help"]      = "Utilitaire pour ajouter une nouvelle langue à PhpGedView.<br /><br />Merci de remplir tous les champs nécessaires dans la fenêtre suivante. Après la création des fichiers, vous serez en mesure de modifier les messages pour cette nouvelle langue.";
$pgv_lang["add_new_lang_button"]        = "Ajouter une nouvelle langue";
$pgv_lang["hide_translated"]            = "Cacher les traductions";
$pgv_lang["lang_file_write_error"]      = "ERREUR !!!<br /><br />Impossible d'écrire dans le ficher de la langue!<br />Vérifier les droits d'accès du fichier (#lang_filename#)";
$pgv_lang["no_open"]                    = "E R R E U R !!!<br /><br />Impossible d'ouvrir le fichier #lang_filename#";
$pgv_lang["users_langs"]                = "Langues des utilisateurs";
$pgv_lang["configured_languages"]       = "Langues activées";
//-- User Migration Tool messages
$pgv_lang["um_header"]                  = "Exporter les comptes utilisateurs pour passage mode Index <-> mode SQL";
$pgv_lang["um_proceed"]                 = "Lancer l'export des comptes utilisateurs ?<br /><br />";
$pgv_lang["um_creating"]                = "Création";
$pgv_lang["um_file_create_fail1"]       = "Un fichier portant le même nom existe déjà :";
$pgv_lang["um_file_create_fail2"]       = "Création impossible";
$pgv_lang["um_file_create_fail3"]       = "Vérifier les droits d'écriture du répertoire.";
$pgv_lang["um_file_create_succ1"]       = "Création réussie :";
$pgv_lang["um_file_not_created"]        = "Echec à la création du fichier";
$pgv_lang["um_nomsg"]                   = "Aucun message trouvé.";
$pgv_lang["um_nofav"]                   = "Aucun favori trouvé.";
$pgv_lang["um_nonews"]                  = "Aucune nouvelle trouvée.";
$pgv_lang["um_noblocks"]                = "Aucun bloc trouvé.";
$pgv_lang["um_index_sql"]               = "Cet outil importera le fichier <i> authenticate.php </ i> et d'autres fichiers<i>. dat </ i> depuis votre le répertoire index de votre base de données. <br />";
$pgv_lang["um_import"]                  = "Import";
$pgv_lang["um_export"]                  = "Export";
$pgv_lang["um_tool_help"]               = "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"]          = "~ Migrer les utilisateurs du mode SQL au mode index ~ <br /> <br /> # pgv_lang [um_sql_index] #";
$pgv_lang["um_index_sql_help"]          = "~ Migrer les utilisateurs du mode index au mode SQL ~ <br /> <br /> # pgv_lang [um_index_sql] #";
$pgv_lang["um_imp_users"]               = "Import des utilisateurs";
$pgv_lang["um_imp_blocks"]              = "Import des blocs";
$pgv_lang["um_imp_favorites"]           = "Import des favoris";
$pgv_lang["um_imp_messages"]            = "Import des messages";
$pgv_lang["um_imp_news"]                = "Import des nouveautés";
$pgv_lang["um_nousers"]                 = "Fichier <i>authenticate.php</i> non trouvé. Opération annulée.";
$pgv_lang["um_imp_succ"]                = "Import réussi";
$pgv_lang["um_imp_fail"]                = "Echec de l'import !!!";
$pgv_lang["um_backup"]                  = "Sauvegarde";
$pgv_lang["um_zip_succ"]                = "Fichier ZIP créé.";
$pgv_lang["um_zip_dl"]                  = "Télécharger le fichier de sauvegarde ZIP ";
$pgv_lang["um_bu_explain"]              = "Avec cet outil, sauvegardez vos données PhpGedView dans un fichier ZIP que vous pourrez ensuite télécharger.";
$pgv_lang["um_bu_help"]                 = "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"]               = "Fichier de configuration PhpGedView";
$pgv_lang["um_bu_gedcoms"]              = "Fichiers GEDCOM";
$pgv_lang["um_bu_gedsets"]              = "Fichiers de configuration";
$pgv_lang["um_bu_logs"]                 = "Journaux et compteurs";
$pgv_lang["um_bu_usinfo"]               = "Blocs, favoris, messages";
$pgv_lang["um_bu_media"]                = "Fichiers MultiMédia";
$pgv_lang["um_mk_bu"]                   = "Lancer la sauvegarde";
$pgv_lang["um_nofiles"]                 = "Aucun fichier à sauvegarder.";
$pgv_lang["um_files_exist"]             = "Un fichier existe déjà. Voulez-vous l'écraser ?";
$pgv_lang["um_results"]                 = "Resultats";
$pgv_lang["preview_faq_item"]           = "Prévisualiser FAQ";
$pgv_lang["restore_faq_edits"]          = "Rétablir la fonctionnalité de modification de la FAQ";
$pgv_lang["restore_faq_edits_help"]     = "~ # pgv_lang [restore_faq_edits] # ~ <br /> Cette option restaure la page FAQ à ce qu'un utilisateur administrateur voit normalement, de sorte que les éléments de la page FAQ puissent être modifiés. <br />";
$pgv_lang["add_faq_item"]               = "Ajouter FAQ";
$pgv_lang["add_faq_item_help"]          = "~ # pgv_lang [add_faq_item] # ~ <br /> Cette option vous permettra d'ajouter un élément à la page FAQ. <br />";
$pgv_lang["edit_faq_item"]              = "Editer FAQ";
$pgv_lang["edit_faq_item_help"]         = "~ # pgv_lang [edit_faq_item] # ~ <br /> Cette option vous permettra de modifier un élément sur la page FAQ. <br />";
$pgv_lang["delete_faq_item"]            = "Supprimer FAQ";
$pgv_lang["delete_faq_item_help"]       = "~ # pgv_lang [delete_faq_item] # ~ <br /> Cette option vous permettra de supprimer un élément de la page FAQ <br />";
$pgv_lang["moveup_faq_item"]            = "Déplacer FAQ vers le haut";
$pgv_lang["movedown_faq_item"]          = "Déplacer FAQ vers le bas";
$pgv_lang["time_limit_help"]            = "~ # pgv_lang [time_limit] # ~ <br /> <br /> Le temps maximum qui est autorisé pour l'importation afin de procéder au traitement du fichier GEDCOM.";
// Media items
// editconfig_gedcom.php Option Filter
$pgv_lang["ged_filter_results"]         = "Résultats trouvés";
$pgv_lang["ged_filter_reset"]           = "Effacer la recherche";
$pgv_lang["ged_filter_description"]     = "L'option de recherche par texte";
?>
