# Pantera Passive Plugin - Check if page has URI suspicious parameters
#
# FILENAME      : check_for_parameters.py
# CODER         : Simon Roses Femerling
# DATE          : 07/23/2006
# LAST UPDATE   : 07/23/2006
# ABSTRACT      : Check if page has URI suspicious parameters
#       
# - Roses Labs Innovations (RL+I)
# Roses Labs
# http://www.roseslabs.com
#
# Copyright (c) 2003-2006 Roses Labs.
#
# You may not distribute, transmit, repost this software for commercial 
# purposes without Roses Labs written permission. 
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, publish,
# distribute the Software, and to permit persons to whom the Software 
# is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
# CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
# TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
# SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

'''
@author:       Simon Roses Femerling
@license:      GNU General Public License 2.0 or later
@contact:      pantera.proxy@gmail.com
@organization: OWASP / Roses Labs
'''

from panteraPlugins import PPM
import re

plugin_info =  {'id':"CheckForParamHunter",
                'name':"URI Param Hunter",
                'author':"Simon Roses Femerling",
                'email':"sroses@roseslabs.com",
                'version':"0.1",
                'desc':"Check if page has URI suspicious parameters",
                'tag':"querystr"  # defined tags else ignore plugin
                } 

class CheckForParamHunter(PPM):
    '''
    CheckForParamHunter class.
    '''
    
    def InitAnalyzer(self):
        '''
        Init function.
        '''
        PPM.__init__(self)
        self.param_list = [('.*session.*?','Session Fingerprint'),
                            ('.*login.*?','Login Fingerprint'),
                            ('.*user.*?','User Fingerprint'),
                            ('.*name.*?','Name Fingerprint'),
                            ('.*password.*?','Password Fingerprint'),
                            ('.*passwdadmin.*?','Admin Password Fingerprint'),
                            ('.*pass.*?','Password Fingerprint'),
                            ('.*pwd.*?','Password Fingerprint'),
                            ('.*admin.*?','Admin Fingerprint'),
                            ('.*file.*?','File Fingerprint'),
                            ('.*auth.*?','Authentication Fingerprint'),
                            ('.*cookie.*?','Cookie Fingerprint'),
                            ('.*id.*?','ID Fingerprint')]
    
    def BeginAnalyzer(self,obj):
        '''
        Begin function.
        '''
        if len(obj.clientheader.URLargsDict)>0 and obj.clientheader.verb == 'GET':
            for k in obj.clientheader.URLargsDict.keys():
                s = k+'='+obj.clientheader.URLargsDict[k]
                for pl in self.param_list:
                    pl_fin, pl_name = pl
                    p = re.compile(pl_fin,re.IGNORECASE)
                    r = p.match(s)
                    if r:
                        self.SetLevel('low')
                        self.SetResult(1,'vuln')
                        self.SetType('vuln')
                        t = "Suspicious Parameter found: %s (%s=%s)" % (pl_name,k,obj.clientheader.URLargsDict[k])
                        self.SetResultData(t)
        
# RL+I EOF