# Pantera Passive Plugin - Check if response has private IP headers 
#
# FILENAME      : check_for_ipheader.py
# CODER         : Simon Roses Femerling
# DATE          : 07/23/2006
# LAST UPDATE   : 07/23/2006
# ABSTRACT      : Check if response has private IP headers
#       
# - Roses Labs Innovations (RL+I)
# Roses Labs
# http://www.roseslabs.com
#
# Copyright (c) 2003-2006 Roses Labs.
#
# You may not distribute, transmit, repost this software for commercial 
# purposes without Roses Labs written permission. 
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, publish,
# distribute the Software, and to permit persons to whom the Software 
# is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
# CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
# TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
# SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

'''
@author:       Simon Roses Femerling
@license:      GNU General Public License 2.0 or later
@contact:      pantera.proxy@gmail.com
@organization: OWASP / Roses Labs
'''

from panteraPlugins import PPM
import re

plugin_info =  {'id':"CheckForPrivateIP",
                'name':"Private IP Header Hunter",
                'author':"Simon Roses Femerling",
                'email':"sroses@roseslabs.com",
                'version':"0.1",
                'desc':"Check if response has private IP headers.",
                'tag':"recon"  # defined tags else ignore plugin
                } 

class CheckForPrivateIP(PPM):
    '''
    CheckForPrivateIP class.
    '''
    
    def InitAnalyzer(self):
        '''
        Init function.
        '''
        PPM.__init__(self)
        self.classA = re.compile('10\.\d?\d?\d?\.\d?\d?\d?\.\d?\d?\d?',re.IGNORECASE)
        self.classB = re.compile('172\.[1-3]\d?\d?\.\d?\d?\d?\.\d?\d?\d?',re.IGNORECASE)
        self.classC = re.compile('192\.168\.\d?\d?\d?\.\d?\d?\d?',re.IGNORECASE)
        
    def BeginAnalyzer(self,obj):
        '''
        Begin function.
        '''
        for h in obj.serverheader.headerValuesDict.keys():
            val = obj.serverheader.headerValuesDict[h]
            for v in val:
                s = "%s: %s" % (h,v)
                res_a = self.classA.search(s)
                if res_a:
                    self.SetLevel('low')
                    self.SetResult(1,'vuln')
                    t = "Private IP class A found (%s: %s)" % (h,obj.serverheader.headerValuesDict[h])
                    self.SetResultData(t)
                res_b = self.classB.search(s)
                if res_b:
                    self.SetLevel('low')
                    self.SetResult(1,'vuln')
                    t = "Private IP class B found (%s: %s)" % (h,obj.serverheader.headerValuesDict[h])
                    self.SetResultData(t)
                res_c = self.classC.search(s)
                if res_c:
                    self.SetLevel('low')
                    self.SetResult(1,'vuln')
                    t = "Private IP class C found (%s: %s)" % (h,obj.serverheader.headerValuesDict[h])
                    self.SetResultData(t)
        
# RL+I EOF