# Pantera Passive Plugin - Check if page has form or authform tag
#
# FILENAME      : check_for_ssl.py
# CODER         : Simon Roses Femerling
# DATE          : 06/07/2006
# LAST UPDATE   : 07/25/2006
# ABSTRACT      : Check if page has form or authform tag
#       
# - Roses Labs Innovations (RL+I)
# Roses Labs
# http://www.roseslabs.com
#
# Copyright (c) 2003-2006 Roses Labs.
#
# You may not distribute, transmit, repost this software for commercial 
# purposes without Roses Labs written permission. 
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, publish,
# distribute the Software, and to permit persons to whom the Software 
# is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
# CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
# TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
# SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

'''
@author:       Simon Roses Femerling
@license:      GNU General Public License 2.0 or later
@contact:      pantera.proxy@gmail.com
@organization: OWASP / Roses Labs
'''

from panteraPlugins import PPM
import re

plugin_info =  {'id':"CheckForForms",
                'name':"Form Tag Checker",
                'author':"Simon Roses Femerling",
                'email':"sroses@roseslabs.com",
                'version':"0.1",
                'desc':"Check if page has form or authform tag",
                'tag':"form"  # defined tags else ignore plugin
                } 

class CheckForForms(PPM):
    '''
    CheckForForms class.
    '''
    
    def InitAnalyzer(self):
        '''
        Init function.
        '''
        PPM.__init__(self)
        self.exp = re.compile(r'<form([^>]*)>',re.IGNORECASE)
        self.input = re.compile('<input(.*?)>',re.IGNORECASE)
        self.passw = re.compile('type="password"',re.IGNORECASE)
    
    def BeginAnalyzer(self,obj):
        '''
        Begin function.
        '''
        self.page_body = obj.printBody(1) # enable gzip decoding
        r = self.exp.search(self.page_body)
        if r: # form found!
            input_res = self.input.findall(self.page_body)
            if input_res: # input tag found
                for i in input_res:
                    passw_res = self.passw.search(i)
                    if passw_res: # Auth form
                        self.SetLevel('info')
                        self.SetOtherType('vuln')
                        self.SetResult(1,'auth_form')
                        return # OK    
            self.SetLevel('info')
            self.SetOtherType('vuln')
            self.SetResult(1,'form')
        else:
            self.SetResult(0,'')
        
# RL+I EOF