# Pantera Passive Plugin - Check if page has autocomplete=off enable
#
# FILENAME      : check_for_autocomplete.py
# CODER         : Simon Roses Femerling
# DATE          : 07/23/2006
# LAST UPDATE   : 07/23/2006
# ABSTRACT      : Check if page has autocomplete=off enable
#       
# - Roses Labs Innovations (RL+I)
# Roses Labs
# http://www.roseslabs.com
#
# Copyright (c) 2003-2006 Roses Labs.
#
# You may not distribute, transmit, repost this software for commercial 
# purposes without Roses Labs written permission. 
#
# Permission is hereby granted, free of charge, to any person obtaining
# a copy of this software and associated documentation files (the
# "Software"), to deal in the Software without restriction, including
# without limitation the rights to use, copy, modify, publish,
# distribute the Software, and to permit persons to whom the Software 
# is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included
# in all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
# EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
# MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
# IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
# CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
# TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
# SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
#

'''
@author:       Simon Roses Femerling
@license:      GNU General Public License 2.0 or later
@contact:      pantera.proxy@gmail.com
@organization: OWASP / Roses Labs
'''

from panteraPlugins import PPM
import re

plugin_info =  {'id':"CheckForAutoComplete",
                'name':"AutoComplete Checker",
                'author':"Simon Roses Femerling",
                'email':"sroses@roseslabs.com",
                'version':"0.1",
                'desc':"Check if page autocomplete=off enable.",
                'tag':"vuln"  # defined tags else ignore plugin
                } 

class CheckForAutoComplete(PPM):
    '''
    CheckForAutoComplete class.
    '''
    
    def InitAnalyzer(self):
        '''
        Init function.
        '''
        PPM.__init__(self)
        self.input = re.compile('<input(.*?)>',re.IGNORECASE)
        self.form = re.compile('<form(.*?)>',re.IGNORECASE)
        self.passw = re.compile('type="password"',re.IGNORECASE)
        self.auto = re.compile('autocomplete="off"',re.IGNORECASE)
        
    def BeginAnalyzer(self,obj):
        '''
        Begin function.
        '''
        self.page_body = obj.printBody(1) # enable gzip decoding
        input_res = self.input.findall(self.page_body)
        if input_res: # input tag found
            for i in input_res:
                passw_res = self.passw.search(i)
                auto_res = self.auto.search(i)
                if passw_res and auto_res: # pass and autocomplete tag found inside input
                    return # OK
                form_res = self.form.search(self.page_body)  
                if form_res:  
                    auto1_res = self.auto.search(form_res.group())
                    if passw_res and auto1_res:
                        return # OK
                    if passw_res and form_res and not auto_res and not auto1_res:
                        self.SetResult(1,'vuln')
                        self.SetLevel('low')
                        s = "Page is missing AUTOCOMPLETE=OFF on password or form fields"
                        self.SetResultData(s)
            
# RL+I EOF