/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xml.ui.internal.text;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.phpeclipse.xml.core.model.IXMLDocument;
import net.sourceforge.phpeclipse.xml.core.parser.IProblem;
import net.sourceforge.phpeclipse.xml.core.parser.IProblemCollector;
import net.sourceforge.phpeclipse.xml.ui.internal.editor.XMLDocumentProvider;
import net.sourceforge.phpeclipse.xml.ui.internal.text.AnnotationAdapter;
import net.sourceforge.phpeclipse.xml.ui.internal.text.XMLAnnotation;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.reconciler.AbstractReconcileStep;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilableModel;
import org.eclipse.jface.text.reconciler.IReconcileResult;
import org.eclipse.jface.text.reconciler.IReconcileStep;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class XMLReconcileStep
extends AbstractReconcileStep {
    private ITextEditor editor;
    private XMLDocumentAdapter xmlDocumentAdapter;

    public XMLReconcileStep(ITextEditor editor) {
        this.editor = editor;
        this.xmlDocumentAdapter = new XMLDocumentAdapter(this.getXMLDocument());
    }

    public XMLReconcileStep(IReconcileStep step, ITextEditor editor) {
        super(step);
        this.editor = editor;
        this.xmlDocumentAdapter = new XMLDocumentAdapter(this.getXMLDocument());
    }

    protected IReconcileResult[] reconcileModel(DirtyRegion dirtyRegion, IRegion subRegion) {
        IXMLDocument model = this.xmlDocumentAdapter.getDocument();
        IEditorInput editorInput = null;
        IFile file = null;
        if (this.editor != null) {
            editorInput = this.editor.getEditorInput();
        }
        if (editorInput instanceof IFileEditorInput) {
            file = ((IFileEditorInput)editorInput).getFile();
        }
        ProblemCollector problemCollector = new ProblemCollector();
        model.reconcile((IProblemCollector)problemCollector, file);
        List problems = problemCollector.getProblems();
        IReconcileResult[] retVal = new IReconcileResult[problems.size()];
        int i = 0;
        while (i < problems.size()) {
            IProblem problem = (IProblem)problems.get(i);
            retVal[i] = new ProblemAdapter(problem);
            ++i;
        }
        return retVal;
    }

    public IReconcilableModel getModel() {
        return this.xmlDocumentAdapter;
    }

    private IXMLDocument getXMLDocument() {
        IDocumentProvider documentProvider = this.editor.getDocumentProvider();
        if (documentProvider instanceof XMLDocumentProvider) {
            XMLDocumentProvider xmlDocumentProvider = (XMLDocumentProvider)documentProvider;
            return xmlDocumentProvider.getModel(this.editor.getEditorInput());
        }
        return null;
    }

    private class ProblemAdapter
    extends AnnotationAdapter {
        private IProblem problem;
        private Position position;

        public ProblemAdapter(IProblem problem) {
            this.problem = problem;
        }

        public Position getPosition() {
            if (this.position == null) {
                this.position = this.createPositionFromProblem();
            }
            return this.position;
        }

        public Annotation createAnnotation() {
            int start = this.problem.getSourceStart();
            if (start < 0) {
                return null;
            }
            int length = this.problem.getSourceEnd() - start + 1;
            if (length < 0) {
                return null;
            }
            String type = this.problem.isWarning() ? "org.eclipse.ui.workbench.texteditor.warning" : (this.problem.isError() ? "org.eclipse.ui.workbench.texteditor.error" : "org.eclipse.ui.workbench.texteditor.info");
            return new XMLAnnotation(type, false, this.problem.getMessage());
        }

        private Position createPositionFromProblem() {
            int start = this.problem.getSourceStart();
            if (start < 0) {
                return null;
            }
            int length = this.problem.getSourceEnd() - this.problem.getSourceStart() + 1;
            if (length < 0) {
                return null;
            }
            return new Position(start, length);
        }
    }

    private class ProblemCollector
    implements IProblemCollector {
        private List collectedProblems = new ArrayList();

        private ProblemCollector() {
        }

        public void addProblem(IProblem problem) {
            this.collectedProblems.add(problem);
        }

        public List getProblems() {
            return Collections.unmodifiableList(this.collectedProblems);
        }
    }

    private class XMLDocumentAdapter
    implements IReconcilableModel {
        private IXMLDocument document;

        public XMLDocumentAdapter(IXMLDocument document) {
            this.document = document;
        }

        public IXMLDocument getDocument() {
            return this.document;
        }
    }
}

