/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.ui.overlaypages;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.phpeclipse.ui.WebUI;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.QualifiedName;

public class ProjectPrefUtil {
    public static String getMiscProjectsPreferenceValue(IResource resource, String key) {
        return ProjectPrefUtil.getOverlayedPrefProjectValue(resource, "net.sourceforge.phpeclipse.preferences.PHPMiscProjectPreferences", key);
    }

    public static List getIncludePaths(IResource resource) {
        String includePaths = ProjectPrefUtil.getMiscProjectsPreferenceValue(resource, "_php_include_paths");
        ArrayList<Object> list = new ArrayList<Object>();
        if (includePaths != null) {
            StringTokenizer st = new StringTokenizer(includePaths, String.valueOf(File.pathSeparator) + "\n\r");
            while (st.hasMoreElements()) {
                list.add(st.nextElement());
            }
        }
        return list;
    }

    public static IPath getDocumentRoot(IResource resource) {
        String documentRoot = ProjectPrefUtil.getMiscProjectsPreferenceValue(resource, "_php_documentroot");
        Path path = new Path(documentRoot);
        return path;
    }

    public static String getOverlayedPrefProjectValue(IResource resource, String pageId, String key) {
        IProject project = resource.getProject();
        String value = null;
        if (ProjectPrefUtil.useProjectSettings((IResource)project, pageId)) {
            value = ProjectPrefUtil.getProperty(resource, pageId, key);
        }
        if (value != null) {
            return value;
        }
        return WebUI.getDefault().getPreferenceStore().getString(key);
    }

    public static String getOverlayedPrefResourceValue(IResource resource, String pageId, String key) {
        String value = null;
        if (ProjectPrefUtil.useProjectSettings(resource, pageId)) {
            value = ProjectPrefUtil.getProperty(resource, pageId, key);
        }
        if (value != null) {
            return value;
        }
        return WebUI.getDefault().getPreferenceStore().getString(key);
    }

    public static boolean getPreviewBooleanValue(IResource resource, String key) {
        return ProjectPrefUtil.getOverlayedPrefResourceValue(resource, "net.sourceforge.phpeclipse.preferences.PHPPreviewProjectPreferences", key).equals("true");
    }

    public static String getPreviewStringValue(IResource resource, String key) {
        return ProjectPrefUtil.getOverlayedPrefResourceValue(resource, "net.sourceforge.phpeclipse.preferences.PHPPreviewProjectPreferences", key);
    }

    private static String getProperty(IResource resource, String pageId, String key) {
        try {
            return resource.getPersistentProperty(new QualifiedName(pageId, key));
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    private static boolean useProjectSettings(IResource resource, String pageId) {
        String use = ProjectPrefUtil.getProperty(resource, pageId, "useProjectSettings");
        return "true".equals(use);
    }
}

