/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.ui.editor;

import net.sourceforge.phpeclipse.ui.WebUI;
import net.sourceforge.phpeclipse.ui.editor.BrowserUtil;
import net.sourceforge.phpeclipse.ui.editor.EditorMessages;
import net.sourceforge.phpeclipse.ui.overlaypages.ProjectPrefUtil;
import net.sourceforge.phpeclipse.webbrowser.views.BrowserView;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.progress.WorkbenchJob;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextEditorAction;

public class ShowExternalPreviewAction
extends TextEditorAction {
    public static final int XML_TYPE = 1;
    public static final int HTML_TYPE = 2;
    public static final int SMARTY_TYPE = 3;
    public static final int PHP_TYPE = 4;
    private static ShowExternalPreviewAction instance = new ShowExternalPreviewAction();

    private ShowExternalPreviewAction() {
        super(EditorMessages.getResourceBundle(), "ParserAction.", null);
        this.update();
    }

    public static ShowExternalPreviewAction getInstance() {
        return instance;
    }

    public void run() {
        this.doRun(4);
    }

    public void doRun(int type) {
        IFile previewFile = this.getFile();
        BrowserUtil.showPreview(previewFile, false, "");
    }

    public void refresh(int type) {
        IFile previewFile = this.getFile();
        if (previewFile == null) {
            return;
        }
        boolean autoPreview = ProjectPrefUtil.getPreviewBooleanValue((IResource)previewFile, "_auto_preview");
        boolean bringToTopPreview = ProjectPrefUtil.getPreviewBooleanValue((IResource)previewFile, "_bring_to_top_preview");
        boolean stickyBrowserURL = ProjectPrefUtil.getPreviewBooleanValue((IResource)previewFile, "_sticky_browser_url");
        if (autoPreview) {
            IWorkbenchPage page = WebUI.getActivePage();
            if (page == null) {
                return;
            }
            try {
                IViewPart part = page.showView("net.sourceforge.phpeclipse.webbrowser.views", null, 3);
                if (part != null) {
                    if (bringToTopPreview) {
                        new WorkbenchJob(((Object)((Object)this)).getClass().getName()){

                            public IStatus runInUIThread(IProgressMonitor monitor) {
                                IViewPart part;
                                IWorkbenchPage page = WebUI.getActivePage();
                                if (page != null && (part = page.findView("net.sourceforge.phpeclipse.webbrowser.views")) != null) {
                                    page.bringToTop((IWorkbenchPart)part);
                                }
                                return Status.OK_STATUS;
                            }
                        }.schedule();
                    }
                    if (stickyBrowserURL && ((BrowserView)part).getUrl() != null && ((BrowserView)part).getUrl().length() > 0) {
                        ((BrowserView)part).refresh();
                    } else {
                        String localhostURL = ShowExternalPreviewAction.getLocalhostURL(null, previewFile);
                        ((BrowserView)part).refresh(localhostURL);
                    }
                }
            }
            catch (PartInitException e) {
                WebUI.getDefault().getLog().log((IStatus)new Status(4, "net.sourceforge.phpeclipse.ui", 0, "Failed to show Browser View", (Throwable)e));
            }
        }
    }

    protected IFile getFile() {
        ITextEditor editor = this.getTextEditor();
        IEditorInput editorInput = null;
        if (editor != null) {
            editorInput = editor.getEditorInput();
        }
        if (editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        return null;
    }

    public static String getLocalhostURL(IPreferenceStore store, IFile file) {
        if (file != null) {
            IPath documentRootPath;
            String documentRoot;
            String localhostURL;
            String lowerCaseFileName;
            if (store == null) {
                store = WebUI.getDefault().getPreferenceStore();
            }
            if (!(lowerCaseFileName = (localhostURL = file.getFullPath().toString()).toLowerCase()).startsWith(documentRoot = (documentRootPath = file.getProject().getFullPath()).toString().toLowerCase())) {
                return null;
            }
            localhostURL = localhostURL.substring(documentRoot.length());
            String projectPath = ProjectPrefUtil.getMiscProjectsPreferenceValue((IResource)file.getProject(), "_php_localhost");
            if (projectPath.endsWith("/") && localhostURL.startsWith("/")) {
                localhostURL = localhostURL.substring(1);
            }
            return String.valueOf(projectPath) + localhostURL;
        }
        return "http://localhost";
    }
}

