/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.ui.editor;

import java.net.MalformedURLException;
import java.net.URL;
import net.sourceforge.phpeclipse.ui.WebUI;
import net.sourceforge.phpeclipse.ui.editor.ShowExternalPreviewAction;
import net.sourceforge.phpeclipse.ui.internal.WebUIMessages;
import net.sourceforge.phpeclipse.ui.overlaypages.ProjectPrefUtil;
import net.sourceforge.phpeclipse.webbrowser.views.BrowserView;
import net.sourceforge.phpeclipse.webbrowser.views.ShowInContextBrowser;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;

public class BrowserUtil {
    private static final String BROWSER_ID = "net.sourceforge.phpeclipse.browser";
    static /* synthetic */ Class class$0;

    public static ShowInContextBrowser getShowInContext(IFile previewFile, boolean forceDBGPreview, String postFix) {
        String localhostURL;
        String extension = previewFile.getFileExtension().toLowerCase();
        if (!forceDBGPreview) {
            boolean bl = "html".equals(extension) || "htm".equals(extension) || "xhtml".equals(extension);
            boolean bl2 = "xml".equals(extension) || "xsd".equals(extension) || "dtd".equals(extension);
        }
        if ((localhostURL = ShowExternalPreviewAction.getLocalhostURL(null, previewFile)) == null) {
            return new ShowInContextBrowser((Object)previewFile, null, null);
        }
        localhostURL = String.valueOf(localhostURL) + postFix;
        return new ShowInContextBrowser((Object)previewFile, null, localhostURL);
    }

    private static IShowInTarget getShowInTarget(IWorkbenchPart targetPart) {
        Object o;
        if (targetPart instanceof IShowInTarget) {
            return (IShowInTarget)targetPart;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((o = targetPart.getAdapter((Class)clazz)) instanceof IShowInTarget) {
            return (IShowInTarget)o;
        }
        return null;
    }

    public static void showPreview(IFile previewFile, boolean forceDBGPreview, String postFix) {
        if (previewFile == null) {
            return;
        }
        IWorkbenchPage page = WebUI.getActivePage();
        if (page != null && page.isEditorAreaVisible()) {
            boolean autoPreview = forceDBGPreview;
            if (!forceDBGPreview) {
                autoPreview = ProjectPrefUtil.getPreviewBooleanValue((IResource)previewFile, "_auto_preview");
            }
            if (autoPreview) {
                ShowInContextBrowser context = BrowserUtil.getShowInContext(previewFile, forceDBGPreview, postFix);
                IWorkbenchPart sourcePart = page.getActivePart();
                if (sourcePart == null && context != null) {
                    return;
                }
                Perspective persp = ((WorkbenchPage)page).getActivePerspective();
                if (persp != null) {
                    IViewReference ref = persp.findView("net.sourceforge.phpeclipse.webbrowser.views", null);
                    IViewPart view = null;
                    if (ref != null) {
                        view = ref.getView(true);
                    }
                    if (view == null && forceDBGPreview) {
                        try {
                            view = persp.showView("net.sourceforge.phpeclipse.webbrowser.views", null);
                            persp.bringToTop(persp.findView("net.sourceforge.phpeclipse.webbrowser.views", null));
                        }
                        catch (PartInitException e) {
                            WebUI.log(e);
                        }
                    }
                    if (view != null) {
                        IShowInTarget target = BrowserUtil.getShowInTarget((IWorkbenchPart)view);
                        boolean stickyBrowserURL = ProjectPrefUtil.getPreviewBooleanValue((IResource)previewFile, "_sticky_browser_url");
                        if (target != null) {
                            if (stickyBrowserURL && ((BrowserView)target).getUrl() != null && ((BrowserView)target).getUrl().length() > 0) {
                                ((BrowserView)target).refresh();
                            } else {
                                target.show((ShowInContext)context);
                            }
                        }
                        ((WorkbenchPage)page).performedShowIn("net.sourceforge.phpeclipse.webbrowser.views");
                    }
                }
            }
        }
    }

    public static void showBrowserAsEditor(IFile file, String queryString) {
        BrowserUtil.showBrowser(32, file, queryString);
    }

    public static void showBrowserAsExternal(IFile file, String queryString) {
        BrowserUtil.showBrowser(128, file, queryString);
    }

    public static void showBrowserAsView(IFile file, String queryString) {
        BrowserUtil.showBrowser(64, file, queryString);
    }

    public static void showBrowser(int style, IFile file, String queryString) {
        ShowInContextBrowser context = BrowserUtil.getShowInContext(file, true, queryString);
        String url = context.getLocalhostUrl();
        if (url == null) {
            String dialogTitle = WebUIMessages.getString("BrowserUtil.error.dialog.title");
            String message = WebUIMessages.getString("BrowserUtil.null.url.message");
            String reason = WebUIMessages.getString("BrowserUtil.null.url.reason");
            Status status = new Status(4, "net.sourceforge.phpeclipse.ui", 0, reason, null);
            ErrorDialog.openError((Shell)new Shell(), (String)dialogTitle, (String)message, (IStatus)status);
            return;
        }
        String id = BROWSER_ID;
        switch (style) {
            case 128: {
                id = String.valueOf(id) + ".x";
                break;
            }
            case 32: {
                id = String.valueOf(id) + ".e";
                break;
            }
            case 64: {
                id = String.valueOf(id) + ".v";
            }
        }
        style |= 0xE;
        try {
            IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().createBrowser(style, id, null, url);
            browser.openURL(new URL(url));
        }
        catch (PartInitException e) {
            WebUI.log(e);
        }
        catch (MalformedURLException e) {
            WebUI.log(e);
        }
    }
}

