/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.php.model;

import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sourceforge.phpeclipse.xdebug.php.model.IXDebugBreakpoint;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugTarget;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.Breakpoint;
import org.eclipse.debug.core.model.IBreakpoint;

public abstract class XDebugBreakpoint
extends Breakpoint
implements IXDebugBreakpoint {
    protected static final String EXPIRED = "org.eclipse.jdt.debug.core.expired";
    protected static final String HIT_COUNT = "net.sourceforge.phpeclipse.xdebug.php.model.hitCount";
    protected static final String INSTALL_COUNT = "org.eclipse.jdt.debug.core.installCount";
    protected static final String TYPE_NAME = "org.eclipse.jdt.debug.core.typeName";
    protected HashMap fRequestsByTarget = new HashMap(1);
    protected String fInstalledTypeName = null;
    protected Set fInstalledTargets = null;
    protected List fInstanceFilters = null;
    protected static final Object[] fgEmptyInstanceFilters = new Object[0];
    public static final String JAVA_BREAKPOINT_PROPERTY = "org.eclipse.jdt.debug.breakpoint";
    protected static final String[] fgExpiredEnabledAttributes = new String[]{"org.eclipse.jdt.debug.core.expired", "org.eclipse.debug.core.enabled"};

    public String getModelIdentifier() {
        return "asd";
    }

    public void setMarker(IMarker marker) throws CoreException {
        super.setMarker(marker);
        this.configureAtStartup();
    }

    protected void register(boolean register) throws CoreException {
        DebugPlugin plugin = DebugPlugin.getDefault();
        if (plugin != null && register) {
            plugin.getBreakpointManager().addBreakpoint((IBreakpoint)this);
        } else {
            this.setRegistered(false);
        }
    }

    protected ArrayList getRequests(XDebugTarget target) {
        ArrayList list = (ArrayList)this.fRequestsByTarget.get(target);
        if (list == null) {
            list = new ArrayList(2);
        }
        return list;
    }

    public boolean shouldSkipBreakpoint() throws CoreException {
        DebugPlugin plugin = DebugPlugin.getDefault();
        return plugin != null && this.isRegistered() && !plugin.getBreakpointManager().isEnabled();
    }

    public boolean isExpired() throws CoreException {
        return this.ensureMarker().getAttribute(EXPIRED, false);
    }

    public boolean isInstalled() throws CoreException {
        return this.ensureMarker().getAttribute(INSTALL_COUNT, 0) > 0;
    }

    protected void incrementInstallCount() throws CoreException {
        int count = this.getInstallCount();
        this.setAttribute(INSTALL_COUNT, count + 1);
    }

    public int getInstallCount() throws CoreException {
        return this.ensureMarker().getAttribute(INSTALL_COUNT, 0);
    }

    protected void decrementInstallCount() throws CoreException {
        int count = this.getInstallCount();
        if (count > 0) {
            this.setAttribute(INSTALL_COUNT, count - 1);
        }
        if (count == 1 && this.isExpired()) {
            this.setAttributes(fgExpiredEnabledAttributes, new Object[]{Boolean.FALSE, Boolean.TRUE});
        }
    }

    protected void setTypeName(String typeName) throws CoreException {
        this.setAttribute(TYPE_NAME, typeName);
    }

    public String getTypeName() throws CoreException {
        if (this.fInstalledTypeName == null) {
            return this.ensureMarker().getAttribute(TYPE_NAME, null);
        }
        return this.fInstalledTypeName;
    }

    private void configureAtStartup() throws CoreException {
        ArrayList<String> attributes = null;
        ArrayList<Constable> values = null;
        if (this.isInstalled()) {
            attributes = new ArrayList<String>(3);
            values = new ArrayList<Constable>(3);
            attributes.add(INSTALL_COUNT);
            values.add(new Integer(0));
        }
        if (this.isExpired()) {
            if (attributes == null) {
                attributes = new ArrayList(3);
                values = new ArrayList(3);
            }
            attributes.add(EXPIRED);
            values.add(Boolean.FALSE);
            attributes.add("org.eclipse.debug.core.enabled");
            values.add(Boolean.TRUE);
        }
        if (attributes != null) {
            String[] strAttributes = new String[attributes.size()];
            this.setAttributes(attributes.toArray(strAttributes), values.toArray());
        }
    }

    public int getHitCount() throws CoreException {
        return this.ensureMarker().getAttribute(HIT_COUNT, -1);
    }

    public void setHitCount(int count) throws CoreException {
        if (this.getHitCount() != count) {
            if (!this.isEnabled() && count > -1) {
                this.setAttributes(new String[]{"org.eclipse.debug.core.enabled", HIT_COUNT, EXPIRED}, new Object[]{Boolean.TRUE, new Integer(count), Boolean.FALSE});
            } else {
                this.setAttributes(new String[]{HIT_COUNT, EXPIRED}, new Object[]{new Integer(count), Boolean.FALSE});
            }
        }
    }

    protected String getMarkerMessage(int hitCount, int suspendPolicy) {
        StringBuffer buff = new StringBuffer();
        return buff.toString();
    }

    public void setExpired(boolean expired) throws CoreException {
        this.setAttribute(EXPIRED, expired);
    }

    protected boolean isInstalledIn(XDebugTarget target) {
        return this.fInstalledTargets != null && this.fInstalledTargets.contains(target);
    }

    protected void setInstalledIn(XDebugTarget target, boolean installed) {
        if (installed) {
            if (this.fInstalledTargets == null) {
                this.fInstalledTargets = new HashSet();
            }
            this.fInstalledTargets.add(target);
        } else if (this.fInstalledTargets != null) {
            this.fInstalledTargets.remove(target);
        }
    }

    public void addInstanceFilter(Object object) throws CoreException {
        if (this.fInstanceFilters == null) {
            this.fInstanceFilters = new ArrayList();
        }
        if (!this.fInstanceFilters.contains(object)) {
            this.fInstanceFilters.add(object);
            this.fireChanged();
        }
    }

    protected void fireChanged() {
        DebugPlugin plugin = DebugPlugin.getDefault();
        if (plugin != null && this.markerExists()) {
            plugin.getBreakpointManager().fireBreakpointChanged((IBreakpoint)this);
        }
    }

    public Object[] getInstanceFilters() {
        if (this.fInstanceFilters == null || this.fInstanceFilters.isEmpty()) {
            return fgEmptyInstanceFilters;
        }
        return this.fInstanceFilters.toArray(new Object[this.fInstanceFilters.size()]);
    }

    public void removeInstanceFilter(Object object) throws CoreException {
        if (this.fInstanceFilters == null) {
            return;
        }
        if (this.fInstanceFilters.remove(object)) {
            this.fireChanged();
        }
    }

    public void setEnabled(boolean enabled) throws CoreException {
        super.setEnabled(enabled);
    }

    public boolean supportsInstanceFilters() {
        return true;
    }
}

