/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.php.model;

import net.sourceforge.phpeclipse.xdebug.core.PHPDebugUtils;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugAbstractValue;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugStackFrame;
import net.sourceforge.phpeclipse.xdebug.php.model.XDebugVariable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XDebugArrayValue
extends XDebugAbstractValue {
    private int NumChildren = 0;

    public XDebugArrayValue(XDebugStackFrame variable, Node value) throws DebugException {
        super(variable, value);
        if (!PHPDebugUtils.getAttributeValue(value, "numchildren").equals("")) {
            this.NumChildren = Integer.parseInt(PHPDebugUtils.getAttributeValue(value, "numchildren"));
        }
        if (this.NumChildren > 0) {
            NodeList property = value.getChildNodes();
            this.renderValueString("" + property.getLength());
            IVariable[] Variables = new IVariable[property.getLength()];
            int i = 0;
            while (i < property.getLength()) {
                Node propertyNode = property.item(i);
                Variables[i] = new XDebugVariable(variable, propertyNode);
                ++i;
            }
            this.setChildren(Variables);
        }
    }

    private void renderValueString(String data) throws DebugException {
        if (data.equals("")) {
            this.setValueString("empty");
        } else if ("array".equals(this.getReferenceTypeName())) {
            this.setValueString("array(" + this.NumChildren + ")");
        } else {
            this.setValueString(data);
        }
    }
}

