/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.xdebug.core.xdebug;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.phpeclipse.xdebug.core.PHPDebugUtils;
import net.sourceforge.phpeclipse.xdebug.core.XDebugCorePlugin;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class XDebugResponse {
    public static final String TYPE_INIT = "init";
    public static final String TYPE_RESPONSE = "response";
    public static final String TYPE_STREAM = "stream";
    private Node parentNode;
    private int fTransactionID = -1;
    private String fCommand = "";
    private String fStatus = "";
    private String fReason = "";
    private String fName = "";
    private boolean fError;
    private String fValue;
    private String fType;
    private String fAddress;
    private String fIdeKey;

    public XDebugResponse(String XMLInput) {
        this.setParentNode(XMLInput);
    }

    private synchronized void setParentNode(String xmlInput) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        Document doc = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
        ByteArrayInputStream InputXMLStream = new ByteArrayInputStream(xmlInput.getBytes());
        try {
            doc = builder.parse(InputXMLStream);
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.parentNode = doc.getFirstChild();
        String responseType = this.parentNode.getNodeName();
        if (responseType == TYPE_INIT) {
            this.fName = TYPE_INIT;
            this.parseInit(this.parentNode);
        } else if (responseType == TYPE_RESPONSE) {
            this.fName = TYPE_RESPONSE;
            this.parseResponse(this.parentNode);
        } else if (responseType == TYPE_STREAM) {
            this.fName = TYPE_STREAM;
            this.parseStream();
        } else {
            this.fName = null;
        }
    }

    private void parseInit(Node parentNode) {
        this.fIdeKey = this.getAttributeValue("idekey");
    }

    private void parseResponse(Node parentNode) {
        block12: {
            Node child;
            String idStr = this.getAttributeValue("transaction_id");
            if (!"".equals(idStr)) {
                this.fTransactionID = Integer.parseInt(idStr);
            }
            this.fCommand = this.getAttributeValue("command");
            if (parentNode.hasChildNodes() && (child = parentNode.getFirstChild()).getNodeName().equals("error")) {
                int code = Integer.parseInt(PHPDebugUtils.getAttributeValue(child, "code"));
                String text = child.getFirstChild().getNodeValue();
                XDebugCorePlugin.log(4, " ERROR " + code + ": " + text);
                this.fError = true;
                return;
            }
            this.fError = false;
            this.fStatus = this.getAttributeValue("status");
            this.fReason = this.getAttributeValue("reason");
            if (this.fCommand.compareTo("eval") == 0) {
                try {
                    Node firstChild1;
                    Node attribute1;
                    Node property = parentNode.getFirstChild();
                    NamedNodeMap listAttribute = property.getAttributes();
                    Node attribute = listAttribute.getNamedItem("type");
                    if (attribute != null) {
                        this.fType = attribute.getNodeValue();
                    }
                    if ((attribute1 = listAttribute.getNamedItem("address")) != null) {
                        this.fAddress = attribute1.getNodeValue();
                    }
                    if ((firstChild1 = property.getFirstChild()) != null) {
                        this.fValue = firstChild1.getNodeValue();
                        break block12;
                    }
                    this.fValue = "";
                }
                catch (Exception exception) {}
            } else {
                try {
                    CDATASection firstChild = (CDATASection)parentNode.getFirstChild();
                    if (firstChild != null) {
                        this.fValue = parentNode.getFirstChild().getNodeValue();
                    }
                }
                catch (Exception exception) {}
            }
        }
    }

    private void parseStream() {
    }

    public String getAttributeValue(String AttributeName) {
        NamedNodeMap listAttribute;
        Node attribute;
        String strValue = "";
        if (this.parentNode.hasAttributes() && (attribute = (listAttribute = this.parentNode.getAttributes()).getNamedItem(AttributeName)) != null) {
            strValue = attribute.getNodeValue();
        }
        return strValue;
    }

    public synchronized Node getParentNode() {
        return this.parentNode;
    }

    public String getCommand() {
        return this.fCommand;
    }

    public String getName() {
        return this.fName;
    }

    public synchronized String getValue() {
        return this.fValue;
    }

    public synchronized String getReason() {
        return this.fReason;
    }

    public synchronized String getStatus() {
        return this.fStatus;
    }

    public synchronized int getTransactionID() {
        return this.fTransactionID;
    }

    public boolean isError() {
        return this.fError;
    }
}

