/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.wizards.html;

import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.wizards.html.EditElementWizard;
import net.sourceforge.phpeclipse.wizards.html.EditElementWizardPage;
import net.sourceforge.phpeclipse.wizards.html.NumVerifyListener;
import net.sourceforge.phpeclipse.wizards.html.TableElementCellModifier;
import net.sourceforge.phpeclipse.wizards.html.TableElementContentProvider;
import net.sourceforge.phpeclipse.wizards.html.TableElementLabelProvider;
import net.sourceforge.phpeclipse.wizards.html.TableElementModel;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class TableElementWizardPage
extends EditElementWizardPage {
    public static final int COLUMNS_MAX = 32;
    public static final int ROWS_MAX = 256;
    static final String[] expandStyleLabels = new String[]{"Flat", "Table", "Enumerate"};
    TableElementModel model;
    TableViewer viewer;
    CellEditor[] editors;
    Combo expandStyleCombo = null;
    Text colsText;
    Text rowsText;
    Button addButton;
    Button removeButton;
    Button upButton;
    Button downButton;
    SelectionListener buttonListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent ev) {
            Element e = TableElementWizardPage.this.getCurrentSelection();
            if (ev.widget == TableElementWizardPage.this.addButton) {
                TableElementWizardPage.this.model.insertNewRowBefore(e);
            } else if (ev.widget == TableElementWizardPage.this.removeButton) {
                TableElementWizardPage.this.model.removeRow(e);
            } else if (ev.widget == TableElementWizardPage.this.upButton) {
                TableElementWizardPage.this.model.move(e, -1);
            } else if (ev.widget == TableElementWizardPage.this.downButton) {
                TableElementWizardPage.this.model.move(e, 1);
            }
            TableElementWizardPage.this.refreshAll();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };
    ModifyListener cellCountChangeListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            try {
                if (e.widget == TableElementWizardPage.this.colsText) {
                    int cols = Integer.parseInt(TableElementWizardPage.this.colsText.getText());
                    if (cols < 1) {
                        cols = 1;
                    }
                    if (cols > 32) {
                        cols = 32;
                    }
                    TableElementWizardPage.this.model.setColumnCount(cols);
                } else if (e.widget == TableElementWizardPage.this.rowsText) {
                    int rows = Integer.parseInt(TableElementWizardPage.this.rowsText.getText());
                    if (rows < 1) {
                        rows = 1;
                    }
                    if (rows > 256) {
                        rows = 256;
                    }
                    TableElementWizardPage.this.model.setRowCount(rows);
                }
                TableElementWizardPage.this.refreshAll();
            }
            catch (NumberFormatException numberFormatException) {}
        }
    };

    public TableElementWizardPage() {
        super("TableElementWizardPage");
        this.setTitle("Table");
        this.setDescription("Edit table element and cells modifier.");
    }

    public String getPreviewText() {
        if (this.model == null) {
            this.initModel();
        }
        return this.model != null ? this.model.expandCodes() : null;
    }

    void initModel() {
        String content = ((EditElementWizard)this.getWizard()).getSelection().getText().trim();
        try {
            this.model = new TableElementModel(content, this.getEditType() == 0);
        }
        catch (ParserConfigurationException e) {
            PHPeclipsePlugin.log(e);
        }
        catch (SAXException e) {
            PHPeclipsePlugin.log(e);
        }
        catch (IOException e) {
            PHPeclipsePlugin.log(e);
        }
    }

    protected void createChildControl(Composite parent) {
        parent.setLayout((Layout)new GridLayout(2, false));
        this.viewer = new TableViewer(parent, 67588);
        this.refreshTableHeaderColumns();
        this.viewer.setContentProvider((IContentProvider)new TableElementContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableElementLabelProvider());
        this.viewer.setCellModifier((ICellModifier)new TableElementCellModifier(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                TableElementWizardPage.this.refreshAll();
            }
        }));
        this.viewer.setInput((Object)this.model);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TableElementWizardPage.this.refreshButtonState();
                TableElementWizardPage.this.refreshPreview();
            }
        });
        Table table = this.viewer.getTable();
        table.setLinesVisible(true);
        table.setHeaderVisible(true);
        GridData gd = new GridData(1808);
        gd.verticalSpan = 2;
        table.setLayoutData((Object)gd);
        Composite textInputArea = new Composite(parent, 0);
        textInputArea.setLayout((Layout)new GridLayout(1, false));
        textInputArea.setLayoutData((Object)new GridData(258));
        this.rowsText = this.createNumInputText(textInputArea, "&Rows:");
        this.colsText = this.createNumInputText(textInputArea, "&Columns:");
        Composite buttonArea = new Composite(parent, 0);
        buttonArea.setLayout((Layout)new GridLayout(1, false));
        buttonArea.setLayoutData((Object)new GridData(264));
        this.addButton = this.createButton(buttonArea, "&Add");
        this.removeButton = this.createButton(buttonArea, "&Remove");
        this.upButton = this.createButton(buttonArea, "&Up");
        this.downButton = this.createButton(buttonArea, "&Down");
        TableColumn[] cols = table.getColumns();
        int i = 0;
        while (i < cols.length) {
            cols[i].pack();
            ++i;
        }
        this.refreshTableLengthText();
        this.refreshButtonState();
    }

    Button createButton(Composite parent, String text) {
        Button button = new Button(parent, 0);
        button.setLayoutData((Object)new GridData(256));
        button.setText(text);
        button.addSelectionListener(this.buttonListener);
        return button;
    }

    Text createNumInputText(Composite parent, String label) {
        Label labe = new Label(parent, 0);
        labe.setText(label);
        Text text = new Text(parent, 2048);
        text.setLayoutData((Object)new GridData(256));
        text.setTextLimit(2);
        text.addVerifyListener((VerifyListener)new NumVerifyListener());
        text.addModifyListener(this.cellCountChangeListener);
        return text;
    }

    void refreshAll() {
        this.refreshTableHeaderColumns();
        this.refreshTableLengthText();
        this.refreshButtonState();
        this.refreshPreview();
        this.viewer.refresh();
    }

    void refreshTableHeaderColumns() {
        CellEditor[] newEditors;
        if (this.model == null) {
            this.initModel();
        }
        Table table = this.viewer.getTable();
        TableColumn[] cols = table.getColumns();
        CellEditor[] editors = this.viewer.getCellEditors();
        String[] props = this.model.getColumnProperties();
        this.viewer.setColumnProperties(props);
        if (props.length > cols.length) {
            newEditors = new CellEditor[props.length];
            if (editors != null) {
                System.arraycopy(editors, 0, newEditors, 0, editors.length);
            }
            int i = cols.length;
            while (i < props.length) {
                TableColumn col = new TableColumn(table, 16384);
                col.setText(TableElementModel.toColumnName(i));
                newEditors[i] = new TextCellEditor((Composite)table);
                ++i;
            }
            this.viewer.setCellEditors(newEditors);
        } else if (props.length < cols.length) {
            int i = props.length;
            while (i < cols.length) {
                cols[i].dispose();
                editors[i].dispose();
                ++i;
            }
            newEditors = new CellEditor[props.length];
            System.arraycopy(editors, 0, newEditors, 0, props.length);
            this.viewer.setCellEditors(newEditors);
        }
        this.viewer.refresh();
        cols = table.getColumns();
        int i = 0;
        while (i < cols.length) {
            cols[i].pack();
            ++i;
        }
    }

    void refreshTableLengthText() {
        String rows;
        String cols = String.valueOf(this.model.getColumnCount());
        if (!cols.equals(this.colsText.getText())) {
            this.colsText.setText(cols);
        }
        if (!(rows = String.valueOf(this.model.getRowCount())).equals(this.rowsText.getText())) {
            this.rowsText.setText(rows);
        }
    }

    void refreshButtonState() {
        Element e = this.getCurrentSelection();
        boolean enable = e != null;
        this.removeButton.setEnabled(enable);
        int currentIndex = -1;
        Element[] rows = this.model.getRows();
        int i = 0;
        while (i < rows.length) {
            if (rows[i].equals(e)) {
                currentIndex = i;
            }
            ++i;
        }
        this.upButton.setEnabled(enable && currentIndex > 0);
        this.downButton.setEnabled(enable && currentIndex < rows.length - 1);
    }

    Element getCurrentSelection() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        return sel != null ? (Element)sel.getFirstElement() : null;
    }
}

