/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.wizards.html;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.wizards.html.EditElementWizard;
import net.sourceforge.phpeclipse.wizards.html.IPreviewer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class EditElementWizardPage
extends WizardPage
implements IPreviewer {
    public static final int NEW = 0;
    public static final int MODIFY = 1;
    private static DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
    Composite extendComp;
    Text preview;
    private String elementName = null;
    int editType = 0;

    protected EditElementWizardPage(String pageName) {
        super(pageName);
    }

    public void createControl(Composite parent) {
        Composite base = new Composite(parent, 0);
        this.setControl((Control)base);
        base.setLayout((Layout)new GridLayout(1, false));
        Composite childControlBase = new Composite(base, 0);
        childControlBase.setLayoutData((Object)new GridData(1808));
        try {
            this.createChildControl(childControlBase);
        }
        catch (CoreException e) {
            PHPeclipsePlugin.log(e);
            return;
        }
        Composite previewBase = new Composite(base, 0);
        GridData gd = new GridData(768);
        previewBase.setLayoutData((Object)gd);
        previewBase.setLayout((Layout)new GridLayout(1, false));
        Label labe = new Label(previewBase, 0);
        labe.setText("Preview:");
        gd = new GridData(768);
        labe.setLayoutData((Object)gd);
        this.preview = new Text(previewBase, 2890);
        gd = new GridData(768);
        gd.widthHint = 0;
        gd.heightHint = this.preview.getLineHeight() * 4;
        this.preview.setLayoutData((Object)gd);
        this.refreshPreview();
    }

    protected abstract void createChildControl(Composite var1) throws CoreException;

    public abstract String getPreviewText();

    public void refreshPreview() {
        if (this.preview != null) {
            String text = this.getPreviewText();
            this.preview.setText(text == null ? "" : text);
        }
    }

    public String getElementName() {
        return this.elementName;
    }

    public void setElementName(String string) {
        this.elementName = string;
    }

    protected IFile getEditFile() {
        IFile file = null;
        IWizard wiz = this.getWizard();
        if (wiz instanceof EditElementWizard) {
            file = ((EditElementWizard)wiz).getCurrentEditFile();
        }
        return file;
    }

    protected void performFinish() {
        EditElementWizard wiz = (EditElementWizard)this.getWizard();
        ITextSelection sel = wiz.getSelection();
        IDocument doc = wiz.getDocument();
        int offset = sel.getOffset();
        try {
            doc.replace(offset, sel.getLength(), this.getPreviewText());
        }
        catch (BadLocationException e) {
            PHPeclipsePlugin.log(e);
        }
        int index = doc.get().indexOf(62, offset);
        if (index != -1) {
            wiz.setSelection((ITextSelection)new TextSelection(index + 1, 0));
        }
    }

    public int getEditType() {
        return this.editType;
    }

    public void setEditType(int i) {
        this.editType = i;
    }

    protected String getSelectionText() {
        return ((EditElementWizard)this.getWizard()).getSelection().getText();
    }

    protected Element getParsedSelectionText() {
        String selText = this.getSelectionText();
        try {
            InputSource source = new InputSource(new StringReader(selText));
            Document doc = docBuilderFactory.newDocumentBuilder().parse(source);
            return doc.getDocumentElement();
        }
        catch (SAXException sAXException) {
        }
        catch (IOException iOException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {}
        return null;
    }

    protected static String chooseContent(String text) {
        int b = -1;
        int e = -1;
        int len = text.length();
        int i = 0;
        while (i < len) {
            if (text.charAt(i) == '>') {
                b = i + 1;
                break;
            }
            ++i;
        }
        i = len - 1;
        while (i >= 0) {
            if (text.charAt(i) == '<') {
                e = i;
                break;
            }
            --i;
        }
        return b != -1 && e != -1 && b < len && e < len ? text.substring(b, e) : "";
    }
}

