/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.wizards;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import net.sourceforge.phpdt.internal.corext.codemanipulation.StubUtility;
import net.sourceforge.phpdt.internal.corext.template.php.CodeTemplateContext;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.wizards.PHPFileWizardPage;
import net.sourceforge.phpeclipse.wizards.PHPWizardMessages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class PHPFileWizard
extends Wizard
implements INewWizard {
    private PHPFileWizardPage page;
    private ISelection selection;

    public PHPFileWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(PHPWizardMessages.getString("WizardNewProjectCreationPage.windowTitle"));
    }

    public void addPages() {
        this.page = new PHPFileWizardPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String fileName = this.page.getFileName();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        PHPFileWizard.this.doFinish(containerName, fileName, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_5 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)PHPWizardMessages.getString("Wizard.error"), (String)realException.getMessage());
            return false;
        }
        return true;
    }

    private void doFinish(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(String.valueOf(PHPWizardMessages.getString("Wizard.Monitor.creating")) + " " + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(containerName));
        if (!resource.exists() || !(resource instanceof IContainer)) {
            this.throwCoreException(PHPWizardMessages.getString("Wizard.Monitor.containerDoesNotExistException"));
        }
        IContainer container = (IContainer)resource;
        final IFile file = container.getFile((IPath)new Path(fileName));
        IProject project = file.getProject();
        String projectName = project.getName();
        String className = PHPFileWizard.getClassName(fileName);
        try {
            InputStream stream = className == null ? this.openContentStream(fileName, projectName) : this.openContentStreamClass(className);
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        monitor.worked(1);
        monitor.setTaskName(PHPWizardMessages.getString("Wizard.Monitor.openingFile"));
        this.getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                try {
                    IDE.openEditor((IWorkbenchPage)page, (IFile)file, (boolean)true);
                }
                catch (PartInitException partInitException) {}
            }
        });
        monitor.worked(1);
    }

    private static final String getClassName(String fileName) {
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot == -1) {
            return null;
        }
        int precLastDot = fileName.lastIndexOf(46, lastDot - 1);
        if (precLastDot == -1) {
            return null;
        }
        if (!fileName.substring(precLastDot + 1, lastDot).toUpperCase().equals("CLASS")) {
            return null;
        }
        return fileName.substring(0, precLastDot);
    }

    private InputStream openContentStreamClass(String className) {
        StringBuffer contents = new StringBuffer("<?php\n\n");
        contents.append("class ");
        contents.append(className);
        contents.append(" {\n\n");
        contents.append("    function ");
        contents.append(className);
        contents.append("() {\n");
        contents.append("    }\n}\n?>");
        return new ByteArrayInputStream(contents.toString().getBytes());
    }

    private InputStream openContentStream(String fileName, String projectname) {
        Template template;
        block4: {
            try {
                template = PHPeclipsePlugin.getDefault().getCodeTemplateStore().findTemplate("newtype");
                if (template != null) break block4;
                return null;
            }
            catch (CoreException e) {
                e.printStackTrace();
                return null;
            }
        }
        String lineDelimiter = System.getProperty("line.separator", "\n");
        CodeTemplateContext context = new CodeTemplateContext(template.getContextTypeId(), null, lineDelimiter);
        context.setFileNameVariable(fileName, projectname);
        String content = StubUtility.evaluateTemplate(context, template);
        if (content == null) {
            content = "";
        }
        return new ByteArrayInputStream(content.getBytes());
    }

    private void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "net.sourceforge.phpeclipse.wizards", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

