/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.phpeditor.php;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.internal.ui.text.java.IPHPCompletionProposal;
import net.sourceforge.phpdt.internal.ui.text.java.PHPCompletionProposalComparator;
import net.sourceforge.phpdt.internal.ui.text.template.contentassist.TemplateEngine;
import net.sourceforge.phpdt.internal.ui.text.template.contentassist.TemplateProposal;
import net.sourceforge.phpdt.ui.IWorkingCopyManager;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationExtension;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;

public class HTMLCompletionProcessor
implements IContentAssistProcessor {
    protected IContextInformationValidator fValidator = new Validator();
    private TemplateEngine fTemplateEngine;
    private char[] fProposalAutoActivationSet;
    private PHPCompletionProposalComparator fComparator;
    private int fNumberOfComputedResults = 0;
    private IEditorPart fEditor;
    protected IWorkingCopyManager fManager;

    public HTMLCompletionProcessor(IEditorPart editor) {
        this.fEditor = editor;
        this.fManager = PHPeclipsePlugin.getDefault().getWorkingCopyManager();
        TemplateContextType contextType = PHPeclipsePlugin.getDefault().getTemplateContextRegistry().getContextType("html");
        if (contextType != null) {
            this.fTemplateEngine = new TemplateEngine(contextType);
        }
        this.fComparator = new PHPCompletionProposalComparator();
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        int contextInformationPosition = this.guessContextInformationPosition(viewer, documentOffset);
        return this.internalComputeCompletionProposals(viewer, documentOffset, contextInformationPosition);
    }

    private ICompletionProposal[] internalComputeCompletionProposals(ITextViewer viewer, int offset, int contextOffset) {
        viewer.getDocument();
        ICompilationUnit unit = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
        if (this.fTemplateEngine != null) {
            this.fTemplateEngine.reset();
            this.fTemplateEngine.complete(viewer, offset, unit);
            TemplateProposal[] templateResults = this.fTemplateEngine.getResults();
            ICompletionProposal[] total = new IPHPCompletionProposal[templateResults.length];
            System.arraycopy(templateResults, 0, total, 0, templateResults.length);
            ICompletionProposal[] results = total;
            this.fNumberOfComputedResults = results == null ? 0 : results.length;
            return this.order(results);
        }
        return new IPHPCompletionProposal[0];
    }

    private int guessContextInformationPosition(ITextViewer viewer, int offset) {
        int contextPosition = offset;
        viewer.getDocument();
        return contextPosition;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        int contextInformationPosition = this.guessContextInformationPosition(viewer, offset);
        List result = this.addContextInformations(viewer, contextInformationPosition);
        return result.toArray(new IContextInformation[result.size()]);
    }

    private List addContextInformations(ITextViewer viewer, int offset) {
        ICompletionProposal[] proposals = this.internalComputeCompletionProposals(viewer, offset, -1);
        ArrayList<ContextInformationWrapper> result = new ArrayList<ContextInformationWrapper>();
        int i = 0;
        while (i < proposals.length) {
            IContextInformation contextInformation = proposals[i].getContextInformation();
            if (contextInformation != null) {
                ContextInformationWrapper wrapper = new ContextInformationWrapper(contextInformation);
                wrapper.setContextInformationPosition(offset);
                result.add(wrapper);
            }
            ++i;
        }
        return result;
    }

    private ICompletionProposal[] order(ICompletionProposal[] proposals) {
        Arrays.sort(proposals, this.fComparator);
        return proposals;
    }

    public void orderProposalsAlphabetically(boolean order) {
        this.fComparator.setOrderAlphabetically(order);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.fProposalAutoActivationSet;
    }

    public void setCompletionProposalAutoActivationCharacters(char[] activationSet) {
        this.fProposalAutoActivationSet = activationSet;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return new char[0];
    }

    public IContextInformationValidator getContextInformationValidator() {
        return this.fValidator;
    }

    public String getErrorMessage() {
        return null;
    }

    private static class ContextInformationWrapper
    implements IContextInformation,
    IContextInformationExtension {
        private final IContextInformation fContextInformation;
        private int fPosition;

        public ContextInformationWrapper(IContextInformation contextInformation) {
            this.fContextInformation = contextInformation;
        }

        public String getContextDisplayString() {
            return this.fContextInformation.getContextDisplayString();
        }

        public Image getImage() {
            return this.fContextInformation.getImage();
        }

        public String getInformationDisplayString() {
            return this.fContextInformation.getInformationDisplayString();
        }

        public int getContextInformationPosition() {
            return this.fPosition;
        }

        public void setContextInformationPosition(int position) {
            this.fPosition = position;
        }
    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        protected int fInstallOffset;

        protected Validator() {
        }

        public boolean isContextInformationValid(int offset) {
            return Math.abs(this.fInstallOffset - offset) < 5;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.fInstallOffset = offset;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            return false;
        }
    }
}

