/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.phpeditor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.phpeclipse.phpeditor.IPainter;
import net.sourceforge.phpeclipse.phpeditor.IPositionManager;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;

public final class PaintManager
implements KeyListener,
MouseListener,
ISelectionChangedListener,
ITextListener,
ITextInputListener {
    private List fPainters = new ArrayList(2);
    private PositionManager fManager;
    private ISourceViewer fSourceViewer;
    private boolean fTextChanged = false;
    private boolean fAutoRepeat = false;

    public PaintManager(ISourceViewer sourceViewer) {
        this.fSourceViewer = sourceViewer;
    }

    public void addPainter(IPainter painter) {
        if (!this.fPainters.contains(painter)) {
            this.fPainters.add(painter);
            if (this.fPainters.size() == 1) {
                this.install();
            }
            painter.setPositionManager(this.fManager);
            painter.paint(8);
        }
    }

    public void removePainter(IPainter painter) {
        if (this.fPainters.remove(painter)) {
            painter.setPositionManager(null);
        }
        if (this.fPainters.size() == 0) {
            this.dispose();
        }
    }

    private void install() {
        this.fManager = new PositionManager();
        this.fManager.install(this.fSourceViewer.getDocument());
        this.fSourceViewer.addTextInputListener((ITextInputListener)this);
        ISelectionProvider provider = this.fSourceViewer.getSelectionProvider();
        provider.addSelectionChangedListener((ISelectionChangedListener)this);
        this.fSourceViewer.addTextListener((ITextListener)this);
        StyledText text = this.fSourceViewer.getTextWidget();
        text.addKeyListener((KeyListener)this);
        text.addMouseListener((MouseListener)this);
    }

    public void dispose() {
        if (this.fManager != null) {
            this.fManager.dispose();
            this.fManager = null;
        }
        Iterator e = this.fPainters.iterator();
        while (e.hasNext()) {
            ((IPainter)e.next()).dispose();
        }
        this.fPainters.clear();
        this.fSourceViewer.removeTextInputListener((ITextInputListener)this);
        ISelectionProvider provider = this.fSourceViewer.getSelectionProvider();
        if (provider != null) {
            provider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        this.fSourceViewer.removeTextListener((ITextListener)this);
        StyledText text = this.fSourceViewer.getTextWidget();
        if (text != null && !text.isDisposed()) {
            text.removeKeyListener((KeyListener)this);
            text.removeMouseListener((MouseListener)this);
        }
    }

    private void paint(int reason) {
        Iterator e = this.fPainters.iterator();
        while (e.hasNext()) {
            ((IPainter)e.next()).paint(reason);
        }
    }

    public void keyPressed(KeyEvent e) {
        this.paint(2);
    }

    public void keyReleased(KeyEvent e) {
    }

    public void mouseDoubleClick(MouseEvent e) {
    }

    public void mouseDown(MouseEvent e) {
        this.paint(4);
    }

    public void mouseUp(MouseEvent e) {
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.paint(0);
    }

    public void textChanged(TextEvent event) {
        if (!event.getViewerRedrawState()) {
            return;
        }
        this.fTextChanged = true;
        StyledText control = this.fSourceViewer.getTextWidget();
        if (control != null) {
            control.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (PaintManager.this.fTextChanged && PaintManager.this.fSourceViewer != null) {
                        PaintManager.this.paint(1);
                    }
                }
            });
        }
    }

    public void inputDocumentAboutToBeChanged(IDocument oldInput, IDocument newInput) {
        if (oldInput != null) {
            Iterator e = this.fPainters.iterator();
            while (e.hasNext()) {
                ((IPainter)e.next()).deactivate(false);
            }
            this.fManager.uninstall(oldInput);
        }
    }

    public void inputDocumentChanged(IDocument oldInput, IDocument newInput) {
        if (newInput != null) {
            this.fManager.install(newInput);
            this.paint(1);
        }
    }

    static class PaintPositionUpdater
    extends DefaultPositionUpdater {
        protected PaintPositionUpdater(String category) {
            super(category);
        }

        protected void adaptToInsert() {
            int myStart = this.fPosition.offset;
            int myEnd = this.fPosition.offset + this.fPosition.length;
            myEnd = Math.max(myStart, myEnd);
            int yoursStart = this.fOffset;
            int yoursEnd = this.fOffset + this.fReplaceLength;
            yoursEnd = Math.max(yoursStart, yoursEnd);
            if (myEnd < yoursStart) {
                return;
            }
            if (myStart <= yoursStart) {
                this.fPosition.length += this.fReplaceLength;
            } else {
                this.fPosition.offset += this.fReplaceLength;
            }
        }
    }

    static class PositionManager
    implements IPositionManager {
        private IDocument fDocument;
        private IPositionUpdater fPositionUpdater;
        private String fCategory = String.valueOf(this.getClass().getName()) + this.hashCode();

        public PositionManager() {
            this.fPositionUpdater = new PaintPositionUpdater(this.fCategory);
        }

        public void install(IDocument document) {
            this.fDocument = document;
            this.fDocument.addPositionCategory(this.fCategory);
            this.fDocument.addPositionUpdater(this.fPositionUpdater);
        }

        public void dispose() {
            this.uninstall(this.fDocument);
        }

        public void uninstall(IDocument document) {
            if (document == this.fDocument && document != null) {
                try {
                    this.fDocument.removePositionUpdater(this.fPositionUpdater);
                    this.fDocument.removePositionCategory(this.fCategory);
                }
                catch (BadPositionCategoryException badPositionCategoryException) {}
                this.fDocument = null;
            }
        }

        public void addManagedPosition(Position position) {
            try {
                this.fDocument.addPosition(this.fCategory, position);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
            }
            catch (BadLocationException badLocationException) {}
        }

        public void removeManagedPosition(Position position) {
            try {
                this.fDocument.removePosition(this.fCategory, position);
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }
    }
}

