/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpeclipse.obfuscator;

import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import net.sourceforge.phpdt.core.compiler.ITerminalSymbols;
import net.sourceforge.phpdt.core.compiler.InvalidInputException;
import net.sourceforge.phpdt.internal.compiler.parser.Scanner;
import net.sourceforge.phpdt.internal.compiler.parser.SyntaxError;
import net.sourceforge.phpdt.internal.compiler.util.Util;
import net.sourceforge.phpdt.internal.ui.util.PHPFileUtil;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import net.sourceforge.phpeclipse.obfuscator.PHPIdentifier;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

public class ObfuscatorPass2Exporter
implements ITerminalSymbols {
    private Scanner fScanner;
    private int fToken;
    private int fCounter;
    protected HashMap fIdentifierMap;

    public ObfuscatorPass2Exporter(Scanner scanner, HashMap identifierMap) {
        this.fScanner = scanner;
        this.fIdentifierMap = identifierMap;
        this.fCounter = 0;
    }

    private void getNextToken() {
        try {
            this.fToken = this.fScanner.getNextToken();
            return;
        }
        catch (InvalidInputException invalidInputException) {
            this.fToken = 1;
            return;
        }
    }

    private boolean obfuscate(StringBuffer buf) {
        int startPosition = 0;
        int lastPosition = 0;
        PHPeclipsePlugin.getDefault().getPreferenceStore();
        try {
            while (this.fToken != 0 && this.fToken != 1) {
                PHPIdentifier value;
                int len;
                String identifier;
                if (this.fToken == 150) {
                    identifier = new String(this.fScanner.getCurrentIdentifierSource());
                    lastPosition = this.fScanner.startPosition;
                    len = lastPosition - startPosition;
                    buf.append(this.fScanner.source, startPosition, len);
                    value = (PHPIdentifier)this.fIdentifierMap.get(identifier);
                    if (value != null) {
                        String obfuscatedIdentifier = value.getIdentifier();
                        if (obfuscatedIdentifier == null) {
                            buf.append("$v" + Integer.toString(this.fCounter));
                            value.setIdentifier("$v" + Integer.toString(this.fCounter++));
                        } else {
                            buf.append(obfuscatedIdentifier);
                        }
                    } else {
                        buf.append(identifier);
                    }
                    startPosition = this.fScanner.currentPosition;
                    this.getNextToken();
                } else if (this.fToken == 138) {
                    identifier = new String(this.fScanner.getCurrentIdentifierSource());
                    lastPosition = this.fScanner.startPosition;
                    len = lastPosition - startPosition;
                    buf.append(this.fScanner.source, startPosition, len);
                    value = (PHPIdentifier)this.fIdentifierMap.get(identifier);
                    if (value != null) {
                        String obfuscatedIdentifier = value.getIdentifier();
                        if (obfuscatedIdentifier == null) {
                            buf.append("_" + Integer.toString(this.fCounter));
                            value.setIdentifier("_" + Integer.toString(this.fCounter++));
                        } else {
                            buf.append(obfuscatedIdentifier);
                        }
                    } else {
                        buf.append(identifier);
                    }
                    startPosition = this.fScanner.currentPosition;
                    this.getNextToken();
                } else if (this.fToken == 901 || this.fToken == 902 || this.fToken == 903) {
                    lastPosition = this.fScanner.startPosition;
                    buf.append(this.fScanner.source, startPosition, lastPosition - startPosition);
                    startPosition = this.fScanner.currentPosition;
                    this.getNextToken();
                } else if (this.fToken == 136) {
                    int i = this.fScanner.startPosition;
                    ArrayList<String> varList = new ArrayList<String>();
                    lastPosition = this.fScanner.startPosition;
                    int len2 = lastPosition - startPosition;
                    buf.append(this.fScanner.source, startPosition, len2);
                    while (i < this.fScanner.currentPosition) {
                        char currentCharacter;
                        if ((currentCharacter = this.fScanner.source[i++]) != '$' || this.fScanner.source[i - 2] == '\\') continue;
                        StringBuffer varName = new StringBuffer();
                        varName.append("$");
                        while (i < this.fScanner.currentPosition) {
                            if (!Scanner.isPHPIdentifierPart(currentCharacter = this.fScanner.source[i++])) break;
                            varName.append(currentCharacter);
                        }
                        varList.add(varName.toString());
                    }
                    StringBuffer stringLiteral = new StringBuffer();
                    stringLiteral.append(this.fScanner.source, this.fScanner.startPosition, this.fScanner.currentPosition - this.fScanner.startPosition);
                    int j = 0;
                    while (j < varList.size()) {
                        String replacement;
                        String stringIdent = (String)varList.get(j);
                        len2 = stringIdent.length();
                        value = (PHPIdentifier)this.fIdentifierMap.get(stringIdent);
                        if (value != null) {
                            String obfuscatedIdentifier = value.getIdentifier();
                            if (obfuscatedIdentifier == null) {
                                replacement = "$v" + Integer.toString(this.fCounter);
                                value.setIdentifier("$v" + Integer.toString(this.fCounter++));
                            } else {
                                replacement = obfuscatedIdentifier;
                            }
                        } else {
                            replacement = stringIdent;
                        }
                        int index = stringLiteral.indexOf(stringIdent);
                        if (index >= 0) {
                            if (index > 0 && stringLiteral.charAt(index - 1) != '\\') {
                                stringLiteral.replace(index, index + stringIdent.length(), replacement);
                            } else if (index == 0) {
                                stringLiteral.replace(index, index + stringIdent.length(), replacement);
                            }
                        }
                        ++j;
                    }
                    buf.append(stringLiteral);
                    startPosition = this.fScanner.currentPosition;
                    this.getNextToken();
                }
                if (this.fToken == 50) {
                    this.getNextToken();
                    if (this.fToken != 138) continue;
                    identifier = new String(this.fScanner.getCurrentIdentifierSource());
                    lastPosition = this.fScanner.startPosition;
                    len = lastPosition - startPosition;
                    buf.append(this.fScanner.source, startPosition, len);
                    value = (PHPIdentifier)this.fIdentifierMap.get("$" + identifier);
                    if (value != null && value.isVariable()) {
                        String obfuscatedIdentifier = value.getIdentifier();
                        if (obfuscatedIdentifier == null) {
                            buf.append("v" + Integer.toString(this.fCounter));
                            value.setIdentifier("$v" + Integer.toString(this.fCounter++));
                        } else if (obfuscatedIdentifier.charAt(0) == '$') {
                            buf.append(obfuscatedIdentifier.substring(1));
                        } else {
                            buf.append(obfuscatedIdentifier);
                        }
                    } else {
                        buf.append(identifier);
                    }
                    startPosition = this.fScanner.currentPosition;
                    this.getNextToken();
                    continue;
                }
                this.getNextToken();
            }
            if (startPosition < this.fScanner.source.length) {
                buf.append(this.fScanner.source, startPosition, this.fScanner.source.length - startPosition);
            }
            return true;
        }
        catch (SyntaxError syntaxError) {
            return false;
        }
    }

    public void createFolder(IPath destinationPath) {
        new File(destinationPath.toOSString()).mkdir();
    }

    public void write(IResource resource, IPath destinationPath) throws CoreException, IOException {
        if (resource.getType() == 1) {
            this.writeFile((IFile)resource, destinationPath);
        } else {
            this.writeChildren((IContainer)resource, destinationPath);
        }
    }

    protected void writeChildren(IContainer folder, IPath destinationPath) throws CoreException, IOException {
        if (folder.isAccessible()) {
            IResource[] children = folder.members();
            int i = 0;
            while (i < children.length) {
                IResource child = children[i];
                this.writeResource(child, destinationPath.append(child.getName()));
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeFile(IFile file, IPath destinationPath) throws IOException, CoreException {
        if (!PHPFileUtil.isPHPFile(file)) {
            this.copyFile(file, destinationPath);
            return;
        }
        BufferedInputStream stream = null;
        char[] charArray = null;
        try {
            try {
                stream = new BufferedInputStream(file.getContents());
                charArray = Util.getInputStreamAsCharArray(stream, -1, null);
            }
            catch (IOException iOException) {
                Object var5_5 = null;
                try {
                    if (stream == null) return;
                    ((InputStream)stream).close();
                    return;
                }
                catch (IOException iOException2) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {}
            catch (IOException iOException) {}
            if (stream == null) throw throwable;
            ((InputStream)stream).close();
            throw throwable;
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (IOException iOException) {}
        if (stream != null) {
            ((InputStream)stream).close();
        }
        if (charArray == null) {
            return;
        }
        this.fScanner.setSource(charArray);
        this.fScanner.setPHPMode(false);
        this.fToken = 0;
        this.getNextToken();
        StringBuffer buf = new StringBuffer();
        if (!this.obfuscate(buf)) {
            this.copyFile(file, destinationPath);
            return;
        }
        BufferedWriter bw = new BufferedWriter(new FileWriter(destinationPath.toOSString()));
        bw.write(buf.toString());
        bw.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void copyFile(IFile file, IPath destinationPath) throws FileNotFoundException, CoreException, IOException {
        InputStream contentStream;
        block5: {
            FileOutputStream output = null;
            contentStream = null;
            try {
                output = new FileOutputStream(destinationPath.toOSString());
                contentStream = file.getContents(false);
                int chunkSize = contentStream.available();
                byte[] readBuffer = new byte[chunkSize];
                int n = contentStream.read(readBuffer);
                while (n > 0) {
                    output.write(readBuffer);
                    n = contentStream.read(readBuffer);
                }
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                if (output != null) {
                    output.close();
                }
                if (contentStream == null) throw throwable;
                contentStream.close();
                throw throwable;
            }
            {
                Object var8_10 = null;
                if (output == null) break block5;
            }
            output.close();
        }
        if (contentStream == null) return;
        contentStream.close();
    }

    protected void writeResource(IResource resource, IPath destinationPath) throws CoreException, IOException {
        if (resource.getType() == 1) {
            this.writeFile((IFile)resource, destinationPath);
        } else {
            this.createFolder(destinationPath);
            this.writeChildren((IContainer)resource, destinationPath);
        }
    }
}

