/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.ltk.ui.wizards;

import net.sourceforge.phpdt.ltk.core.RenameIdentifierInfo;
import net.sourceforge.phpdt.ltk.ui.UITexts;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class RenameIdentifierPage
extends UserInputWizardPage {
    private static final String DS_KEY;
    private static final String DS_UPDATE_BUNDLE = "UPDATE_BUNDLE";
    private static final String DS_ALL_PROJECTS = "ALL_PROJECTS";
    private final RenameIdentifierInfo info;
    private IDialogSettings dialogSettings;
    private Text txtNewName;
    private Button cbUpdateBundle;
    private Button cbAllProjects;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.phpdt.ltk.ui.wizards.RenameIdentifierPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        DS_KEY = clazz.getName();
    }

    public RenameIdentifierPage(RenameIdentifierInfo info) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sourceforge.phpdt.ltk.ui.wizards.RenameIdentifierPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(clazz.getName());
        this.info = info;
        this.initDialogSettings();
    }

    public void createControl(Composite parent) {
        Composite composite = this.createRootComposite(parent);
        this.setControl((Control)composite);
        this.createLblNewName(composite);
        this.createTxtNewName(composite);
        this.createCbUpdateBundle(composite);
        this.createCbAllProjects(composite);
        this.validate();
    }

    private Composite createRootComposite(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 10;
        gridLayout.marginHeight = 10;
        result.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)result);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private void createLblNewName(Composite composite) {
        Label lblNewName = new Label(composite, 0);
        lblNewName.setText(UITexts.renamePropertyInputPage_lblNewName);
    }

    private void createTxtNewName(Composite composite) {
        this.txtNewName = new Text(composite, 2048);
        this.txtNewName.setText(this.info.getOldName());
        this.txtNewName.setLayoutData((Object)new GridData(768));
        this.txtNewName.selectAll();
        this.txtNewName.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                RenameIdentifierPage.this.info.setNewName(RenameIdentifierPage.this.txtNewName.getText());
                RenameIdentifierPage.this.validate();
            }
        });
    }

    private void createCbUpdateBundle(Composite composite) {
        String texts = UITexts.renamePropertyInputPage_cbUpdateBundle;
        this.cbUpdateBundle = this.createCheckbox(composite, texts);
        this.cbUpdateBundle.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean selected = RenameIdentifierPage.this.cbUpdateBundle.getSelection();
                RenameIdentifierPage.this.dialogSettings.put(RenameIdentifierPage.DS_UPDATE_BUNDLE, selected);
                RenameIdentifierPage.this.info.setUpdateProject(selected);
            }
        });
        this.initUpdateBundleOption();
    }

    private void createCbAllProjects(Composite composite) {
        String text = UITexts.renamePropertyInputPage_cbAllProjects;
        this.cbAllProjects = this.createCheckbox(composite, text);
        this.cbAllProjects.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                boolean selected = RenameIdentifierPage.this.cbAllProjects.getSelection();
                RenameIdentifierPage.this.dialogSettings.put(RenameIdentifierPage.DS_ALL_PROJECTS, selected);
                RenameIdentifierPage.this.info.setAllProjects(selected);
                RenameIdentifierPage.this.getRefactoringWizard().setForcePreviewReview(selected);
            }
        });
        this.initAllProjectsOption();
    }

    private Button createCheckbox(Composite composite, String text) {
        Button result = new Button(composite, 32);
        result.setText(text);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        result.setLayoutData((Object)gridData);
        return result;
    }

    private void initDialogSettings() {
        IDialogSettings ds = PHPeclipsePlugin.getDefault().getDialogSettings();
        this.dialogSettings = ds.getSection(DS_KEY);
        if (this.dialogSettings == null) {
            this.dialogSettings = ds.addNewSection(DS_KEY);
            this.dialogSettings.put(DS_UPDATE_BUNDLE, true);
            this.dialogSettings.put(DS_ALL_PROJECTS, false);
        }
    }

    private void validate() {
        String txt = this.txtNewName.getText();
        this.setPageComplete(txt.length() > 0 && !txt.equals(this.info.getOldName()));
    }

    private void initUpdateBundleOption() {
        boolean updateRefs = this.dialogSettings.getBoolean(DS_UPDATE_BUNDLE);
        this.cbUpdateBundle.setSelection(updateRefs);
        this.info.setUpdateProject(updateRefs);
    }

    private void initAllProjectsOption() {
        boolean allProjects = this.dialogSettings.getBoolean(DS_ALL_PROJECTS);
        this.cbAllProjects.setSelection(allProjects);
        this.info.setAllProjects(allProjects);
    }
}

