/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.wizards.dialogfields;

import net.sourceforge.phpdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class DialogField {
    private Label fLabel = null;
    protected String fLabelText = "";
    private IDialogFieldListener fDialogFieldListener;
    private boolean fEnabled = true;

    public void setLabelText(String labeltext) {
        this.fLabelText = labeltext;
    }

    public final void setDialogFieldListener(IDialogFieldListener listener) {
        this.fDialogFieldListener = listener;
    }

    public void dialogFieldChanged() {
        if (this.fDialogFieldListener != null) {
            this.fDialogFieldListener.dialogFieldChanged(this);
        }
    }

    public boolean setFocus() {
        return false;
    }

    public void postSetFocusOnDialogField(Display display) {
        if (display != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    DialogField.this.setFocus();
                }
            });
        }
    }

    public Control[] doFillIntoGrid(Composite parent, int nColumns) {
        this.assertEnoughColumns(nColumns);
        Label label = this.getLabelControl(parent);
        label.setLayoutData((Object)DialogField.gridDataForLabel(nColumns));
        return new Control[]{label};
    }

    public int getNumberOfControls() {
        return 1;
    }

    protected static GridData gridDataForLabel(int span) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = span;
        return gd;
    }

    public Label getLabelControl(Composite parent) {
        if (this.fLabel == null) {
            this.assertCompositeNotNull(parent);
            this.fLabel = new Label(parent, 16448);
            this.fLabel.setFont(parent.getFont());
            this.fLabel.setEnabled(this.fEnabled);
            if (this.fLabelText != null && !"".equals(this.fLabelText)) {
                this.fLabel.setText(this.fLabelText);
            } else {
                this.fLabel.setText(".");
                this.fLabel.setVisible(false);
            }
        }
        return this.fLabel;
    }

    public static Control createEmptySpace(Composite parent) {
        return DialogField.createEmptySpace(parent, 1);
    }

    public static Control createEmptySpace(Composite parent, int span) {
        Label label = new Label(parent, 16384);
        GridData gd = new GridData();
        gd.horizontalAlignment = 1;
        gd.grabExcessHorizontalSpace = false;
        gd.horizontalSpan = span;
        gd.horizontalIndent = 0;
        gd.widthHint = 0;
        gd.heightHint = 0;
        label.setLayoutData((Object)gd);
        return label;
    }

    protected final boolean isOkToUse(Control control) {
        return control != null && !control.isDisposed();
    }

    public final void setEnabled(boolean enabled) {
        if (enabled != this.fEnabled) {
            this.fEnabled = enabled;
            this.updateEnableState();
        }
    }

    protected void updateEnableState() {
        if (this.fLabel != null) {
            this.fLabel.setEnabled(this.fEnabled);
        }
    }

    public final boolean isEnabled() {
        return this.fEnabled;
    }

    protected final void assertCompositeNotNull(Composite comp) {
        Assert.isNotNull((Object)comp, (String)"uncreated control requested with composite null");
    }

    protected final void assertEnoughColumns(int nColumns) {
        Assert.isTrue((nColumns >= this.getNumberOfControls() ? 1 : 0) != 0, (String)"given number of columns is too small");
    }
}

