/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.util;

import java.util.Comparator;
import java.util.HashSet;
import java.util.Vector;
import net.sourceforge.phpdt.internal.ui.util.StringMatcher;
import net.sourceforge.phpdt.internal.ui.util.TwoArrayQuickSorter;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class FilteredList
extends Composite {
    private Table fList;
    private ILabelProvider fRenderer;
    private boolean fMatchEmtpyString = true;
    private boolean fIgnoreCase;
    private boolean fAllowDuplicates;
    private String fFilter = "";
    private TwoArrayQuickSorter fSorter;
    private Object[] fElements = new Object[0];
    private Label[] fLabels;
    private Vector fImages = new Vector();
    private int[] fFoldedIndices;
    private int fFoldedCount;
    private int[] fFilteredIndices;
    private int fFilteredCount;
    private FilterMatcher fFilterMatcher = new DefaultFilterMatcher();
    private Comparator fComparator;

    public FilteredList(Composite parent, int style, ILabelProvider renderer, boolean ignoreCase, boolean allowDuplicates, boolean matchEmptyString) {
        super(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.fList = new Table((Composite)this, style);
        this.fList.setLayoutData((Object)new GridData(1808));
        this.fList.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                FilteredList.this.fRenderer.dispose();
            }
        });
        this.fRenderer = renderer;
        this.fIgnoreCase = ignoreCase;
        this.fSorter = new TwoArrayQuickSorter(new LabelComparator(ignoreCase));
        this.fAllowDuplicates = allowDuplicates;
        this.fMatchEmtpyString = matchEmptyString;
    }

    public void setElements(Object[] elements) {
        if (elements == null) {
            this.fElements = new Object[0];
        } else {
            this.fElements = new Object[elements.length];
            System.arraycopy(elements, 0, this.fElements, 0, elements.length);
        }
        int length = this.fElements.length;
        this.fLabels = new Label[length];
        HashSet<Image> imageSet = new HashSet<Image>();
        int i = 0;
        while (i != length) {
            String text = this.fRenderer.getText(this.fElements[i]);
            Image image = this.fRenderer.getImage(this.fElements[i]);
            this.fLabels[i] = new Label(text, image);
            imageSet.add(image);
            ++i;
        }
        this.fImages.clear();
        this.fImages.addAll(imageSet);
        this.fSorter.sort(this.fLabels, this.fElements);
        this.fFilteredIndices = new int[length];
        this.fFilteredCount = this.filter();
        this.fFoldedIndices = new int[length];
        this.fFoldedCount = this.fold();
        this.updateList();
    }

    public boolean isEmpty() {
        return this.fElements == null || this.fElements.length == 0;
    }

    public void setFilterMatcher(FilterMatcher filterMatcher) {
        Assert.isNotNull((Object)filterMatcher);
        this.fFilterMatcher = filterMatcher;
    }

    public void setComparator(Comparator comparator) {
        Assert.isNotNull((Object)comparator);
        this.fComparator = comparator;
    }

    public void addSelectionListener(SelectionListener listener) {
        this.fList.addSelectionListener(listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.fList.removeSelectionListener(listener);
    }

    public void setSelection(int[] selection) {
        this.fList.setSelection(selection);
    }

    public int[] getSelectionIndices() {
        return this.fList.getSelectionIndices();
    }

    public int getSelectionIndex() {
        return this.fList.getSelectionIndex();
    }

    public void setSelection(Object[] elements) {
        if (elements == null || this.fElements == null) {
            return;
        }
        int[] indices = new int[elements.length];
        int i = 0;
        while (i != elements.length) {
            int j = 0;
            while (j != this.fFoldedCount) {
                int max = j == this.fFoldedCount - 1 ? this.fFilteredCount : this.fFoldedIndices[j + 1];
                int l = this.fFoldedIndices[j];
                while (l != max) {
                    if (this.fElements[this.fFilteredIndices[l]].equals(elements[i])) {
                        indices[i] = j;
                        break;
                    }
                    ++l;
                }
                if (l != max) break;
                ++j;
            }
            if (j == this.fFoldedCount) {
                indices[i] = 0;
            }
            ++i;
        }
        this.fList.setSelection(indices);
    }

    public Object[] getSelection() {
        if (this.fList.isDisposed() || this.fList.getSelectionCount() == 0) {
            return new Object[0];
        }
        int[] indices = this.fList.getSelectionIndices();
        Object[] elements = new Object[indices.length];
        int i = 0;
        while (i != indices.length) {
            elements[i] = this.fElements[this.fFilteredIndices[this.fFoldedIndices[indices[i]]]];
            ++i;
        }
        return elements;
    }

    public void setFilter(String filter) {
        this.fFilter = filter == null ? "" : filter;
        this.fFilteredCount = this.filter();
        this.fFoldedCount = this.fold();
        this.updateList();
    }

    public String getFilter() {
        return this.fFilter;
    }

    public Object[] getFoldedElements(int index) {
        if (index < 0 || index >= this.fFoldedCount) {
            return null;
        }
        int start = this.fFoldedIndices[index];
        int count = index == this.fFoldedCount - 1 ? this.fFilteredCount - start : this.fFoldedIndices[index + 1] - start;
        Object[] elements = new Object[count];
        int i = 0;
        while (i != count) {
            elements[i] = this.fElements[this.fFilteredIndices[start + i]];
            ++i;
        }
        return elements;
    }

    private int fold() {
        if (this.fAllowDuplicates) {
            int i = 0;
            while (i != this.fFilteredCount) {
                this.fFoldedIndices[i] = i;
                ++i;
            }
            return this.fFilteredCount;
        }
        int k = 0;
        Label last = null;
        int i = 0;
        while (i != this.fFilteredCount) {
            int j = this.fFilteredIndices[i];
            Label current = this.fLabels[j];
            if (!current.equals(last)) {
                this.fFoldedIndices[k] = i;
                ++k;
                last = current;
            }
            ++i;
        }
        return k;
    }

    private int filter() {
        if (!(this.fFilter != null && this.fFilter.length() != 0 || this.fMatchEmtpyString)) {
            return 0;
        }
        this.fFilterMatcher.setFilter(this.fFilter.trim(), this.fIgnoreCase, false);
        int k = 0;
        int i = 0;
        while (i != this.fElements.length) {
            if (this.fFilterMatcher.match(this.fElements[i])) {
                this.fFilteredIndices[k++] = i;
            }
            ++i;
        }
        return k;
    }

    private void updateList() {
        if (this.fList.isDisposed()) {
            return;
        }
        this.fList.setRedraw(false);
        int itemCount = this.fList.getItemCount();
        if (this.fFoldedCount < itemCount) {
            this.fList.remove(0, itemCount - this.fFoldedCount - 1);
        } else if (this.fFoldedCount > itemCount) {
            int i = 0;
            while (i != this.fFoldedCount - itemCount) {
                new TableItem(this.fList, 0);
                ++i;
            }
        }
        TableItem[] items = this.fList.getItems();
        int i = 0;
        while (i != this.fFoldedCount) {
            TableItem item = items[i];
            Label label = this.fLabels[this.fFilteredIndices[this.fFoldedIndices[i]]];
            item.setText(label.string);
            item.setImage(label.image);
            ++i;
        }
        if (this.fList.getItemCount() > 0) {
            this.fList.setSelection(0);
        }
        this.fList.setRedraw(true);
        this.fList.notifyListeners(13, new Event());
    }

    private class DefaultFilterMatcher
    implements FilterMatcher {
        private StringMatcher fMatcher;

        private DefaultFilterMatcher() {
        }

        public void setFilter(String pattern, boolean ignoreCase, boolean ignoreWildCards) {
            this.fMatcher = new StringMatcher(String.valueOf(pattern) + '*', ignoreCase, ignoreWildCards);
        }

        public boolean match(Object element) {
            return this.fMatcher.match(FilteredList.this.fRenderer.getText(element));
        }
    }

    public static interface FilterMatcher {
        public void setFilter(String var1, boolean var2, boolean var3);

        public boolean match(Object var1);
    }

    private static class Label {
        public final String string;
        public final Image image;

        public Label(String string, Image image) {
            this.string = string;
            this.image = image;
        }

        public boolean equals(Label label) {
            if (label == null) {
                return false;
            }
            return this.string.equals(label.string) && this.image.equals((Object)label.image);
        }
    }

    private final class LabelComparator
    implements Comparator {
        private boolean fIgnoreCase;

        LabelComparator(boolean ignoreCase) {
            this.fIgnoreCase = ignoreCase;
        }

        public int compare(Object left, Object right) {
            Label leftLabel = (Label)left;
            Label rightLabel = (Label)right;
            int value = FilteredList.this.fComparator == null ? (this.fIgnoreCase ? leftLabel.string.compareToIgnoreCase(rightLabel.string) : leftLabel.string.compareTo(rightLabel.string)) : FilteredList.this.fComparator.compare(leftLabel.string, rightLabel.string);
            if (value != 0) {
                return value;
            }
            if (leftLabel.image == null) {
                return rightLabel.image == null ? 0 : -1;
            }
            if (rightLabel.image == null) {
                return 1;
            }
            return FilteredList.this.fImages.indexOf(leftLabel.image) - FilteredList.this.fImages.indexOf(rightLabel.image);
        }
    }
}

