/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text.template.contentassist;

import java.util.ArrayList;
import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.internal.corext.Assert;
import net.sourceforge.phpdt.internal.corext.template.php.CompilationUnitContext;
import net.sourceforge.phpdt.internal.corext.template.php.CompilationUnitContextType;
import net.sourceforge.phpdt.internal.ui.PHPUiImages;
import net.sourceforge.phpdt.internal.ui.text.template.contentassist.TemplateProposal;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.swt.graphics.Point;

public class TemplateEngine {
    private static final String $_LINE_SELECTION = "${line_selection}";
    private static final String $_WORD_SELECTION = "${word_selection}";
    private TemplateContextType fContextType;
    private ArrayList fProposals = new ArrayList();

    public TemplateEngine(TemplateContextType contextType) {
        Assert.isNotNull(contextType);
        this.fContextType = contextType;
    }

    public void reset() {
        this.fProposals.clear();
    }

    public TemplateProposal[] getResults() {
        return this.fProposals.toArray(new TemplateProposal[this.fProposals.size()]);
    }

    public void complete(ITextViewer viewer, int completionPosition, ICompilationUnit compilationUnit) {
        IDocument document = viewer.getDocument();
        if (!(this.fContextType instanceof CompilationUnitContextType)) {
            return;
        }
        Point selection = viewer.getSelectedRange();
        String selectedText = null;
        if (selection.y != 0) {
            try {
                selectedText = document.get(selection.x, selection.y);
            }
            catch (BadLocationException badLocationException) {}
        }
        CompilationUnitContext context = ((CompilationUnitContextType)this.fContextType).createContext(document, completionPosition, selection.y, compilationUnit);
        context.setVariable("selection", selectedText);
        int start = context.getStart();
        int end = context.getEnd();
        Region region = new Region(start, end - start);
        Template[] templates = PHPeclipsePlugin.getDefault().getTemplateStore().getTemplates();
        if (selection.y == 0) {
            int i = 0;
            while (i != templates.length) {
                if (context.canEvaluate(templates[i])) {
                    this.fProposals.add(new TemplateProposal(templates[i], (TemplateContext)context, (IRegion)region, PHPUiImages.get("net.sourceforge.phpdt.internal.ui.template_obj.gif")));
                }
                ++i;
            }
        } else {
            if (context.getKey().length() == 0) {
                context.setForceEvaluation(true);
            }
            boolean multipleLinesSelected = this.areMultipleLinesSelected(viewer);
            int i = 0;
            while (i != templates.length) {
                Template template = templates[i];
                if (context.canEvaluate(template) && template.getContextTypeId().equals(context.getContextType().getId()) && (!multipleLinesSelected && template.getPattern().indexOf($_WORD_SELECTION) != -1 || multipleLinesSelected && template.getPattern().indexOf($_LINE_SELECTION) != -1)) {
                    this.fProposals.add(new TemplateProposal(templates[i], (TemplateContext)context, (IRegion)region, PHPUiImages.get("net.sourceforge.phpdt.internal.ui.template_obj.gif")));
                }
                ++i;
            }
        }
    }

    private boolean areMultipleLinesSelected(ITextViewer viewer) {
        if (viewer == null) {
            return false;
        }
        Point s = viewer.getSelectedRange();
        if (s.y == 0) {
            return false;
        }
        try {
            IDocument document = viewer.getDocument();
            int startLine = document.getLineOfOffset(s.x);
            int endLine = document.getLineOfOffset(s.x + s.y);
            IRegion line = document.getLineInformation(startLine);
            return startLine != endLine || s.x == line.getOffset() && s.y == line.getLength();
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }
}

