/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text.template;

import net.sourceforge.phpdt.internal.corext.template.TemplateMessages;
import net.sourceforge.phpdt.internal.corext.template.php.JavaContext;
import net.sourceforge.phpdt.internal.ui.text.link.LinkedPositionManager;
import net.sourceforge.phpdt.internal.ui.text.link.LinkedPositionUI;
import net.sourceforge.phpdt.internal.ui.text.template.AbstractProposal;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.swt.graphics.Image;

public class IdentifierProposal
extends AbstractProposal {
    private final TemplateContext fContext;
    private final Image fImage_fun;
    private final Image fImage_var;
    private final IRegion fRegion;
    private final String fTemplate;

    public IdentifierProposal(String template, TemplateContext context, IRegion region, ITextViewer viewer, Image image_fun, Image image_var) {
        super(viewer);
        this.fTemplate = template;
        this.fContext = context;
        this.fImage_fun = image_fun;
        this.fImage_var = image_var;
        this.fRegion = region;
    }

    public void apply(IDocument document) {
        try {
            int start = this.fRegion.getOffset();
            int end = this.fRegion.getOffset() + this.fRegion.getLength();
            document.replace(start, end - start, this.fTemplate);
            LinkedPositionManager manager = new LinkedPositionManager(document);
            LinkedPositionUI editor = new LinkedPositionUI(this.fViewer, manager);
            editor.setFinalCaretOffset(this.fTemplate.length() + start);
            editor.enter();
            this.fSelectedRegion = editor.getSelectedRegion();
        }
        catch (BadLocationException e) {
            PHPeclipsePlugin.log(e);
            this.openErrorDialog(e);
        }
    }

    public String getAdditionalProposalInfo() {
        return IdentifierProposal.textToHTML(this.fTemplate);
    }

    public String getDisplayString() {
        return String.valueOf(this.fTemplate) + TemplateMessages.getString("TemplateProposal.delimiter") + this.fTemplate;
    }

    public Image getImage() {
        if (this.fTemplate.charAt(0) == '$') {
            return this.fImage_var;
        }
        return this.fImage_fun;
    }

    public int getRelevance() {
        if (this.fContext instanceof JavaContext) {
            JavaContext context = (JavaContext)this.fContext;
            switch (context.getCharacterBeforeStart()) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    return 50;
                }
            }
            return 0;
        }
        return 50;
    }
}

