/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text.spelling;

import java.text.MessageFormat;
import java.util.Locale;
import net.sourceforge.phpdt.core.IProblemRequestor;
import net.sourceforge.phpdt.core.compiler.IProblem;
import net.sourceforge.phpdt.internal.ui.PHPUIMessages;
import net.sourceforge.phpdt.internal.ui.text.spelling.SpellCheckEngine;
import net.sourceforge.phpdt.internal.ui.text.spelling.SpellCheckIterator;
import net.sourceforge.phpdt.internal.ui.text.spelling.engine.ISpellCheckEngine;
import net.sourceforge.phpdt.internal.ui.text.spelling.engine.ISpellChecker;
import net.sourceforge.phpdt.internal.ui.text.spelling.engine.ISpellEvent;
import net.sourceforge.phpdt.internal.ui.text.spelling.engine.ISpellEventListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.ITextEditor;

public class SpellReconcileStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
ISpellEventListener {
    private IDocument fDocument = null;
    private final ITextEditor fEditor;
    private Locale fLocale = SpellCheckEngine.getDefaultLocale();
    private final String fPartitioning;
    private final IPreferenceStore fPreferences;
    private IProblemRequestor fRequestor;

    public SpellReconcileStrategy(ITextEditor editor, String partitioning, IPreferenceStore store) {
        this.fEditor = editor;
        this.fPartitioning = partitioning;
        this.fPreferences = store;
        this.updateProblemRequestor();
    }

    public Locale getLocale() {
        String locale = this.fPreferences.getString("spelling_locale");
        if (locale.equals(this.fLocale.toString())) {
            return this.fLocale;
        }
        if (locale.length() >= 5) {
            return new Locale(locale.substring(0, 2), locale.substring(3, 5));
        }
        return SpellCheckEngine.getDefaultLocale();
    }

    public void handle(ISpellEvent event) {
        if (this.fRequestor != null) {
            SpellProblem problem = new SpellProblem(event.getWord());
            problem.setSourceStart(event.getBegin());
            problem.setSourceEnd(event.getEnd());
            problem.setSentenceStart(event.isStart());
            problem.setDictionaryMatch(event.isMatch());
            try {
                problem.setSourceLineNumber(this.fDocument.getLineOfOffset(event.getBegin()) + 1);
            }
            catch (BadLocationException badLocationException) {}
            this.fRequestor.acceptProblem(problem);
        }
    }

    public void initialReconcile() {
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile(subRegion);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reconcile(IRegion region) {
        if (!this.fPreferences.getBoolean("spelling_check_spelling")) return;
        if (this.fRequestor == null) return;
        try {
            try {
                this.fRequestor.beginReporting();
                ITypedRegion partition = null;
                ITypedRegion[] partitions = TextUtilities.computePartitioning((IDocument)this.fDocument, (String)this.fPartitioning, (int)0, (int)this.fDocument.getLength(), (boolean)false);
                Locale locale = this.getLocale();
                ISpellCheckEngine engine = SpellCheckEngine.getInstance();
                ISpellChecker checker = engine.createSpellChecker(locale, this.fPreferences);
                if (checker != null) {
                    try {
                        checker.addListener(this);
                        int index = 0;
                        while (index < partitions.length) {
                            partition = partitions[index];
                            if (!partition.getType().equals("__dftl_partition_content_type") && !partition.getType().equals("__php_script_code")) {
                                checker.execute(new SpellCheckIterator(this.fDocument, (IRegion)partition, locale));
                            }
                            ++index;
                        }
                        Object var8_10 = null;
                        checker.removeListener(this);
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        checker.removeListener(this);
                        throw throwable;
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
            Object var10_13 = null;
            this.fRequestor.endReporting();
            return;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            this.fRequestor.endReporting();
            throw throwable;
        }
    }

    public final void setDocument(IDocument document) {
        this.fDocument = document;
        this.updateProblemRequestor();
    }

    public final void setProgressMonitor(IProgressMonitor monitor) {
    }

    private void updateProblemRequestor() {
        IAnnotationModel model = this.fEditor.getDocumentProvider().getAnnotationModel((Object)this.fEditor.getEditorInput());
        this.fRequestor = model instanceof IProblemRequestor ? (IProblemRequestor)model : null;
    }

    public class SpellProblem
    implements IProblem {
        public static final int Spelling = Integer.MIN_VALUE;
        private int fEnd = 0;
        private int fLine = 1;
        private boolean fMatch;
        private boolean fSentence = false;
        private int fStart = 0;
        private final String fWord;

        protected SpellProblem(String word) {
            this.fWord = word;
        }

        public String[] getArguments() {
            String prefix = "";
            String postfix = "";
            try {
                IRegion line = SpellReconcileStrategy.this.fDocument.getLineInformationOfOffset(this.fStart);
                prefix = SpellReconcileStrategy.this.fDocument.get(line.getOffset(), this.fStart - line.getOffset());
                postfix = SpellReconcileStrategy.this.fDocument.get(this.fEnd + 1, line.getOffset() + line.getLength() - this.fEnd);
            }
            catch (BadLocationException badLocationException) {}
            return new String[]{this.fWord, prefix, postfix, this.fSentence ? Boolean.toString(true) : Boolean.toString(false), this.fMatch ? Boolean.toString(true) : Boolean.toString(false)};
        }

        public int getID() {
            return Integer.MIN_VALUE;
        }

        public String getMessage() {
            if (this.fSentence && this.fMatch) {
                return MessageFormat.format(PHPUIMessages.getString("Spelling.error.case.label"), this.fWord);
            }
            return MessageFormat.format(PHPUIMessages.getString("Spelling.error.label"), this.fWord);
        }

        public char[] getOriginatingFileName() {
            return SpellReconcileStrategy.this.fEditor.getEditorInput().getName().toCharArray();
        }

        public final int getSourceEnd() {
            return this.fEnd;
        }

        public final int getSourceLineNumber() {
            return this.fLine;
        }

        public final int getSourceStart() {
            return this.fStart;
        }

        public final boolean isDictionaryMatch() {
            return this.fMatch;
        }

        public final boolean isError() {
            return false;
        }

        public final boolean isSentenceStart() {
            return this.fSentence;
        }

        public final boolean isWarning() {
            return true;
        }

        public final void setDictionaryMatch(boolean match) {
            this.fMatch = match;
        }

        public final void setSentenceStart(boolean sentence) {
            this.fSentence = sentence;
        }

        public final void setSourceEnd(int end) {
            this.fEnd = end;
        }

        public final void setSourceLineNumber(int line) {
            this.fLine = line;
        }

        public final void setSourceStart(int start) {
            this.fStart = start;
        }
    }
}

