/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.text.java;

import net.sourceforge.phpdt.core.ICompilationUnit;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.internal.ui.text.java.IJavaReconcilingListener;
import net.sourceforge.phpdt.internal.ui.text.java.IProblemRequestorExtension;
import net.sourceforge.phpdt.internal.ui.text.java.IReconcilingParticipant;
import net.sourceforge.phpdt.ui.IWorkingCopyManager;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class JavaReconcilingStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension {
    private ITextEditor fEditor;
    private IWorkingCopyManager fManager;
    private IDocumentProvider fDocumentProvider;
    private IProgressMonitor fProgressMonitor;
    private boolean fNotify = true;
    private IJavaReconcilingListener fJavaReconcilingListener;
    private boolean fIsJavaReconcilingListener;

    public JavaReconcilingStrategy(ITextEditor editor) {
        this.fEditor = editor;
        this.fManager = PHPeclipsePlugin.getDefault().getWorkingCopyManager();
        this.fDocumentProvider = PHPeclipsePlugin.getDefault().getCompilationUnitDocumentProvider();
        this.fIsJavaReconcilingListener = this.fEditor instanceof IJavaReconcilingListener;
        if (this.fIsJavaReconcilingListener) {
            this.fJavaReconcilingListener = (IJavaReconcilingListener)this.fEditor;
        }
    }

    private IProblemRequestorExtension getProblemRequestorExtension() {
        IAnnotationModel model = this.fDocumentProvider.getAnnotationModel((Object)this.fEditor.getEditorInput());
        if (model instanceof IProblemRequestorExtension) {
            return (IProblemRequestorExtension)model;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reconcile() {
        try {
            ICompilationUnit unit = this.fManager.getWorkingCopy(this.fEditor.getEditorInput());
            if (unit != null) {
                try {
                    IProblemRequestorExtension extension = this.getProblemRequestorExtension();
                    if (extension != null) {
                        extension.setProgressMonitor(this.fProgressMonitor);
                    }
                    ICompilationUnit iCompilationUnit = unit;
                    synchronized (iCompilationUnit) {
                        unit.reconcile(true, this.fProgressMonitor);
                    }
                    if (extension != null) {
                        extension.setProgressMonitor(null);
                    }
                    try {
                        if (this.fEditor instanceof IReconcilingParticipant && this.fNotify && !this.fProgressMonitor.isCanceled()) {
                            IReconcilingParticipant p = (IReconcilingParticipant)this.fEditor;
                            p.reconciled();
                        }
                        Object var4_6 = null;
                        this.fNotify = true;
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        this.fNotify = true;
                        throw throwable;
                    }
                }
                catch (JavaModelException javaModelException) {}
            }
            Object var6_9 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            try {
                if (this.fIsJavaReconcilingListener) {
                    IProgressMonitor pm = this.fProgressMonitor;
                    if (pm == null) {
                        pm = new NullProgressMonitor();
                    }
                    this.fJavaReconcilingListener.reconciled(null, !this.fNotify, pm);
                }
                Object var9_15 = null;
                this.fNotify = true;
                throw throwable;
            }
            catch (Throwable throwable2) {
                Object var9_14 = null;
                this.fNotify = true;
                throw throwable2;
            }
        }
        try {}
        catch (Throwable throwable) {
            Object var9_16 = null;
            this.fNotify = true;
            throw throwable;
        }
        if (this.fIsJavaReconcilingListener) {
            IProgressMonitor pm = this.fProgressMonitor;
            if (pm == null) {
                pm = new NullProgressMonitor();
            }
            this.fJavaReconcilingListener.reconciled(null, !this.fNotify, pm);
        }
        Object var9_17 = null;
        this.fNotify = true;
    }

    public void reconcile(IRegion partition) {
        this.reconcile();
    }

    public void reconcile(DirtyRegion dirtyRegion, IRegion subRegion) {
        this.reconcile();
    }

    public void setDocument(IDocument document) {
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.fProgressMonitor = monitor;
    }

    public void initialReconcile() {
        this.reconcile();
    }

    public void notifyParticipants(boolean notify) {
        this.fNotify = notify;
    }

    public void notifyListeners(boolean notify) {
        this.fNotify = notify;
    }

    public void aboutToBeReconciled() {
        if (this.fIsJavaReconcilingListener) {
            this.fJavaReconcilingListener.aboutToBeReconciled();
        }
    }
}

