/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.ui.preferences;

import java.util.Iterator;
import net.sourceforge.phpdt.internal.ui.text.JavaColorManager;
import net.sourceforge.phpdt.internal.ui.text.JavaWordFinder;
import net.sourceforge.phpdt.internal.ui.text.template.preferences.TemplateVariableProcessor;
import net.sourceforge.phpdt.ui.text.IColorManager;
import net.sourceforge.phpdt.ui.text.JavaTextTools;
import net.sourceforge.phpdt.ui.text.PHPSourceViewerConfiguration;
import net.sourceforge.phpeclipse.PHPeclipsePlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.texteditor.ITextEditor;

public class TemplateEditorSourceViewerConfiguration
extends PHPSourceViewerConfiguration {
    private final TemplateVariableProcessor fProcessor;

    public TemplateEditorSourceViewerConfiguration(IColorManager colorManager, IPreferenceStore store, ITextEditor editor, TemplateVariableProcessor processor) {
        super(colorManager, store, editor, "___php_partitioning");
        this.fProcessor = processor;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        IPreferenceStore store = PHPeclipsePlugin.getDefault().getPreferenceStore();
        JavaTextTools textTools = PHPeclipsePlugin.getDefault().getJavaTextTools();
        JavaColorManager manager = textTools.getColorManager();
        ContentAssistant assistant = new ContentAssistant();
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__dftl_partition_content_type");
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__php_string");
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__php_string_sq");
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__php_string_heredoc");
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__php_singleline_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__php_multiline_comment");
        assistant.setContentAssistProcessor((IContentAssistProcessor)this.fProcessor, "__php_phpdoc_comment");
        assistant.enableAutoInsert(store.getBoolean("content_assist_autoinsert"));
        assistant.enableAutoActivation(store.getBoolean("content_assist_autoactivation"));
        assistant.setAutoActivationDelay(store.getInt("content_assist_autoactivation_delay"));
        assistant.setProposalPopupOrientation(10);
        assistant.setContextInformationPopupOrientation(20);
        assistant.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        Color background = this.getColor(store, "content_assist_proposals_background", manager);
        assistant.setContextInformationPopupBackground(background);
        assistant.setContextSelectorBackground(background);
        assistant.setProposalSelectorBackground(background);
        Color foreground = this.getColor(store, "content_assist_proposals_foreground", manager);
        assistant.setContextInformationPopupForeground(foreground);
        assistant.setContextSelectorForeground(foreground);
        assistant.setProposalSelectorForeground(foreground);
        return assistant;
    }

    private Color getColor(IPreferenceStore store, String key, IColorManager manager) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)store, (String)key);
        return manager.getColor(rgb);
    }

    public ITextHover getTextHover(ISourceViewer sourceViewer, String contentType, int stateMask) {
        return new TemplateVariableTextHover(this.fProcessor);
    }

    private static class TemplateVariableTextHover
    implements ITextHover {
        private TemplateVariableProcessor fProcessor;

        public TemplateVariableTextHover(TemplateVariableProcessor processor) {
            this.fProcessor = processor;
        }

        public String getHoverInfo(ITextViewer textViewer, IRegion subject) {
            try {
                IDocument doc = textViewer.getDocument();
                int offset = subject.getOffset();
                if (offset >= 2 && "${".equals(doc.get(offset - 2, 2))) {
                    String varName = doc.get(offset, subject.getLength());
                    TemplateContextType contextType = this.fProcessor.getContextType();
                    if (contextType != null) {
                        Iterator iter = contextType.resolvers();
                        while (iter.hasNext()) {
                            TemplateVariableResolver var = (TemplateVariableResolver)iter.next();
                            if (!varName.equals(var.getType())) continue;
                            return var.getDescription();
                        }
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
            return null;
        }

        public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
            if (textViewer != null) {
                return JavaWordFinder.findWord(textViewer.getDocument(), offset);
            }
            return null;
        }
    }
}

