/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.corext.textmanipulation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.phpdt.internal.corext.textmanipulation.TextBufferEditor;
import net.sourceforge.phpdt.internal.corext.textmanipulation.TextEdit;
import net.sourceforge.phpdt.internal.corext.textmanipulation.TextRange;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.util.Assert;

public class MultiTextEdit {
    private List fChildren;

    public MultiTextEdit() {
        this.fChildren = new ArrayList(3);
    }

    protected MultiTextEdit(List children) throws CoreException {
        this.fChildren = new ArrayList(children.size());
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            this.fChildren.add(((TextEdit)iter.next()).copy());
        }
    }

    protected List getChildren() {
        return this.fChildren;
    }

    public void add(MultiTextEdit edit) {
        Assert.isNotNull((Object)edit);
        this.fChildren.add(edit);
    }

    public void add(TextEdit edit) {
        Assert.isNotNull((Object)edit);
        this.fChildren.add(edit);
    }

    public Iterator iterator() {
        return this.fChildren.iterator();
    }

    public void connect(TextBufferEditor editor) throws CoreException {
        Iterator iter = this.fChildren.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (element instanceof TextEdit) {
                editor.add((TextEdit)element);
                continue;
            }
            editor.add((MultiTextEdit)element);
        }
    }

    public MultiTextEdit copy() throws CoreException {
        return new MultiTextEdit(this.fChildren);
    }

    public TextRange getTextRange() {
        int size = this.fChildren.size();
        if (size == 0) {
            return new TextRange(0, 0);
        }
        TextRange range = ((TextEdit)this.fChildren.get(0)).getTextRange();
        int start = range.getOffset();
        int end = range.getInclusiveEnd();
        int i = 1;
        while (i < size) {
            range = ((TextEdit)this.fChildren.get(i)).getTextRange();
            start = Math.min(start, range.getOffset());
            end = Math.max(end, range.getInclusiveEnd());
            ++i;
        }
        return new TextRange(start, end - start + 1);
    }

    public Object getModifiedElement() {
        return null;
    }
}

