/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core.builder;

import net.sourceforge.phpdt.internal.compiler.env.NameEnvironmentAnswer;
import net.sourceforge.phpdt.internal.core.builder.ClasspathLocation;
import net.sourceforge.phpdt.internal.core.util.SimpleLookupTable;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;

class ClasspathDirectory
extends ClasspathLocation {
    IContainer binaryFolder;
    boolean isOutputFolder;
    String binaryLocation;
    SimpleLookupTable directoryCache;
    String[] missingPackageHolder = new String[1];

    ClasspathDirectory(IContainer binaryFolder, boolean isOutputFolder) {
        this.binaryFolder = binaryFolder;
        this.isOutputFolder = isOutputFolder;
        this.binaryLocation = "";
        this.directoryCache = new SimpleLookupTable(5);
    }

    public void cleanup() {
        this.directoryCache = null;
    }

    String[] directoryList(String qualifiedPackageName) {
        String[] dirList = (String[])this.directoryCache.get(qualifiedPackageName);
        if (dirList == this.missingPackageHolder) {
            return null;
        }
        if (dirList != null) {
            return dirList;
        }
        try {
            IResource container = this.binaryFolder.findMember(qualifiedPackageName);
            if (container instanceof IContainer) {
                IResource[] members = ((IContainer)container).members();
                dirList = new String[members.length];
                int index = 0;
                int i = 0;
                int l = members.length;
                while (i < l) {
                    IResource cfr_ignored_0 = members[i];
                    ++i;
                }
                if (index < dirList.length) {
                    String[] stringArray = dirList;
                    dirList = new String[index];
                    System.arraycopy(stringArray, 0, dirList, 0, index);
                }
                this.directoryCache.put(qualifiedPackageName, dirList);
                return dirList;
            }
        }
        catch (CoreException coreException) {}
        this.directoryCache.put(qualifiedPackageName, this.missingPackageHolder);
        return null;
    }

    boolean doesFileExist(String fileName, String qualifiedPackageName, String qualifiedFullName) {
        String[] dirList = this.directoryList(qualifiedPackageName);
        if (dirList == null) {
            return false;
        }
        int i = dirList.length;
        while (--i >= 0) {
            if (!fileName.equals(dirList[i])) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathDirectory)) {
            return false;
        }
        return this.binaryFolder.equals((Object)((ClasspathDirectory)o).binaryFolder);
    }

    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String qualifiedBinaryFileName) {
        if (!this.doesFileExist(binaryFileName, qualifiedPackageName, qualifiedBinaryFileName)) {
            return null;
        }
        return null;
    }

    public IPath getProjectRelativePath() {
        return this.binaryFolder.getProjectRelativePath();
    }

    public boolean isOutputFolder() {
        return this.isOutputFolder;
    }

    public boolean isPackage(String qualifiedPackageName) {
        return this.directoryList(qualifiedPackageName) != null;
    }

    public void reset() {
        this.directoryCache = new SimpleLookupTable(5);
    }

    public String toString() {
        return "Binary classpath directory " + this.binaryFolder.getFullPath().toString();
    }
}

