/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sourceforge.phpdt.core.IJavaElement;
import net.sourceforge.phpdt.core.IJavaElementDelta;
import net.sourceforge.phpdt.core.IParent;
import net.sourceforge.phpdt.core.JavaModelException;
import net.sourceforge.phpdt.core.compiler.CharOperation;
import net.sourceforge.phpdt.internal.core.JavaElement;
import net.sourceforge.phpdt.internal.core.JavaElementDelta;
import net.sourceforge.phpdt.internal.core.JavaElementInfo;
import net.sourceforge.phpdt.internal.core.JavaModel;
import net.sourceforge.phpdt.internal.core.JavaModelManager;
import net.sourceforge.phpdt.internal.core.MemberElementInfo;
import net.sourceforge.phpdt.internal.core.SourceFieldElementInfo;
import net.sourceforge.phpdt.internal.core.SourceMethodElementInfo;
import net.sourceforge.phpdt.internal.core.SourceTypeElementInfo;

public class JavaElementDeltaBuilder {
    IJavaElement javaElement;
    int maxDepth = Integer.MAX_VALUE;
    Map infos;
    Map oldPositions;
    Map newPositions;
    JavaElementDelta delta;
    ArrayList added;
    ArrayList removed;

    public JavaElementDeltaBuilder(IJavaElement javaElement) {
        this.javaElement = javaElement;
        this.initialize();
        this.recordElementInfo(javaElement, (JavaModel)this.javaElement.getJavaModel(), 0);
    }

    public JavaElementDeltaBuilder(IJavaElement javaElement, int maxDepth) {
        this.javaElement = javaElement;
        this.maxDepth = maxDepth;
        this.initialize();
        this.recordElementInfo(javaElement, (JavaModel)this.javaElement.getJavaModel(), 0);
    }

    private void added(IJavaElement element) {
        this.added.add(element);
        ListItem current = this.getNewPosition(element);
        ListItem previous = null;
        ListItem next = null;
        if (current.previous != null) {
            previous = this.getNewPosition(current.previous);
        }
        if (current.next != null) {
            next = this.getNewPosition(current.next);
        }
        if (previous != null) {
            previous.next = current.next;
        }
        if (next != null) {
            next.previous = current.previous;
        }
    }

    public void buildDeltas() {
        this.recordNewPositions(this.javaElement, 0);
        this.findAdditions(this.javaElement, 0);
        this.findDeletions();
        this.findChangesInPositioning(this.javaElement, 0);
        this.trimDelta(this.delta);
        if (this.delta.getAffectedChildren().length == 0) {
            this.delta.contentChanged();
        }
    }

    private void findAdditions(IJavaElement newElement, int depth) {
        IJavaElement[] children;
        JavaElementInfo oldInfo = this.getElementInfo(newElement);
        if (oldInfo == null && depth < this.maxDepth) {
            this.delta.added(newElement);
            this.added(newElement);
        } else {
            this.removeElementInfo(newElement);
        }
        if (depth >= this.maxDepth) {
            this.delta.changed(newElement, 1);
            return;
        }
        JavaElementInfo newInfo = null;
        try {
            newInfo = (JavaElementInfo)((JavaElement)newElement).getElementInfo();
        }
        catch (JavaModelException javaModelException) {
            return;
        }
        this.findContentChange(oldInfo, newInfo, newElement);
        if (oldInfo != null && newElement instanceof IParent && (children = newInfo.getChildren()) != null) {
            int length = children.length;
            int i = 0;
            while (i < length) {
                this.findAdditions(children[i], depth + 1);
                ++i;
            }
        }
    }

    private void findChangesInPositioning(IJavaElement element, int depth) {
        if (depth >= this.maxDepth || this.added.contains(element) || this.removed.contains(element)) {
            return;
        }
        if (!this.isPositionedCorrectly(element)) {
            this.delta.changed(element, 256);
        }
        if (element instanceof IParent) {
            JavaElementInfo info = null;
            try {
                info = (JavaElementInfo)((JavaElement)element).getElementInfo();
            }
            catch (JavaModelException javaModelException) {
                return;
            }
            IJavaElement[] children = info.getChildren();
            if (children != null) {
                int length = children.length;
                int i = 0;
                while (i < length) {
                    this.findChangesInPositioning(children[i], depth + 1);
                    ++i;
                }
            }
        }
    }

    private void findContentChange(JavaElementInfo oldInfo, JavaElementInfo newInfo, IJavaElement newElement) {
        if (oldInfo instanceof MemberElementInfo && newInfo instanceof MemberElementInfo) {
            if (((MemberElementInfo)oldInfo).getModifiers() != ((MemberElementInfo)newInfo).getModifiers()) {
                this.delta.changed(newElement, 2);
            } else if (oldInfo instanceof SourceMethodElementInfo && newInfo instanceof SourceMethodElementInfo) {
                if (!CharOperation.equals(((SourceMethodElementInfo)oldInfo).getReturnTypeName(), ((SourceMethodElementInfo)newInfo).getReturnTypeName())) {
                    this.delta.changed(newElement, 1);
                }
            } else if (oldInfo instanceof SourceFieldElementInfo && newInfo instanceof SourceFieldElementInfo && !CharOperation.equals(((SourceFieldElementInfo)oldInfo).getTypeName(), ((SourceFieldElementInfo)newInfo).getTypeName())) {
                this.delta.changed(newElement, 1);
            }
        }
        if (oldInfo instanceof SourceTypeElementInfo && newInfo instanceof SourceTypeElementInfo) {
            SourceTypeElementInfo oldSourceTypeInfo = (SourceTypeElementInfo)oldInfo;
            SourceTypeElementInfo newSourceTypeInfo = (SourceTypeElementInfo)newInfo;
            if (!CharOperation.equals(oldSourceTypeInfo.getSuperclassName(), newSourceTypeInfo.getSuperclassName()) || !CharOperation.equals(oldSourceTypeInfo.getInterfaceNames(), newSourceTypeInfo.getInterfaceNames())) {
                this.delta.changed(newElement, 2048);
            }
        }
    }

    private void findDeletions() {
        Iterator iter = this.infos.keySet().iterator();
        while (iter.hasNext()) {
            IJavaElement element = (IJavaElement)iter.next();
            this.delta.removed(element);
            this.removed(element);
        }
    }

    private JavaElementInfo getElementInfo(IJavaElement element) {
        return (JavaElementInfo)this.infos.get(element);
    }

    private ListItem getNewPosition(IJavaElement element) {
        return (ListItem)this.newPositions.get(element);
    }

    private ListItem getOldPosition(IJavaElement element) {
        return (ListItem)this.oldPositions.get(element);
    }

    private void initialize() {
        this.infos = new HashMap(20);
        this.oldPositions = new HashMap(20);
        this.newPositions = new HashMap(20);
        this.putOldPosition(this.javaElement, new ListItem(null, null));
        this.putNewPosition(this.javaElement, new ListItem(null, null));
        this.delta = new JavaElementDelta(this.javaElement);
        if (this.javaElement.getElementType() >= 5) {
            this.delta.fineGrained();
        }
        this.added = new ArrayList(5);
        this.removed = new ArrayList(5);
    }

    private void insertPositions(IJavaElement[] elements, boolean isNew) {
        int length = elements.length;
        IJavaElement previous = null;
        IJavaElement current = null;
        IJavaElement next = length > 0 ? elements[0] : null;
        int i = 0;
        while (i < length) {
            previous = current;
            current = next;
            IJavaElement iJavaElement = next = i + 1 < length ? elements[i + 1] : null;
            if (isNew) {
                this.putNewPosition(current, new ListItem(previous, next));
            } else {
                this.putOldPosition(current, new ListItem(previous, next));
            }
            ++i;
        }
    }

    private boolean isPositionedCorrectly(IJavaElement element) {
        ListItem oldListItem = this.getOldPosition(element);
        if (oldListItem == null) {
            return false;
        }
        ListItem newListItem = this.getNewPosition(element);
        if (newListItem == null) {
            return false;
        }
        IJavaElement oldPrevious = oldListItem.previous;
        IJavaElement newPrevious = newListItem.previous;
        if (oldPrevious == null) {
            return newPrevious == null;
        }
        return oldPrevious.equals(newPrevious);
    }

    private void putElementInfo(IJavaElement element, JavaElementInfo info) {
        this.infos.put(element, info);
    }

    private void putNewPosition(IJavaElement element, ListItem position) {
        this.newPositions.put(element, position);
    }

    private void putOldPosition(IJavaElement element, ListItem position) {
        this.oldPositions.put(element, position);
    }

    private void recordElementInfo(IJavaElement element, JavaModel model, int depth) {
        IJavaElement[] children;
        if (depth >= this.maxDepth) {
            return;
        }
        JavaElementInfo info = (JavaElementInfo)JavaModelManager.getJavaModelManager().getInfo(element);
        if (info == null) {
            return;
        }
        this.putElementInfo(element, info);
        if (element instanceof IParent && (children = info.getChildren()) != null) {
            this.insertPositions(children, false);
            int i = 0;
            int length = children.length;
            while (i < length) {
                this.recordElementInfo(children[i], model, depth + 1);
                ++i;
            }
        }
    }

    private void recordNewPositions(IJavaElement newElement, int depth) {
        if (depth < this.maxDepth && newElement instanceof IParent) {
            JavaElementInfo info = null;
            try {
                info = (JavaElementInfo)((JavaElement)newElement).getElementInfo();
            }
            catch (JavaModelException javaModelException) {
                return;
            }
            IJavaElement[] children = info.getChildren();
            if (children != null) {
                this.insertPositions(children, true);
                int i = 0;
                int length = children.length;
                while (i < length) {
                    this.recordNewPositions(children[i], depth + 1);
                    ++i;
                }
            }
        }
    }

    private void removed(IJavaElement element) {
        this.removed.add(element);
        ListItem current = this.getOldPosition(element);
        ListItem previous = null;
        ListItem next = null;
        if (current.previous != null) {
            previous = this.getOldPosition(current.previous);
        }
        if (current.next != null) {
            next = this.getOldPosition(current.next);
        }
        if (previous != null) {
            previous.next = current.next;
        }
        if (next != null) {
            next.previous = current.previous;
        }
    }

    private void removeElementInfo(IJavaElement element) {
        this.infos.remove(element);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Built delta:\n");
        buffer.append(this.delta.toString());
        return buffer.toString();
    }

    private void trimDelta(JavaElementDelta delta) {
        if (delta.getKind() == 2) {
            IJavaElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            int length = children.length;
            while (i < length) {
                delta.removeAffectedChild((JavaElementDelta)children[i]);
                ++i;
            }
        } else {
            IJavaElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            int length = children.length;
            while (i < length) {
                this.trimDelta((JavaElementDelta)children[i]);
                ++i;
            }
        }
    }

    class ListItem {
        public IJavaElement previous;
        public IJavaElement next;

        public ListItem(IJavaElement previous, IJavaElement next) {
            this.previous = previous;
            this.next = next;
        }
    }
}

