/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.parser;

import java.util.ArrayList;
import net.sourceforge.phpdt.core.compiler.CharOperation;
import net.sourceforge.phpdt.internal.compiler.CompilationResult;
import net.sourceforge.phpdt.internal.compiler.ast.AbstractMethodDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.Argument;
import net.sourceforge.phpdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import net.sourceforge.phpdt.internal.compiler.ast.ArrayTypeReference;
import net.sourceforge.phpdt.internal.compiler.ast.CompilationUnitDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.ConstructorDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.FieldDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.ImportReference;
import net.sourceforge.phpdt.internal.compiler.ast.MemberTypeDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.MethodDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.QualifiedTypeReference;
import net.sourceforge.phpdt.internal.compiler.ast.SingleTypeReference;
import net.sourceforge.phpdt.internal.compiler.ast.TypeDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.TypeReference;
import net.sourceforge.phpdt.internal.compiler.env.ISourceField;
import net.sourceforge.phpdt.internal.compiler.env.ISourceMethod;
import net.sourceforge.phpdt.internal.compiler.env.ISourceType;
import net.sourceforge.phpdt.internal.compiler.lookup.CompilerModifiers;
import net.sourceforge.phpdt.internal.compiler.parser.UnitParser;
import net.sourceforge.phpdt.internal.compiler.problem.ProblemReporter;

public class SourceTypeConverter
implements CompilerModifiers {
    private boolean needFieldInitialization;
    private CompilationUnitDeclaration unit;
    private UnitParser parser;
    private ProblemReporter problemReporter;

    private SourceTypeConverter(boolean needFieldInitialization, ProblemReporter problemReporter) {
        this.needFieldInitialization = needFieldInitialization;
        this.problemReporter = problemReporter;
    }

    public static CompilationUnitDeclaration buildCompilationUnit(ISourceType[] sourceTypes, boolean needFieldsAndMethods, boolean needMemberTypes, boolean needFieldInitialization, ProblemReporter problemReporter, CompilationResult compilationResult) {
        return new SourceTypeConverter(needFieldInitialization, problemReporter).convert(sourceTypes, needFieldsAndMethods, needMemberTypes, compilationResult);
    }

    private CompilationUnitDeclaration convert(ISourceType[] sourceTypes, boolean needFieldsAndMethods, boolean needMemberTypes, CompilationResult compilationResult) {
        ISourceType sourceType = sourceTypes[0];
        if (sourceType.getName() == null) {
            return null;
        }
        this.unit = new CompilationUnitDeclaration(this.problemReporter, compilationResult, 0);
        sourceType.getNameSourceStart();
        sourceType.getNameSourceEnd();
        char[][] importNames = sourceType.getImports();
        int importCount = importNames == null ? 0 : importNames.length;
        this.unit.imports = new ImportReference[importCount];
        int typeCount = sourceTypes.length;
        this.unit.types = new ArrayList(typeCount);
        int i = 0;
        while (i < typeCount) {
            this.unit.types.set(i, this.convert(sourceTypes[i], needFieldsAndMethods, needMemberTypes, compilationResult));
            ++i;
        }
        return this.unit;
    }

    private FieldDeclaration convert(ISourceField sourceField, TypeDeclaration type) {
        char[] initializationSource;
        FieldDeclaration field = new FieldDeclaration();
        int start = sourceField.getNameSourceStart();
        int end = sourceField.getNameSourceEnd();
        field.name = sourceField.getName();
        field.sourceStart = start;
        field.sourceEnd = end;
        field.type = this.createTypeReference(sourceField.getTypeName(), start, end);
        field.declarationSourceStart = sourceField.getDeclarationSourceStart();
        field.declarationSourceEnd = sourceField.getDeclarationSourceEnd();
        field.modifiers = sourceField.getModifiers();
        if (this.needFieldInitialization && (initializationSource = sourceField.getInitializationSource()) != null) {
            if (this.parser == null) {
                this.parser = new UnitParser(this.problemReporter);
            }
            this.parser.parse(field, type, this.unit, initializationSource);
        }
        return field;
    }

    private AbstractMethodDeclaration convert(ISourceMethod sourceMethod, CompilationResult compilationResult) {
        AbstractMethodDeclaration method;
        AbstractMethodDeclaration decl;
        int start = sourceMethod.getNameSourceStart();
        int end = sourceMethod.getNameSourceEnd();
        if (sourceMethod.isConstructor()) {
            decl = new ConstructorDeclaration(compilationResult);
            decl.isDefaultConstructor = false;
            method = decl;
        } else {
            decl = new MethodDeclaration(compilationResult);
            ((MethodDeclaration)decl).returnType = this.createTypeReference(sourceMethod.getReturnTypeName(), start, end);
            method = decl;
        }
        method.selector = sourceMethod.getSelector();
        method.modifiers = sourceMethod.getModifiers();
        method.sourceStart = start;
        method.sourceEnd = end;
        method.declarationSourceStart = sourceMethod.getDeclarationSourceStart();
        method.declarationSourceEnd = sourceMethod.getDeclarationSourceEnd();
        char[][] argumentTypeNames = sourceMethod.getArgumentTypeNames();
        char[][] argumentNames = sourceMethod.getArgumentNames();
        int argumentCount = argumentTypeNames == null ? 0 : argumentTypeNames.length;
        long position = (long)start << 32 + end;
        method.arguments = new Argument[argumentCount];
        int i = 0;
        while (i < argumentCount) {
            method.arguments[i] = new Argument(argumentNames[i], position, this.createTypeReference(argumentTypeNames[i], start, end), 0);
            ++i;
        }
        char[][] exceptionTypeNames = sourceMethod.getExceptionTypeNames();
        int exceptionCount = exceptionTypeNames == null ? 0 : exceptionTypeNames.length;
        method.thrownExceptions = new TypeReference[exceptionCount];
        int i2 = 0;
        while (i2 < exceptionCount) {
            method.thrownExceptions[i2] = this.createTypeReference(exceptionTypeNames[i2], start, end);
            ++i2;
        }
        return method;
    }

    private TypeDeclaration convert(ISourceType sourceType, boolean needFieldsAndMethods, boolean needMemberTypes, CompilationResult compilationResult) {
        int i;
        char[][] interfaceNames;
        int end;
        int start;
        TypeDeclaration type = sourceType.getEnclosingType() == null ? new TypeDeclaration(compilationResult) : new MemberTypeDeclaration(compilationResult);
        type.name = sourceType.getName();
        type.sourceStart = start = sourceType.getNameSourceStart();
        type.sourceEnd = end = sourceType.getNameSourceEnd();
        type.modifiers = sourceType.getModifiers();
        type.declarationSourceStart = sourceType.getDeclarationSourceStart();
        type.bodyEnd = type.declarationSourceEnd = sourceType.getDeclarationSourceEnd();
        if (sourceType.getSuperclassName() != null) {
            type.superclass = this.createTypeReference(sourceType.getSuperclassName(), start, end);
        }
        int interfaceCount = (interfaceNames = sourceType.getInterfaceNames()) == null ? 0 : interfaceNames.length;
        type.superInterfaces = new TypeReference[interfaceCount];
        int i2 = 0;
        while (i2 < interfaceCount) {
            type.superInterfaces[i2] = this.createTypeReference(interfaceNames[i2], start, end);
            ++i2;
        }
        if (needMemberTypes) {
            ISourceType[] sourceMemberTypes = sourceType.getMemberTypes();
            int sourceMemberTypeCount = sourceMemberTypes == null ? 0 : sourceMemberTypes.length;
            type.memberTypes = new MemberTypeDeclaration[sourceMemberTypeCount];
            i = 0;
            while (i < sourceMemberTypeCount) {
                type.memberTypes[i] = (MemberTypeDeclaration)this.convert(sourceMemberTypes[i], needFieldsAndMethods, true, compilationResult);
                ++i;
            }
        }
        if (needFieldsAndMethods) {
            ISourceField[] sourceFields = sourceType.getFields();
            int sourceFieldCount = sourceFields == null ? 0 : sourceFields.length;
            type.fields = new FieldDeclaration[sourceFieldCount];
            i = 0;
            while (i < sourceFieldCount) {
                type.fields[i] = this.convert(sourceFields[i], type);
                ++i;
            }
            ISourceMethod[] sourceMethods = sourceType.getMethods();
            int sourceMethodCount = sourceMethods == null ? 0 : sourceMethods.length;
            int neededCount = 0;
            if (!type.isInterface()) {
                neededCount = 1;
                int i3 = 0;
                while (i3 < sourceMethodCount) {
                    if (sourceMethods[i3].isConstructor()) {
                        neededCount = 0;
                        break;
                    }
                    ++i3;
                }
            }
            type.methods = new AbstractMethodDeclaration[sourceMethodCount + neededCount];
            if (neededCount != 0) {
                type.methods[0] = type.createsInternalConstructor(false, false);
            }
            boolean isInterface = type.isInterface();
            int i4 = 0;
            while (i4 < sourceMethodCount) {
                AbstractMethodDeclaration method = this.convert(sourceMethods[i4], compilationResult);
                if (isInterface || method.isAbstract()) {
                    method.modifiers |= 0x1000000;
                }
                type.methods[neededCount + i4] = method;
                ++i4;
            }
        }
        return type;
    }

    private TypeReference createTypeReference(char[] typeSignature, int start, int end) {
        int max;
        int dimStart = max = typeSignature.length;
        int dim = 0;
        int identCount = 1;
        int i = 0;
        while (i < max) {
            switch (typeSignature[i]) {
                case '[': {
                    if (dim == 0) {
                        dimStart = i;
                    }
                    ++dim;
                    break;
                }
                case '.': {
                    ++identCount;
                }
            }
            ++i;
        }
        if (identCount == 1) {
            if (dim == 0) {
                return new SingleTypeReference(typeSignature, ((long)start << 32) + (long)end);
            }
            char[] identifier = new char[dimStart];
            System.arraycopy(typeSignature, 0, identifier, 0, dimStart);
            return new ArrayTypeReference(identifier, dim, ((long)start << 32) + (long)end);
        }
        long[] positions = new long[identCount];
        long pos = ((long)start << 32) + (long)end;
        int i2 = 0;
        while (i2 < identCount) {
            positions[i2] = pos;
            ++i2;
        }
        char[][] identifiers = CharOperation.splitOn('.', typeSignature, 0, dimStart);
        if (dim == 0) {
            return new QualifiedTypeReference(identifiers, positions);
        }
        return new ArrayQualifiedTypeReference(identifiers, dim, positions);
    }
}

