/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.lookup;

import net.sourceforge.phpdt.internal.compiler.lookup.ClassScope;
import net.sourceforge.phpdt.internal.compiler.lookup.LocalVariableBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.ReferenceBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.SourceTypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.SyntheticArgumentBinding;

public class NestedTypeBinding
extends SourceTypeBinding {
    public SourceTypeBinding enclosingType;
    public SyntheticArgumentBinding[] enclosingInstances;
    public SyntheticArgumentBinding[] outerLocalVariables;
    public int enclosingInstancesSlotSize;
    public int outerLocalVariablesSlotSize;

    public NestedTypeBinding(char[][] typeName, ClassScope scope, SourceTypeBinding enclosingType) {
        super(typeName, enclosingType.fPackage, scope);
        this.tagBits |= 4;
        this.enclosingType = enclosingType;
    }

    public SyntheticArgumentBinding addSyntheticArgument(LocalVariableBinding actualOuterLocalVariable) {
        SyntheticArgumentBinding synthLocal = null;
        if (this.outerLocalVariables == null) {
            synthLocal = new SyntheticArgumentBinding(actualOuterLocalVariable);
            this.outerLocalVariables = new SyntheticArgumentBinding[]{synthLocal};
        } else {
            int size;
            int newArgIndex = size = this.outerLocalVariables.length;
            int i = size;
            while (--i >= 0) {
                if (this.outerLocalVariables[i].actualOuterLocalVariable == actualOuterLocalVariable) {
                    return this.outerLocalVariables[i];
                }
                if (this.outerLocalVariables[i].id <= actualOuterLocalVariable.id) continue;
                newArgIndex = i;
            }
            SyntheticArgumentBinding[] synthLocals = new SyntheticArgumentBinding[size + 1];
            System.arraycopy(this.outerLocalVariables, 0, synthLocals, 0, newArgIndex);
            synthLocals[newArgIndex] = synthLocal = new SyntheticArgumentBinding(actualOuterLocalVariable);
            System.arraycopy(this.outerLocalVariables, newArgIndex, synthLocals, newArgIndex + 1, size - newArgIndex);
            this.outerLocalVariables = synthLocals;
        }
        if (this.scope.referenceCompilationUnit().isPropagatingInnerClassEmulation) {
            this.updateInnerEmulationDependents();
        }
        return synthLocal;
    }

    public SyntheticArgumentBinding addSyntheticArgument(ReferenceBinding enclosingType) {
        SyntheticArgumentBinding synthLocal = null;
        if (this.enclosingInstances == null) {
            synthLocal = new SyntheticArgumentBinding(enclosingType);
            this.enclosingInstances = new SyntheticArgumentBinding[]{synthLocal};
        } else {
            int size;
            int newArgIndex = size = this.enclosingInstances.length;
            int i = size;
            while (--i >= 0) {
                if (this.enclosingInstances[i].type == enclosingType) {
                    return this.enclosingInstances[i];
                }
                if (this.enclosingType() != enclosingType) continue;
                newArgIndex = 0;
            }
            SyntheticArgumentBinding[] newInstances = new SyntheticArgumentBinding[size + 1];
            System.arraycopy(this.enclosingInstances, 0, newInstances, newArgIndex == 0 ? 1 : 0, size);
            newInstances[newArgIndex] = synthLocal = new SyntheticArgumentBinding(enclosingType);
            this.enclosingInstances = newInstances;
        }
        if (this.scope.referenceCompilationUnit().isPropagatingInnerClassEmulation) {
            this.updateInnerEmulationDependents();
        }
        return synthLocal;
    }

    public SyntheticArgumentBinding addSyntheticArgumentAndField(LocalVariableBinding actualOuterLocalVariable) {
        SyntheticArgumentBinding synthLocal = this.addSyntheticArgument(actualOuterLocalVariable);
        if (synthLocal == null) {
            return null;
        }
        if (synthLocal.matchingField == null) {
            synthLocal.matchingField = this.addSyntheticField(actualOuterLocalVariable);
        }
        return synthLocal;
    }

    public SyntheticArgumentBinding addSyntheticArgumentAndField(ReferenceBinding enclosingType) {
        SyntheticArgumentBinding synthLocal = this.addSyntheticArgument(enclosingType);
        if (synthLocal == null) {
            return null;
        }
        if (synthLocal.matchingField == null) {
            synthLocal.matchingField = this.addSyntheticField(enclosingType);
        }
        return synthLocal;
    }

    public final void computeSyntheticArgumentSlotSizes() {
        int slotSize = 0;
        SyntheticArgumentBinding[] enclosingInstances = this.syntheticEnclosingInstances();
        int enclosingInstancesCount = enclosingInstances == null ? 0 : enclosingInstances.length;
        int i = 0;
        while (i < enclosingInstancesCount) {
            SyntheticArgumentBinding argument = enclosingInstances[i];
            argument.resolvedPosition = slotSize + 1;
            if (slotSize + 1 > 255) {
                this.scope.problemReporter().noMoreAvailableSpaceForArgument(argument, this.scope.referenceType());
            }
            slotSize = argument.type == LongBinding || argument.type == DoubleBinding ? (slotSize += 2) : ++slotSize;
            ++i;
        }
        this.enclosingInstancesSlotSize = slotSize;
        slotSize = 0;
        SyntheticArgumentBinding[] outerLocals = this.syntheticOuterLocalVariables();
        int outerLocalsCount = outerLocals == null ? 0 : outerLocals.length;
        int i2 = 0;
        while (i2 < outerLocalsCount) {
            SyntheticArgumentBinding argument = outerLocals[i2];
            slotSize = argument.type == LongBinding || argument.type == DoubleBinding ? (slotSize += 2) : ++slotSize;
            ++i2;
        }
        this.outerLocalVariablesSlotSize = slotSize;
    }

    public ReferenceBinding enclosingType() {
        return this.enclosingType;
    }

    public SyntheticArgumentBinding getSyntheticArgument(LocalVariableBinding actualOuterLocalVariable) {
        if (this.outerLocalVariables == null) {
            return null;
        }
        int i = this.outerLocalVariables.length;
        while (--i >= 0) {
            if (this.outerLocalVariables[i].actualOuterLocalVariable != actualOuterLocalVariable) continue;
            return this.outerLocalVariables[i];
        }
        return null;
    }

    public SyntheticArgumentBinding[] syntheticEnclosingInstances() {
        return this.enclosingInstances;
    }

    public ReferenceBinding[] syntheticEnclosingInstanceTypes() {
        if (this.enclosingInstances == null) {
            return null;
        }
        int length = this.enclosingInstances.length;
        ReferenceBinding[] types = new ReferenceBinding[length];
        int i = 0;
        while (i < length) {
            types[i] = (ReferenceBinding)this.enclosingInstances[i].type;
            ++i;
        }
        return types;
    }

    public SyntheticArgumentBinding[] syntheticOuterLocalVariables() {
        return this.outerLocalVariables;
    }

    public void updateInnerEmulationDependents() {
    }

    public SyntheticArgumentBinding getSyntheticArgument(ReferenceBinding targetEnclosingType, boolean onlyExactMatch) {
        if (this.enclosingInstances == null) {
            return null;
        }
        int i = this.enclosingInstances.length;
        while (--i >= 0) {
            if (this.enclosingInstances[i].type != targetEnclosingType || this.enclosingInstances[i].actualOuterLocalVariable != null) continue;
            return this.enclosingInstances[i];
        }
        if (!onlyExactMatch) {
            i = this.enclosingInstances.length;
            while (--i >= 0) {
                if (this.enclosingInstances[i].actualOuterLocalVariable != null || !targetEnclosingType.isSuperclassOf((ReferenceBinding)this.enclosingInstances[i].type)) continue;
                return this.enclosingInstances[i];
            }
        }
        return null;
    }
}

