/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.BreakStatement;
import net.sourceforge.phpdt.internal.compiler.ast.CaseStatement;
import net.sourceforge.phpdt.internal.compiler.ast.DefaultCase;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.codegen.Label;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.flow.SwitchFlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.UnconditionalFlowInfo;
import net.sourceforge.phpdt.internal.compiler.impl.Constant;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class SwitchStatement
extends Statement {
    public Expression expression;
    public Statement[] statements;
    public BlockScope scope;
    public int explicitDeclarations;
    public Label breakLabel;
    public CaseStatement[] cases;
    public DefaultCase defaultCase;
    public int caseCount = 0;
    int preSwitchInitStateIndex = -1;
    int mergedInitStateIndex = -1;

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        flowInfo = this.expression.analyseCode(currentScope, flowContext, flowInfo);
        this.breakLabel = new Label();
        SwitchFlowContext switchContext = new SwitchFlowContext(flowContext, this, this.breakLabel);
        FlowInfo caseInits = FlowInfo.DEAD_END;
        this.preSwitchInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
        int caseIndex = 0;
        if (this.statements != null) {
            boolean didAlreadyComplain = false;
            int i = 0;
            int max = this.statements.length;
            while (i < max) {
                Statement statement = this.statements[i];
                if (caseIndex < this.caseCount && statement == this.cases[caseIndex]) {
                    ++caseIndex;
                    caseInits = ((FlowInfo)caseInits).mergedWith(flowInfo.copy().unconditionalInits());
                    didAlreadyComplain = false;
                } else if (statement == this.defaultCase) {
                    caseInits = ((FlowInfo)caseInits).mergedWith(flowInfo.copy().unconditionalInits());
                    didAlreadyComplain = false;
                }
                if (!caseInits.complainIfUnreachable(statement, this.scope, didAlreadyComplain)) {
                    caseInits = statement.analyseCode(this.scope, switchContext, caseInits);
                } else {
                    didAlreadyComplain = true;
                }
                ++i;
            }
        }
        if (this.defaultCase == null) {
            flowInfo.addPotentialInitializationsFrom(((FlowInfo)caseInits).mergedWith(switchContext.initsOnBreak));
            this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
            return flowInfo;
        }
        UnconditionalFlowInfo mergedInfo = ((FlowInfo)caseInits).mergedWith(switchContext.initsOnBreak);
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public void resetStateForCodeGeneration() {
        if (this.breakLabel != null) {
            this.breakLabel.resetStateForCodeGeneration();
        }
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        SwitchStatement.printIndent(indent, output).append("switch (");
        this.expression.printExpression(0, output).append(") {");
        if (this.statements != null) {
            int i = 0;
            while (i < this.statements.length) {
                output.append('\n');
                if (this.statements[i] instanceof CaseStatement) {
                    this.statements[i].printStatement(indent, output);
                } else {
                    this.statements[i].printStatement(indent + 2, output);
                }
                ++i;
            }
        }
        output.append("\n");
        return SwitchStatement.printIndent(indent, output).append('}');
    }

    public void resolve(BlockScope upperScope) {
        TypeBinding testType = this.expression.resolveType(upperScope);
        if (testType == null) {
            return;
        }
        this.expression.implicitWidening(testType, testType);
        if (!this.expression.isConstantValueOfTypeAssignableToType(testType, IntBinding) && !testType.isCompatibleWith(IntBinding)) {
            upperScope.problemReporter().incorrectSwitchType(this.expression, testType);
            return;
        }
        if (this.statements != null) {
            this.scope = this.explicitDeclarations == 0 ? upperScope : new BlockScope(upperScope);
            int length = this.statements.length;
            this.cases = new CaseStatement[length];
            int[] casesValues = new int[length];
            int counter = 0;
            int i = 0;
            while (i < length) {
                Constant cst = this.statements[i].resolveCase(this.scope, testType, this);
                if (cst != null && cst != NotAConstant) {
                    int key = cst.intValue();
                    int j = 0;
                    while (j < counter) {
                        if (casesValues[j] == key) {
                            this.scope.problemReporter().duplicateCase((CaseStatement)this.statements[i], cst);
                        }
                        ++j;
                    }
                    casesValues[counter++] = key;
                }
                ++i;
            }
        }
    }

    public String toString(int tab) {
        String s;
        String inFront = s = SwitchStatement.tabString(tab);
        s = String.valueOf(s) + "switch (" + this.expression.toStringExpression() + ") ";
        if (this.statements == null) {
            s = String.valueOf(s) + "{}";
            return s;
        }
        s = String.valueOf(s) + "{";
        s = String.valueOf(s) + (this.explicitDeclarations != 0 ? "// ---scope needed for " + String.valueOf(this.explicitDeclarations) + " locals------------ \n" : "// ---NO scope needed------ \n");
        int i = 0;
        String tabulation = "  ";
        try {
            block2: while (true) {
                if (this.statements[i] instanceof Expression) {
                    s = String.valueOf(s) + "\n" + inFront + tabulation;
                }
                s = this.statements[i] instanceof BreakStatement ? String.valueOf(s) + this.statements[i].toString(0) : String.valueOf(s) + "\n" + this.statements[i].toString(tab + 2);
                if (this.statements[i] instanceof CaseStatement || this.statements[i] instanceof DefaultCase) {
                    ++i;
                    while (true) {
                        if (this.statements[i] instanceof CaseStatement || this.statements[i] instanceof DefaultCase) continue block2;
                        s = this.statements[i] instanceof Expression || this.statements[i] instanceof BreakStatement ? String.valueOf(s) + this.statements[i].toString(0) + " ; " : String.valueOf(s) + "\n" + this.statements[i].toString(tab + 6) + " ; ";
                        ++i;
                    }
                }
                s = String.valueOf(s) + " ;";
                ++i;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            s = String.valueOf(s) + "}";
            return s;
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.expression.traverse(visitor, this.scope);
            if (this.statements != null) {
                int statementsLength = this.statements.length;
                int i = 0;
                while (i < statementsLength) {
                    this.statements[i].traverse(visitor, this.scope);
                    ++i;
                }
            }
        }
        visitor.endVisit(this, blockScope);
    }

    public void branchChainTo(Label label) {
        if (this.breakLabel.hasForwardReferences()) {
            label.appendForwardReferencesFrom(this.breakLabel);
        }
    }
}

