/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.AbstractVariableDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.ArrayInitializer;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.lookup.ArrayBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.BaseTypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.LocalVariableBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class LocalDeclaration
extends AbstractVariableDeclaration {
    public LocalVariableBinding binding;

    public LocalDeclaration(Expression expr, char[] name, int sourceStart, int sourceEnd) {
        this.initialization = expr;
        this.name = name;
        this.sourceStart = sourceStart;
        this.sourceEnd = sourceEnd;
        if (this.initialization != null) {
            this.declarationSourceEnd = this.initialization.sourceEnd;
            this.declarationEnd = this.initialization.sourceEnd;
        } else {
            this.declarationEnd = sourceEnd;
        }
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (flowInfo.isReachable()) {
            this.bits |= 0x40000000;
        }
        if (this.initialization == null) {
            return flowInfo;
        }
        flowInfo = this.initialization.analyseCode(currentScope, flowContext, flowInfo).unconditionalInits();
        flowInfo.markAsDefinitelyAssigned(this.binding);
        return flowInfo;
    }

    public void checkModifiers() {
        if ((this.modifiers & 0xFFFF & 0xFFFFFFEF) != 0) {
            this.modifiers = this.modifiers & 0xFFBFFFFF | 0x800000;
        }
    }

    public String name() {
        return String.valueOf(this.name);
    }

    public void resolve(BlockScope scope) {
        TypeBinding tb = this.type.resolveType(scope);
        this.checkModifiers();
        if (tb != null) {
            if (tb == VoidBinding) {
                scope.problemReporter().variableTypeCannotBeVoid(this);
                return;
            }
            if (tb.isArrayType() && ((ArrayBinding)tb).leafComponentType == VoidBinding) {
                scope.problemReporter().variableTypeCannotBeVoidArray(this);
                return;
            }
        }
        if ((this.binding = scope.duplicateName(this.name)) != null) {
            scope.problemReporter().redefineLocal(this);
        } else {
            if ((this.modifiers & 0x10) != 0 && this.initialization == null) {
                this.modifiers |= 0x4000000;
            }
            this.binding = new LocalVariableBinding(this, tb, this.modifiers, false);
            scope.addLocalVariable(this.binding);
            this.binding.constant = NotAConstant;
        }
        if (tb == null) {
            if (this.initialization != null) {
                this.initialization.resolveType(scope);
            }
            return;
        }
        if (this.initialization != null) {
            if (this.initialization instanceof ArrayInitializer) {
                TypeBinding initTb = this.initialization.resolveTypeExpecting(scope, tb);
                if (initTb != null) {
                    ((ArrayInitializer)this.initialization).binding = (ArrayBinding)initTb;
                    this.initialization.implicitWidening(tb, initTb);
                }
            } else {
                TypeBinding initTb = this.initialization.resolveType(scope);
                if (initTb != null) {
                    if (this.initialization.isConstantValueOfTypeAssignableToType(initTb, tb) || tb.isBaseType() && BaseTypeBinding.isWidening(tb.id, initTb.id) || initTb.isCompatibleWith(tb)) {
                        this.initialization.implicitWidening(tb, initTb);
                    } else {
                        scope.problemReporter().typeMismatchError(initTb, tb, this);
                    }
                }
            }
            this.binding.constant = this.binding.isFinal() ? this.initialization.constant.castTo((tb.id << 4) + this.initialization.constant.typeID()) : NotAConstant;
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.type.traverse(visitor, scope);
            if (this.initialization != null) {
                this.initialization.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }
}

