/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.ASTNode;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.codegen.Label;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.flow.LabelFlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.UnconditionalFlowInfo;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;

public class LabeledStatement
extends Statement {
    public Statement statement;
    public char[] label;
    public Label targetLabel;
    int mergedInitStateIndex = -1;

    public LabeledStatement(char[] l, Statement st, int s, int e) {
        this.statement = st;
        this.label = l;
        this.sourceStart = s;
        this.sourceEnd = e;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.statement == null) {
            return flowInfo;
        }
        this.targetLabel = new Label();
        LabelFlowContext labelContext = new LabelFlowContext(flowContext, this, this.label, this.targetLabel, currentScope);
        UnconditionalFlowInfo mergedInfo = this.statement.analyseCode(currentScope, labelContext, flowInfo).mergedWith(labelContext.initsOnBreak);
        this.mergedInitStateIndex = currentScope.methodScope().recordInitializationStates(mergedInfo);
        return mergedInfo;
    }

    public ASTNode concreteStatement() {
        return this.statement;
    }

    public StringBuffer printStatement(int tab, StringBuffer output) {
        LabeledStatement.printIndent(tab, output).append(this.label).append(": ");
        if (this.statement == null) {
            output.append(';');
        } else {
            this.statement.printStatement(0, output);
        }
        return output;
    }

    public void resolve(BlockScope scope) {
        this.statement.resolve(scope);
    }

    public String toString(int tab) {
        String s = LabeledStatement.tabString(tab);
        s = String.valueOf(s) + new String(this.label) + ": " + this.statement.toString(0);
        return s;
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope)) {
            this.statement.traverse(visitor, blockScope);
        }
        visitor.endVisit(this, blockScope);
    }

    public void resetStateForCodeGeneration() {
        if (this.targetLabel != null) {
            this.targetLabel.resetStateForCodeGeneration();
        }
    }
}

