/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.codegen.Label;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;

public class Block
extends Statement {
    public Statement[] statements;
    public int explicitDeclarations;
    public BlockScope scope;
    public static final Block None = new Block(0);

    public Block(int explicitDeclarations) {
        this.explicitDeclarations = explicitDeclarations;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.statements == null) {
            return flowInfo;
        }
        boolean didAlreadyComplain = false;
        int i = 0;
        int max = this.statements.length;
        while (i < max) {
            Statement stat = this.statements[i];
            if (!flowInfo.complainIfUnreachable(stat, this.scope, didAlreadyComplain)) {
                flowInfo = stat.analyseCode(this.scope, flowContext, flowInfo);
            } else {
                didAlreadyComplain = true;
            }
            ++i;
        }
        return flowInfo;
    }

    public static final Block EmptyWith(int sourceStart, int sourceEnd) {
        Block bk = new Block(0);
        bk.sourceStart = sourceStart;
        bk.sourceEnd = sourceEnd;
        return bk;
    }

    public boolean isEmptyBlock() {
        return this.statements == null;
    }

    public StringBuffer printBody(int indent, StringBuffer output) {
        if (this.statements == null) {
            return output;
        }
        int i = 0;
        while (i < this.statements.length) {
            this.statements[i].printStatement(indent + 1, output);
            output.append('\n');
            ++i;
        }
        return output;
    }

    public StringBuffer printStatement(int indent, StringBuffer output) {
        Block.printIndent(indent, output);
        output.append("{\n");
        this.printBody(indent, output);
        return Block.printIndent(indent, output).append('}');
    }

    public void resolve(BlockScope upperScope) {
        if (this.statements != null) {
            this.scope = this.explicitDeclarations == 0 ? upperScope : new BlockScope(upperScope, this.explicitDeclarations);
            int i = 0;
            int length = this.statements.length;
            while (i < length) {
                this.statements[i++].resolve(this.scope);
            }
        }
    }

    public void resolveUsing(BlockScope givenScope) {
        this.scope = givenScope;
        if (this.statements != null) {
            int i = 0;
            int length = this.statements.length;
            while (i < length) {
                this.statements[i++].resolve(this.scope);
            }
        }
    }

    public String toString(int tab) {
        String s = Block.tabString(tab);
        if (this.statements == null) {
            s = String.valueOf(s) + "{\n";
            s = String.valueOf(s) + Block.tabString(tab);
            s = String.valueOf(s) + "}";
            return s;
        }
        s = String.valueOf(s) + "{\n";
        s = String.valueOf(s) + this.toStringStatements(tab);
        s = String.valueOf(s) + Block.tabString(tab);
        s = String.valueOf(s) + "}";
        return s;
    }

    public String toStringStatements(int tab) {
        if (this.statements == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.statements.length) {
            buffer.append(this.statements[i].toString(tab + 1));
            if (this.statements[i] instanceof Block) {
                buffer.append("\n");
            } else {
                buffer.append(";\n");
            }
            ++i;
        }
        return buffer.toString();
    }

    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        if (visitor.visit(this, blockScope) && this.statements != null) {
            int statementLength = this.statements.length;
            int i = 0;
            while (i < statementLength) {
                this.statements[i].traverse(visitor, this.scope);
                ++i;
            }
        }
        visitor.endVisit(this, blockScope);
    }

    public void branchChainTo(Label label) {
        if (this.statements != null) {
            this.statements[this.statements.length - 1].branchChainTo(label);
        }
    }
}

