/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.compiler.ast;

import net.sourceforge.phpdt.internal.compiler.ASTVisitor;
import net.sourceforge.phpdt.internal.compiler.ast.ASTNode;
import net.sourceforge.phpdt.internal.compiler.ast.AbstractMethodDeclaration;
import net.sourceforge.phpdt.internal.compiler.ast.Clinit;
import net.sourceforge.phpdt.internal.compiler.ast.Expression;
import net.sourceforge.phpdt.internal.compiler.ast.Statement;
import net.sourceforge.phpdt.internal.compiler.ast.TypeDeclaration;
import net.sourceforge.phpdt.internal.compiler.flow.FlowContext;
import net.sourceforge.phpdt.internal.compiler.flow.FlowInfo;
import net.sourceforge.phpdt.internal.compiler.impl.Constant;
import net.sourceforge.phpdt.internal.compiler.lookup.BlockScope;
import net.sourceforge.phpdt.internal.compiler.lookup.FieldBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.ReferenceBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.SourceTypeBinding;
import net.sourceforge.phpdt.internal.compiler.lookup.TypeBinding;

public class AssertStatement
extends Statement {
    public Expression assertExpression;
    public Expression exceptionArgument;
    int preAssertInitStateIndex = -1;
    private FieldBinding assertionSyntheticFieldBinding;

    public AssertStatement(Expression exceptionArgument, Expression assertExpression, int startPosition) {
        this.assertExpression = assertExpression;
        this.exceptionArgument = exceptionArgument;
        this.sourceStart = startPosition;
        this.sourceEnd = exceptionArgument.sourceEnd;
    }

    public AssertStatement(Expression assertExpression, int startPosition) {
        this.assertExpression = assertExpression;
        this.sourceStart = startPosition;
        this.sourceEnd = assertExpression.sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.preAssertInitStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
        Constant cst = this.assertExpression.optimizedBooleanConstant();
        boolean isOptimizedTrueAssertion = cst != NotAConstant && cst.booleanValue();
        boolean isOptimizedFalseAssertion = cst != NotAConstant && !cst.booleanValue();
        FlowInfo assertInfo = flowInfo.copy();
        if (isOptimizedTrueAssertion) {
            assertInfo.setReachMode(1);
        }
        assertInfo = this.assertExpression.analyseCode(currentScope, flowContext, assertInfo).unconditionalInits();
        if (this.exceptionArgument != null) {
            FlowInfo exceptionInfo = this.exceptionArgument.analyseCode(currentScope, flowContext, assertInfo.copy());
            if (!isOptimizedTrueAssertion) {
                flowContext.checkExceptionHandlers(currentScope.getJavaLangAssertionError(), (ASTNode)this, exceptionInfo, currentScope);
            }
        }
        this.manageSyntheticAccessIfNecessary(currentScope);
        if (isOptimizedFalseAssertion) {
            return flowInfo;
        }
        return flowInfo.mergedWith(assertInfo.unconditionalInits());
    }

    public StringBuffer printStatement(int tab, StringBuffer output) {
        AssertStatement.printIndent(tab, output);
        output.append("assert ");
        this.assertExpression.printExpression(0, output);
        if (this.exceptionArgument != null) {
            output.append(": ");
            this.exceptionArgument.printExpression(0, output);
        }
        return output.append(';');
    }

    public void resolve(BlockScope scope) {
        TypeBinding exceptionArgumentType;
        this.assertExpression.resolveTypeExpecting(scope, BooleanBinding);
        if (this.exceptionArgument != null && (exceptionArgumentType = this.exceptionArgument.resolveType(scope)) != null) {
            if (exceptionArgumentType.id == 6) {
                scope.problemReporter().illegalVoidExpression(this.exceptionArgument);
            }
            this.exceptionArgument.implicitConversion = (exceptionArgumentType.id << 4) + exceptionArgumentType.id;
        }
    }

    public void traverse(ASTVisitor visitor, BlockScope scope) {
        if (visitor.visit(this, scope)) {
            this.assertExpression.traverse(visitor, scope);
            if (this.exceptionArgument != null) {
                this.exceptionArgument.traverse(visitor, scope);
            }
        }
        visitor.endVisit(this, scope);
    }

    public void manageSyntheticAccessIfNecessary(BlockScope currentScope) {
        SourceTypeBinding outerMostClass = currentScope.enclosingSourceType();
        while (outerMostClass.isLocalType()) {
            ReferenceBinding enclosing = outerMostClass.enclosingType();
            if (enclosing == null || enclosing.isInterface()) break;
            outerMostClass = (SourceTypeBinding)enclosing;
        }
        this.assertionSyntheticFieldBinding = outerMostClass.addSyntheticField(this, currentScope);
        TypeDeclaration typeDeclaration = outerMostClass.scope.referenceType();
        AbstractMethodDeclaration[] methods = typeDeclaration.methods;
        int i = 0;
        int max = methods.length;
        while (i < max) {
            AbstractMethodDeclaration method = methods[i];
            if (method.isClinit()) {
                ((Clinit)method).addSupportForAssertion(this.assertionSyntheticFieldBinding);
                break;
            }
            ++i;
        }
    }

    public String toString(int tab) {
        StringBuffer buffer = new StringBuffer(AssertStatement.tabString(tab));
        buffer.append("assert ");
        buffer.append(this.assertExpression);
        if (this.exceptionArgument != null) {
            buffer.append(":");
            buffer.append(this.exceptionArgument);
            buffer.append(";");
        }
        return buffer.toString();
    }
}

