/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.phpdt.internal.debug.ui;

import java.util.HashMap;
import net.sourceforge.phpdt.internal.debug.core.breakpoints.PHPLineBreakpoint;
import net.sourceforge.phpdt.internal.debug.core.model.IPHPDebugTarget;
import net.sourceforge.phpdt.internal.debug.core.model.PHPStackFrame;
import net.sourceforge.phpdt.internal.debug.core.model.PHPThread;
import net.sourceforge.phpdt.internal.debug.core.model.PHPValue;
import net.sourceforge.phpdt.internal.debug.core.model.PHPVariable;
import net.sourceforge.phpdt.internal.debug.ui.PHPDebugUiMessages;
import net.sourceforge.phpdt.internal.debug.ui.PHPDebugUiPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public class PHPDebugModelPresentation
extends LabelProvider
implements IDebugModelPresentation {
    protected HashMap fAttributes = new HashMap(3);

    public String getEditorId(IEditorInput input, Object inputObject) {
        IEditorRegistry registry = PlatformUI.getWorkbench().getEditorRegistry();
        IEditorDescriptor descriptor = registry.getDefaultEditor(input.getName());
        if (descriptor != null) {
            return descriptor.getId();
        }
        return null;
    }

    public void setAttribute(String id, Object value) {
        if (value == null) {
            return;
        }
        this.fAttributes.put(id, value);
    }

    public IEditorInput getEditorInput(Object item) {
        if (item instanceof PHPLineBreakpoint) {
            IBreakpoint bp = (IBreakpoint)item;
            IMarker ma = bp.getMarker();
            IFile eclipseFile = PHPDebugUiPlugin.getWorkspace().getRoot().getFile(ma.getResource().getFullPath());
            if (eclipseFile == null) {
                return null;
            }
            return new FileEditorInput(eclipseFile);
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof PHPLineBreakpoint) {
            return DebugUITools.getImage((String)"IMG_OBJS_BREAKPOINT");
        }
        if (element instanceof IMarker) {
            return DebugUITools.getImage((String)"IMG_OBJS_BREAKPOINT");
        }
        if (element instanceof PHPStackFrame || element instanceof PHPThread || element instanceof IPHPDebugTarget) {
            return this.getDebugElementImage(element);
        }
        if (element instanceof PHPVariable) {
            return this.getVariableImage((PHPVariable)element);
        }
        if (element instanceof PHPValue) {
            return this.getValueImage((PHPValue)element);
        }
        return DebugUITools.getImage((String)"IMG_OBJS_BREAKPOINT");
    }

    private Image getVariableImage(PHPVariable phpVar) {
        return DebugUITools.getImage((String)"IMG_OBJS_VARIABLE");
    }

    private Image getValueImage(PHPValue phpVar) {
        if (phpVar != null) {
            return DebugUITools.getImage((String)"IMG_OBJS_VARIABLE");
        }
        return DebugUITools.getImage((String)"IMG_OBJS_VARIABLE");
    }

    public String getText(Object element) {
        try {
            if (element instanceof PHPLineBreakpoint) {
                return this.getBreakpointText((IBreakpoint)element);
            }
            if (element instanceof PHPVariable) {
                PHPVariable phpVar = (PHPVariable)element;
                return phpVar.toString();
            }
        }
        catch (CoreException coreException) {
            return PHPDebugUiMessages.getString("PHPDebugModelPresentation.<not responding>");
        }
        return null;
    }

    public void computeDetail(IValue value, IValueDetailListener listener) {
    }

    protected IBreakpoint getBreakpoint(IMarker marker) {
        return DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
    }

    protected String getBreakpointText(IBreakpoint breakpoint) throws CoreException {
        if (breakpoint instanceof PHPLineBreakpoint) {
            return this.getLineBreakpointText((PHPLineBreakpoint)breakpoint);
        }
        return "";
    }

    protected String getLineBreakpointText(PHPLineBreakpoint breakpoint) throws CoreException {
        StringBuffer label = new StringBuffer();
        label.append(breakpoint.getMarker().getResource().getFullPath());
        label.append(" [");
        label.append(PHPDebugUiMessages.getString("PHPDebugModelPresentation.line"));
        label.append(' ');
        label.append(breakpoint.getLineNumber());
        label.append(']');
        if (breakpoint.getHitCount() > 0) {
            label.append(" [skip count ");
            label.append(breakpoint.getHitCount());
            label.append(']');
        }
        if (breakpoint.isConditionEnabled()) {
            label.append(" [conditional]");
        }
        return label.toString();
    }

    protected Image getDebugElementImage(Object element) {
        Image image = null;
        if (element instanceof PHPThread) {
            PHPThread thread = (PHPThread)element;
            image = thread.isSuspended() ? DebugUITools.getImage((String)"IMG_OBJS_THREAD_SUSPENDED") : (thread.isTerminated() ? DebugUITools.getImage((String)"IMG_OBJS_THREAD_TERMINATED") : DebugUITools.getImage((String)"IMG_OBJS_THREAD_RUNNING"));
        } else if (element instanceof PHPStackFrame) {
            image = DebugUITools.getImage((String)"IMG_OBJS_STACKFRAME");
        } else if (element instanceof IPHPDebugTarget) {
            IPHPDebugTarget debugTarget = (IPHPDebugTarget)element;
            image = debugTarget.isTerminated() ? DebugUITools.getImage((String)"IMG_OBJS_DEBUG_TARGET_TERMINATED") : DebugUITools.getImage((String)"IMG_OBJS_DEBUG_TARGET");
        }
        return image;
    }
}

